/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.spi;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.heapwalk.details.spi.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.openide.util.RequestProcessor;

public abstract class DetailsProvider {
    public String[] getSupportedClasses() {
        return null;
    }

    public String getDetailsString(String className, Instance instance, Heap heap) {
        return null;
    }

    public View getDetailsView(String className, Instance instance, Heap heap) {
        return null;
    }

    public static abstract class View
    extends JPanel {
        private RequestProcessor.Task workerTask;
        private Instance instance;
        private Heap heap;

        protected View(Instance instance, Heap heap) {
            this(instance, heap, View.initialView());
        }

        private static JComponent initialView() {
            JLabel loading = new JLabel(Bundle.BrowserUtils_Loading(), 0);
            loading.setEnabled(false);
            JPanel loadingContainer = new JPanel(new BorderLayout());
            loadingContainer.setOpaque(true);
            loadingContainer.setBackground(UIUtils.getProfilerResultsBackground());
            loadingContainer.setEnabled(false);
            loadingContainer.add((Component)loading, "Center");
            return loadingContainer;
        }

        protected View(Instance instance, Heap heap, Component initialView) {
            super(new BorderLayout());
            this.add(initialView, "Center");
            this.instance = instance;
            this.heap = heap;
        }

        protected abstract void computeView(Instance var1, Heap var2);

        @Override
        public final void addNotify() {
            super.addNotify();
            this.workerTask = BrowserUtils.performTask(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.interrupted()) {
                        this.computeView(instance, heap);
                    }
                }
            });
        }

        protected void removed() {
        }

        @Override
        public final void removeNotify() {
            this.workerTask.cancel();
            super.removeNotify();
            this.removed();
        }
    }

    public static abstract class Basic
    extends DetailsProvider {
        private final String[] supportedClasses;

        public Basic() {
            this(null);
        }

        protected Basic(String ... supportedClasses) {
            this.supportedClasses = supportedClasses;
        }

        @Override
        public final String[] getSupportedClasses() {
            return this.supportedClasses;
        }
    }
}

