/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;

public final class RunAsPanel
extends JPanel {
    private static final long serialVersionUID = -5723489817914071L;
    private static final Font JL_PLAIN_FONT = new JLabel().getFont().deriveFont(0);
    private static final Font JL_BOLD_FONT = JL_PLAIN_FONT.deriveFont(1);
    private final LinkedHashMap<String, InsidePanel> allInsidePanels;
    private final ComboModel comboBoxModel = new ComboModel();

    public RunAsPanel(InsidePanel[] cards) {
        assert (cards != null);
        this.allInsidePanels = new LinkedHashMap();
        for (InsidePanel basicCard : cards) {
            this.allInsidePanels.put(basicCard.getDisplayName(), basicCard);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.comboBoxModel.isInitialized) {
            Collection<InsidePanel> insidePanels = this.allInsidePanels.values();
            this.initComboModel(insidePanels);
            for (InsidePanel insidePanel : insidePanels) {
                JComboBox<String> comboBox = insidePanel.getRunAsCombo();
                comboBox.setModel(this.comboBoxModel);
            }
            this.comboBoxModel.setAsInitialized();
        }
    }

    private void initComboModel(Collection<InsidePanel> insidePanels) {
        this.comboBoxModel.removeAllElements();
        for (InsidePanel insidePanel : insidePanels) {
            this.add((Component)insidePanel, insidePanel.getDisplayName());
            this.comboBoxModel.addElement(insidePanel.getDisplayName());
        }
    }

    private void selectInsidePanel(String name) {
        CardLayout cl = (CardLayout)this.getLayout();
        InsidePanel current = this.allInsidePanels.get(name);
        Dimension preferredSize = current.getPreferredSize();
        this.setPreferredSize(preferredSize);
        cl.show(this, name);
    }

    private class ComboModel
    extends DefaultComboBoxModel<String> {
        private static final long serialVersionUID = -68784654654657987L;
        private boolean isInitialized;

        private ComboModel() {
        }

        private void setAsInitialized() {
            this.isInitialized = true;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            super.setSelectedItem(anObject);
            if (this.isInitialized) {
                String name = (String)anObject;
                RunAsPanel.this.selectInsidePanel(name);
                InsidePanel current = RunAsPanel.this.allInsidePanels.get(name);
                if (current != null) {
                    current.loadFields();
                    current.validateFields();
                    current.putValue(current.currentCfg(), "run.as", current.getRunAsType().name());
                    current.markAsModified(current.getRunAsLabel(), "run.as", current.getRunAsType().name());
                }
            }
        }
    }

    public static abstract class InsidePanel
    extends JPanel
    implements ChangeListener {
        private final ConfigManager manager;

        public InsidePanel(ConfigManager manager) {
            this.manager = manager;
            manager.addChangeListener(this);
        }

        protected abstract PhpProjectProperties.RunAsType getRunAsType();

        protected abstract String getDisplayName();

        protected abstract JComboBox<String> getRunAsCombo();

        protected abstract JLabel getRunAsLabel();

        protected abstract void loadFields();

        protected abstract void validateFields();

        protected boolean isDefault() {
            return false;
        }

        @Override
        public final void stateChanged(ChangeEvent e) {
            String initPanelName = this.getValue("run.as");
            if (initPanelName == null && this.isDefault() || initPanelName != null && initPanelName.equals(this.getRunAsType().name())) {
                JComboBox<String> comboBox = this.getRunAsCombo();
                comboBox.getModel().setSelectedItem(this.getDisplayName());
            }
        }

        protected final String getCurrentValue(String propertyName) {
            return this.getValue(this.currentCfg(), propertyName);
        }

        protected final String getDefaultValue(String propertyName) {
            return this.getValue(this.defaultCfg(), propertyName);
        }

        protected final String getValue(String propertyName) {
            String value = this.getCurrentValue(propertyName);
            value = value == null ? this.getDefaultValue(propertyName) : value;
            return value;
        }

        protected final void markAsModified(JComponent label, String propertyName, String value) {
            String defaultValue = this.getDefaultValue(propertyName);
            if (this.currentCfg().isDefault() || value.equals(defaultValue)) {
                label.setFont(JL_PLAIN_FONT);
            } else {
                label.setFont(JL_BOLD_FONT);
            }
        }

        protected final String getValue(ConfigManager.Configuration configuration, String propertyName) {
            return configuration.getValue(propertyName);
        }

        protected final void putValue(ConfigManager.Configuration configuration, String propertyName, String value) {
            configuration.putValue(propertyName, value);
        }

        protected final void putValue(String propertyName, String value) {
            String string = value = value != null ? value.trim() : "";
            if (!this.currentCfg().isDefault() && value.equals(this.getDefaultValue(propertyName))) {
                value = null;
            }
            this.putValue(this.currentCfg(), propertyName, value);
        }

        protected final void putValueAndMarkAsModified(JLabel label, String propertyName, String value) {
            value = value != null ? value.trim() : "";
            this.putValue(propertyName, value);
            this.markAsModified(label, propertyName, value);
        }

        protected final ConfigManager.Configuration currentCfg() {
            return this.getManager().currentConfiguration();
        }

        protected final ConfigManager.Configuration cfgFor(String activeConfig) {
            return this.getManager().configurationFor(activeConfig);
        }

        protected final ConfigManager.Configuration defaultCfg() {
            return this.getManager().defaultConfiguration();
        }

        protected final ConfigManager getManager() {
            return this.manager;
        }

        protected abstract class TextFieldUpdater
        implements DocumentListener {
            private final JLabel label;
            private final JTextField field;
            private final String propName;

            public TextFieldUpdater(String propName, JLabel label, JTextField field) {
                this.propName = propName;
                this.label = label;
                this.field = field;
            }

            protected abstract String getDefaultValue();

            @Override
            public final void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public final void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public final void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            protected final String getPropName() {
                return this.propName;
            }

            protected void processUpdate() {
                InsidePanel.this.putValue(this.propName, this.getPropValue());
                InsidePanel.this.markAsModified(this.label, this.propName, this.getPropValue());
                InsidePanel.this.validateFields();
            }

            protected String getPropValue() {
                return this.field.getText();
            }
        }
    }
}

