/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.runconfigs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public final class RunConfigInternal {
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 8000;
    private File workDir;
    private File documentRoot;
    private String hostname;
    private String port;
    private String routerRelativePath;

    private RunConfigInternal() {
    }

    public static PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.INTERNAL;
    }

    public static String getDisplayName() {
        return RunConfigInternal.getRunAsType().getLabel();
    }

    public static RunConfigInternal create() {
        return new RunConfigInternal();
    }

    public static RunConfigInternal forProject(final PhpProject project) {
        return (RunConfigInternal)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<RunConfigInternal>(){

            public RunConfigInternal run() {
                return new RunConfigInternal().setHostname(ProjectPropertiesSupport.getHostname(project)).setPort(ProjectPropertiesSupport.getPort(project)).setWorkDir(FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(project))).setDocumentRoot(FileUtil.toFile((FileObject)ProjectPropertiesSupport.getWebRootDirectory(project))).setRouterRelativePath(ProjectPropertiesSupport.getInternalRouter(project));
            }
        });
    }

    public String getServer() {
        return this.hostname + ":" + this.port;
    }

    public URL getUrl() throws MalformedURLException {
        return new URL("http://" + this.getServer() + "/");
    }

    public String getUrlHint() {
        try {
            return this.getUrl().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getRelativeDocumentRoot() {
        FileObject workDirFo = FileUtil.toFileObject((File)this.workDir);
        FileObject documentRootFo = FileUtil.toFileObject((File)this.documentRoot);
        String relativePath = FileUtil.getRelativePath((FileObject)workDirFo, (FileObject)documentRootFo);
        assert (relativePath != null) : "Document root " + this.documentRoot + " must be underneath workdir " + this.workDir;
        return StringUtils.hasText((String)relativePath) ? relativePath : null;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public RunConfigInternal setWorkDir(File workDir) {
        this.workDir = workDir;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public RunConfigInternal setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getPort() {
        return this.port;
    }

    public RunConfigInternal setPort(String port) {
        this.port = port;
        return this;
    }

    public File getDocumentRoot() {
        return this.documentRoot;
    }

    public RunConfigInternal setDocumentRoot(File documentRoot) {
        this.documentRoot = documentRoot;
        return this;
    }

    public String getRouterRelativePath() {
        return this.routerRelativePath;
    }

    public RunConfigInternal setRouterRelativePath(String routerRelativePath) {
        this.routerRelativePath = routerRelativePath;
        return this;
    }
}

