/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.connections.Bundle;
import org.netbeans.modules.php.project.connections.DownloadSkipException;
import org.netbeans.modules.php.project.connections.RemoteClientImplementation;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TmpLocalFile;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConnectionProvider;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.netbeans.modules.php.project.connections.transfer.LocalTransferFile;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.transfer.TransferInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.windows.InputOutput;

public final class RemoteClient
implements Cancellable {
    private static final Logger LOGGER = Logger.getLogger(RemoteClient.class.getName());
    public static final FileSystem.AtomicAction DOWNLOAD_ATOMIC_ACTION = new DownloadAtomicAction(null);
    private static final AdvancedProperties DEFAULT_ADVANCED_PROPERTIES = new AdvancedProperties();
    private static final OperationMonitor DEV_NULL_OPERATION_MONITOR = new DevNullOperationMonitor();
    private static final Set<String> IGNORED_DIRS = new HashSet<String>(Arrays.asList(".", "..", "nbproject"));
    private static final int TRIES_TO_TRANSFER = 3;
    private static final String REMOTE_TMP_NEW_SUFFIX = ".new";
    private static final String REMOTE_TMP_OLD_SUFFIX = ".old";
    private static final int MAX_FILE_SIZE_FOR_MEMORY = 512000;
    private final RemoteConfiguration configuration;
    private final AdvancedProperties properties;
    private final org.netbeans.modules.php.project.connections.spi.RemoteClient remoteClient;
    private volatile String baseRemoteDirectory;
    private volatile boolean cancelled = false;
    private volatile OperationMonitor operationMonitor;

    public RemoteClient(RemoteConfiguration configuration) {
        this(configuration, DEFAULT_ADVANCED_PROPERTIES);
    }

    public RemoteClient(RemoteConfiguration configuration, AdvancedProperties properties) {
        RemoteConnectionProvider provider;
        String baseDir;
        assert (configuration != null);
        assert (properties != null);
        this.configuration = configuration;
        this.properties = properties;
        this.setOperationMonitor(properties.getOperationMonitor());
        StringBuilder baseDirBuffer = new StringBuilder(configuration.getInitialDirectory());
        String additionalInitialSubdirectory = properties.getAdditionalInitialSubdirectory();
        if (StringUtils.hasText((String)additionalInitialSubdirectory)) {
            if (!additionalInitialSubdirectory.startsWith("/")) {
                throw new IllegalArgumentException("additionalInitialSubdirectory must start with /");
            }
            baseDirBuffer.append(additionalInitialSubdirectory);
        }
        if ((baseDir = baseDirBuffer.toString()).length() > 1 && baseDir.endsWith("/")) {
            baseDir = baseDir.substring(0, baseDir.length() - 1);
        }
        this.baseRemoteDirectory = baseDir.replaceAll("/{2,}", "/");
        assert (this.baseRemoteDirectory.startsWith("/")) : "base directory must start with /: " + this.baseRemoteDirectory;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Remote client created with configuration: %s, advanced properties: %s, base remote directory: %s", configuration, properties, this.baseRemoteDirectory));
        }
        org.netbeans.modules.php.project.connections.spi.RemoteClient client = null;
        Iterator<RemoteConnectionProvider> iterator = RemoteConnections.get().getConnectionProviders().iterator();
        while (iterator.hasNext() && (client = (provider = iterator.next()).getRemoteClient(configuration, properties.getInputOutput())) == null) {
        }
        assert (client != null) : "no suitable remote client for configuration: " + configuration;
        this.remoteClient = client;
    }

    String getBaseRemoteDirectory() {
        return this.baseRemoteDirectory;
    }

    public OperationMonitor getOperationMonitor() {
        if (this.operationMonitor == null) {
            return DEV_NULL_OPERATION_MONITOR;
        }
        return this.operationMonitor;
    }

    public void setOperationMonitor(OperationMonitor operationMonitor) {
        this.operationMonitor = operationMonitor;
    }

    public synchronized void connect() throws RemoteException {
        this.remoteClient.connect();
        assert (this.remoteClient.isConnected()) : "Remote client should be connected";
        if (!this.cdBaseRemoteDirectory()) {
            if (this.remoteClient.isConnected()) {
                this.disconnect(true);
            }
            throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)this.baseRemoteDirectory), this.remoteClient.getReplyString());
        }
        String pwd = this.getWorkingDirectory();
        if (!pwd.equals(this.baseRemoteDirectory)) {
            LOGGER.log(Level.FINE, "Changing base remote directory (symlink?): {0} -> {1}", new Object[]{this.baseRemoteDirectory, pwd});
            this.baseRemoteDirectory = pwd;
        }
    }

    public synchronized void disconnect(boolean force) throws RemoteException {
        this.remoteClient.disconnect(force);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    public void reset() {
        this.cancelled = false;
    }

    public synchronized boolean exists(TransferFile file) throws RemoteException {
        this.ensureConnected();
        LOGGER.fine(String.format("Checking whether file %s exists", file));
        this.cdBaseRemoteDirectory();
        boolean exists = this.remoteClient.exists(file.getParentRemotePath(), file.getName());
        LOGGER.fine(String.format("Exists: %b", exists));
        return exists;
    }

    public synchronized boolean rename(TransferFile from, TransferFile to) throws RemoteException {
        this.ensureConnected();
        LOGGER.fine(String.format("Moving file from %s to %s", from, to));
        this.cdBaseRemoteDirectory();
        boolean success = this.remoteClient.rename(from.getRemotePath(), to.getRemotePath());
        LOGGER.fine(String.format("Success: %b", success));
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransferFile> listFiles(TransferFile file) throws RemoteException {
        this.ensureConnected();
        LOGGER.log(Level.FINE, "Getting children for {0}", file);
        try {
            this.getOperationMonitor().operationStart(Operation.LIST, Collections.singleton(file));
            List<Object> remoteFiles = Collections.emptyList();
            Object object = this;
            synchronized (object) {
                if (this.cdBaseRemoteDirectory(file.getRemotePath(), false)) {
                    remoteFiles = this.remoteClient.listFiles();
                }
            }
            if (remoteFiles.isEmpty()) {
                LOGGER.log(Level.FINE, "No children found for {0}", file);
                object = Collections.emptyList();
                return object;
            }
            RemoteClientImplementation remoteClientImplementation = this.createRemoteClientImplementation(file.getBaseLocalDirectoryPath());
            ArrayList<TransferFile> transferFiles = new ArrayList<TransferFile>(remoteFiles.size());
            for (RemoteFile remoteFile : remoteFiles) {
                if (this.isVisible(this.getLocalFile(new File(file.getBaseLocalDirectoryPath()), file, remoteFile))) {
                    LOGGER.log(Level.FINE, "File {0} added to download queue", remoteFile);
                    TransferFile transferFile = TransferFile.fromRemoteFile(remoteClientImplementation, file, remoteFile);
                    this.getOperationMonitor().operationProcess(Operation.LIST, transferFile);
                    transferFiles.add(transferFile);
                    continue;
                }
                LOGGER.log(Level.FINE, "File {0} NOT added to download queue [invisible]", remoteFile);
            }
            LOGGER.log(Level.FINE, "{0} children found for {1}", new Object[]{transferFiles.size(), file});
            ArrayList<TransferFile> arrayList = transferFiles;
            return arrayList;
        }
        finally {
            this.getOperationMonitor().operationFinish(Operation.LIST, Collections.singleton(file));
        }
    }

    public Set<TransferFile> prepareUpload(FileObject baseLocalDirectory, FileObject ... filesToUpload) {
        assert (baseLocalDirectory != null);
        assert (filesToUpload != null);
        assert (baseLocalDirectory.isFolder()) : "Base local directory must be a directory";
        assert (filesToUpload.length > 0) : "At least one file to upload must be specified";
        File baseLocalDir = FileUtil.toFile((FileObject)baseLocalDirectory);
        baseLocalDir = FileUtil.normalizeFile((File)baseLocalDir);
        String baseLocalAbsolutePath = baseLocalDir.getAbsolutePath();
        RemoteClientImplementation remoteClientImpl = this.createRemoteClientImplementation(baseLocalAbsolutePath);
        LinkedList<TransferFile> baseFiles = new LinkedList<TransferFile>();
        for (FileObject fo : filesToUpload) {
            File f = FileUtil.toFile((FileObject)fo);
            if (f == null) continue;
            if (this.isVisible(f)) {
                LOGGER.log(Level.FINE, "File {0} added to upload queue", fo);
                baseFiles.add(TransferFile.fromFileObject(remoteClientImpl, null, fo));
                continue;
            }
            LOGGER.log(Level.FINE, "File {0} NOT added to upload queue [invisible]", fo);
        }
        HashSet<TransferFile> files = new HashSet<TransferFile>();
        for (TransferFile file : baseFiles) {
            if (this.cancelled) {
                LOGGER.fine("Prepare upload cancelled");
                break;
            }
            if (!files.add(file)) {
                LOGGER.log(Level.FINE, "File {0} already in queue", file);
                files.remove(file);
                files.add(file);
            }
            if (!file.isDirectory()) continue;
            files.addAll(file.getLocalChildren());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Prepared for upload: {0}", files);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo upload(Set<TransferFile> filesToUpload) throws RemoteException {
        assert (filesToUpload != null);
        assert (filesToUpload.size() > 0) : "At least one file to upload must be specified";
        this.ensureConnected();
        long start = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        try {
            this.getOperationMonitor().operationStart(Operation.UPLOAD, filesToUpload);
            for (TransferFile file : filesToUpload) {
                this.uploadFile(transferInfo, file);
            }
        }
        finally {
            this.getOperationMonitor().operationFinish(Operation.UPLOAD, filesToUpload);
            transferInfo.setRuntime(System.currentTimeMillis() - start);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
        }
        return transferInfo;
    }

    private void uploadFile(TransferInfo transferInfo, TransferFile file) throws RemoteException {
        if (this.cancelled) {
            LOGGER.fine("Upload cancelled");
            return;
        }
        this.getOperationMonitor().operationProcess(Operation.UPLOAD, file);
        try {
            this.uploadFileInternal(transferInfo, file);
        }
        catch (IOException | RemoteException exc) {
            LOGGER.log(Level.INFO, null, exc);
            this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFileInternal(TransferInfo transferInfo, TransferFile file) throws IOException, RemoteException {
        block77: {
            block78: {
                boolean success;
                String tmpFileName;
                String fileName;
                block74: {
                    int oldPermissions;
                    block75: {
                        block76: {
                            if (!file.isDirectory()) break block76;
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "Uploading directory: {0}", file);
                            }
                            this.cdBaseRemoteDirectory(file.getRemotePath(), true);
                            this.transferSucceeded(transferInfo, file);
                            if (!file.hasLocalChildrenFetched()) {
                                List<TransferFile> localChildren = file.getLocalChildren();
                                this.getOperationMonitor().addUnits(localChildren);
                                for (TransferFile child : localChildren) {
                                    this.uploadFile(transferInfo, child);
                                }
                            }
                            break block77;
                        }
                        if (!file.isFile()) break block78;
                        assert (file.getParentRemotePath() != null) : "Must be underneath base remote directory! [" + file + "]";
                        if (!this.cdBaseRemoteDirectory(file.getParentRemotePath(), true)) {
                            this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)file.getParentRemotePath()));
                            return;
                        }
                        fileName = file.getName();
                        oldPermissions = -1;
                        if (this.properties.isPreservePermissions()) {
                            RemoteClient child = this;
                            synchronized (child) {
                                oldPermissions = this.remoteClient.getPermissions(fileName);
                            }
                            LOGGER.fine(String.format("Original permissions of %s: %d", fileName, oldPermissions));
                        } else {
                            LOGGER.fine("Permissions are not preserved.");
                        }
                        tmpFileName = null;
                        if (this.properties.isUploadDirectly()) {
                            LOGGER.fine("File will be uploaded directly.");
                            tmpFileName = fileName;
                        } else {
                            tmpFileName = fileName + REMOTE_TMP_NEW_SUFFIX;
                            LOGGER.fine("File will be uploaded using a temporary file.");
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            RemoteClient remoteClient = this;
                            synchronized (remoteClient) {
                                LOGGER.log(Level.FINE, "Uploading file {0} => {1}", new Object[]{fileName, this.getWorkingDirectory() + "/" + tmpFileName});
                            }
                        }
                        success = false;
                        try {
                            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(new File(file.getBaseLocalDirectoryPath()), file.getLocalPath())));){
                                for (int i = 1; i <= 3; ++i) {
                                    String f;
                                    boolean fileStored;
                                    RemoteClient remoteClient = this;
                                    synchronized (remoteClient) {
                                        fileStored = this.remoteClient.storeFile(tmpFileName, is);
                                    }
                                    if (fileStored) {
                                        success = true;
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            f = file.getRemotePath() + (this.properties.isUploadDirectly() ? "" : REMOTE_TMP_NEW_SUFFIX);
                                            LOGGER.fine(String.format("The %d. attempt to upload '%s' was successful", i, f));
                                        }
                                        break;
                                    }
                                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                                    f = file.getRemotePath() + (this.properties.isUploadDirectly() ? "" : REMOTE_TMP_NEW_SUFFIX);
                                    LOGGER.fine(String.format("The %d. attempt to upload '%s' was NOT successful", i, f));
                                }
                            }
                            if (!success) break block74;
                            if (this.properties.isUploadDirectly()) break block75;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                if (!this.properties.isUploadDirectly()) {
                                    success = this.moveRemoteFile(tmpFileName, fileName);
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine(String.format("File %s renamed to %s: %s", tmpFileName, fileName, success));
                                    }
                                }
                                if (this.properties.isPreservePermissions() && success && oldPermissions != -1) {
                                    int newPermissions;
                                    RemoteClient remoteClient = this;
                                    synchronized (remoteClient) {
                                        newPermissions = this.remoteClient.getPermissions(fileName);
                                    }
                                    LOGGER.fine(String.format("New permissions of %s: %d", fileName, newPermissions));
                                    if (oldPermissions != newPermissions) {
                                        boolean permissionsSet;
                                        LOGGER.fine(String.format("Setting permissions %d for %s.", oldPermissions, fileName));
                                        RemoteClient remoteClient2 = this;
                                        synchronized (remoteClient2) {
                                            permissionsSet = this.remoteClient.setPermissions(oldPermissions, fileName);
                                        }
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.fine(String.format("Permissions for %s set: %s", fileName, permissionsSet));
                                            remoteClient2 = this;
                                            synchronized (remoteClient2) {
                                                LOGGER.fine(String.format("Permissions for %s read: %s", fileName, this.remoteClient.getPermissions(fileName)));
                                            }
                                        }
                                        if (!permissionsSet) {
                                            this.transferPartiallyFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_PermissionsNotSet", (Object)oldPermissions, (Object)file.getName()));
                                        }
                                    }
                                }
                            }
                            if (success) {
                                this.transferSucceeded(transferInfo, file);
                            } else {
                                this.transferFailed(transferInfo, file, this.getOperationFailureMessage(Operation.UPLOAD, fileName));
                                if (!this.properties.isUploadDirectly()) {
                                    boolean deleted;
                                    RemoteClient remoteClient = this;
                                    synchronized (remoteClient) {
                                        deleted = this.remoteClient.deleteFile(tmpFileName);
                                    }
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine(String.format("Unsuccessfully uploaded file %s deleted: %s", file.getRemotePath() + REMOTE_TMP_NEW_SUFFIX, deleted));
                                    }
                                }
                            }
                            throw throwable;
                        }
                        success = this.moveRemoteFile(tmpFileName, fileName);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("File %s renamed to %s: %s", tmpFileName, fileName, success));
                        }
                    }
                    if (this.properties.isPreservePermissions() && success && oldPermissions != -1) {
                        int newPermissions;
                        RemoteClient i = this;
                        synchronized (i) {
                            newPermissions = this.remoteClient.getPermissions(fileName);
                        }
                        LOGGER.fine(String.format("New permissions of %s: %d", fileName, newPermissions));
                        if (oldPermissions != newPermissions) {
                            boolean permissionsSet;
                            LOGGER.fine(String.format("Setting permissions %d for %s.", oldPermissions, fileName));
                            RemoteClient remoteClient = this;
                            synchronized (remoteClient) {
                                permissionsSet = this.remoteClient.setPermissions(oldPermissions, fileName);
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine(String.format("Permissions for %s set: %s", fileName, permissionsSet));
                                remoteClient = this;
                                synchronized (remoteClient) {
                                    LOGGER.fine(String.format("Permissions for %s read: %s", fileName, this.remoteClient.getPermissions(fileName)));
                                }
                            }
                            if (!permissionsSet) {
                                this.transferPartiallyFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_PermissionsNotSet", (Object)oldPermissions, (Object)file.getName()));
                            }
                        }
                    }
                }
                if (success) {
                    this.transferSucceeded(transferInfo, file);
                } else {
                    this.transferFailed(transferInfo, file, this.getOperationFailureMessage(Operation.UPLOAD, fileName));
                    if (!this.properties.isUploadDirectly()) {
                        boolean deleted;
                        RemoteClient remoteClient = this;
                        synchronized (remoteClient) {
                            deleted = this.remoteClient.deleteFile(tmpFileName);
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("Unsuccessfully uploaded file %s deleted: %s", file.getRemotePath() + REMOTE_TMP_NEW_SUFFIX, deleted));
                        }
                    }
                }
                break block77;
            }
            this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_UnknownFileType", (Object)file.getRemotePath()));
        }
    }

    private synchronized boolean moveRemoteFile(String source, String target) throws RemoteException {
        boolean moved = this.remoteClient.rename(source, target);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("File %s directly renamed to %s: %s", source, target, moved));
        }
        if (moved) {
            return true;
        }
        String oldPath = target + REMOTE_TMP_OLD_SUFFIX;
        this.remoteClient.deleteFile(oldPath);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Renaming in chain: (1) <file> -> <file>.old~ ; (2) <file>.new~ -> <file> ; (3) rm <file>.old~");
        }
        moved = this.remoteClient.rename(target, oldPath);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("(1) File %s renamed to %s: %s", target, oldPath, moved));
        }
        if (!moved) {
            return false;
        }
        moved = this.remoteClient.rename(source, target);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("(2) File %s renamed to %s: %s", source, target, moved));
        }
        if (!moved) {
            boolean restored = this.remoteClient.rename(oldPath, target);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("(-) File %s restored to original %s: %s", oldPath, target, restored));
            }
        } else {
            boolean deleted = this.remoteClient.deleteFile(oldPath);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("(3) File %s deleted: %s", oldPath, deleted));
            }
        }
        return moved;
    }

    public synchronized TransferFile listFile(FileObject baseLocalDir, FileObject file) throws RemoteException {
        this.ensureConnected();
        String baseLocalAbsolutePath = FileUtil.toFile((FileObject)baseLocalDir).getAbsolutePath();
        TransferFile localTransferFile = TransferFile.fromFile(this.createRemoteClientImplementation(baseLocalAbsolutePath), null, FileUtil.toFile((FileObject)file));
        RemoteFile remoteFile = this.remoteClient.listFile(localTransferFile.getRemoteAbsolutePath());
        if (remoteFile != null) {
            LOGGER.log(Level.FINE, "Remote file {0} found", localTransferFile.getRemotePath());
            return TransferFile.fromRemoteFile(this.createRemoteClientImplementation(localTransferFile.getBaseLocalDirectoryPath()), localTransferFile.hasParent() ? localTransferFile.getParent() : null, remoteFile);
        }
        LOGGER.log(Level.FINE, "Remote file {0} not found", localTransferFile.getRemotePath());
        return null;
    }

    public Set<TransferFile> prepareDownload(FileObject baseLocalDirectory, FileObject ... filesToDownload) throws RemoteException {
        assert (baseLocalDirectory != null);
        assert (baseLocalDirectory.isFolder()) : "Base local directory must be a directory";
        assert (filesToDownload != null);
        assert (filesToDownload.length > 0) : "At least one file to download must be specified";
        ArrayList<File> files = new ArrayList<File>(filesToDownload.length);
        for (FileObject fo : filesToDownload) {
            File f = FileUtil.toFile((FileObject)fo);
            if (f == null) continue;
            files.add(f);
        }
        return this.prepareDownload(FileUtil.toFile((FileObject)baseLocalDirectory), files.toArray(new File[files.size()]));
    }

    public Set<TransferFile> prepareDownload(File baseLocalDir, File ... filesToDownload) throws RemoteException {
        assert (baseLocalDir != null);
        assert (filesToDownload != null);
        assert (filesToDownload.length > 0) : "At least one file to download must be specified";
        this.ensureConnected();
        String baseLocalAbsolutePath = FileUtil.normalizeFile((File)baseLocalDir).getAbsolutePath();
        RemoteClientImplementation remoteClientImpl = this.createRemoteClientImplementation(baseLocalAbsolutePath);
        LinkedList<TransferFile> baseFiles = new LinkedList<TransferFile>();
        for (File f : filesToDownload) {
            if (this.isVisible(f = FileUtil.normalizeFile((File)f))) {
                LOGGER.log(Level.FINE, "File {0} added to download queue", f);
                TransferFile tf = f.exists() ? TransferFile.fromFile(remoteClientImpl, null, f) : TransferFile.fromDirectory(remoteClientImpl, null, f);
                baseFiles.add(tf);
                continue;
            }
            LOGGER.log(Level.FINE, "File {0} NOT added to download queue [invisible]", f);
        }
        HashSet<TransferFile> files = new HashSet<TransferFile>();
        for (TransferFile file : baseFiles) {
            if (this.cancelled) {
                LOGGER.fine("Prepare download cancelled");
                break;
            }
            if (!files.add(file)) {
                LOGGER.log(Level.FINE, "File {0} already in queue", file);
                files.remove(file);
                files.add(file);
            }
            if (!file.isDirectory()) continue;
            files.addAll(file.getRemoteChildren());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Prepared for download: {0}", files);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo download(Set<TransferFile> filesToDownload) throws RemoteException {
        assert (filesToDownload != null);
        assert (filesToDownload.size() > 0) : "At least one file to download must be specified";
        this.ensureConnected();
        long start = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        try {
            this.getOperationMonitor().operationStart(Operation.DOWNLOAD, filesToDownload);
            for (TransferFile file : filesToDownload) {
                this.downloadFile(transferInfo, file);
            }
        }
        finally {
            this.getOperationMonitor().operationFinish(Operation.DOWNLOAD, filesToDownload);
            transferInfo.setRuntime(System.currentTimeMillis() - start);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
        }
        return transferInfo;
    }

    private void downloadFile(final TransferInfo transferInfo, final TransferFile file) {
        if (this.cancelled) {
            LOGGER.fine("Download cancelled");
            return;
        }
        this.getOperationMonitor().operationProcess(Operation.DOWNLOAD, file);
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new DownloadAtomicAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteClient.this.downloadFileInternal(transferInfo, file);
                    }
                    catch (IOException | RemoteException exc) {
                        LOGGER.log(Level.INFO, null, exc);
                        RemoteClient.this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
                    }
                }
            }));
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)ex.getMessage().trim()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void downloadFileInternal(TransferInfo transferInfo, TransferFile file) throws IOException, RemoteException {
        block47: {
            block50: {
                block49: {
                    block48: {
                        block46: {
                            localFile = this.getLocalFile(new File(file.getBaseLocalDirectoryPath()), file);
                            if (!file.isLink()) break block46;
                            this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_Symlink", (Object)file.getRemotePath()));
                            break block47;
                        }
                        if (!this.isParentLink(file)) break block48;
                        this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ParentSymlink", (Object)file.getRemotePath()));
                        break block47;
                    }
                    if (!file.isDirectory()) break block49;
                    if (RemoteClient.LOGGER.isLoggable(Level.FINE)) {
                        RemoteClient.LOGGER.log(Level.FINE, "Downloading directory: {0}", file);
                    }
                    if (!this.cdBaseRemoteDirectory(file.getRemotePath(), false)) {
                        RemoteClient.LOGGER.log(Level.FINE, "Remote directory {0} does not exist => ignoring", file.getRemotePath());
                        this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)file.getRemotePath()));
                        return;
                    }
                    if (!localFile.exists()) {
                        if (!RemoteClient.mkLocalDirs(localFile)) {
                            this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDir", (Object)localFile));
                            return;
                        }
                    } else if (localFile.isFile()) {
                        this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_DirFileCollision", (Object)file));
                        return;
                    }
                    this.transferSucceeded(transferInfo, file);
                    if (!file.hasRemoteChildrenFetched()) {
                        for (TransferFile child : file.getRemoteChildren()) {
                            this.downloadFile(transferInfo, child);
                        }
                    }
                    break block47;
                }
                if (!file.isFile()) break block50;
                parent = localFile.getParentFile();
                if (!RemoteClient.$assertionsDisabled && parent == null) {
                    throw new AssertionError((Object)("File " + localFile + " has no parent file?!"));
                }
                if (!parent.exists()) {
                    if (!RemoteClient.mkLocalDirs(parent)) {
                        this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDir", (Object)parent));
                        return;
                    }
                } else {
                    if (parent.isFile()) {
                        this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_DirFileCollision", (Object)file));
                        return;
                    }
                    if (localFile.exists() && !localFile.canWrite()) {
                        this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FileNotWritable", (Object)localFile));
                        return;
                    }
                }
                if (!RemoteClient.$assertionsDisabled && !parent.isDirectory()) {
                    throw new AssertionError((Object)("Parent file of " + localFile + " must be a directory"));
                }
                tmpLocalFile = this.createTmpLocalFile(file);
                if (tmpLocalFile == null) {
                    RemoteClient.LOGGER.log(Level.INFO, "Local temporary file could not be created for {0}", file.getRemotePath());
                    this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateTmpLocalFile", (Object)file.getRemotePath()));
                    return;
                }
                if (RemoteClient.LOGGER.isLoggable(Level.FINE)) {
                    RemoteClient.LOGGER.log(Level.FINE, "Downloading {0} => {1}", new Object[]{file.getRemotePath(), tmpLocalFile.isInMemory() != false ? "memory" : "tmp local file on disk"});
                }
                if (!this.cdBaseRemoteDirectory(file.getParentRemotePath(), false)) {
                    RemoteClient.LOGGER.log(Level.FINE, "Remote directory {0} does not exist => ignoring file {1}", new Object[]{file.getParentRemotePath(), file.getRemotePath()});
                    this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)file.getParentRemotePath()));
                    return;
                }
                success = false;
                os = tmpLocalFile.getOutputStream();
                if (os == null) {
                    this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotOpenTmpLocalFile", (Object)tmpLocalFile));
                    return;
                }
                try {
                    for (i = 1; i <= 3; ++i) {
                        var10_13 = this;
                        synchronized (var10_13) {
                            fileRetrieved = this.remoteClient.retrieveFile(file.getName(), os);
                        }
                        if (fileRetrieved) {
                            success = true;
                            if (!RemoteClient.LOGGER.isLoggable(Level.FINE)) ** break;
                            RemoteClient.LOGGER.fine(String.format("The %d. attempt to download '%s' was successful", new Object[]{i, file.getRemotePath()}));
                            ** break;
                        }
                        if (!RemoteClient.LOGGER.isLoggable(Level.FINE)) continue;
                        RemoteClient.LOGGER.fine(String.format("The %d. attempt to download '%s' was NOT successful", new Object[]{i, file.getRemotePath()}));
                    }
                }
                catch (Throwable var13_16) {
                    os.close();
                    try {
                        if (success) {
                            success = this.copyTmpLocalFile(tmpLocalFile, localFile);
                            if (RemoteClient.LOGGER.isLoggable(Level.FINE)) {
                                RemoteClient.LOGGER.fine(String.format("File %s copied to %s: %s", new Object[]{tmpLocalFile, localFile, success}));
                            }
                        }
                        if (success) {
                            this.transferSucceeded(transferInfo, file);
                        } else {
                            this.transferFailed(transferInfo, file, this.getOperationFailureMessage(Operation.DOWNLOAD, file.getName()));
                        }
                    }
                    catch (DownloadSkipException ex) {
                        if (RemoteClient.LOGGER.isLoggable(Level.FINE)) {
                            RemoteClient.LOGGER.fine(String.format("File %s ignored by user (unsaved changes in the local file)", new Object[]{localFile}));
                        }
                        this.transferIgnored(transferInfo, file, Bundle.RemoteClient_download_ignored_byUser());
                    }
                    finally {
                        RemoteClient.LOGGER.fine("Tmp local file cleanup");
                        tmpLocalFile.cleanup();
                    }
                    throw var13_16;
                }
lbl105:
                // 3 sources

                os.close();
                try {
                    if (success) {
                        success = this.copyTmpLocalFile(tmpLocalFile, localFile);
                        if (RemoteClient.LOGGER.isLoggable(Level.FINE)) {
                            RemoteClient.LOGGER.fine(String.format("File %s copied to %s: %s", new Object[]{tmpLocalFile, localFile, success}));
                        }
                    }
                    if (success) {
                        this.transferSucceeded(transferInfo, file);
                    }
                    this.transferFailed(transferInfo, file, this.getOperationFailureMessage(Operation.DOWNLOAD, file.getName()));
                }
                catch (DownloadSkipException ex) {
                    if (RemoteClient.LOGGER.isLoggable(Level.FINE)) {
                        RemoteClient.LOGGER.fine(String.format("File %s ignored by user (unsaved changes in the local file)", new Object[]{localFile}));
                    }
                    this.transferIgnored(transferInfo, file, Bundle.RemoteClient_download_ignored_byUser());
                }
                finally {
                    RemoteClient.LOGGER.fine("Tmp local file cleanup");
                    tmpLocalFile.cleanup();
                }
            }
            this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_UnknownFileType", (Object)file.getRemotePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadTemporary(TmpLocalFile tmpFile, TransferFile file) throws RemoteException {
        if (!file.isFile()) {
            throw new RemoteException(Bundle.RemoteClient_error_notFile());
        }
        if (!this.cdBaseRemoteDirectory(file.getParentRemotePath(), false)) {
            LOGGER.log(Level.FINE, "Remote directory {0} does not exist => cannot download file {1}", new Object[]{file.getParentRemotePath(), file.getRemotePath()});
            return false;
        }
        boolean success = false;
        OutputStream os = tmpFile.getOutputStream();
        if (os == null) {
            throw new RemoteException(Bundle.RemoteClient_error_cannotOpenTmpLocalFile(tmpFile));
        }
        try {
            for (int i = 1; i <= 3; ++i) {
                boolean fileRetrieved;
                RemoteClient remoteClient = this;
                synchronized (remoteClient) {
                    fileRetrieved = this.remoteClient.retrieveFile(file.getName(), os);
                }
                if (fileRetrieved) {
                    success = true;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("The %d. attempt to download '%s' was successful", i, file.getRemotePath()));
                    }
                    break;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(String.format("The %d. attempt to download '%s' was NOT successful", i, file.getRemotePath()));
            }
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return success;
    }

    private TmpLocalFile createTmpLocalFile(TransferFile file) {
        long size = file.getSize();
        if (size <= 512000L && !(file instanceof LocalTransferFile)) {
            return TmpLocalFile.inMemory((int)size);
        }
        return TmpLocalFile.onDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyTmpLocalFile(TmpLocalFile source, File target) throws DownloadSkipException {
        boolean moved = false;
        boolean downloadSkipped = false;
        FileObject foTarget = this.ensureTargetExists(FileUtil.normalizeFile((File)target));
        if (foTarget == null) {
            return false;
        }
        try {
            FileLock lock = this.lockFile(foTarget);
            if (lock == null) {
                return false;
            }
            try (InputStream in = source.getInputStream();){
                if (in == null) {
                    boolean bl = false;
                    return bl;
                }
                try (OutputStream out = foTarget.getOutputStream(lock);){
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                    moved = true;
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException | InvalidPathException ex) {
            LOGGER.log(Level.INFO, "Error while moving local file", ex);
            moved = false;
        }
        catch (DownloadSkipException ex) {
            downloadSkipped = true;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Content of tmp local file copied into %s: %s", target.getName(), moved));
        }
        if (!downloadSkipped) return moved;
        throw new DownloadSkipException();
    }

    private FileObject ensureTargetExists(File target) {
        if (target.exists()) {
            FileObject targetFo = FileUtil.toFileObject((File)target);
            if (targetFo == null) {
                LOGGER.log(Level.WARNING, "Cannot get file object for existing file {0}", target);
                return null;
            }
            return targetFo;
        }
        LOGGER.log(Level.FINE, "Local file {0} does not exists so it will be created", target.getName());
        File parent = target.getParentFile();
        boolean parentExists = parent.isDirectory();
        if (!parentExists) {
            parentExists = parent.mkdirs();
        }
        if (!parentExists) {
            LOGGER.log(Level.INFO, "Cannot create parent directory {0}", parent);
            return null;
        }
        FileObject parentFo = FileUtil.toFileObject((File)parent);
        if (parentFo == null) {
            LOGGER.log(Level.WARNING, "Cannot get file object for existing file {0}", parent);
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Data file %s created.", target.getName()));
        }
        try {
            return parentFo.createData(target.getName());
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Error while creating local file '" + target + "'", ex);
            return null;
        }
    }

    private FileLock lockFile(FileObject fo) throws IOException, DownloadSkipException {
        try {
            return fo.lock();
        }
        catch (FileAlreadyLockedException lockedException) {
            if (this.warnChangedFile(fo)) {
                FileUtils.saveFile((FileObject)fo);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return fo.lock();
            }
            throw new DownloadSkipException();
        }
    }

    private boolean warnChangedFile(FileObject file) {
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)Bundle.RemoteClient_file_replaceUnsavedContent_question(file.getNameExt()), Bundle.RemoteClient_file_replaceUnsavedContent_title(), 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)desc).equals(NotifyDescriptor.OK_OPTION);
    }

    private File getLocalFile(File localFile, TransferFile transferFile) {
        File newFile = transferFile.resolveLocalFile(localFile);
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)newFile));
        if (fo != null) {
            fo.refresh();
        }
        return newFile;
    }

    private File getLocalFile(File localFile, TransferFile parent, RemoteFile file) {
        File newFile = new File(this.getLocalFile(localFile, parent), file.getName());
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)newFile));
        if (fo != null) {
            fo.refresh();
        }
        return newFile;
    }

    private boolean isParentLink(TransferFile file) {
        while (file.hasParent()) {
            TransferFile parent = file.getParent();
            if (parent.isProjectRoot()) {
                return false;
            }
            if (parent.isLink()) {
                return true;
            }
            file = parent;
        }
        return false;
    }

    public Set<TransferFile> prepareDelete(FileObject baseLocalDirectory, FileObject ... filesToDelete) {
        LOGGER.fine("Preparing files to delete => calling prepareUpload because in fact the same operation is done");
        return this.prepareUpload(baseLocalDirectory, filesToDelete);
    }

    public TransferInfo delete(TransferFile fileToDelete) throws RemoteException {
        return this.delete(Collections.singleton(fileToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo delete(Set<TransferFile> filesToDelete) throws RemoteException {
        assert (filesToDelete != null);
        assert (filesToDelete.size() > 0) : "At least one file to upload must be specified";
        this.ensureConnected();
        long start = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        try {
            this.getOperationMonitor().operationStart(Operation.DELETE, filesToDelete);
            Set<TransferFile> files = this.getFiles(filesToDelete);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Only files: %s => %s", filesToDelete, files));
            }
            this.delete(transferInfo, files);
            Set<TransferFile> dirs = this.getDirectories(filesToDelete);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Only dirs: %s => %s", filesToDelete, dirs));
            }
            this.delete(transferInfo, dirs);
            assert (filesToDelete.size() == files.size() + dirs.size()) : String.format("%s does not match files and dirs: %s %s", filesToDelete, files, dirs);
        }
        finally {
            this.getOperationMonitor().operationFinish(Operation.DELETE, filesToDelete);
            transferInfo.setRuntime(System.currentTimeMillis() - start);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
        }
        return transferInfo;
    }

    private void delete(TransferInfo transferInfo, Set<TransferFile> filesToDelete) {
        for (TransferFile file : filesToDelete) {
            if (this.cancelled) {
                LOGGER.fine("Delete cancelled");
                break;
            }
            try {
                this.getOperationMonitor().operationProcess(Operation.DELETE, file);
                this.deleteFile(transferInfo, file);
            }
            catch (IOException | RemoteException exc) {
                LOGGER.log(Level.INFO, null, exc);
                this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
            }
        }
    }

    private synchronized void deleteFile(TransferInfo transferInfo, TransferFile file) throws IOException, RemoteException {
        boolean success = false;
        this.cdBaseRemoteDirectory();
        if (file.isDirectory()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Deleting directory: {0}", file);
            }
            success = this.remoteClient.deleteDirectory(file.getRemotePath());
            LOGGER.log(Level.FINE, "Folder deleted: {0}", success);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Deleting file: {0}", file);
            }
            success = this.remoteClient.deleteFile(file.getRemotePath());
            LOGGER.log(Level.FINE, "File deleted: {0}", success);
        }
        if (success) {
            this.transferSucceeded(transferInfo, file);
        } else {
            String msg = null;
            msg = !this.remoteClient.exists(file.getParentRemotePath(), file.getName()) ? NbBundle.getMessage(RemoteClient.class, (String)"MSG_FileNotExists", (Object)file.getName()) : (file.isDirectory() && this.cdBaseRemoteDirectory(file.getParentRemotePath(), false) && this.remoteClient.listFiles().size() > 0 ? NbBundle.getMessage(RemoteClient.class, (String)"MSG_FolderNotEmpty", (Object)file.getName()) : this.getOperationFailureMessage(Operation.DELETE, file.getName()));
            this.transferFailed(transferInfo, file, msg);
        }
    }

    private void transferSucceeded(TransferInfo transferInfo, TransferFile file) {
        transferInfo.addTransfered(file);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Transfered: {0}", file);
        }
    }

    private void transferFailed(TransferInfo transferInfo, TransferFile file, String reason) {
        if (!transferInfo.isFailed(file)) {
            transferInfo.addFailed(file, reason);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Failed: {0}, reason: {1}", new Object[]{file, reason});
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Failed: {0}, reason: {1} [ignored, failed already]", new Object[]{file, reason});
        }
    }

    private void transferPartiallyFailed(TransferInfo transferInfo, TransferFile file, String reason) {
        if (!transferInfo.isPartiallyFailed(file)) {
            transferInfo.addPartiallyFailed(file, reason);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Partially failed: {0}, reason: {1}", new Object[]{file, reason});
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Partially failed: {0}, reason: {1} [ignored, partially failed already]", new Object[]{file, reason});
        }
    }

    private void transferIgnored(TransferInfo transferInfo, TransferFile file, String reason) {
        if (!transferInfo.isIgnored(file)) {
            transferInfo.addIgnored(file, reason);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Ignored: {0}, reason: {1}", new Object[]{file, reason});
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Ignored: {0}, reason: {1} [ignored, ignored already]", new Object[]{file, reason});
        }
    }

    private synchronized String getOperationFailureMessage(Operation operation, String fileName) {
        String message = this.remoteClient.getNegativeReplyString();
        if (message == null) {
            String key = null;
            switch (operation) {
                case UPLOAD: {
                    key = "MSG_CannotUploadFile";
                    break;
                }
                case DOWNLOAD: {
                    key = "MSG_CannotDownloadFile";
                    break;
                }
                case DELETE: {
                    key = "MSG_CannotDeleteFile";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation type: " + (Object)((Object)operation));
                }
            }
            message = NbBundle.getMessage(RemoteClient.class, (String)key, (Object)fileName);
        }
        return message;
    }

    private synchronized void ensureConnected() throws RemoteException {
        if (!this.remoteClient.isConnected()) {
            LOGGER.fine("Client not connected -> connecting");
            this.connect();
        }
    }

    private boolean cdBaseRemoteDirectory() throws RemoteException {
        return this.cdRemoteDirectory(this.baseRemoteDirectory, true);
    }

    private boolean cdBaseRemoteDirectory(String subdirectory, boolean create) throws RemoteException {
        assert (subdirectory == null || !subdirectory.startsWith("/")) : "Subdirectory must be null or relative [" + subdirectory + "]";
        String path = this.baseRemoteDirectory;
        if (subdirectory != null && !subdirectory.equals(".")) {
            path = this.baseRemoteDirectory + (this.baseRemoteDirectory.equals("/") ? "" : "/") + subdirectory;
        }
        return this.cdRemoteDirectory(path, create);
    }

    private synchronized boolean cdRemoteDirectory(String directory, boolean create) throws RemoteException {
        LOGGER.log(Level.FINE, "Changing directory to {0}", directory);
        boolean success = this.remoteClient.changeWorkingDirectory(directory);
        if (!success && create) {
            return this.createAndCdRemoteDirectory(directory);
        }
        return success;
    }

    private synchronized boolean createAndCdRemoteDirectory(String filePath) throws RemoteException {
        LOGGER.log(Level.FINE, "Creating file path {0}", filePath);
        if (filePath.startsWith("/") && !this.remoteClient.changeWorkingDirectory("/")) {
            throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)"/"), this.remoteClient.getReplyString());
        }
        for (String dir : filePath.split("/")) {
            if (dir.length() == 0 || this.remoteClient.changeWorkingDirectory(dir)) continue;
            if (!this.remoteClient.makeDirectory(dir)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Cannot create directory: {0}", this.getWorkingDirectory() + "/" + dir);
                }
                throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDirectory", (Object)dir), this.remoteClient.getReplyString());
            }
            if (!this.remoteClient.changeWorkingDirectory(dir)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Cannot enter directory: {0}", this.getWorkingDirectory() + "/" + dir);
                }
                return false;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Directory ''{0}'' created and entered", this.getWorkingDirectory());
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [remote configuration: ");
        sb.append(this.configuration);
        sb.append(", baseRemoteDirectory: ");
        sb.append(this.baseRemoteDirectory);
        sb.append("]");
        return sb.toString();
    }

    private boolean isVisible(String name) {
        assert (name != null);
        return !IGNORED_DIRS.contains(name);
    }

    private boolean isVisible(File file) {
        assert (file != null);
        if (!this.isVisible(file.getName())) {
            return false;
        }
        return this.properties.getPhpVisibilityQuery().isVisible(file);
    }

    private static boolean mkLocalDirs(File folder) {
        try {
            FileUtil.createFolder((File)folder);
        }
        catch (IOException exc) {
            LOGGER.log(Level.INFO, null, exc);
            return false;
        }
        return true;
    }

    private Set<TransferFile> getFiles(Set<TransferFile> all) {
        HashSet<TransferFile> files = new HashSet<TransferFile>();
        for (TransferFile file : all) {
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private Set<TransferFile> getDirectories(Set<TransferFile> all) {
        TreeSet<TransferFile> dirs = new TreeSet<TransferFile>(new Comparator<TransferFile>(){
            private final String SEPARATOR = Pattern.quote("/");

            @Override
            public int compare(TransferFile o1, TransferFile o2) {
                int cmp = o2.getRemotePath().split(this.SEPARATOR).length - o1.getRemotePath().split(this.SEPARATOR).length;
                return cmp != 0 ? cmp : 1;
            }
        });
        for (TransferFile file : all) {
            if (!file.isDirectory()) continue;
            dirs.add(file);
        }
        return dirs;
    }

    private synchronized String getWorkingDirectory() throws RemoteException {
        return RemoteUtils.sanitizeDirectoryPath(this.remoteClient.printWorkingDirectory());
    }

    public RemoteClientImplementation createRemoteClientImplementation(final String baseLocalDirectory) {
        return new RemoteClientImplementation(){

            @Override
            public String getBaseLocalDirectory() {
                return baseLocalDirectory;
            }

            @Override
            public String getBaseRemoteDirectory() {
                return RemoteClient.this.getBaseRemoteDirectory();
            }

            @Override
            public List<TransferFile> listLocalFiles(TransferFile file) {
                ArrayList<TransferFile> kids = new ArrayList<TransferFile>();
                File[] children = file.resolveLocalFile().listFiles();
                if (children != null) {
                    for (File child : children) {
                        if (RemoteClient.this.isVisible(child)) {
                            LOGGER.log(Level.FINE, "File {0} added to children", child);
                            kids.add(TransferFile.fromFile(this, file, child));
                            continue;
                        }
                        LOGGER.log(Level.FINE, "File {0} NOT added to children [invisible]", child);
                    }
                }
                return kids;
            }

            @Override
            public List<TransferFile> listRemoteFiles(TransferFile file) throws RemoteException {
                return RemoteClient.this.listFiles(file);
            }
        };
    }

    private static final class DownloadAtomicAction
    implements FileSystem.AtomicAction {
        private final Runnable runnable;

        public DownloadAtomicAction(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() throws IOException {
            if (this.runnable != null) {
                this.runnable.run();
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return 42;
        }
    }

    private static final class AdvancedPropertiesBuilder {
        InputOutput io;
        String additionalInitialSubdirectory;
        boolean preservePermissions = false;
        boolean uploadDirectly = false;
        OperationMonitor operationMonitor;
        PhpVisibilityQuery phpVisibilityQuery;

        AdvancedPropertiesBuilder() {
        }

        public AdvancedPropertiesBuilder(AdvancedProperties properties) {
            this.io = properties.getInputOutput();
            this.additionalInitialSubdirectory = properties.getAdditionalInitialSubdirectory();
            this.preservePermissions = properties.isPreservePermissions();
            this.uploadDirectly = properties.isUploadDirectly();
            this.operationMonitor = properties.getOperationMonitor();
            this.phpVisibilityQuery = properties.getPhpVisibilityQuery();
        }

        public AdvancedPropertiesBuilder setAdditionalInitialSubdirectory(String additionalInitialSubdirectory) {
            this.additionalInitialSubdirectory = additionalInitialSubdirectory;
            return this;
        }

        public AdvancedPropertiesBuilder setInputOutput(InputOutput io) {
            this.io = io;
            return this;
        }

        public AdvancedPropertiesBuilder setOperationMonitor(OperationMonitor operationMonitor) {
            this.operationMonitor = operationMonitor;
            return this;
        }

        public AdvancedPropertiesBuilder setPreservePermissions(boolean preservePermissions) {
            this.preservePermissions = preservePermissions;
            return this;
        }

        public AdvancedPropertiesBuilder setUploadDirectly(boolean uploadDirectly) {
            this.uploadDirectly = uploadDirectly;
            return this;
        }

        public AdvancedPropertiesBuilder setPhpVisibilityQuery(PhpVisibilityQuery phpVisibilityQuery) {
            this.phpVisibilityQuery = phpVisibilityQuery;
            return this;
        }
    }

    public static final class AdvancedProperties {
        private final InputOutput io;
        private final String additionalInitialSubdirectory;
        private final boolean preservePermissions;
        private final boolean uploadDirectly;
        private final OperationMonitor operationMonitor;
        private final PhpVisibilityQuery phpVisibilityQuery;

        public AdvancedProperties() {
            this(new AdvancedPropertiesBuilder());
        }

        private AdvancedProperties(AdvancedPropertiesBuilder builder) {
            this.io = builder.io;
            this.additionalInitialSubdirectory = builder.additionalInitialSubdirectory;
            this.preservePermissions = builder.preservePermissions;
            this.uploadDirectly = builder.uploadDirectly;
            this.operationMonitor = builder.operationMonitor;
            this.phpVisibilityQuery = builder.phpVisibilityQuery;
        }

        public String getAdditionalInitialSubdirectory() {
            return this.additionalInitialSubdirectory;
        }

        public AdvancedProperties setAdditionalInitialSubdirectory(String additionalInitialSubdirectory) {
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setAdditionalInitialSubdirectory(additionalInitialSubdirectory));
        }

        public InputOutput getInputOutput() {
            return this.io;
        }

        public AdvancedProperties setInputOutput(InputOutput io) {
            Parameters.notNull((CharSequence)"io", (Object)io);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setInputOutput(io));
        }

        public OperationMonitor getOperationMonitor() {
            return this.operationMonitor;
        }

        public AdvancedProperties setOperationMonitor(OperationMonitor operationMonitor) {
            Parameters.notNull((CharSequence)"operationMonitor", (Object)operationMonitor);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setOperationMonitor(operationMonitor));
        }

        public boolean isPreservePermissions() {
            return this.preservePermissions;
        }

        public AdvancedProperties setPreservePermissions(boolean preservePermissions) {
            Parameters.notNull((CharSequence)"preservePermissions", (Object)preservePermissions);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setPreservePermissions(preservePermissions));
        }

        public boolean isUploadDirectly() {
            return this.uploadDirectly;
        }

        public AdvancedProperties setUploadDirectly(boolean uploadDirectly) {
            Parameters.notNull((CharSequence)"uploadDirectly", (Object)uploadDirectly);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setUploadDirectly(uploadDirectly));
        }

        public PhpVisibilityQuery getPhpVisibilityQuery() {
            if (this.phpVisibilityQuery != null) {
                return this.phpVisibilityQuery;
            }
            return PhpVisibilityQuery.getDefault();
        }

        public AdvancedProperties setPhpVisibilityQuery(PhpVisibilityQuery phpVisibilityQuery) {
            Parameters.notNull((CharSequence)"phpVisibilityQuery", (Object)phpVisibilityQuery);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setPhpVisibilityQuery(phpVisibilityQuery));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(200);
            sb.append("AdvancedProperties [ io: ");
            sb.append(this.io);
            sb.append(", additionalInitialSubdirectory: ");
            sb.append(this.additionalInitialSubdirectory);
            sb.append(", preservePermissions: ");
            sb.append(this.preservePermissions);
            sb.append(", uploadDirectly: ");
            sb.append(this.uploadDirectly);
            sb.append(", operationMonitor: ");
            sb.append(this.operationMonitor);
            sb.append(", phpVisibilityQuery: ");
            sb.append(this.phpVisibilityQuery);
            sb.append(" ]");
            return sb.toString();
        }
    }

    private static final class DevNullOperationMonitor
    implements OperationMonitor {
        private DevNullOperationMonitor() {
        }

        @Override
        public void operationStart(Operation operation, Collection<TransferFile> forFiles) {
        }

        @Override
        public void operationProcess(Operation operation, TransferFile forFile) {
        }

        @Override
        public void operationFinish(Operation operation, Collection<TransferFile> forFiles) {
        }

        @Override
        public void addUnits(Collection<TransferFile> files) {
        }
    }

    public static interface OperationMonitor {
        public void operationStart(Operation var1, Collection<TransferFile> var2);

        public void operationProcess(Operation var1, TransferFile var2);

        public void operationFinish(Operation var1, Collection<TransferFile> var2);

        public void addUnits(Collection<TransferFile> var1);
    }

    public static enum Operation {
        UPLOAD,
        DOWNLOAD,
        DELETE,
        LIST;

    }
}

