/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import javax.swing.event.ChangeListener;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.php.latte.lexer.LatteMarkupTokenId;
import org.netbeans.modules.php.latte.parser.Bundle;
import org.netbeans.modules.php.latte.parser.LatteParserResult;
import org.netbeans.modules.php.latte.utils.LatteLexerUtils;

public class LatteParser
extends Parser {
    private static final String CLOSING_SIGN = "/";
    private static final List<String> PAIR_MACROS = new ArrayList<String>();
    private final Deque<Macro> macros = new ArrayDeque<Macro>();
    private LatteParserResult parserResult;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.parserResult = new LatteParserResult(snapshot);
        this.macros.clear();
        TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
        LanguagePath latteLanguagePath = LatteLexerUtils.fetchLanguagePath(tokenHierarchy, LatteMarkupTokenId.language());
        if (latteLanguagePath != null) {
            List tokenSequenceList = tokenHierarchy.tokenSequenceList(latteLanguagePath, 0, Integer.MAX_VALUE);
            this.processTokenSequences(tokenSequenceList);
        }
    }

    private void processTokenSequences(List<TokenSequence<?>> tokenSequenceList) {
        for (TokenSequence<?> tokenSequence : tokenSequenceList) {
            this.processTokenSequence(tokenSequence);
        }
        for (Macro macro : this.macros) {
            this.parserResult.addError(Bundle.ERR_UnclosedMacro(macro.getName()), macro.getOffset(), macro.getLength());
        }
    }

    private void processTokenSequence(TokenSequence<?> tokenSequence) {
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            LatteMarkupTokenId tokenId = (LatteMarkupTokenId)token.id();
            CharSequence tokenText = token.text();
            if (tokenId == LatteMarkupTokenId.T_MACRO_START && LatteParser.mustBeEnded(tokenText)) {
                this.macros.push(new Macro((Token<LatteMarkupTokenId>)token, tokenSequence.offset()));
                continue;
            }
            if (tokenId != LatteMarkupTokenId.T_MACRO_END || !LatteParser.mustBeStarted(tokenText)) continue;
            Macro lastMacro = this.macros.peek();
            if (lastMacro == null) {
                if (CLOSING_SIGN.equals(tokenText)) continue;
                this.parserResult.addError(Bundle.ERR_UnopenendMacro(tokenText), tokenSequence.offset(), token.length());
                continue;
            }
            this.macros.pop();
            if (lastMacro.endsWith(tokenText)) continue;
            this.parserResult.addError(Bundle.ERR_UnclosedMacro(lastMacro.getName()), lastMacro.getOffset(), lastMacro.getLength());
            lastMacro = this.macros.peek();
            if (lastMacro == null || !lastMacro.endsWith(tokenText)) continue;
            this.macros.pop();
        }
    }

    private static boolean mustBeEnded(CharSequence macroName) {
        return PAIR_MACROS.contains(CharSequenceUtilities.toString((CharSequence)macroName));
    }

    private static boolean mustBeStarted(CharSequence macroName) {
        return PAIR_MACROS.contains(CharSequenceUtilities.toString((CharSequence)macroName.subSequence(1, macroName.length()))) || CLOSING_SIGN.equals(macroName);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        return this.parserResult;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    static {
        PAIR_MACROS.add("cache");
        PAIR_MACROS.add("capture");
        PAIR_MACROS.add("define");
        PAIR_MACROS.add("first");
        PAIR_MACROS.add("for");
        PAIR_MACROS.add("foreach");
        PAIR_MACROS.add("form");
        PAIR_MACROS.add("if");
        PAIR_MACROS.add("ifCurrent");
        PAIR_MACROS.add("ifset");
        PAIR_MACROS.add("last");
        PAIR_MACROS.add("sep");
        PAIR_MACROS.add("snippet");
        PAIR_MACROS.add("while");
    }

    private static final class Macro {
        private final Token<LatteMarkupTokenId> token;
        private final int offset;

        private Macro(Token<LatteMarkupTokenId> token, int offset) {
            this.token = token;
            this.offset = offset;
        }

        private boolean endsWith(CharSequence endingTokenText) {
            CharSequence tokenText = this.token.text();
            return CharSequenceUtilities.textEquals((CharSequence)tokenText, (CharSequence)endingTokenText.subSequence(1, endingTokenText.length())) || LatteParser.CLOSING_SIGN.equals(endingTokenText);
        }

        public String getName() {
            return CharSequenceUtilities.toString((CharSequence)this.token.text());
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.token.length();
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + Objects.hashCode(this.token);
            hash = 59 * hash + this.offset;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Macro other = (Macro)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            return this.offset == other.offset;
        }
    }
}

