/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.ExceptionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.packets.BrkpntCommandBuilder;
import org.netbeans.modules.php.dbgp.packets.BrkpntRemoveCommand;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public final class Utils {
    public static final String PATH_IN_LAYER = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/Debugger";
    static final String MIME_TYPE = "text/x-php5";
    private static LineFactory lineFactory = new LineFactory();

    private Utils() {
    }

    public static void setLineFactory(LineFactory lineFactory) {
        Utils.lineFactory = lineFactory;
    }

    @CheckForNull
    public static Line getCurrentLine() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getCurrentFile();
        if (!Utils.isPhpFile(fileObject)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    @CheckForNull
    public static Line getLine(FileObject file, int lineNumber) {
        DataObject dataObject;
        if (file == null || lineNumber < 0) {
            return null;
        }
        try {
            dataObject = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set ls = lineCookie.getLineSet();
        if (ls == null) {
            return null;
        }
        try {
            return ls.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static BrkpntSetCommand getCommand(DebugSession session, SessionId id, AbstractBreakpoint breakpoint) {
        if (!breakpoint.isSessionRelated(session)) {
            return null;
        }
        BrkpntSetCommand command = null;
        if (breakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            command = BrkpntCommandBuilder.buildLineBreakpoint(id, session.getTransactionId(), lineBreakpoint);
        } else if (breakpoint instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)breakpoint;
            FunctionBreakpoint.Type type = functionBreakpoint.getType();
            if (type == FunctionBreakpoint.Type.CALL) {
                command = BrkpntCommandBuilder.buildCallBreakpoint(session.getTransactionId(), functionBreakpoint);
            } else if (type == FunctionBreakpoint.Type.RETURN) {
                command = BrkpntCommandBuilder.buildReturnBreakpoint(session.getTransactionId(), functionBreakpoint);
            } else assert (false);
        } else if (breakpoint instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
            command = BrkpntCommandBuilder.buildExceptionBreakpoint(session.getTransactionId(), exceptionBreakpoint);
        }
        if (command == null) {
            breakpoint.setInvalid();
        }
        if (!breakpoint.isEnabled()) {
            command.setState(BrkpntSetCommand.State.DISABLED);
        }
        return command;
    }

    public static AbstractBreakpoint getBreakpoint(String id) {
        Breakpoint[] breakpoints;
        for (Breakpoint breakpoint : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            AbstractBreakpoint bkpnt;
            String bkpntId;
            if (!(breakpoint instanceof AbstractBreakpoint) || !id.equals(bkpntId = (bkpnt = (AbstractBreakpoint)breakpoint).getBreakpointId())) continue;
            return bkpnt;
        }
        return null;
    }

    public static void cleanBreakpoint(DebugSession session, String breakpointId) {
        BrkpntRemoveCommand removeCommand = new BrkpntRemoveCommand(session.getTransactionId(), breakpointId);
        session.sendCommandLater(removeCommand);
    }

    public static boolean isPhpFile(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        String mimeType = fileObject.getMIMEType();
        return MIME_TYPE.equals(mimeType);
    }

    public static Line getLine(int line, String remoteFileName, SessionId id) {
        return lineFactory.getLine(line, remoteFileName, id);
    }

    public static void openPhpOptionsDialog() {
        OptionsDisplayer.getDefault().open(PATH_IN_LAYER);
    }

    public static DataObject getDataObjectByRemote(SessionId id, String uri) {
        try {
            FileObject fileObject = id.toSourceFile(uri);
            if (fileObject == null) {
                return null;
            }
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
    }

    public static boolean isInPhpScript(Line line) {
        FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
        if (!Utils.isPhpFile(fo)) {
            return false;
        }
        Set mimeTypesOnLine = EditorContextDispatcher.getDefault().getMIMETypesOnLine(line);
        return mimeTypesOnLine.contains(MIME_TYPE);
    }

    public static class LineFactory {
        public Line getLine(int line, String remoteFileName, SessionId id) {
            DataObject dataObject = Utils.getDataObjectByRemote(id, remoteFileName);
            if (dataObject == null) {
                return null;
            }
            LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
            if (lineCookie == null) {
                return null;
            }
            Line.Set set = lineCookie.getLineSet();
            if (set == null) {
                return null;
            }
            try {
                return set.getCurrent(line - 1);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                Logger.getLogger(Utils.class.getName()).log(Level.FINE, e.getMessage(), e);
                return null;
            }
        }
    }
}

