/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.files;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.web.clientproject.api.json.JsonFile;
import org.openide.filesystems.FileObject;

public final class ComposerJson {
    public static final String FILE_NAME = "composer.json";
    public static final String PROP_REQUIRE = "REQUIRE";
    public static final String PROP_REQUIRE_DEV = "REQUIRE_DEV";
    public static final String PROP_VENDOR_DIR = "VENDOR_DIR";
    private static final String FIELD_REQUIRE = "require";
    private static final String FIELD_REQUIRE_DEV = "require-dev";
    private static final String FIELD_CONFIG = "config";
    private static final String FIELD_VENDOR_DIR = "vendor-dir";
    private static final String FIELD_SCRIPTS = "scripts";
    static final String DEFAULT_VENDOR_DIR = "vendor";
    private final JsonFile composerJson;

    public ComposerJson(FileObject directory) {
        this(directory, FILE_NAME);
    }

    ComposerJson(FileObject directory, String filename) {
        assert (directory != null);
        assert (filename != null);
        this.composerJson = new JsonFile(filename, directory, JsonFile.WatchedFields.create().add(PROP_REQUIRE, new String[]{FIELD_REQUIRE}).add(PROP_REQUIRE_DEV, new String[]{FIELD_REQUIRE_DEV}).add(PROP_VENDOR_DIR, new String[]{FIELD_CONFIG, FIELD_VENDOR_DIR}));
    }

    public File getFile() {
        return this.composerJson.getFile();
    }

    public boolean exists() {
        return this.composerJson.exists();
    }

    public File getVendorDir() {
        String vendorDir = (String)this.composerJson.getContentValue(String.class, new String[]{FIELD_CONFIG, FIELD_VENDOR_DIR});
        if (vendorDir == null) {
            vendorDir = DEFAULT_VENDOR_DIR;
        }
        return new File(this.getFile().getParentFile(), vendorDir);
    }

    public Set<String> getScripts() {
        Map scripts = (Map)this.composerJson.getContentValue(Map.class, new String[]{FIELD_SCRIPTS});
        if (scripts == null) {
            return Collections.emptySet();
        }
        return scripts.keySet();
    }

    public void addPropertyChangeListener(PropertyChangeListener composerJsonListener) {
        this.composerJson.addPropertyChangeListener(composerJsonListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener composerJsonListener) {
        this.composerJson.removePropertyChangeListener(composerJsonListener);
    }

    public ComposerDependencies getDependencies() {
        Map dependencies = (Map)this.composerJson.getContentValue(Map.class, new String[]{FIELD_REQUIRE});
        Map devDependencies = (Map)this.composerJson.getContentValue(Map.class, new String[]{FIELD_REQUIRE_DEV});
        return new ComposerDependencies(this.sanitizeDependencies(dependencies), this.sanitizeDependencies(devDependencies));
    }

    @CheckForNull
    private Map<String, String> sanitizeDependencies(@NullAllowed Map<Object, Object> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        HashMap<String, String> sanitized = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            sanitized.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return sanitized;
    }

    public static final class ComposerDependencies {
        public final Map<String, String> dependencies = new ConcurrentHashMap<String, String>();
        public final Map<String, String> devDependencies = new ConcurrentHashMap<String, String>();

        ComposerDependencies(@NullAllowed Map<String, String> dependencies, @NullAllowed Map<String, String> devDependencies) {
            if (dependencies != null) {
                this.dependencies.putAll(dependencies);
            }
            if (devDependencies != null) {
                this.devDependencies.putAll(devDependencies);
            }
        }

        public boolean isEmpty() {
            return this.dependencies.isEmpty() && this.devDependencies.isEmpty();
        }

        public int getCount() {
            return this.dependencies.size() + this.devDependencies.size();
        }

        public String toString() {
            return "ComposerDependencies{dependencies=" + this.dependencies + ", devDependencies=" + this.devDependencies + "}";
        }
    }
}

