/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.run;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.codeception.run.Bundle;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.run.TestCase;
import org.openide.filesystems.FileUtil;

public final class TestCaseVo {
    private static final String CODECEPTION_TYPE = "Codeception";
    private static final String EXPECTED_SECTION_START = "--- Expected";
    private static final String EXPECTED_ROW_START = "-";
    private static final String ACTUAL_SECTION_START = "+++ Actual";
    private static final String ACTUAL_ROW_START = "+";
    private static final String DIFF_SECTION_START = "@@ @@";
    private final List<String> stacktrace = new ArrayList<String>();
    private final String className;
    private final String name;
    private final String file;
    private final int line;
    private final long time;
    TestCase.Status status = TestCase.Status.PASSED;

    public TestCaseVo(String className, String name, String file, int line, long time) {
        assert (name != null);
        this.className = className;
        this.name = name;
        this.file = file;
        this.line = line;
        this.time = time;
    }

    static TestCaseVo skippedTestCase() {
        TestCaseVo testCase = new TestCaseVo(null, Bundle.TestCaseVo_tests_no(), null, -1, -1L);
        testCase.status = TestCase.Status.SKIPPED;
        return testCase;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return CODECEPTION_TYPE;
    }

    @CheckForNull
    public String getClassName() {
        return this.className;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public Locations.Line getLocation() {
        if (this.file == null) {
            return null;
        }
        File f = new File(this.file);
        if (!f.isFile()) {
            return null;
        }
        return new Locations.Line(FileUtil.toFileObject((File)f), this.line);
    }

    public long getTime() {
        return this.time;
    }

    public String[] getStackTrace() {
        return this.stacktrace.toArray(new String[this.stacktrace.size()]);
    }

    public TestCase.Diff getDiff() {
        StringBuilder expected = new StringBuilder(100);
        StringBuilder actual = new StringBuilder(100);
        boolean diffStarted = false;
        for (String row : this.stacktrace) {
            if (!row.contains(EXPECTED_SECTION_START) || !row.contains(ACTUAL_SECTION_START)) continue;
            for (String part : row.split("\r?\n")) {
                if (diffStarted) {
                    if (part.startsWith(EXPECTED_ROW_START)) {
                        this.addSpace(expected);
                        expected.append(part.substring(EXPECTED_ROW_START.length()));
                        continue;
                    }
                    if (part.startsWith(ACTUAL_ROW_START)) {
                        this.addSpace(actual);
                        actual.append(part.substring(ACTUAL_ROW_START.length()));
                        continue;
                    }
                    String p = part.substring(1);
                    this.addSpace(expected);
                    expected.append(p);
                    this.addSpace(actual);
                    actual.append(p);
                    continue;
                }
                if (!part.equals(DIFF_SECTION_START)) continue;
                diffStarted = true;
            }
        }
        return new TestCase.Diff(expected.toString(), actual.toString());
    }

    private void addSpace(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append("\n");
        }
    }

    void addStacktrace(String line) {
        this.stacktrace.add(line);
    }

    void setErrorStatus() {
        assert (this.status == TestCase.Status.PASSED);
        this.status = TestCase.Status.ERROR;
    }

    public void setFailureStatus() {
        assert (this.status == TestCase.Status.PASSED);
        this.status = TestCase.Status.FAILED;
    }

    public TestCase.Status getStatus() {
        return this.status;
    }

    public boolean isError() {
        return this.status.equals((Object)TestCase.Status.ERROR);
    }

    public boolean isFailure() {
        return this.status.equals((Object)TestCase.Status.FAILED);
    }

    public String toString() {
        return String.format("TestCaseVo{name: %s, file: %s, line: %d, time: %d, status: %s, stacktrace: %s}", this.name, this.file, this.line, this.time, this.status, this.stacktrace);
    }
}

