/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.analysis.commands.CodingStandardsFixer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorCodingStandardsFixerParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.netbeans.modules.php.analysis.ui.options.Bundle;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CodingStandardsFixerOptionsPanel
extends AnalysisCategoryPanel {
    private static final long serialVersionUID = -1267197272368337313L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton codingStandardsFixerBrowseButton;
    private JComboBox<String> codingStandardsFixerConfigComboBox;
    private JLabel codingStandardsFixerConfigLabel;
    private JLabel codingStandardsFixerHintLabel;
    private JLabel codingStandardsFixerLabel;
    private JLabel codingStandardsFixerLearnMoreLabel;
    private JComboBox<String> codingStandardsFixerLevelComboBox;
    private JLabel codingStandardsFixerLevelLabel;
    private JLabel codingStandardsFixerOptionsLabel;
    private JTextField codingStandardsFixerOptionsTextField;
    private JButton codingStandardsFixerSearchButton;
    private JTextField codingStandardsFixerTextField;
    private JComboBox<String> codingStandardsFixerVersionComboBox;
    private JLabel codingStandardsFixerVersionLabel;
    private JLabel noteLabel;

    public CodingStandardsFixerOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        AnalysisDefaultDocumentListener defaultDocumentListener = new AnalysisDefaultDocumentListener(() -> this.fireChange());
        this.initCodingStandardsFixer(defaultDocumentListener);
        this.codingStandardsFixerVersionComboBox.setModel(new DefaultComboBoxModel<String>(CodingStandardsFixer.VERSIONS.toArray(new String[0])));
        this.codingStandardsFixerLevelComboBox.setModel(new DefaultComboBoxModel<String>(CodingStandardsFixer.ALL_LEVEL.toArray(new String[0])));
        this.codingStandardsFixerConfigComboBox.setModel(new DefaultComboBoxModel<String>(CodingStandardsFixer.ALL_CONFIG.toArray(new String[0])));
    }

    private void initCodingStandardsFixer(DocumentListener defaultDocumentListener) {
        this.codingStandardsFixerHintLabel.setText(Bundle.CodingStandardsFixerOptionsPanel_hint("php-cs-fixer", "php-cs-fixer.phar"));
        this.codingStandardsFixerLevelComboBox.setModel(new DefaultComboBoxModel());
        this.codingStandardsFixerTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.codingStandardsFixerOptionsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        ActionListener defaultAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodingStandardsFixerOptionsPanel.this.fireChange();
            }
        };
        this.codingStandardsFixerLevelComboBox.addActionListener(defaultAL);
        this.codingStandardsFixerConfigComboBox.addActionListener(defaultAL);
    }

    public String getCodingStandardsFixerPath() {
        return this.codingStandardsFixerTextField.getText();
    }

    public void setCodingStandardsFixerPath(String path) {
        this.codingStandardsFixerTextField.setText(path);
    }

    public String getCodingStandardsFixerVersion() {
        return (String)this.codingStandardsFixerVersionComboBox.getSelectedItem();
    }

    public void setCodingStandardsFixerVersion(String version) {
        this.codingStandardsFixerVersionComboBox.setSelectedItem(version);
    }

    @CheckForNull
    public String getCodingStandardsFixerLevel() {
        return (String)this.codingStandardsFixerLevelComboBox.getSelectedItem();
    }

    public void setCodingStandardsFixerLevel(String level) {
        this.codingStandardsFixerLevelComboBox.setSelectedItem(level);
    }

    @CheckForNull
    public String getCodingStandardsFixerConfig() {
        return (String)this.codingStandardsFixerConfigComboBox.getSelectedItem();
    }

    public void setCodingStandardsFixerConfig(String config) {
        this.codingStandardsFixerConfigComboBox.setSelectedItem(config);
    }

    public String getCodingStandardsFixerOptions() {
        return this.codingStandardsFixerOptionsTextField.getText();
    }

    public void setCodingStandardsFixerOptoins(String options) {
        this.codingStandardsFixerOptionsTextField.setText(options);
    }

    @Override
    public String getCategoryName() {
        return Bundle.CodingStandardsFixerOptionsPanel_category_name();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void update() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        this.setCodingStandardsFixerVersion(analysisOptions.getCodingStandardsFixerVersion());
        this.setCodingStandardsFixerPath(analysisOptions.getCodingStandardsFixerPath());
        this.setCodingStandardsFixerLevel(analysisOptions.getCodingStandardsFixerLevel());
        this.setCodingStandardsFixerConfig(analysisOptions.getCodingStandardsFixerConfig());
        this.setCodingStandardsFixerOptoins(analysisOptions.getCodingStandardsFixerOptions());
    }

    @Override
    public void applyChanges() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        analysisOptions.setCodingStandardsFixerVersion(this.getCodingStandardsFixerVersion());
        analysisOptions.setCodingStandardsFixerPath(this.getCodingStandardsFixerPath());
        analysisOptions.setCodingStandardsFixerLevel(this.getCodingStandardsFixerLevel());
        analysisOptions.setCodingStandardsFixerConfig(this.getCodingStandardsFixerConfig());
        analysisOptions.setCodingStandardsFixerOptions(this.getCodingStandardsFixerOptions());
    }

    @Override
    public boolean isChanged() {
        String saved = AnalysisOptions.getInstance().getCodingStandardsFixerPath();
        String current = this.getCodingStandardsFixerPath().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getCodingStandardsFixerVersion();
        current = this.getCodingStandardsFixerVersion();
        if (saved == null ? StringUtils.hasText((String)current) : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getCodingStandardsFixerLevel();
        current = this.getCodingStandardsFixerLevel();
        if (saved == null ? StringUtils.hasText((String)current) : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getCodingStandardsFixerConfig();
        current = this.getCodingStandardsFixerConfig();
        if (saved == null ? StringUtils.hasText((String)current) : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getCodingStandardsFixerOptions();
        return !saved.equals(current = this.getCodingStandardsFixerOptions());
    }

    @Override
    public ValidationResult getValidationResult() {
        return new AnalysisOptionsValidator().validateCodingStandardsFixer(ValidatorCodingStandardsFixerParameter.create(this)).getResult();
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void setVersion1ComponentsVisible(boolean visible) {
        this.codingStandardsFixerLevelLabel.setVisible(visible);
        this.codingStandardsFixerLevelComboBox.setVisible(visible);
        this.codingStandardsFixerConfigLabel.setVisible(visible);
        this.codingStandardsFixerConfigComboBox.setVisible(visible);
    }

    private void initComponents() {
        this.codingStandardsFixerLabel = new JLabel();
        this.codingStandardsFixerTextField = new JTextField();
        this.codingStandardsFixerBrowseButton = new JButton();
        this.codingStandardsFixerSearchButton = new JButton();
        this.codingStandardsFixerHintLabel = new JLabel();
        this.codingStandardsFixerVersionLabel = new JLabel();
        this.codingStandardsFixerVersionComboBox = new JComboBox();
        this.codingStandardsFixerLevelLabel = new JLabel();
        this.codingStandardsFixerLevelComboBox = new JComboBox();
        this.codingStandardsFixerConfigLabel = new JLabel();
        this.codingStandardsFixerConfigComboBox = new JComboBox();
        this.codingStandardsFixerOptionsLabel = new JLabel();
        this.codingStandardsFixerOptionsTextField = new JTextField();
        this.noteLabel = new JLabel();
        this.codingStandardsFixerLearnMoreLabel = new JLabel();
        this.codingStandardsFixerLabel.setLabelFor(this.codingStandardsFixerTextField);
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerLabel.text"));
        this.codingStandardsFixerTextField.setText(NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codingStandardsFixerBrowseButton, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerBrowseButton.text"));
        this.codingStandardsFixerBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.codingStandardsFixerSearchButton, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerSearchButton.text"));
        this.codingStandardsFixerSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerVersionLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerVersionLabel.text"));
        this.codingStandardsFixerVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerVersionComboBoxActionPerformed(evt);
            }
        });
        this.codingStandardsFixerLevelLabel.setLabelFor(this.codingStandardsFixerLevelComboBox);
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerLevelLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerLevelLabel.text"));
        this.codingStandardsFixerConfigLabel.setLabelFor(this.codingStandardsFixerConfigComboBox);
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerConfigLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerConfigLabel.text"));
        this.codingStandardsFixerOptionsLabel.setLabelFor(this.codingStandardsFixerOptionsTextField);
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerOptionsLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerOptionsLabel.text"));
        this.codingStandardsFixerOptionsTextField.setText(NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerOptionsTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerLearnMoreLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerLearnMoreLabel.text"));
        this.codingStandardsFixerLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerLearnMoreLabelMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.codingStandardsFixerLearnMoreLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codingStandardsFixerLabel).addComponent(this.codingStandardsFixerLevelLabel).addComponent(this.codingStandardsFixerConfigLabel).addComponent(this.codingStandardsFixerOptionsLabel).addComponent(this.noteLabel, -2, -1, -2).addComponent(this.codingStandardsFixerVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codingStandardsFixerVersionComboBox, -2, -1, -2).addComponent(this.codingStandardsFixerConfigComboBox, -2, -1, -2).addComponent(this.codingStandardsFixerLevelComboBox, -2, -1, -2).addComponent(this.codingStandardsFixerHintLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.codingStandardsFixerOptionsTextField, GroupLayout.Alignment.LEADING).addComponent(this.codingStandardsFixerTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codingStandardsFixerBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codingStandardsFixerSearchButton)))));
        layout.linkSize(0, this.codingStandardsFixerBrowseButton, this.codingStandardsFixerSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerLabel).addComponent(this.codingStandardsFixerTextField, -2, -1, -2).addComponent(this.codingStandardsFixerSearchButton).addComponent(this.codingStandardsFixerBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codingStandardsFixerHintLabel).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerVersionLabel).addComponent(this.codingStandardsFixerVersionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerLevelLabel).addComponent(this.codingStandardsFixerLevelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerConfigComboBox, -2, -1, -2).addComponent(this.codingStandardsFixerConfigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerOptionsLabel).addComponent(this.codingStandardsFixerOptionsTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codingStandardsFixerLearnMoreLabel, -2, -1, -2)));
    }

    private void codingStandardsFixerBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browseCodingStandardsFixer();
        if (file != null) {
            this.codingStandardsFixerTextField.setText(file.getAbsolutePath());
        }
    }

    private void codingStandardsFixerSearchButtonActionPerformed(ActionEvent evt) {
        String codingStandardsFixer = AnalysisUiUtils.searchCodingStandardsFixer();
        if (codingStandardsFixer != null) {
            this.codingStandardsFixerTextField.setText(codingStandardsFixer);
        }
    }

    private void codingStandardsFixerLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void codingStandardsFixerLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/FriendsOfPHP/PHP-CS-Fixer");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void codingStandardsFixerVersionComboBoxActionPerformed(ActionEvent evt) {
        switch (this.getCodingStandardsFixerVersion()) {
            case "1": {
                this.setVersion1ComponentsVisible(true);
                break;
            }
            case "2": {
                this.setVersion1ComponentsVisible(false);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

