/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.testing.run;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.spi.testing.locate.Locations;

public interface TestCase {
    public void setClassName(@NonNull String var1);

    public void setLocation(@NonNull Locations.Line var1);

    public void setTime(long var1);

    public void setStatus(@NonNull Status var1);

    public void setFailureInfo(@NonNull String var1, @NonNull String[] var2, boolean var3, @NonNull Diff var4);

    public static final class Diff {
        private static final Logger LOGGER = Logger.getLogger(Diff.class.getName());
        public static final Diff NOT_KNOWN = new Diff((String)null, (String)null);
        private final Callable<String> expectedTask;
        private final Callable<String> actualTask;
        private volatile String expected;
        private volatile String actual;

        public Diff(@NullAllowed String expected, @NullAllowed String actual) {
            this.expected = expected;
            this.actual = actual;
            this.expectedTask = null;
            this.actualTask = null;
        }

        public Diff(@NullAllowed Callable<String> expectedTask, @NullAllowed Callable<String> actualTask) {
            this.expectedTask = expectedTask;
            this.actualTask = actualTask;
        }

        @CheckForNull
        public String getExpected() {
            if (this.expected != null) {
                return this.expected;
            }
            if (this.expectedTask == null) {
                return null;
            }
            try {
                this.expected = this.expectedTask.call();
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return this.expected;
        }

        @CheckForNull
        public String getActual() {
            if (this.actual != null) {
                return this.actual;
            }
            if (this.actualTask == null) {
                return null;
            }
            try {
                this.actual = this.actualTask.call();
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return this.actual;
        }

        public boolean isValid() {
            return StringUtils.hasText((String)this.getExpected()) || StringUtils.hasText((String)this.getActual());
        }

        public String toString() {
            return "Diff{expected=" + this.getExpected() + ", actual=" + this.getActual() + "}";
        }
    }

    public static enum Status {
        PASSED,
        PENDING,
        FAILED,
        ERROR,
        ABORTED,
        SKIPPED,
        PASSEDWITHERRORS,
        IGNORED;

    }
}

