/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.testing.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class TestRunInfo {
    private final SessionType sessionType;
    private final List<FileObject> startFiles;
    private final String suiteName;
    private final boolean coverageEnabled;
    private final List<TestInfo> initialTests = new CopyOnWriteArrayList<TestInfo>();
    private final List<TestInfo> customTests = new CopyOnWriteArrayList<TestInfo>();
    private final Map<String, Object> parameters = new ConcurrentHashMap<String, Object>();
    private volatile boolean rerun = false;

    private TestRunInfo(Builder builder) {
        assert (builder != null);
        assert (builder.sessionType != null);
        assert (builder.startFiles != null);
        this.sessionType = builder.sessionType;
        this.startFiles = builder.startFiles;
        this.suiteName = builder.suiteName;
        this.coverageEnabled = builder.coverageEnabled;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public List<FileObject> getStartFiles() {
        return Collections.unmodifiableList(this.startFiles);
    }

    @CheckForNull
    public String getSuiteName() {
        return this.suiteName;
    }

    public boolean allTests() {
        return this.suiteName == null;
    }

    public boolean isCoverageEnabled() {
        return this.coverageEnabled;
    }

    public void setInitialTests(Collection<TestInfo> tests) {
        Parameters.notNull((CharSequence)"tests", tests);
        this.initialTests.clear();
        this.initialTests.addAll(tests);
    }

    public List<TestInfo> getCustomTests() {
        List<TestInfo> tests = this.customTests;
        if (tests.isEmpty()) {
            tests = this.initialTests;
        }
        return new ArrayList<TestInfo>(tests);
    }

    public void resetCustomTests() {
        this.customTests.clear();
    }

    public void setCustomTests(Collection<TestInfo> tests) {
        Parameters.notNull((CharSequence)"tests", tests);
        this.resetCustomTests();
        this.customTests.addAll(tests);
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public void setRerun(boolean rerun) {
        this.rerun = rerun;
    }

    public <T> T getParameter(String key, Class<T> type) {
        Parameters.notEmpty((CharSequence)"key", (CharSequence)key);
        Parameters.notNull((CharSequence)"type", type);
        Object param = this.parameters.get(key);
        if (param == null) {
            return null;
        }
        return type.cast(param);
    }

    public void setParameter(String key, Object value) {
        Parameters.notEmpty((CharSequence)"key", (CharSequence)key);
        Parameters.notNull((CharSequence)"value", (Object)value);
        this.parameters.put(key, value);
    }

    public void removeParameter(String key) {
        Parameters.notEmpty((CharSequence)"key", (CharSequence)key);
        this.parameters.remove(key);
    }

    public static final class TestInfo {
        public static final String UNKNOWN_TYPE = "UNKNOWN_TYPE";
        private final String type;
        private final String name;
        private final String className;
        private final String location;

        public TestInfo(String type, String name, @NullAllowed String className, @NullAllowed String location) {
            Parameters.notEmpty((CharSequence)"type", (CharSequence)name);
            Parameters.notEmpty((CharSequence)"name", (CharSequence)name);
            this.type = type;
            this.name = name;
            this.className = className;
            this.location = location;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getClassName() {
            return this.className;
        }

        @CheckForNull
        public String getLocation() {
            return this.location;
        }

        public String toString() {
            return "TestInfo{type=" + this.type + ", name=" + this.name + ", className=" + this.className + ", location=" + this.location + '}';
        }
    }

    public static final class Builder {
        SessionType sessionType;
        List<FileObject> startFiles;
        String suiteName;
        boolean coverageEnabled;

        public Builder setSessionType(@NonNull SessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public Builder setStartFile(@NonNull FileObject startFile) {
            this.setStartFiles(Collections.singletonList(startFile));
            return this;
        }

        public Builder setStartFiles(@NonNull List<FileObject> startFiles) {
            this.startFiles = startFiles;
            return this;
        }

        public Builder setSuiteName(@NullAllowed String suiteName) {
            this.suiteName = suiteName;
            return this;
        }

        public Builder setCoverageEnabled(boolean coverageEnabled) {
            this.coverageEnabled = coverageEnabled;
            return this;
        }

        public TestRunInfo build() {
            Parameters.notNull((CharSequence)"sessionType", (Object)((Object)this.sessionType));
            Parameters.notNull((CharSequence)"startFiles", this.startFiles);
            if (this.startFiles.isEmpty()) {
                throw new IllegalArgumentException("Start files cannot be empty");
            }
            return new TestRunInfo(this);
        }
    }

    public static enum SessionType {
        TEST,
        DEBUG;

    }
}

