/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.queries;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.queries.PhpVisibilityQuery;
import org.openide.filesystems.FileObject;

public final class Queries {
    private static final PhpVisibilityQuery DEFAULT_PHP_VISIBILITY_QUERY = new DefaultPhpVisibilityQuery();

    private Queries() {
    }

    public static PhpVisibilityQuery getVisibilityQuery(@NullAllowed PhpModule phpModule) {
        if (phpModule == null) {
            return DEFAULT_PHP_VISIBILITY_QUERY;
        }
        PhpVisibilityQuery visibilityQuery = (PhpVisibilityQuery)phpModule.getLookup().lookup(PhpVisibilityQuery.class);
        assert (visibilityQuery != null) : "No php visibility query for php module " + phpModule.getClass().getName();
        return visibilityQuery;
    }

    private static final class DefaultPhpVisibilityQuery
    implements PhpVisibilityQuery {
        private DefaultPhpVisibilityQuery() {
        }

        @Override
        public boolean isVisible(File file) {
            return VisibilityQuery.getDefault().isVisible(file);
        }

        @Override
        public boolean isVisible(FileObject file) {
            return VisibilityQuery.getDefault().isVisible(file);
        }

        @Override
        public Collection<FileObject> getIgnoredFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<FileObject> getCodeAnalysisExcludeFiles() {
            return Collections.emptyList();
        }
    }
}

