/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.server.FetchLogException;
import org.netbeans.modules.payara.tooling.server.FetchLogPiped;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;

public class FetchLogLocal
extends FetchLogPiped {
    private static final Logger LOGGER = new Logger(FetchLogLocal.class);

    FetchLogLocal(PayaraServer server, boolean skip) {
        super(server, skip);
    }

    FetchLogLocal(ExecutorService executor, PayaraServer server, boolean skip) {
        super(executor, server, skip);
    }

    private InputStream initInputFile() {
        FileInputStream log;
        String METHOD = "initInputFile";
        File logFile = ServerUtils.getServerLogFile(this.server);
        try {
            log = new FileInputStream(logFile);
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.log(Level.INFO, "initInputFile", "fileNotFound", logFile.getAbsolutePath());
            return null;
        }
        if (this.skip) {
            try {
                int count;
                while ((count = ((InputStream)log).available()) > 0) {
                    ((InputStream)log).skip(count);
                }
            }
            catch (IOException ioe) {
                try {
                    ((InputStream)log).close();
                }
                catch (IOException ioec) {
                    LOGGER.log(Level.INFO, "initInputFile", "cantClose", ioec);
                }
                throw new FetchLogException(LOGGER.excMsg("initInputFile", "cantInit"), ioe);
            }
        }
        return log;
    }

    @Override
    public TaskState call() {
        String METHOD = "call";
        this.notifyListeners(TaskState.RUNNING);
        InputStream fIn = this.initInputFile();
        byte[] buff = new byte[8192];
        File logFile = ServerUtils.getServerLogFile(this.server);
        if (fIn == null) {
            return this.notifyListeners(TaskState.FAILED);
        }
        while (this.taksExecute) {
            try {
                int inCount = fIn.available();
                long lastModified = logFile.lastModified();
                if (inCount <= 0) {
                    Thread.sleep(1000L);
                    inCount = fIn.available();
                    if (inCount <= 0 && logFile.lastModified() > lastModified) {
                        LOGGER.log(Level.FINER, "call", "rotation");
                        fIn.close();
                        fIn = this.initInputFile();
                    }
                }
                if (inCount <= 0) continue;
                while (inCount > 0) {
                    int count = fIn.read(buff);
                    LOGGER.log(Level.FINEST, "call", "read", new Object[]{count});
                    if (count > 0) {
                        this.out.write(buff, 0, count);
                    }
                    if ((inCount -= count) > 0) continue;
                    inCount = fIn.available();
                }
                this.out.flush();
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.INFO, "call", "interrupted", ie.getMessage());
                Thread.currentThread().interrupt();
                return this.notifyListeners(TaskState.COMPLETED);
            }
            catch (InterruptedIOException ie) {
                LOGGER.log(Level.INFO, "call", "interruptedIO", ie.getMessage());
                Thread.currentThread().interrupt();
                return this.notifyListeners(TaskState.COMPLETED);
            }
            catch (IOException ioe) {
                if (this.taksExecute) {
                    LOGGER.log(Level.INFO, "call", "ioException", ioe);
                    return this.notifyListeners(TaskState.FAILED);
                }
                LOGGER.log(Level.INFO, "call", "ioExceptionMsg", ioe.getMessage());
                return this.notifyListeners(TaskState.COMPLETED);
            }
        }
        return this.notifyListeners(TaskState.COMPLETED);
    }
}

