/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.jar.Attributes;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.ResultList;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpTarget;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

public class RunnerHttpListResources
extends RunnerHttpTarget {
    ResultList<String> result;

    public RunnerHttpListResources(PayaraServer server, Command command) {
        super(server, command);
    }

    @Override
    protected ResultList<String> createResult() {
        this.result = new ResultList<String>();
        return this.result;
    }

    @Override
    protected boolean processResponse() {
        String resourcesAttr = this.manifest.getMainAttributes().getValue("children");
        String[] resources = resourcesAttr != null ? resourcesAttr.split("[,;]") : null;
        int resoucesCount = resources != null ? resources.length : 0;
        this.result.value = new ArrayList(resoucesCount);
        if (resources != null) {
            for (String resource : resources) {
                String name;
                Attributes resourceAttr = this.manifest.getAttributes(resource);
                String resourceMsg = resourceAttr.getValue("message");
                try {
                    name = resourceMsg != null ? URLDecoder.decode(resourceMsg, "UTF-8") : null;
                    if (name == null || name.length() <= 0) {
                        name = URLDecoder.decode(resource.trim(), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    throw new CommandException("Can not read HTTP response, caught UnsupportedEncodingException", uee);
                }
                this.result.value.add(name);
            }
        }
        return true;
    }
}

