/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.data;

import java.util.Optional;

public final class JDKVersion {
    private final short major;
    private final Optional<Short> minor;
    private final Optional<Short> subminor;
    private final Optional<Short> update;
    private final Optional<String> vendor;
    private static final int MAJOR_INDEX = 0;
    private static final int MINOR_INDEX = 1;
    private static final int SUBMINOR_INDEX = 2;
    private static final int UPDATE_INDEX = 3;
    private static JDKVersion IDE_JDK_VERSION;
    private static final String VERSION_MATCHER = "(\\d+(\\.\\d+)*)([_u\\-]+[\\S]+)*";
    private static final Short DEFAULT_VALUE;

    private JDKVersion(String version, String vendor) {
        short[] versions = JDKVersion.parseVersions(version);
        this.major = versions[0];
        this.minor = Optional.ofNullable(versions[1]);
        this.subminor = Optional.ofNullable(versions[2]);
        this.update = Optional.ofNullable(versions[3]);
        this.vendor = Optional.ofNullable(vendor);
    }

    JDKVersion(Short major, Optional<Short> minor, Optional<Short> subminor, Optional<Short> update, Optional<String> vendor) {
        this.major = major;
        this.minor = minor;
        this.subminor = subminor;
        this.update = update;
        this.vendor = vendor;
    }

    public short getMajor() {
        return this.major;
    }

    public Optional<Short> getMinor() {
        return this.minor;
    }

    public Optional<Short> getSubMinor() {
        return this.subminor;
    }

    public Optional<Short> getUpdate() {
        return this.update;
    }

    public Optional<String> getVendor() {
        return this.vendor;
    }

    public boolean gt(JDKVersion version) {
        if (this.major > version.getMajor()) {
            return true;
        }
        if (this.major == version.getMajor()) {
            if (this.gt(this.minor, version.getMinor())) {
                return true;
            }
            if (this.eq(this.minor, version.getMinor())) {
                if (this.gt(this.subminor, version.getSubMinor())) {
                    return true;
                }
                if (this.eq(this.subminor, version.getSubMinor()) && this.gt(this.update, version.getUpdate())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean lt(JDKVersion version) {
        if (this.major < version.getMajor()) {
            return true;
        }
        if (this.major == version.getMajor()) {
            if (this.lt(this.minor, version.getMinor())) {
                return true;
            }
            if (this.eq(this.minor, version.getMinor())) {
                if (this.lt(this.subminor, version.getSubMinor())) {
                    return true;
                }
                if (this.eq(this.subminor, version.getSubMinor()) && this.lt(this.update, version.getUpdate())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean ge(JDKVersion version) {
        return this.gt(version) || this.equals(version);
    }

    public boolean le(JDKVersion version) {
        return this.lt(version) || this.equals(version);
    }

    private boolean gt(Optional<Short> v1, Optional<Short> v2) {
        return v1.orElse(DEFAULT_VALUE) > v2.orElse(DEFAULT_VALUE);
    }

    private boolean lt(Optional<Short> v1, Optional<Short> v2) {
        return v1.orElse(DEFAULT_VALUE) < v2.orElse(DEFAULT_VALUE);
    }

    private boolean eq(Optional<Short> v1, Optional<Short> v2) {
        if (!v1.isPresent() || !v2.isPresent()) {
            return true;
        }
        return v1.orElse(DEFAULT_VALUE).equals(v2.orElse(DEFAULT_VALUE));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDKVersion other = (JDKVersion)obj;
        if (this.major != other.getMajor()) {
            return false;
        }
        if (!this.eq(this.minor, other.getMinor())) {
            return false;
        }
        if (!this.eq(this.subminor, other.getSubMinor())) {
            return false;
        }
        return this.eq(this.update, other.getUpdate());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.major;
        hash = 89 * hash + this.minor.orElse(DEFAULT_VALUE);
        hash = 89 * hash + this.subminor.orElse(DEFAULT_VALUE);
        hash = 89 * hash + this.update.orElse(DEFAULT_VALUE);
        return hash;
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        value.append(this.major);
        if (this.minor.isPresent()) {
            value.append('.').append(this.minor.get());
        }
        if (this.subminor.isPresent()) {
            value.append('.').append(this.subminor.get());
        }
        if (this.update.isPresent()) {
            value.append('.').append(this.update.get());
        }
        return value.toString();
    }

    public static JDKVersion toValue(String version) {
        if (version != null && version.matches(VERSION_MATCHER)) {
            return new JDKVersion(version, null);
        }
        return null;
    }

    public static JDKVersion toValue(String version, String vendor) {
        if (version != null && version.matches(VERSION_MATCHER)) {
            return new JDKVersion(version, vendor);
        }
        return null;
    }

    public static JDKVersion getDefaultPlatformVersion() {
        return IDE_JDK_VERSION;
    }

    public static boolean isCorrectJDK(JDKVersion jdkVersion, Optional<String> vendor, Optional<JDKVersion> minVersion, Optional<JDKVersion> maxVersion) {
        boolean correctJDK = true;
        if (vendor.isPresent()) {
            correctJDK = jdkVersion.getVendor().isPresent() ? jdkVersion.getVendor().get().contains(vendor.get()) : false;
        }
        if (correctJDK && minVersion.isPresent()) {
            correctJDK = jdkVersion.ge(minVersion.get());
        }
        if (correctJDK && maxVersion.isPresent()) {
            correctJDK = jdkVersion.le(maxVersion.get());
        }
        return correctJDK;
    }

    public static boolean isCorrectJDK(Optional<JDKVersion> minVersion, Optional<JDKVersion> maxVersion) {
        return JDKVersion.isCorrectJDK(IDE_JDK_VERSION, Optional.empty(), minVersion, maxVersion);
    }

    private static void initialize() {
        String vendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        short[] versions = JDKVersion.parseVersions(javaVersion);
        IDE_JDK_VERSION = new JDKVersion(versions[0], Optional.of(versions[1]), Optional.of(versions[2]), Optional.of(versions[3]), Optional.of(vendor));
    }

    static short[] parseVersions(String javaVersion) {
        short[] versions = new short[]{1, 0, 0, 0};
        if (javaVersion == null || javaVersion.length() <= 0) {
            return versions;
        }
        String[] javaVersionSplit = javaVersion.split("-");
        String[] split = javaVersionSplit[0].split("\\.");
        if (split.length > 0) {
            if (split.length > 0) {
                versions[0] = Short.parseShort(split[0]);
            }
            if (split.length > 1) {
                versions[1] = Short.parseShort(split[1]);
            }
            if (split.length > 2) {
                split = split[2].split("[_u]");
                versions[2] = Short.parseShort(split[0]);
                if (split.length > 1) {
                    versions[3] = Short.parseShort(split[1]);
                }
            }
        }
        return versions;
    }

    static {
        DEFAULT_VALUE = 0;
        JDKVersion.initialize();
    }
}

