/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.text.AbstractDocument;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.PayaraSettings;
import org.netbeans.modules.payara.common.ui.Filter;
import org.netbeans.modules.payara.common.ui.IpComboBox;
import org.netbeans.modules.payara.tooling.utils.NetUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class InstancePanel
extends JPanel {
    private static final Logger LOGGER = PayaraLogger.get(InstancePanel.class);
    private static final int MAX_PORT_VALUE = 65535;
    protected final PayaraInstance instance;
    protected Set<? extends InetAddress> ips;
    protected boolean cometSupportFlag;
    protected boolean httpMonitorFlag;
    protected boolean jdbcDriverDeploymentFlag;
    protected boolean showPasswordFlag;
    protected boolean preserverSessionsFlag;
    protected boolean hotDeployFlag;
    protected boolean loopbackFlag;
    protected boolean configFileParsed;
    protected JCheckBox commetSupport;
    protected JTextField dasPortField;
    protected JLabel dasPortLabel;
    protected JTextField domainField;
    protected JLabel domainLabel;
    protected JTextField domainsFolderField;
    protected JLabel domainsFolderLabel;
    protected JComboBox hostLocalField;
    protected JLabel hostLocalLabel;
    protected JTextField hostRemoteField;
    protected JLabel hostRemoteLabel;
    protected JCheckBox hotDeploy;
    protected JCheckBox httpMonitor;
    protected JTextField httpPortField;
    protected JLabel httpPortLabel;
    protected JTextField installationLocationField;
    protected JLabel installationLocationLabel;
    protected JCheckBox jdbcDriverDeployment;
    protected JCheckBox localIpCB;
    protected JPasswordField passwordField;
    protected JLabel passwordLabel;
    protected JCheckBox preserveSessions;
    protected JToggleButton showPassword;
    protected JTextField targetField;
    protected JLabel targetLabel;
    protected JTextField userNameField;
    protected JLabel userNameLabel;

    protected abstract void initHost();

    protected abstract void initPorts();

    protected abstract String getHost();

    protected InstancePanel(PayaraInstance instance) {
        this.instance = instance;
        this.ips = NetUtils.getHostIP4s();
        this.initComponents();
        ((AbstractDocument)this.dasPortField.getDocument()).setDocumentFilter(new Filter.PortNumber());
        ((AbstractDocument)this.httpPortField.getDocument()).setDocumentFilter(new Filter.PortNumber());
    }

    protected void initDirectoriesFields() {
        String installationRoot = this.instance.getPayaraRoot();
        String domainsFolder = this.instance.getDomainsFolder();
        this.installationLocationField.setText(installationRoot != null ? installationRoot : "");
        this.domainsFolderField.setText(domainsFolder != null ? domainsFolder : "");
    }

    protected void initDomainAndTarget() {
        String target = this.instance.getTarget();
        String domainName = this.instance.getDomainName();
        this.domainField.setText(domainName != null ? domainName : "");
        this.targetField.setText(target != null ? target : "");
    }

    protected void initCredentials() {
        this.userNameField.setText(this.instance.getUserName());
        this.passwordField.setText(this.instance.getPassword());
    }

    protected void initFlagsFromProperties(CheckBoxProperties properties) {
        this.cometSupportFlag = properties.getCommetSupportProperty();
        this.httpMonitorFlag = properties.getHttpMonitorProperty();
        this.jdbcDriverDeploymentFlag = properties.getJdbcDriverDeploymentProperty();
        this.hotDeployFlag = properties.getHotDeployProperty();
        this.preserverSessionsFlag = properties.getPreserveSessionsProperty();
        this.loopbackFlag = properties.getLoopbackProperty();
    }

    protected void initCheckBoxes() {
        this.initFlagsFromProperties(new CheckBoxProperties(this.instance));
        this.showPasswordFlag = PayaraSettings.getGfShowPasswordInPropertiesForm();
        this.commetSupport.setSelected(this.cometSupportFlag);
        this.httpMonitor.setSelected(this.httpMonitorFlag);
        this.jdbcDriverDeployment.setSelected(this.jdbcDriverDeploymentFlag);
        this.showPassword.setSelected(this.showPasswordFlag);
        this.hotDeploy.setSelected(this.instance.isHotDeployFeatureAvailable() ? this.hotDeployFlag : false);
        this.preserveSessions.setSelected(this.preserverSessionsFlag);
        this.localIpCB.setSelected(this.loopbackFlag);
    }

    protected void storeHost() {
        String host = this.getHost();
        if (!host.equals(this.instance.getHost())) {
            this.instance.setHost(host);
        }
    }

    protected void storeCheckBoxes() {
        CheckBoxProperties properties = new CheckBoxProperties(this.instance);
        properties.store(this.cometSupportFlag, this.httpMonitorFlag, this.jdbcDriverDeploymentFlag, this.hotDeployFlag, this.preserverSessionsFlag, this.loopbackFlag, this.instance);
        PayaraSettings.setGfShowPasswordInPropertiesForm(this.showPasswordFlag);
    }

    protected void storePorts() {
        String dasPortStr = this.dasPortField.getText().trim();
        String httpPortStr = this.httpPortField.getText().trim();
        try {
            int dasPort = Integer.parseInt(dasPortStr);
            if (0 <= dasPort && dasPort < 65535) {
                if (this.instance.getAdminPort() != dasPort) {
                    this.instance.setAdminPort(dasPort);
                }
            } else {
                LOGGER.log(Level.INFO, NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.storePorts.dasPortRange", (Object)dasPortStr));
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.storePorts.dasPortInvalid", (Object)dasPortStr));
        }
        try {
            int httpPort = Integer.parseInt(httpPortStr);
            if (0 <= httpPort && httpPort < 65535) {
                if (this.instance.getPort() != httpPort) {
                    this.instance.setHttpPort(httpPort);
                }
            } else {
                LOGGER.log(Level.INFO, NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.storePorts.httpPortRange", (Object)dasPortStr));
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.storePorts.httpPortInvalid", (Object)httpPortStr));
        }
    }

    protected void storeTarget() {
        String target = this.targetField.getText().trim();
        if (!target.equals(this.instance.getTarget())) {
            this.instance.setTarget(target);
        }
    }

    protected void storeCredentials() {
        String userName = this.userNameField.getText().trim();
        String password = new String(this.passwordField.getPassword());
        if (!userName.equals(this.instance.getAdminUser())) {
            this.instance.setAdminUser(userName);
        }
        if (!password.equals(this.instance.getAdminPassword())) {
            this.instance.setAdminPassword(password);
        }
    }

    protected void enableFields() {
        if (!this.configFileParsed) {
            this.dasPortField.setEnabled(true);
            this.httpPortField.setEnabled(true);
        }
        this.targetField.setEnabled(true);
        this.userNameField.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.commetSupport.setEnabled(true);
        this.httpMonitor.setEnabled(true);
        this.jdbcDriverDeployment.setEnabled(true);
        this.hotDeploy.setEnabled(this.instance.isHotDeployFeatureAvailable());
        this.showPassword.setEnabled(true);
        this.preserveSessions.setEnabled(true);
    }

    protected void disableAllFields() {
        this.installationLocationField.setEnabled(false);
        this.domainsFolderField.setEnabled(false);
        this.hostLocalField.setEnabled(false);
        this.localIpCB.setEnabled(false);
        this.hostRemoteField.setEnabled(false);
        this.dasPortField.setEnabled(false);
        this.httpPortField.setEnabled(false);
        this.domainField.setEnabled(false);
        this.targetField.setEnabled(false);
        this.userNameField.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.commetSupport.setEnabled(false);
        this.httpMonitor.setEnabled(false);
        this.jdbcDriverDeployment.setEnabled(false);
        this.hotDeploy.setEnabled(false);
        this.showPassword.setEnabled(false);
        this.preserveSessions.setEnabled(false);
    }

    protected void initFormFields() {
        this.initDirectoriesFields();
        this.initPorts();
        this.initHost();
        this.initDomainAndTarget();
        this.initCredentials();
        this.initCheckBoxes();
        this.updatePasswordVisibility();
        this.localIpCBActionPerformed(null);
    }

    protected void storeFormFields() {
        this.storeHost();
        this.storePorts();
        this.storeTarget();
        this.storeCredentials();
        this.storeCheckBoxes();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.disableAllFields();
        this.initFormFields();
        this.enableFields();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.disableAllFields();
        this.storeFormFields();
    }

    protected void updatePasswordVisibility() {
        this.showPasswordFlag = this.showPassword.isSelected();
        this.passwordField.setEchoChar(this.showPasswordFlag ? (char)'\u0000' : '*');
    }

    private void initComponents() {
        this.hostLocalLabel = new JLabel();
        this.localIpCB = new JCheckBox();
        this.hostLocalField = new IpComboBox(this.ips, this.localIpCB.isSelected());
        this.dasPortLabel = new JLabel();
        this.dasPortField = new JTextField();
        this.httpPortLabel = new JLabel();
        this.httpPortField = new JTextField();
        this.domainLabel = new JLabel();
        this.domainField = new JTextField();
        this.targetLabel = new JLabel();
        this.targetField = new JTextField();
        this.installationLocationLabel = new JLabel();
        this.installationLocationField = new JTextField();
        this.domainsFolderLabel = new JLabel();
        this.domainsFolderField = new JTextField();
        this.userNameLabel = new JLabel();
        this.userNameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.commetSupport = new JCheckBox();
        this.preserveSessions = new JCheckBox();
        this.httpMonitor = new JCheckBox();
        this.jdbcDriverDeployment = new JCheckBox();
        this.passwordField = new JPasswordField();
        this.hostRemoteLabel = new JLabel();
        this.hostRemoteField = new JTextField();
        this.hotDeploy = new JCheckBox();
        this.showPassword = new JToggleButton();
        this.setName(NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.displayName"));
        this.setPreferredSize(new Dimension(602, 304));
        this.hostLocalLabel.setLabelFor(this.hostLocalField);
        Mnemonics.setLocalizedText((JLabel)this.hostLocalLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.hostLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.localIpCB, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.localIpCB"));
        this.localIpCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePanel.this.localIpCBActionPerformed(evt);
            }
        });
        this.hostLocalField.setEditable(true);
        this.dasPortLabel.setLabelFor(this.dasPortField);
        Mnemonics.setLocalizedText((JLabel)this.dasPortLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.dasPortLabel"));
        this.dasPortField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.dasPortField.text"));
        this.httpPortLabel.setLabelFor(this.httpPortField);
        Mnemonics.setLocalizedText((JLabel)this.httpPortLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.httpPortLabel"));
        this.httpPortField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.httpPortField.text"));
        this.domainLabel.setLabelFor(this.domainField);
        Mnemonics.setLocalizedText((JLabel)this.domainLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.domainLabel"));
        this.domainField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.domainField.text"));
        this.targetLabel.setLabelFor(this.targetField);
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.targetLabel"));
        this.targetField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.targetField.text"));
        this.installationLocationLabel.setLabelFor(this.installationLocationField);
        Mnemonics.setLocalizedText((JLabel)this.installationLocationLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.InstallationlocationLabel"));
        this.installationLocationField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.installationLocationField.text"));
        this.domainsFolderLabel.setLabelFor(this.domainsFolderField);
        Mnemonics.setLocalizedText((JLabel)this.domainsFolderLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.domainsFolderLabel"));
        this.domainsFolderField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.domainsFolderField.text"));
        this.userNameLabel.setLabelFor(this.userNameField);
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.userNameLabel"));
        this.userNameField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.userNameField.text"));
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.passwordLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.commetSupport, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.commetSupport"));
        this.commetSupport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePanel.this.commetSupportActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.preserveSessions, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.preserveSessions"));
        this.preserveSessions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePanel.this.preserveSessionsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.httpMonitor, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.httpMonitor"));
        this.httpMonitor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePanel.this.httpMonitorActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jdbcDriverDeployment, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.jdbcDriverDeployment"));
        this.jdbcDriverDeployment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePanel.this.jdbcDriverDeploymentActionPerformed(evt);
            }
        });
        this.passwordField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.passwordField.text"));
        this.hostRemoteLabel.setLabelFor(this.domainsFolderField);
        Mnemonics.setLocalizedText((JLabel)this.hostRemoteLabel, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.hostRemoteLabel.text"));
        this.hostRemoteField.setText(NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.hostRemoteField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.hotDeploy, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.hotDeploy.text"));
        this.hotDeploy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePanel.this.hotDeployActionPerformed(evt);
            }
        });
        this.showPassword.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/payara/common/resources/show-password.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.showPassword, (String)NbBundle.getMessage(InstancePanel.class, (String)"InstancePanel.showPassword.text"));
        this.showPassword.setAlignmentY(0.0f);
        this.showPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePanel.this.showPasswordActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.installationLocationLabel, -1, -1, Short.MAX_VALUE).addComponent(this.domainsFolderLabel, -1, -1, Short.MAX_VALUE).addComponent(this.hostRemoteLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.domainsFolderField, -2, 1, Short.MAX_VALUE).addComponent(this.installationLocationField, -2, 1, Short.MAX_VALUE).addComponent(this.hostRemoteField))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLocalLabel, -2, 59, -2).addComponent(this.domainLabel, -2, 59, -2).addComponent(this.dasPortLabel).addComponent(this.userNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hostLocalField, 0, 207, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localIpCB)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.domainField, GroupLayout.Alignment.LEADING, -2, 1, Short.MAX_VALUE).addComponent(this.dasPortField, GroupLayout.Alignment.LEADING, -2, 1, Short.MAX_VALUE).addComponent(this.userNameField, GroupLayout.Alignment.LEADING, -2, 1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.httpPortLabel, -1, -1, Short.MAX_VALUE).addComponent(this.targetLabel, -1, -1, Short.MAX_VALUE).addComponent(this.passwordLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.httpPortField, -2, 1, Short.MAX_VALUE).addComponent(this.targetField, -2, 1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.passwordField, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPassword, -2, 27, -2).addGap(2, 2, 2)))))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jdbcDriverDeployment, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.httpMonitor, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.commetSupport, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.preserveSessions, -1, -1, Short.MAX_VALUE).addComponent(this.hotDeploy, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.dasPortLabel, this.domainLabel, this.hostLocalLabel, this.httpPortLabel, this.passwordLabel, this.targetLabel, this.userNameLabel);
        layout.linkSize(0, this.domainsFolderLabel, this.installationLocationLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.installationLocationLabel).addComponent(this.installationLocationField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainsFolderLabel).addComponent(this.domainsFolderField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostRemoteLabel).addComponent(this.hostRemoteField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLocalLabel).addComponent(this.hostLocalField, -2, -1, -2).addComponent(this.localIpCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dasPortLabel).addComponent(this.dasPortField, -2, -1, -2).addComponent(this.httpPortLabel).addComponent(this.httpPortField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainLabel).addComponent(this.domainField, -2, -1, -2).addComponent(this.targetLabel).addComponent(this.targetField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordField).addComponent(this.showPassword, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameField).addComponent(this.passwordLabel).addComponent(this.userNameLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commetSupport).addComponent(this.hotDeploy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.httpMonitor).addComponent(this.preserveSessions)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jdbcDriverDeployment).addGap(120, 120, 120)));
    }

    private void commetSupportActionPerformed(ActionEvent evt) {
        this.cometSupportFlag = this.commetSupport.isSelected();
    }

    private void preserveSessionsActionPerformed(ActionEvent evt) {
        this.preserverSessionsFlag = this.preserveSessions.isSelected();
    }

    private void httpMonitorActionPerformed(ActionEvent evt) {
        this.httpMonitorFlag = this.httpMonitor.isSelected();
    }

    private void jdbcDriverDeploymentActionPerformed(ActionEvent evt) {
        this.jdbcDriverDeploymentFlag = this.jdbcDriverDeployment.isSelected();
    }

    private void localIpCBActionPerformed(ActionEvent evt) {
        this.loopbackFlag = this.localIpCB.isSelected();
        Object hostValue = this.hostLocalField.getEditor().getItem();
        this.hostLocalField.setEnabled(false);
        ((IpComboBox)this.hostLocalField).updateModel(this.ips, this.localIpCB.isSelected());
        if (hostValue instanceof IpComboBox.InetAddr) {
            ((IpComboBox)this.hostLocalField).setSelectedIp(((IpComboBox.InetAddr)hostValue).getIp());
        } else if (hostValue instanceof String) {
            ((IpComboBox)this.hostLocalField).getEditor().setItem((String)hostValue);
        } else {
            ((IpComboBox)this.hostLocalField).setSelectedItem(null);
        }
        this.hostLocalField.setEnabled(true);
    }

    private void showPasswordActionPerformed(ActionEvent evt) {
        this.updatePasswordVisibility();
    }

    private void hotDeployActionPerformed(ActionEvent evt) {
        this.hotDeployFlag = this.hotDeploy.isSelected();
    }

    protected static class CheckBoxProperties {
        final String cometSupportProperty;
        final String httpMonitorProperty;
        final String jdbcDriverDeploymentProperty;
        final String preserveSessionsProperty;
        final String hotDeployProperty;
        final String loopbackProperty;

        protected CheckBoxProperties(PayaraInstance instance) {
            String cometSupportPropertyTmp = instance.getProperty("v3.grizzly.cometSupport");
            this.cometSupportProperty = cometSupportPropertyTmp != null ? cometSupportPropertyTmp : System.getProperty("v3.grizzly.cometSupport");
            this.httpMonitorProperty = instance.getProperty("httpMonitorOn");
            this.jdbcDriverDeploymentProperty = instance.getProperty("driverDeployOn");
            this.hotDeployProperty = instance.getProperty("hotDeploy");
            this.preserveSessionsProperty = instance.getProperty("preserveSessionsOn");
            this.loopbackProperty = instance.getProperty("loopbackOn");
        }

        protected void storeBooleanProperty(String key, boolean value, PayaraInstance instance) {
            if (value) {
                instance.putProperty(key, Boolean.toString(value));
            } else {
                instance.removeProperty(key);
            }
        }

        protected void store(boolean cometSupportFlag, boolean httpMonitorFlag, boolean jdbcDriverDeploymentFlag, boolean hotDeployFlag, boolean preserveSessionsFlag, boolean loopbackFlag, PayaraInstance instance) {
            if (cometSupportFlag != this.getCommetSupportProperty()) {
                instance.putProperty("v3.grizzly.cometSupport", Boolean.toString(cometSupportFlag));
            }
            if (httpMonitorFlag != this.getHttpMonitorProperty()) {
                this.storeBooleanProperty("httpMonitorOn", httpMonitorFlag, instance);
            }
            if (jdbcDriverDeploymentFlag != this.getJdbcDriverDeploymentProperty()) {
                this.storeBooleanProperty("driverDeployOn", jdbcDriverDeploymentFlag, instance);
            }
            if (hotDeployFlag != this.getHotDeployProperty()) {
                this.storeBooleanProperty("hotDeploy", hotDeployFlag, instance);
            }
            if (preserveSessionsFlag != this.getPreserveSessionsProperty()) {
                this.storeBooleanProperty("preserveSessionsOn", preserveSessionsFlag, instance);
            }
            if (loopbackFlag != this.getLoopbackProperty()) {
                this.storeBooleanProperty("loopbackOn", loopbackFlag, instance);
            }
        }

        protected boolean getCommetSupportProperty() {
            return Boolean.parseBoolean(this.cometSupportProperty);
        }

        protected boolean getHttpMonitorProperty() {
            return Boolean.parseBoolean(this.httpMonitorProperty);
        }

        protected boolean getJdbcDriverDeploymentProperty() {
            return Boolean.parseBoolean(this.jdbcDriverDeploymentProperty);
        }

        protected boolean getHotDeployProperty() {
            return Boolean.parseBoolean(this.hotDeployProperty);
        }

        protected boolean getPreserveSessionsProperty() {
            return Boolean.parseBoolean(this.preserveSessionsProperty);
        }

        protected boolean getLoopbackProperty() {
            return Boolean.parseBoolean(this.loopbackProperty);
        }
    }
}

