/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openjfx.samples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class OpenJFXSampleProjectGenerator {
    private OpenJFXSampleProjectGenerator() {
    }

    public static FileObject createProjectFromTemplate(FileObject template, File projectLocation, String name) throws IOException {
        assert (template != null && projectLocation != null && name != null);
        FileObject prjLoc = OpenJFXSampleProjectGenerator.createProjectFolder(projectLocation);
        if (template.getExt().endsWith("zip")) {
            OpenJFXSampleProjectGenerator.unzip(template.getInputStream(), prjLoc);
            prjLoc.refresh(false);
        }
        return prjLoc;
    }

    private static FileObject createProjectFolder(File projectFolder) throws IOException {
        FileObject projLoc;
        Stack<String> nameStack = new Stack<String>();
        while ((projLoc = FileUtil.toFileObject((File)projectFolder)) == null) {
            nameStack.push(projectFolder.getName());
            projectFolder = projectFolder.getParentFile();
        }
        while (!nameStack.empty()) {
            projLoc = projLoc.createFolder((String)nameStack.pop());
            assert (projLoc != null);
        }
        return projLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, FileObject targetFolder) throws IOException {
        ZipInputStream zip = new ZipInputStream(source);
        try {
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                if (ent.isDirectory()) {
                    FileUtil.createFolder((FileObject)targetFolder, (String)ent.getName());
                    continue;
                }
                FileObject destFile = FileUtil.createData((FileObject)targetFolder, (String)ent.getName());
                FileLock lock = destFile.lock();
                try {
                    OutputStream out = destFile.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)zip, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            zip.close();
        }
    }
}

