/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;

public class SubmitCommand
extends BugtrackingCommand {
    private final AbstractRepositoryConnector repositoryConnector;
    private final TaskRepository taskRepository;
    private final TaskData data;
    private RepositoryResponse rr;
    private boolean wasNew;
    private String stringValue;

    public SubmitCommand(AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, TaskData data) {
        this.taskRepository = taskRepository;
        this.repositoryConnector = repositoryConnector;
        this.data = data;
        this.wasNew = data.isNew();
    }

    @Override
    public void execute() throws CoreException, IOException, MalformedURLException {
        Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "executing SubmitCommand for taskData with id {0} ", this.data.getTaskId());
        }
        this.rr = this.repositoryConnector.getTaskDataHandler().postTaskData(this.taskRepository, this.data, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public RepositoryResponse getRepositoryResponse() {
        return this.rr;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder();
            if (this.wasNew) {
                sb.append("SubmitCommand new issue [repository=");
                sb.append(this.taskRepository.getUrl());
                sb.append("]");
            } else {
                sb.append("SubmitCommand [issue #");
                sb.append(this.data.getTaskId());
                sb.append(",repository=");
                sb.append(this.taskRepository.getUrl());
                sb.append("]");
            }
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }
}

