/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.symbol;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePathScanner;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.WeakListeners;

public final class MicronautSymbolFinder
extends EmbeddingIndexer
implements PropertyChangeListener {
    public static final String NAME = "mn";
    public static final int VERSION = 1;
    public static final MicronautSymbolFinder INSTANCE = new MicronautSymbolFinder();
    public static final String[] META_ANNOTATIONS = new String[]{"io.micronaut.http.annotation.HttpMethodMapping", "io.micronaut.context.annotation.Bean", "jakarta.inject.Qualifier", "jakarta.inject.Scope"};
    private final Map<Project, Boolean> map = new WeakHashMap<Project, Boolean>();

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        CompilationController cc = CompilationController.get((Parser.Result)parserResult);
        if (this.initialize(cc)) {
            try {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                List<SymbolLocation> symbols = this.scan(cc);
                if (!symbols.isEmpty()) {
                    this.store(context.getIndexFolder(), indexable.getURL(), indexable.getRelativePath(), symbols);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        MicronautSymbolFinder micronautSymbolFinder = this;
        synchronized (micronautSymbolFinder) {
            this.map.clear();
        }
    }

    private synchronized boolean initialize(CompilationController cc) {
        Project p = FileOwnerQuery.getOwner((FileObject)cc.getFileObject());
        Boolean ret = this.map.get(p);
        if (ret == null) {
            ClassPath cp = ClassPath.getClassPath((FileObject)p.getProjectDirectory(), (String)"classpath/compile");
            cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp));
            ret = cp.findResource("io/micronaut/http/annotation/HttpMethodMapping.class") != null;
            this.map.put(p, ret);
        }
        return ret;
    }

    private List<SymbolLocation> scan(final CompilationController cc) {
        final ArrayList<SymbolLocation> ret = new ArrayList<SymbolLocation>();
        TreePathScanner<Void, String> scanner = new TreePathScanner<Void, String>(){

            @Override
            public Void visitClass(ClassTree node, String path) {
                Pair metaAnnotated;
                Element cls = cc.getTrees().getElement(this.getCurrentPath());
                if (cls != null && (metaAnnotated = MicronautSymbolFinder.isMetaAnnotated(cls)) != null) {
                    Element annEl = ((AnnotationMirror)metaAnnotated.first()).getAnnotationType().asElement();
                    if ("io.micronaut.http.annotation.Controller".contentEquals(((TypeElement)annEl).getQualifiedName())) {
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ((AnnotationMirror)metaAnnotated.first()).getElementValues().entrySet()) {
                            if (!"value".contentEquals(entry.getKey().getSimpleName())) continue;
                            path = (String)entry.getValue().getValue();
                        }
                    }
                    String name = "@+ '" + MicronautSymbolFinder.getBeanName(node.getSimpleName().toString()) + "' (@" + annEl.getSimpleName() + (metaAnnotated.second() != null ? " <: @" + ((AnnotationMirror)metaAnnotated.second()).getAnnotationType().asElement().getSimpleName() : "") + ") " + node.getSimpleName();
                    int[] span = cc.getTreeUtilities().findNameSpan(node);
                    ret.add(new SymbolLocation(name, span[0], span[1]));
                }
                return (Void)super.visitClass(node, path);
            }

            @Override
            public Void visitMethod(MethodTree node, String path) {
                MthIterator it = new MthIterator(cc.getTrees().getElement(this.getCurrentPath()), cc.getElements(), cc.getTypes());
                while (it.hasNext()) {
                    for (AnnotationMirror annotationMirror : it.next().getAnnotationMirrors()) {
                        String method = MicronautSymbolFinder.getEndpointMethod((TypeElement)annotationMirror.getAnnotationType().asElement());
                        if (method == null) continue;
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                            if (!"value".contentEquals(entry.getKey().getSimpleName()) && !"uri".contentEquals(entry.getKey().getSimpleName())) continue;
                            String name = '@' + (path != null ? path : "") + entry.getValue().getValue() + " -- " + method;
                            int[] span = cc.getTreeUtilities().findNameSpan(node);
                            ret.add(new SymbolLocation(name, span[0], span[1]));
                            return null;
                        }
                    }
                }
                return null;
            }
        };
        scanner.scan(cc.getCompilationUnit(), null);
        return ret;
    }

    private void store(FileObject indexFolder, URL url, String resourceName, List<SymbolLocation> symbols) {
        File cacheRoot = FileUtil.toFile((FileObject)indexFolder);
        File output = new File(cacheRoot, resourceName + ".mn");
        if (symbols.isEmpty()) {
            if (output.exists()) {
                output.delete();
            }
        } else {
            output.getParentFile().mkdirs();
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));){
                pw.print("url: ");
                pw.println(url.toString());
                for (SymbolLocation symbol : symbols) {
                    pw.print("symbol: ");
                    pw.print(symbol.name);
                    pw.print(':');
                    pw.print(symbol.start);
                    pw.print('-');
                    pw.println(symbol.end);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static Pair<AnnotationMirror, AnnotationMirror> isMetaAnnotated(Element el) {
        for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
            Element annEl = annotationMirror.getAnnotationType().asElement();
            Name name = ((TypeElement)annEl).getQualifiedName();
            String annotation = MicronautSymbolFinder.check(name);
            if (annotation != null) {
                return Pair.of((Object)annotationMirror, null);
            }
            for (AnnotationMirror annotationMirror2 : annEl.getAnnotationMirrors()) {
                Element metaAnnEl = annotationMirror2.getAnnotationType().asElement();
                String metaAnnotation = MicronautSymbolFinder.check(((TypeElement)metaAnnEl).getQualifiedName());
                if (metaAnnotation == null) continue;
                return Pair.of((Object)annotationMirror, (Object)annotationMirror2);
            }
        }
        return null;
    }

    private static String check(Name name) {
        for (String ann : META_ANNOTATIONS) {
            if (!ann.contentEquals(name)) continue;
            return ann;
        }
        return null;
    }

    private static String getEndpointMethod(TypeElement te) {
        for (AnnotationMirror annotationMirror : te.getAnnotationMirrors()) {
            Element el = annotationMirror.getAnnotationType().asElement();
            if (!"io.micronaut.http.annotation.HttpMethodMapping".contentEquals(((TypeElement)el).getQualifiedName())) continue;
            return te.getSimpleName().toString().toUpperCase();
        }
        return null;
    }

    public static String getBeanName(String typeName) {
        if (typeName.length() > 0 && Character.isUpperCase(typeName.charAt(0)) && (typeName.length() == 1 || !Character.isUpperCase(typeName.charAt(1)))) {
            typeName = Character.toLowerCase(typeName.charAt(0)) + typeName.substring(1);
        }
        return typeName;
    }

    private static class MthIterator
    implements Iterator<ExecutableElement> {
        private final ExecutableElement ee;
        private final Elements elements;
        private final Types types;
        private boolean createIt = false;
        private Iterator<ExecutableElement> it = null;

        private MthIterator(Element e, Elements elements, Types types) {
            this.ee = e != null && e.getKind() == ElementKind.METHOD ? (ExecutableElement)e : null;
            this.elements = elements;
            this.types = types;
        }

        @Override
        public boolean hasNext() {
            if (this.ee == null) {
                return false;
            }
            if (this.it == null) {
                if (!this.createIt) {
                    return true;
                }
                ArrayList<ExecutableElement> overriden = new ArrayList<ExecutableElement>();
                this.collectOverriden(this.ee, this.ee.getEnclosingElement(), overriden);
                this.it = overriden.iterator();
            }
            return this.it.hasNext();
        }

        @Override
        public ExecutableElement next() {
            if (this.it == null) {
                this.createIt = true;
                return this.ee;
            }
            return this.it.next();
        }

        private void collectOverriden(ExecutableElement orig, Element el, List<ExecutableElement> overriden) {
            for (TypeMirror typeMirror : this.types.directSupertypes(el.asType())) {
                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                Element se = ((DeclaredType)typeMirror).asElement();
                overriden.addAll(ElementFilter.methodsIn(se.getEnclosedElements()).stream().filter(me -> orig.getSimpleName().contentEquals(me.getSimpleName()) && this.elements.overrides(orig, (ExecutableElement)me, (TypeElement)el)).collect(Collectors.toList()));
                this.collectOverriden(orig, se, overriden);
            }
        }
    }

    private static class SymbolLocation {
        private String name;
        private int start;
        private int end;

        private SymbolLocation(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            return INSTANCE;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            File cacheRoot = FileUtil.toFile((FileObject)context.getIndexFolder());
            for (Indexable indexable : deleted) {
                File output = new File(cacheRoot, indexable.getRelativePath() + ".mn");
                if (!output.exists()) continue;
                output.delete();
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return MicronautSymbolFinder.NAME;
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

