/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.newproject;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.micronaut.newproject.BasePropertiesWizardPanel;
import org.netbeans.modules.micronaut.newproject.Bundle;
import org.netbeans.modules.micronaut.newproject.FeaturesWizardPanel;
import org.netbeans.modules.micronaut.newproject.MicronautLaunchService;
import org.netbeans.modules.micronaut.newproject.NameAndLocationWizardPanel;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.AsyncGUIJob;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class MicronautProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    public static final String PROJECT_NAME = "project.name";
    public static final String PROJECT_LOCATION = "project.location";
    public static final String SERVICE_URL = "service.url";
    public static final String MAVEN_GROUP = "maven.group";
    public static final String MAVEN_ARTIFACT = "maven.artifact";
    public static final String APPLICATION_TYPE = "application.type";
    public static final String JAVA_VERSION = "java.version";
    public static final String LANGUAGE = "language";
    public static final String BUILD_TOOL = "build.tool";
    public static final String TEST_FRAMEWORK = "test.framework";
    public static final String FEATURES = "features";
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(ProgressHandle handle) throws IOException {
        try {
            File parent;
            ActionProvider actionProvider;
            handle.start(4);
            File projFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty(PROJECT_LOCATION)));
            projFile.mkdirs();
            handle.progress(1);
            InputStream stream = MicronautLaunchService.getInstance().create((String)this.wiz.getProperty(SERVICE_URL), (MicronautLaunchService.ApplicationType)this.wiz.getProperty(APPLICATION_TYPE), (String)this.wiz.getProperty(MAVEN_GROUP) + '.' + (String)this.wiz.getProperty(MAVEN_ARTIFACT), (String)this.wiz.getProperty(JAVA_VERSION), (String)this.wiz.getProperty(LANGUAGE), (String)this.wiz.getProperty(BUILD_TOOL), (String)this.wiz.getProperty(TEST_FRAMEWORK), (Set)this.wiz.getProperty(FEATURES));
            handle.progress(2);
            FileObject projDir = FileUtil.toFileObject((File)projFile);
            MicronautProjectWizardIterator.unzip(stream, projDir);
            handle.progress(3);
            ProjectManager.getDefault().clearNonProjectCache();
            Project prj = ProjectManager.getDefault().findProject(projDir);
            if (prj != null && (actionProvider = (ActionProvider)prj.getLookup().lookup(ActionProvider.class)) != null && actionProvider.isActionEnabled("prime", Lookup.EMPTY)) {
                actionProvider.invokeAction("prime", Lookup.EMPTY);
            }
            if ((parent = projFile.getParentFile()) != null && parent.exists()) {
                ProjectChooser.setProjectsFolder((File)parent);
            }
            Set<FileObject> set = Collections.singleton(projDir);
            return set;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            handle.finish();
        }
        return Collections.emptySet();
    }

    public Set instantiate() throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void initialize(WizardDescriptor wizard) {
        this.wiz = wizard;
        this.wiz.putProperty("NewProjectWizard_Title", (Object)Bundle.LBL_WizardTitle());
        this.index = 0;
        this.panels = new WizardDescriptor.Panel[]{new NameAndLocationWizardPanel(), new BasePropertiesWizardPanel(), new FeaturesWizardPanel()};
        String[] steps = new String[]{Bundle.LBL_NameAndLocationStep(), Bundle.LBL_BasePropertiesStep(), Bundle.LBL_Features()};
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        Utilities.attachInitJob((Component)this.panels[1].getComponent(), (AsyncGUIJob)((AsyncGUIJob)this.panels[1].getComponent()));
        Utilities.attachInitJob((Component)this.panels[2].getComponent(), (AsyncGUIJob)((AsyncGUIJob)this.panels[2].getComponent()));
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return Bundle.NameFormat(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzip(InputStream stream, FileObject folder) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(stream);){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                OutputStream out;
                block23: {
                    String entryName = zipEntry.getName();
                    if (zipEntry.isDirectory()) {
                        FileUtil.createFolder((FileObject)folder, (String)entryName);
                        continue;
                    }
                    FileObject fo = FileUtil.createData((FileObject)folder, (String)entryName);
                    out = fo.getOutputStream();
                    Throwable throwable = null;
                    try {
                        FileUtil.copy((InputStream)zis, (OutputStream)out);
                        if (out == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    out.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            out.close();
                            throw throwable3;
                        }
                    }
                    try {
                        out.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                out.close();
            }
            return;
        }
    }

    public static class GradleMicronautProject
    extends MicronautProjectWizardIterator {
        @Override
        public void initialize(WizardDescriptor wizard) {
            super.initialize(wizard);
            wizard.putProperty(MicronautProjectWizardIterator.BUILD_TOOL, (Object)"GRADLE");
        }
    }

    public static class MavenMicronautProject
    extends MicronautProjectWizardIterator {
        @Override
        public void initialize(WizardDescriptor wizard) {
            super.initialize(wizard);
            wizard.putProperty(MicronautProjectWizardIterator.BUILD_TOOL, (Object)"MAVEN");
        }
    }
}

