/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.completion.MicronautConfigCompletionItem;
import org.netbeans.modules.micronaut.completion.MicronautConfigCompletionTask;
import org.netbeans.modules.micronaut.completion.MicronautConfigDocumentation;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautConfigCompletionProvider
implements CompletionProvider {
    public static MicronautConfigCompletionProvider createYamlProvider() {
        return new MicronautConfigCompletionProvider();
    }

    public static MicronautConfigCompletionProvider createPropertiesProvider() {
        return new MicronautConfigCompletionProvider();
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        Project project;
        FileObject fo = EditorDocumentUtils.getFileObject((Document)component.getDocument());
        if (MicronautConfigUtilities.isMicronautConfigFile(fo) && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && MicronautConfigProperties.hasConfigMetadata(project)) {
            switch (queryType) {
                case 1: 
                case 9: {
                    return new AsyncCompletionTask((AsyncCompletionQuery)new MicronautConfigCompletionQuery(project), component);
                }
                case 2: {
                    return new AsyncCompletionTask((AsyncCompletionQuery)new MicronautConfigDocumentationQuery(null), component);
                }
            }
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static CompletionTask createDocTask(ConfigurationMetadataProperty element) {
        return new AsyncCompletionTask((AsyncCompletionQuery)new MicronautConfigDocumentationQuery(element));
    }

    private static class MicronautConfigDocumentationQuery
    extends AsyncCompletionQuery {
        private ConfigurationMetadataProperty element;

        private MicronautConfigDocumentationQuery(ConfigurationMetadataProperty element) {
            this.element = element;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (this.element == null) {
                this.element = MicronautConfigUtilities.resolveProperty(doc, caretOffset, null, null);
            }
            resultSet.setDocumentation((CompletionDocumentation)(this.element != null ? new MicronautConfigDocumentation(this.element) : null));
            resultSet.finish();
        }
    }

    private static class MicronautConfigCompletionQuery
    extends AsyncCompletionQuery {
        private final Project project;

        public MicronautConfigCompletionQuery(Project project) {
            this.project = project;
        }

        protected void query(final CompletionResultSet resultSet, Document doc, int caretOffset) {
            resultSet.addAllItems(new MicronautConfigCompletionTask().query(doc, caretOffset, this.project, new MicronautConfigCompletionTask.ItemFactory<MicronautConfigCompletionItem>(){

                @Override
                public MicronautConfigCompletionItem createPropertyItem(ConfigurationMetadataProperty property, int offset, int baseIndent, int indentLevelSize, int idx) {
                    resultSet.setAnchorOffset(offset);
                    return MicronautConfigCompletionItem.createPropertyItem(property, offset, baseIndent, indentLevelSize, idx);
                }

                @Override
                public MicronautConfigCompletionItem createTopLevelPropertyItem(String propName, int offset, int baseIndent, int indentLevelSize) {
                    resultSet.setAnchorOffset(offset);
                    return MicronautConfigCompletionItem.createTopLevelPropertyItem(propName, offset, baseIndent, indentLevelSize);
                }
            }));
            resultSet.finish();
        }
    }
}

