/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.queues.QCommitPanel;
import org.netbeans.modules.mercurial.ui.queues.QCreatePatchParameters;
import org.netbeans.modules.mercurial.ui.queues.QFileNode;
import org.netbeans.modules.mercurial.ui.queues.QUtils;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.HgQueueHook;
import org.netbeans.modules.versioning.hooks.HgQueueHookContext;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSCommitTable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

abstract class CreateRefreshAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";
    private final String bundleKeyPostfix;

    public CreateRefreshAction(String bundleKeyPostfix) {
        this.bundleKeyPostfix = bundleKeyPostfix;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext ctx = HgUtils.getCurrentContext(nodes);
        final File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        new HgProgressSupport(){

            @Override
            protected void perform() {
                if (!QUtils.isMQEnabledExtension(root)) {
                    return;
                }
                final QCommitPanel panel = CreateRefreshAction.this.createPanel(root, roots);
                if (panel != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CreateRefreshAction.this.performAction(root, roots, panel, ctx);
                        }
                    });
                }
            }
        }.start(Mercurial.getInstance().getRequestProcessor(root), root, NbBundle.getMessage(CreateRefreshAction.class, (String)"LBL_CreateRefreshAction.preparing.progress"));
    }

    abstract QCommitPanel createPanel(File var1, File[] var2);

    private void performAction(final File root, final File[] roots, final QCommitPanel panel, VCSContext ctx) {
        VCSCommitTable table = panel.getCommitTable();
        String contentTitle = Utils.getContextDisplayName((VCSContext)ctx);
        boolean ok = panel.open(ctx, panel.getHelpContext(), NbBundle.getMessage(CreateRefreshAction.class, (String)("CTL_RefreshPatchDialog_Title." + this.bundleKeyPostfix), (Object)contentTitle));
        if (ok) {
            final List commitFiles = table.getCommitFiles();
            this.persistCanceledCommitMessage(panel.getParameters(), "");
            panel.getParameters().storeCommitMessage();
            new HgProgressSupport(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    String message = panel.getParameters().getCommitMessage();
                    String patchName = panel.getParameters().getPatchName();
                    HashSet<File> excludedFiles = new HashSet<File>();
                    LinkedList<File> addCandidates = new LinkedList<File>();
                    LinkedList<File> deleteCandidates = new LinkedList<File>();
                    LinkedList<File> commitCandidates = new LinkedList<File>();
                    Collection<HgQueueHook> hooks = panel.getHooks();
                    String user = panel.getParameters().getUser();
                    if (user != null) {
                        HgModuleConfig.getDefault().putRecentCommitAuthors(user);
                    }
                    FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
                    for (QFileNode node : commitFiles) {
                        if (this.isCanceled()) {
                            return;
                        }
                        VCSCommitOptions option = node.getCommitOptions();
                        if (option != QFileNode.EXCLUDE) {
                            int status = cache.getStatus(node.getFile()).getStatus();
                            if ((status & 4) != 0) {
                                addCandidates.add(node.getFile());
                            } else if ((status & 0x800) != 0) {
                                addCandidates.add(node.getFile());
                            }
                            commitCandidates.add(node.getFile());
                            continue;
                        }
                        excludedFiles.add(node.getFile());
                    }
                    if (this.isCanceled()) {
                        return;
                    }
                    OutputLogger logger = this.getLogger();
                    HashSet<File> filesToRefresh = new HashSet<File>();
                    try {
                        logger.outputInRed(NbBundle.getMessage(CreateRefreshAction.class, (String)("MSG_CREATE_REFRESH_TITLE." + CreateRefreshAction.this.bundleKeyPostfix)));
                        logger.outputInRed(NbBundle.getMessage(CreateRefreshAction.class, (String)("MSG_CREATE_REFRESH_TITLE_SEP." + CreateRefreshAction.this.bundleKeyPostfix)));
                        logger.output(NbBundle.getMessage(CreateRefreshAction.class, (String)("MSG_CREATE_REFRESH_INFO_SEP." + CreateRefreshAction.this.bundleKeyPostfix), (Object)patchName, (Object)root.getAbsolutePath()));
                        new Cmd.AddCmd(root, addCandidates, logger, null, "hg add {0} into {1}").handle();
                        new Cmd.RemoveCmd(root, deleteCandidates, logger, null, "hg delete {0} from {1}").handle();
                        File[] hookFiles = null;
                        if (hooks.size() > 0) {
                            hookFiles = commitCandidates.toArray(new File[commitCandidates.size()]);
                        }
                        HgModuleConfig.getDefault().setLastUsedQPatchMessage(patchName, message);
                        HgQueueHookContext context = new HgQueueHookContext(hookFiles, message, patchName, new HgHookContext.LogEntry[0]);
                        for (HgQueueHook hook : hooks) {
                            try {
                                if ((context = hook.beforePatchRefresh(context)) == null) continue;
                                message = context.getMessage();
                            }
                            catch (IOException iOException) {}
                        }
                        Cmd.CreateRefreshPatchCmd commitCmd = CreateRefreshAction.this.createHgCommand(root, commitCandidates, logger, message, patchName, user, CreateRefreshAction.this.bundleKeyPostfix, Arrays.asList(roots), excludedFiles, filesToRefresh);
                        commitCmd.setCommitHooks(context, hooks, hookFiles);
                        commitCmd.handle();
                    }
                    catch (HgException.HgCommandCanceledException hookFiles) {
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                    }
                    finally {
                        Mercurial.getInstance().getFileStatusCache().refreshAllRoots(filesToRefresh);
                        Mercurial.getInstance().getMercurialHistoryProvider().fireHistoryChange(filesToRefresh.toArray(new File[filesToRefresh.size()]));
                        logger.outputInRed(NbBundle.getMessage(CreateRefreshAction.class, (String)("MSG_CREATE_REFRESH_DONE." + CreateRefreshAction.this.bundleKeyPostfix)));
                        logger.output("");
                    }
                }
            }.start(Mercurial.getInstance().getRequestProcessor(root), root, NbBundle.getMessage(CreateRefreshAction.class, (String)("LBL_CreateRefreshAction.progress." + this.bundleKeyPostfix)));
        } else if (!panel.getParameters().getCommitMessage().isEmpty()) {
            this.persistCanceledCommitMessage(panel.getParameters(), panel.getParameters().getCommitMessage());
        }
    }

    abstract Cmd.CreateRefreshPatchCmd createHgCommand(File var1, List<File> var2, OutputLogger var3, String var4, String var5, String var6, String var7, List<File> var8, Set<File> var9, Set<File> var10);

    abstract void persistCanceledCommitMessage(QCreatePatchParameters var1, String var2);

    static abstract class Cmd {
        protected final List<File> candidates;
        protected final OutputLogger logger;
        protected final String logMsgFormat;
        protected final String msg;
        protected final File repository;

        public Cmd(File repository, List<File> candidates, OutputLogger logger, String msg, String logMsgFormat) {
            this.repository = repository;
            this.candidates = candidates;
            this.logger = logger;
            this.logMsgFormat = logMsgFormat;
            this.msg = msg;
        }

        void handle() throws HgException {
            if (this.candidates.isEmpty()) {
                return;
            }
            this.doCmd();
            for (File f : this.candidates) {
                this.logger.output(MessageFormat.format(this.logMsgFormat, f.getName(), this.repository));
            }
        }

        abstract void doCmd() throws HgException;

        static abstract class CreateRefreshPatchCmd
        extends Cmd {
            private HgQueueHookContext context;
            private Collection<HgQueueHook> hooks;
            private File[] hookFiles;
            private final List<File> rootFiles;
            private final Set<File> refreshFiles;
            private final Set<File> excludedFiles;
            private final String patchId;
            private final String bundleKeyPostfix;
            private final String user;

            public CreateRefreshPatchCmd(File repository, List<File> m, OutputLogger logger, String commitMessage, String patchId, String user, String bundleKeyPostfix, List<File> rootFiles, Set<File> excludedFiles, Set<File> filesToRefresh) {
                super(repository, m, logger, commitMessage, null);
                this.patchId = patchId;
                this.user = user;
                this.bundleKeyPostfix = bundleKeyPostfix;
                this.rootFiles = rootFiles;
                this.excludedFiles = excludedFiles;
                this.refreshFiles = filesToRefresh;
            }

            public void setCommitHooks(HgQueueHookContext context, Collection<HgQueueHook> hooks, File[] hookFiles) {
                this.context = context;
                this.hooks = hooks;
                this.hookFiles = hookFiles;
            }

            @Override
            void handle() throws HgException {
                this.doCmd();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void doCmd() throws HgException {
                Set<File> files = new HashSet<File>(this.candidates);
                files.addAll(this.excludedFiles);
                try {
                    this.runHgCommand(this.repository, this.candidates, this.excludedFiles, this.patchId, this.msg, this.user, this.logger);
                }
                catch (HgException.HgTooLongArgListException e) {
                    List<File> reducedCommitCandidates;
                    Mercurial.LOG.log(Level.INFO, null, e);
                    String offeredFileNames = "";
                    if (this.rootFiles != null && this.rootFiles.size() < 5) {
                        reducedCommitCandidates = new ArrayList<File>(this.rootFiles);
                        files = new HashSet<File>(this.rootFiles);
                        for (File f : reducedCommitCandidates) {
                            offeredFileNames = offeredFileNames + "\n" + f.getName();
                        }
                    } else {
                        reducedCommitCandidates = Collections.emptyList();
                        files = Collections.singleton(this.repository);
                        offeredFileNames = "\n" + this.repository.getName();
                    }
                    NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CreateRefreshAction.class, (String)("MSG_LONG_COMMAND_QUERY." + this.bundleKeyPostfix), (Object)offeredFileNames));
                    descriptor.setTitle(NbBundle.getMessage(CreateRefreshAction.class, (String)"MSG_LONG_COMMAND_TITLE"));
                    descriptor.setMessageType(2);
                    descriptor.setOptionType(0);
                    Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    if (res == NotifyDescriptor.NO_OPTION) {
                        return;
                    }
                    Mercurial.LOG.log(Level.INFO, "QRefresh: refreshing patch with a reduced set of files: {0}", reducedCommitCandidates.toString());
                    this.runHgCommand(this.repository, reducedCommitCandidates, Collections.emptySet(), this.patchId, this.msg, this.user, this.logger);
                }
                finally {
                    this.refreshFiles.addAll(files);
                }
                HgLogMessage tip = HgCommand.doTip(this.repository, this.logger);
                this.context = new HgQueueHookContext(this.hookFiles, this.msg, this.patchId, new HgHookContext.LogEntry[0]);
                for (HgQueueHook hook : this.hooks) {
                    hook.afterPatchRefresh(this.context);
                }
                if (this.candidates.size() == 1) {
                    this.logger.output(NbBundle.getMessage(CreateRefreshAction.class, (String)("MSG_PATCH_REFRESH_SEP_ONE." + this.bundleKeyPostfix), (Object)this.patchId));
                } else if (!this.candidates.isEmpty()) {
                    this.logger.output(NbBundle.getMessage(CreateRefreshAction.class, (String)("MSG_PATCH_REFRESH_SEP." + this.bundleKeyPostfix), (Object)this.patchId, (Object)this.candidates.size()));
                }
                for (File f : this.candidates) {
                    this.logger.output("\t" + f.getAbsolutePath());
                }
                HgUtils.logHgLog(tip, this.logger);
            }

            protected abstract void runHgCommand(File var1, List<File> var2, Set<File> var3, String var4, String var5, String var6, OutputLogger var7) throws HgException;
        }

        static class RemoveCmd
        extends Cmd {
            public RemoveCmd(File repository, List<File> m, OutputLogger logger, String msgFormat, String msg) {
                super(repository, m, logger, msgFormat, msg);
            }

            @Override
            void doCmd() throws HgException {
                HgCommand.doRemove(this.repository, this.candidates, this.logger);
            }
        }

        static class AddCmd
        extends Cmd {
            public AddCmd(File repository, List<File> m, OutputLogger logger, String msgFormat, String msg) {
                super(repository, m, logger, msgFormat, msg);
            }

            @Override
            void doCmd() throws HgException {
                HgCommand.doAdd(this.repository, this.candidates, this.logger);
            }
        }
    }
}

