/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.newproject.Bundle;
import org.netbeans.modules.maven.newproject.TemplateUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;

public final class ArchetypeTemplateHandler
extends CreateFromTemplateHandler {
    protected boolean accept(CreateDescriptor desc) {
        return desc.getTemplate().hasExt("archetype");
    }

    public List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
        Properties archetype = new Properties();
        try (InputStream is = desc.getTemplate().getInputStream();){
            archetype.load(is);
        }
        ArchetypeTemplateHandler.mergeProperties(desc, archetype);
        ProjectInfo pi = TemplateUtils.createProjectInfo(desc.getName(), archetype);
        String groupId = archetype.getProperty("groupId");
        if (groupId == null) {
            throw new IOException(Bundle.MSG_NoGroupId());
        }
        Archetype arch = new Archetype();
        arch.setArtifactId(archetype.getProperty("archetypeArtifactId"));
        arch.setGroupId(archetype.getProperty("archetypeGroupId"));
        arch.setVersion(archetype.getProperty("archetypeVersion"));
        File projDir = (File)desc.getValue("projdir");
        if (projDir == null) {
            projDir = FileUtil.toFile((FileObject)desc.getTarget());
        }
        if (projDir == null) {
            throw new IOException("projdir not specified");
        }
        Map filteredProperties = NbCollections.checkedMapByFilter((Map)archetype, String.class, String.class, (boolean)false);
        File toCreate = new File(projDir, pi.artifactId);
        ArchetypeWizards.createFromArchetype(toCreate, pi, arch, filteredProperties, true);
        FileObject fo = FileUtil.toFileObject((File)toCreate);
        return TemplateUtils.afterTemplateCreation(archetype, desc, null, fo);
    }

    static void mergeProperties(CreateDescriptor desc, Properties archetype) {
        ArchetypeTemplateHandler.putAllTo(desc.getParameters(), archetype);
        Map wizardParams = (Map)desc.getValue("wizard");
        if (wizardParams != null) {
            ArchetypeTemplateHandler.putAllTo(wizardParams, archetype);
        }
    }

    private static void putAllTo(Map<String, ?> parameters, Properties archetype) {
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            archetype.put(entry.getKey(), entry.getValue());
        }
    }
}

