/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.project.MavenProject;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.OutputUtils;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.execute.AbstractMavenExecutor;
import org.netbeans.modules.maven.execute.AbstractOutputHandler;
import org.netbeans.modules.maven.execute.cmd.ExecMojo;
import org.netbeans.modules.maven.execute.cmd.ExecProject;
import org.netbeans.modules.maven.execute.cmd.ExecSession;
import org.netbeans.modules.maven.execute.cmd.ExecutionEventObject;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.spi.project.ProjectContainerProvider;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOPosition;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class CommandLineOutputHandler
extends AbstractOutputHandler {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Maven ComandLine Output Redirection", Integer.getInteger("maven.concurrent.builds", 16) * 2);
    private static final Logger LOG = Logger.getLogger(CommandLineOutputHandler.class.getName());
    private InputOutput inputOutput;
    static final Pattern DOWNLOAD = Pattern.compile("^(\\d+(/\\d*)? ?(M|K|b|KB|B|\\?)\\s*)+$");
    private static final Pattern linePattern = Pattern.compile("\\[(DEBUG|INFO|WARNING|ERROR|FATAL)\\] (.*)");
    public static final Pattern startPatternM2 = Pattern.compile("\\[INFO\\] \\[([\\w]*):([\\w]*)[ ]?.*\\]");
    public static final Pattern startPatternM3 = Pattern.compile("\\[INFO\\] --- (\\S+):\\S+:(\\S+)(?: [(]\\S+[)])? @ \\S+ ---");
    private static final Pattern mavenSomethingPlugin = Pattern.compile("maven-(.+)-plugin");
    private static final Pattern somethingMavenPlugin = Pattern.compile("(.+)-maven-plugin");
    static final Pattern reactorFailure = Pattern.compile("\\[INFO\\] (.+) [.]* FAILURE \\[.+\\]");
    private static final Pattern stackTraceElement = OutputUtils.linePattern;
    public static final Pattern reactorSummaryLine = Pattern.compile("(.+) [.]* (FAILURE|SUCCESS) (\\[.+\\])?");
    private OutputWriter stdOut;
    private String currentProject;
    private String currentTag;
    RequestProcessor.Task outTask;
    private Input inp;
    private ProgressHandle handle;
    String firstFailure;
    private final JSONParser parser;
    private ContextImpl contextImpl;
    private final ExecutionEventObject.Tree executionTree;
    private ExecutionEventObject.Tree currentTreeNode;
    private boolean inStackTrace;
    private boolean addMojoFold;
    private boolean addProjectFold;
    private URL[] mavencoreurls;
    private static final String SEC_MOJO_EXEC = "mojo-execute";
    private static final Map<ExecutionEvent.Type, ExecutionEvent.Type> END_TO_START_Mappings = new EnumMap<ExecutionEvent.Type, ExecutionEvent.Type>(ExecutionEvent.Type.class);
    private ProgressState state;
    private int forkCount;
    private int reactorSize;
    private int projectCount;

    public CommandLineOutputHandler(InputOutput io, Project proj, ProgressHandle hand, RunConfig config, boolean createVisitorContext) {
        super(proj, hand, config, createVisitorContext ? new OutputVisitor(new ContextImpl()) : new OutputVisitor());
        this.currentTreeNode = this.executionTree = new ExecutionEventObject.Tree(null, null);
        this.inStackTrace = false;
        this.addMojoFold = false;
        this.addProjectFold = false;
        this.state = ProgressState.INITIAL;
        if (createVisitorContext) {
            this.contextImpl = (ContextImpl)this.visitor.getContext();
            assert (this.contextImpl != null);
            this.contextImpl.setExecutionTree(this.executionTree);
        }
        this.parser = new JSONParser();
        this.handle = hand;
        this.inputOutput = io;
        this.stdOut = this.inputOutput.getOut();
        this.initProcessorList(proj, config);
    }

    @CheckForNull
    public ExecutionEventObject.Tree getExecutionTree() {
        if (this.contextImpl != null) {
            return this.executionTree;
        }
        return null;
    }

    @Override
    protected final void checkSleepiness() {
        if (this.contextImpl == null) {
            this.handle.progress(this.currentProject == null ? "" : (this.currentTag == null ? this.currentProject : this.currentProject + " " + this.currentTag));
        }
        super.checkSleepiness();
    }

    void setStdOut(InputStream inStr) {
        this.outTask = PROCESSOR.post((Runnable)new Output(inStr));
    }

    void setStdIn(OutputStream in) {
        this.inp = new Input(in, this.inputOutput);
        PROCESSOR.post((Runnable)this.inp);
    }

    void waitFor() {
        this.inp.stopInput();
        if (this.outTask != null) {
            this.outTask.waitFinished();
        }
    }

    @Override
    protected InputOutput getIO() {
        return this.inputOutput;
    }

    private void closeCurrentTag() {
        assert (this.contextImpl == null);
        if (this.currentTag != null) {
            this.processEnd(this.getEventId(SEC_MOJO_EXEC, this.currentTag), this.stdOut);
            this.currentTag = null;
        }
    }

    private void mergeClasspath(ExecMojo exec, URL[] coreurls) {
        if (coreurls != null) {
            URL[] urls = exec.getClasspathURLs();
            if (urls == null) {
                exec.setClasspathURLs(coreurls);
            } else {
                ArrayList<URL> newones = new ArrayList<URL>();
                newones.addAll(Arrays.asList(urls));
                newones.addAll(Arrays.asList(coreurls));
                exec.setClasspathURLs(newones.toArray(new URL[0]));
            }
        }
    }

    private void completeTreeAtEnd() {
        for (ExecutionEventObject.Tree nd : this.executionTree.getChildrenNodes()) {
            if (nd.getEndEvent() != null) continue;
            ExecutionEventObject innerEnd = this.createEndForStart(nd.getStartEvent());
            this.trimTree(innerEnd);
        }
    }

    private void processExecEvent(ExecutionEventObject obj) {
        block23: {
            block25: {
                block24: {
                    String tag;
                    ExecMojo exec;
                    block22: {
                        if (obj == null) {
                            return;
                        }
                        this.checkProgress(obj);
                        if (ExecutionEvent.Type.SessionStarted.equals((Object)obj.type)) {
                            if (this.currentTreeNode != this.executionTree) {
                                this.completeTreeAtEnd();
                            }
                            this.mavencoreurls = ((ExecSession)obj).getMnvcoreurls();
                        }
                        if (ExecutionEvent.Type.MojoStarted.equals((Object)obj.type)) {
                            this.growTree(obj);
                            this.addMojoFold = true;
                            exec = (ExecMojo)obj;
                            tag = this.goalPrefixFromArtifactId(exec.plugin.artifactId) + ":" + exec.goal;
                            ExecutionEventObject.Tree prjNode = this.currentTreeNode.findParentNodeOfType(ExecutionEvent.Type.ProjectStarted);
                            assert (prjNode != null);
                            ExecProject p = (ExecProject)prjNode.getStartEvent();
                            this.handle.progress(p.gav.artifactId + " " + tag);
                            this.processStart(this.getEventId(SEC_MOJO_EXEC, tag), this.stdOut);
                        }
                        if (!ExecutionEvent.Type.MojoSucceeded.equals((Object)obj.type)) break block22;
                        if (MavenSettings.getDefault().isCollapseSuccessFolds()) {
                            this.currentTreeNode.collapseFold();
                        }
                        this.currentTreeNode.finishFold();
                        exec = (ExecMojo)obj;
                        this.mergeClasspath(exec, this.mavencoreurls);
                        this.trimTree(exec);
                        tag = this.goalPrefixFromArtifactId(exec.plugin.artifactId) + ":" + exec.goal;
                        this.processEnd(this.getEventId(SEC_MOJO_EXEC, tag), this.stdOut);
                        break block23;
                    }
                    if (!ExecutionEvent.Type.MojoFailed.equals((Object)obj.type)) break block24;
                    this.currentTreeNode.finishFold();
                    exec = (ExecMojo)obj;
                    this.mergeClasspath(exec, this.mavencoreurls);
                    this.trimTree(exec);
                    tag = this.goalPrefixFromArtifactId(exec.plugin.artifactId) + ":" + exec.goal;
                    this.processFail(this.getEventId(SEC_MOJO_EXEC, tag), this.stdOut);
                    break block23;
                }
                if (!ExecutionEvent.Type.ProjectStarted.equals((Object)obj.type)) break block25;
                this.growTree(obj);
                this.addProjectFold = true;
                if (this.contextImpl == null) break block23;
                ExecProject pr = (ExecProject)obj;
                Project project = pr.findProject();
                this.contextImpl.setCurrentProject(project);
                this.processStart(this.getEventId("project-execute", null), this.stdOut);
                break block23;
            }
            if (!ExecutionEvent.Type.ProjectSkipped.equals((Object)obj.type)) {
                if (ExecutionEvent.Type.ProjectSucceeded.equals((Object)obj.type)) {
                    if (MavenSettings.getDefault().isCollapseSuccessFolds()) {
                        this.currentTreeNode.collapseFold();
                    }
                    this.currentTreeNode.finishFold();
                    this.trimTree(obj);
                    this.processEnd(this.getEventId("project-execute", null), this.stdOut);
                } else if (ExecutionEvent.Type.ProjectFailed.equals((Object)obj.type)) {
                    this.currentTreeNode.finishFold();
                    this.trimTree(obj);
                    this.processEnd(this.getEventId("project-execute", null), this.stdOut);
                } else if (ExecutionEvent.Type.ForkStarted.equals((Object)obj.type)) {
                    this.growTree(obj);
                } else if (ExecutionEvent.Type.ForkedProjectStarted.equals((Object)obj.type)) {
                    this.growTree(obj);
                } else if (ExecutionEvent.Type.ForkFailed.equals((Object)obj.type) || ExecutionEvent.Type.ForkSucceeded.equals((Object)obj.type)) {
                    this.trimTree(obj);
                } else if (ExecutionEvent.Type.ForkedProjectFailed.equals((Object)obj.type) || ExecutionEvent.Type.ForkedProjectSucceeded.equals((Object)obj.type)) {
                    this.trimTree(obj);
                } else if (!MavenSettings.getDefault().isAlwaysShowOutput() && ExecutionEvent.Type.SessionEnded.equals((Object)obj.type)) {
                    for (ExecutionEventObject.Tree node : this.executionTree.getChildrenNodes()) {
                        if (node.getEndEvent() == null || !ExecutionEvent.Type.ProjectFailed.equals((Object)node.getEndEvent().type)) continue;
                        this.getIO().select();
                        break;
                    }
                }
            }
        }
    }

    private String goalPrefixFromArtifactId(String mojoArtifact) {
        Matcher match2 = mavenSomethingPlugin.matcher(mojoArtifact);
        if (match2.matches()) {
            mojoArtifact = match2.group(1);
        } else {
            match2 = somethingMavenPlugin.matcher(mojoArtifact);
            if (match2.matches()) {
                mojoArtifact = match2.group(1);
            }
        }
        return mojoArtifact;
    }

    private void growTree(ExecutionEventObject obj) {
        ExecutionEventObject.Tree tn = new ExecutionEventObject.Tree(obj, this.currentTreeNode);
        if (tn.getStartEvent().type.equals((Object)ExecutionEvent.Type.MojoStarted) && !this.currentTreeNode.getChildrenNodes().isEmpty()) {
            ExecutionEventObject.Tree lastSibling = this.currentTreeNode.getChildrenNodes().get(this.currentTreeNode.getChildrenNodes().size() - 1);
            while (lastSibling != null && lastSibling.getEndEvent() != null && (ExecutionEvent.Type.ForkFailed.equals((Object)lastSibling.getEndEvent().type) || ExecutionEvent.Type.ForkSucceeded.equals((Object)lastSibling.getEndEvent().type))) {
                this.currentTreeNode.getChildrenNodes().remove(lastSibling);
                tn.getChildrenNodes().add(0, lastSibling);
                lastSibling.reassingParent(tn);
                lastSibling = this.currentTreeNode.getChildrenNodes().isEmpty() ? null : this.currentTreeNode.getChildrenNodes().get(this.currentTreeNode.getChildrenNodes().size() - 1);
            }
        }
        this.currentTreeNode.getChildrenNodes().add(tn);
        this.currentTreeNode = tn;
        this.currentTreeNode.setStartOffset(IOPosition.currentPosition((InputOutput)this.inputOutput));
    }

    private void trimTree(ExecutionEventObject obj) {
        ExecutionEventObject start = this.currentTreeNode.getStartEvent();
        while (!this.matchingEvents(obj.type, start.type)) {
            ExecutionEventObject innerEnd = this.createEndForStart(start);
            this.processExecEvent(innerEnd);
            start = this.currentTreeNode.getStartEvent();
        }
        this.currentTreeNode.setEndOffset(IOPosition.currentPosition((InputOutput)this.inputOutput));
        this.currentTreeNode.setEndEvent(obj);
        this.currentTreeNode = this.currentTreeNode.getParentNode();
    }

    private boolean matchingEvents(ExecutionEvent.Type typeEnd, ExecutionEvent.Type typeStart) {
        ExecutionEvent.Type match = END_TO_START_Mappings.get(typeEnd);
        assert (match != null) : "unknown event type:" + typeEnd;
        return typeStart.equals((Object)match);
    }

    private ExecutionEventObject createEndForStart(ExecutionEventObject start) {
        ExecutionEventObject toRet;
        if (start instanceof ExecMojo) {
            ExecMojo startEx = (ExecMojo)start;
            toRet = new ExecMojo(startEx.goal, startEx.plugin, startEx.phase, startEx.executionId, ExecutionEvent.Type.MojoFailed);
        } else if (start instanceof ExecProject) {
            ExecProject startPrj = (ExecProject)start;
            toRet = new ExecProject(startPrj.gav, startPrj.currentProjectLocation, ExecutionEvent.Type.ProjectFailed);
        } else if (start instanceof ExecSession) {
            ExecSession ss = (ExecSession)start;
            toRet = new ExecSession(ss.projectCount, ExecutionEvent.Type.SessionEnded);
        } else {
            ExecutionEvent.Type endType;
            if (start.type.equals((Object)ExecutionEvent.Type.ForkStarted)) {
                endType = ExecutionEvent.Type.ForkFailed;
            } else if (start.type.equals((Object)ExecutionEvent.Type.ForkedProjectStarted)) {
                endType = ExecutionEvent.Type.ForkedProjectFailed;
            } else {
                throw new RuntimeException("unknown event type: " + start.type);
            }
            toRet = new ExecutionEventObject(endType);
        }
        return toRet;
    }

    AbstractMavenExecutor.ResumeFromFinder createResumeFromFinder() {
        if (this.contextImpl == null) {
            if (this.firstFailure != null) {
                return new FindByName(this.firstFailure);
            }
            return null;
        }
        for (ExecutionEventObject.Tree prj : this.executionTree.getChildrenNodes()) {
            if (prj.getEndEvent() == null || !ExecutionEvent.Type.ProjectFailed.equals((Object)prj.getEndEvent().type)) continue;
            return new FindByEvents((ExecProject)prj.getStartEvent());
        }
        return null;
    }

    private void checkProgress(ExecutionEventObject eeo) {
        if (ExecutionEvent.Type.ProjectDiscoveryStarted.equals((Object)eeo.type)) {
            this.handle.switchToIndeterminate();
        } else if (ExecutionEvent.Type.SessionStarted.equals((Object)eeo.type)) {
            this.reactorSize = ((ExecSession)eeo).projectCount + 1;
            this.projectCount = 0;
            this.handle.switchToDeterminate(this.reactorSize);
        } else if (ExecutionEvent.Type.ProjectStarted.equals((Object)eeo.type)) {
            this.handle.progress(((ExecProject)eeo).gav.artifactId, Math.min(++this.projectCount, this.reactorSize));
        } else if (ExecutionEvent.Type.ProjectSkipped.equals((Object)eeo.type)) {
            this.handle.progress(((ExecProject)eeo).gav.artifactId + " " + ((ExecProject)eeo).gav.version, Math.min(++this.projectCount, this.reactorSize));
        } else if (ExecutionEvent.Type.SessionEnded.equals((Object)eeo.type)) {
            // empty if block
        }
    }

    private void checkProgress(String text) {
        switch (this.state) {
            case INITIAL: {
                if (!text.equals("Reactor Build Order:")) break;
                this.state = ProgressState.GOT_REACTOR_BUILD_ORDER;
                break;
            }
            case GOT_REACTOR_BUILD_ORDER: {
                if (text.trim().isEmpty()) {
                    this.state = ProgressState.GETTING_REACTOR_PROJECTS;
                    break;
                }
                this.state = ProgressState.INITIAL;
                break;
            }
            case GETTING_REACTOR_PROJECTS: {
                if (text.trim().isEmpty()) {
                    this.state = ProgressState.NORMAL;
                    ++this.reactorSize;
                    this.handle.switchToDeterminate(this.reactorSize);
                    LOG.log(Level.FINE, "reactor size: {0}", this.reactorSize);
                    break;
                }
                ++this.reactorSize;
                break;
            }
            case NORMAL: {
                if (this.forkCount == 0 && text.matches("-+")) {
                    this.state = ProgressState.GOT_DASHES;
                    break;
                }
                if (text.startsWith(">>> ")) {
                    ++this.forkCount;
                    LOG.log(Level.FINE, "fork count up to {0}", this.forkCount);
                    break;
                }
                if (this.forkCount <= 0 || !text.startsWith("<<< ")) break;
                --this.forkCount;
                LOG.log(Level.FINE, "fork count down to {0}", this.forkCount);
                break;
            }
            case GOT_DASHES: {
                if (text.startsWith("Building ") && !text.startsWith("Building in ") || text.startsWith("Skipping ")) {
                    this.currentProject = text.substring(9);
                    this.closeCurrentTag();
                    this.handle.progress(this.currentProject, Math.min(++this.projectCount, this.reactorSize));
                    LOG.log(Level.FINE, "got project #{0}: {1}", new Object[]{this.projectCount, this.currentProject});
                }
                this.state = ProgressState.NORMAL;
                break;
            }
            default: {
                assert (false) : this.state;
                break;
            }
        }
    }

    private static Charset getNativeCharset() {
        String nativeEncoding = System.getProperty("native.encoding");
        Charset nativeCharset = null;
        if (nativeEncoding != null) {
            try {
                nativeCharset = Charset.forName(nativeEncoding);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Failed to get charset for native.encoding value : '" + nativeEncoding + "'", ex);
            }
        }
        if (nativeCharset == null) {
            nativeCharset = Charset.defaultCharset();
        }
        return nativeCharset;
    }

    static {
        END_TO_START_Mappings.put(ExecutionEvent.Type.ForkFailed, ExecutionEvent.Type.ForkStarted);
        END_TO_START_Mappings.put(ExecutionEvent.Type.ForkSucceeded, ExecutionEvent.Type.ForkStarted);
        END_TO_START_Mappings.put(ExecutionEvent.Type.ForkedProjectFailed, ExecutionEvent.Type.ForkedProjectStarted);
        END_TO_START_Mappings.put(ExecutionEvent.Type.ForkedProjectSucceeded, ExecutionEvent.Type.ForkedProjectStarted);
        END_TO_START_Mappings.put(ExecutionEvent.Type.MojoFailed, ExecutionEvent.Type.MojoStarted);
        END_TO_START_Mappings.put(ExecutionEvent.Type.MojoSucceeded, ExecutionEvent.Type.MojoStarted);
        END_TO_START_Mappings.put(ExecutionEvent.Type.ProjectFailed, ExecutionEvent.Type.ProjectStarted);
        END_TO_START_Mappings.put(ExecutionEvent.Type.ProjectSucceeded, ExecutionEvent.Type.ProjectStarted);
        END_TO_START_Mappings.put(ExecutionEvent.Type.SessionEnded, ExecutionEvent.Type.SessionEnded);
    }

    public static class ContextImpl
    implements OutputVisitor.Context {
        private Project currentProject;
        private ExecutionEventObject.Tree executionTree;

        ContextImpl() {
        }

        @Override
        @CheckForNull
        public Project getCurrentProject() {
            return this.currentProject;
        }

        public void setCurrentProject(@NullAllowed Project currentProject) {
            this.currentProject = currentProject;
        }

        private void setExecutionTree(ExecutionEventObject.Tree executionTree) {
            this.executionTree = executionTree;
        }

        public ExecutionEventObject.Tree getExecutionTree() {
            return this.executionTree;
        }
    }

    static enum ProgressState {
        INITIAL,
        GOT_REACTOR_BUILD_ORDER,
        GETTING_REACTOR_PROJECTS,
        NORMAL,
        GOT_DASHES;

    }

    static class Input
    implements Runnable {
        private final InputOutput inputOutput;
        private final OutputStream str;
        private boolean stopIn = false;

        public Input(OutputStream out, InputOutput inputOutput) {
            this.str = out;
            this.inputOutput = inputOutput;
        }

        public void stopInput() {
            this.stopIn = true;
            PROCESSOR.post(() -> {
                try {
                    this.inputOutput.getIn().close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }

        @Override
        public void run() {
            Reader in = this.inputOutput.getIn();
            try (OutputStreamWriter out = new OutputStreamWriter(this.str, CommandLineOutputHandler.getNativeCharset());){
                while (true) {
                    int read;
                    if ((read = in.read()) == -1) {
                        return;
                    }
                    ((Writer)out).write(read);
                    ((Writer)out).flush();
                    if (!this.stopIn) continue;
                    return;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    private static class FindByEvents
    implements AbstractMavenExecutor.ResumeFromFinder {
        private final ExecProject execProject;

        private FindByEvents(ExecProject execProject) {
            this.execProject = execProject;
        }

        @Override
        @CheckForNull
        public NbMavenProject find(@NonNull Project root) {
            Project project = this.execProject.findProject();
            if (project != null) {
                return (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            }
            return null;
        }
    }

    private static class FindByName
    implements AbstractMavenExecutor.ResumeFromFinder {
        @NonNull
        private final String firstFailure;

        private FindByName(@NonNull String firstFailure) {
            this.firstFailure = firstFailure;
        }

        @Override
        @CheckForNull
        public NbMavenProject find(@NonNull Project root) {
            for (Project module : ((ProjectContainerProvider)root.getLookup().lookup(ProjectContainerProvider.class)).getContainedProjects().getProjects()) {
                MavenProject mp;
                if (Thread.interrupted()) break;
                NbMavenProject nbmp = (NbMavenProject)module.getLookup().lookup(NbMavenProject.class);
                if (nbmp == null || !this.firstFailure.equals((mp = nbmp.getMavenProject()).getName())) continue;
                return nbmp;
            }
            return null;
        }
    }

    private class Output
    implements Runnable {
        private static final String INFO_NETBEANS_EXEC_EVENT = "[INFO] NETBEANS-ExecEvent:";
        private final BufferedReader str;
        private boolean skipLF = false;

        public Output(InputStream instream) {
            this.str = new BufferedReader(new InputStreamReader(instream, CommandLineOutputHandler.getNativeCharset()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readLine() throws IOException {
            char[] char1 = new char[1];
            boolean isReady = true;
            int count = 0;
            StringBuilder buf = new StringBuilder();
            while (isReady && ++count <= 20000) {
                int ret = this.str.read(char1);
                if (ret != 1) {
                    if (ret == -1 && buf.length() == 0) {
                        return null;
                    }
                    return buf.toString();
                }
                if (this.skipLF) {
                    this.skipLF = false;
                    if (char1[0] == '\n') continue;
                }
                if (char1[0] == '\n') {
                    return buf.toString();
                }
                if (char1[0] == '\r') {
                    this.skipLF = true;
                    buf.append(char1[0]);
                    return buf.toString();
                }
                buf.append(char1[0]);
                isReady = this.str.ready();
                if (isReady) continue;
                Output output = this;
                synchronized (output) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        if (!this.str.ready()) {
                            break;
                        }
                        isReady = true;
                    }
                }
            }
            return "&^#INCOMPLINE:" + buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId("session-execute", null), CommandLineOutputHandler.this.stdOut);
            if (CommandLineOutputHandler.this.contextImpl == null) {
                CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId("project-execute", null), CommandLineOutputHandler.this.stdOut);
            }
            try {
                String line = this.readLine();
                while (line != null) {
                    Matcher match;
                    if (line.startsWith("&^#INCOMPLINE:")) {
                        CommandLineOutputHandler.this.stdOut.print(line.substring("&^#INCOMPLINE:".length()));
                        line = this.readLine();
                        continue;
                    }
                    int execEventIdx = line.indexOf(INFO_NETBEANS_EXEC_EVENT);
                    if (execEventIdx == 0) {
                        CommandLineOutputHandler.this.processExecEvent(this.parseExecEvent(line));
                        line = this.readLine();
                        continue;
                    }
                    String nextLine = null;
                    if (execEventIdx > 0) {
                        nextLine = line.substring(execEventIdx);
                        line = line.substring(0, execEventIdx);
                    }
                    if (line.startsWith("[INFO] Final Memory:") && CommandLineOutputHandler.this.contextImpl == null) {
                        CommandLineOutputHandler.this.closeCurrentTag();
                    }
                    String tag = null;
                    if (CommandLineOutputHandler.this.contextImpl == null) {
                        Matcher match2 = startPatternM3.matcher(line);
                        if (match2.matches()) {
                            String mojoArtifact = match2.group(1);
                            mojoArtifact = CommandLineOutputHandler.this.goalPrefixFromArtifactId(mojoArtifact);
                            tag = mojoArtifact + ':' + match2.group(2);
                        } else {
                            match2 = startPatternM2.matcher(line);
                            if (match2.matches()) {
                                tag = match2.group(1) + ':' + match2.group(2);
                            }
                        }
                    }
                    if (tag != null) {
                        CommandLineOutputHandler.this.closeCurrentTag();
                        CommandLineOutputHandler.this.currentTag = tag;
                        CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId(CommandLineOutputHandler.SEC_MOJO_EXEC, tag), CommandLineOutputHandler.this.stdOut);
                        CommandLineOutputHandler.this.checkSleepiness();
                    }
                    boolean isDownloadProgress = false;
                    if (line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
                        if (DOWNLOAD.matcher(line).matches()) {
                            isDownloadProgress = true;
                        } else {
                            line = line.substring(0, line.length() - 1);
                        }
                    }
                    if (!isDownloadProgress) {
                        match = linePattern.matcher(line);
                        if (match.matches()) {
                            String levelS = match.group(1);
                            AbstractOutputHandler.Level level = AbstractOutputHandler.Level.valueOf(levelS);
                            String text = match.group(2);
                            this.updateFoldForException(text);
                            CommandLineOutputHandler.this.processLine(MavenSettings.getDefault().isShowLoggingLevel() ? line : text, CommandLineOutputHandler.this.stdOut, level);
                            if (level == AbstractOutputHandler.Level.INFO && CommandLineOutputHandler.this.contextImpl == null) {
                                CommandLineOutputHandler.this.checkProgress(text);
                            }
                        } else {
                            this.updateFoldForException(line);
                            CommandLineOutputHandler.this.processLine(line, CommandLineOutputHandler.this.stdOut, AbstractOutputHandler.Level.INFO);
                        }
                    }
                    if (CommandLineOutputHandler.this.contextImpl == null && CommandLineOutputHandler.this.firstFailure == null && (match = reactorFailure.matcher(line)).matches()) {
                        CommandLineOutputHandler.this.firstFailure = match.group(1);
                    }
                    if (CommandLineOutputHandler.this.addMojoFold && line.startsWith("[INFO] ---")) {
                        CommandLineOutputHandler.this.currentTreeNode.startFold(CommandLineOutputHandler.this.inputOutput);
                        CommandLineOutputHandler.this.addMojoFold = false;
                    }
                    if (CommandLineOutputHandler.this.addProjectFold && line.startsWith("[INFO] Building")) {
                        CommandLineOutputHandler.this.currentTreeNode.startFold(CommandLineOutputHandler.this.inputOutput);
                        CommandLineOutputHandler.this.addProjectFold = false;
                    }
                    line = nextLine != null ? nextLine : this.readLine();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CommandLineOutputHandler.class.getName()).log(Level.FINE, null, ex);
            }
            finally {
                if (CommandLineOutputHandler.this.contextImpl == null) {
                    CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId("project-execute", null), CommandLineOutputHandler.this.stdOut);
                } else {
                    CommandLineOutputHandler.this.completeTreeAtEnd();
                }
                CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId("session-execute", null), CommandLineOutputHandler.this.stdOut);
                try {
                    this.str.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }

        private ExecutionEventObject parseExecEvent(String line) {
            String jsonContent = line.substring(INFO_NETBEANS_EXEC_EVENT.length());
            try {
                Object o = CommandLineOutputHandler.this.parser.parse(jsonContent);
                if (o instanceof JSONObject) {
                    JSONObject json = (JSONObject)o;
                    return ExecutionEventObject.create(json);
                }
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }

        private void updateFoldForException(String line) {
            if (stackTraceElement.matcher(line).find()) {
                CommandLineOutputHandler.this.inStackTrace = true;
                if (!CommandLineOutputHandler.this.currentTreeNode.hasInnerOutputFold()) {
                    CommandLineOutputHandler.this.currentTreeNode.startInnerOutputFold(CommandLineOutputHandler.this.inputOutput);
                }
            } else if (CommandLineOutputHandler.this.inStackTrace) {
                CommandLineOutputHandler.this.currentTreeNode.finishInnerOutputFold();
                CommandLineOutputHandler.this.inStackTrace = false;
            }
        }
    }
}

