/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.newproject.Bundle;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;

public final class ArchetypeTemplateHandler
extends CreateFromTemplateHandler {
    protected boolean accept(CreateDescriptor desc) {
        return desc.getTemplate().hasExt("archetype");
    }

    public List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
        String artifactId;
        Properties archetype = new Properties();
        try (InputStream is = desc.getTemplate().getInputStream();){
            archetype.load(is);
        }
        ArchetypeTemplateHandler.mergeProperties(desc, archetype);
        String version = archetype.getProperty("version");
        if (version == null) {
            version = "1.0-SNAPSHOT";
        }
        if ((artifactId = archetype.getProperty("artifactId")) == null) {
            throw new IOException(Bundle.MSG_NoArtifactId());
        }
        String groupId = archetype.getProperty("groupId");
        if (groupId == null) {
            throw new IOException(Bundle.MSG_NoGroupId());
        }
        String packageName = archetype.getProperty("package");
        ProjectInfo pi = new ProjectInfo(groupId, artifactId, version, packageName);
        Archetype arch = new Archetype();
        arch.setArtifactId(archetype.getProperty("archetypeArtifactId"));
        arch.setGroupId(archetype.getProperty("archetypeGroupId"));
        arch.setVersion(archetype.getProperty("archetypeVersion"));
        File projDir = (File)desc.getValue("projdir");
        if (projDir == null) {
            projDir = FileUtil.toFile((FileObject)desc.getTarget());
        }
        if (projDir == null) {
            throw new IOException("projdir not specified");
        }
        Map filteredProperties = NbCollections.checkedMapByFilter((Map)archetype, String.class, String.class, (boolean)false);
        File toCreate = new File(projDir, pi.artifactId);
        ArchetypeWizards.createFromArchetype(toCreate, pi, arch, filteredProperties, true);
        FileObject fo = FileUtil.toFileObject((File)toCreate);
        ArrayList<FileObject> fos = new ArrayList<FileObject>();
        ArchetypeTemplateHandler.collectPomDirs(fo, fos);
        String toOpen = archetype.getProperty("archetypeOpen");
        if (toOpen != null) {
            ArchetypeTemplateHandler.collectFiles(fo, fos, toOpen.split(","));
        }
        if ("true".equals(archetype.getProperty("archetypeBuild"))) {
            ActionProvider ap;
            Project prj = ProjectManager.getDefault().findProject(fo);
            ActionProvider actionProvider = ap = prj == null ? null : (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
            if (ap != null) {
                ap.invokeAction("build", prj.getLookup());
            }
        }
        return fos;
    }

    static void mergeProperties(CreateDescriptor desc, Properties archetype) {
        ArchetypeTemplateHandler.putAllTo(desc.getParameters(), archetype);
        Map wizardParams = (Map)desc.getValue("wizard");
        if (wizardParams != null) {
            ArchetypeTemplateHandler.putAllTo(wizardParams, archetype);
        }
    }

    private static void collectPomDirs(FileObject dir, Collection<? super FileObject> found) {
        if (dir == null || !dir.isFolder()) {
            return;
        }
        if (dir.getFileObject("pom.xml") == null) {
            return;
        }
        found.add((FileObject)dir);
        for (FileObject f : dir.getChildren()) {
            ArchetypeTemplateHandler.collectPomDirs(f, found);
        }
    }

    static void collectFiles(FileObject root, Collection<? super FileObject> found, String ... includes) {
        Pattern[] check = new Pattern[includes.length];
        for (int i = 0; i < check.length; ++i) {
            check[i] = Pattern.compile(includes[i]);
        }
        Enumeration en = root.getChildren(true);
        block1: while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            if (relPath == null) continue;
            for (Pattern p : check) {
                if (!p.matcher(relPath).matches()) continue;
                found.add((FileObject)fo);
                continue block1;
            }
        }
    }

    private static void putAllTo(Map<String, ?> parameters, Properties archetype) {
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            archetype.put(entry.getKey(), entry.getValue());
        }
    }
}

