/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.MavenModelProblemsProvider;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SanityBuildAction
implements ProjectProblemResolver {
    private final Project nbproject;

    public SanityBuildAction(Project nbproject) {
        this.nbproject = nbproject;
    }

    public Future<ProjectProblemsProvider.Result> resolve() {
        FutureTask<ProjectProblemsProvider.Result> toRet = new FutureTask<ProjectProblemsProvider.Result>(new Callable<ProjectProblemsProvider.Result>(){

            @Override
            public ProjectProblemsProvider.Result call() throws Exception {
                BeanRunConfig config = new BeanRunConfig();
                config.setExecutionDirectory(FileUtil.toFile((FileObject)SanityBuildAction.this.nbproject.getProjectDirectory()));
                NbMavenProject mavenPrj = (NbMavenProject)SanityBuildAction.this.nbproject.getLookup().lookup(NbMavenProject.class);
                if (mavenPrj != null && mavenPrj.getMavenProject().getVersion() != null && mavenPrj.getMavenProject().getVersion().endsWith("SNAPSHOT")) {
                    config.setGoals(Arrays.asList("--fail-at-end", "install"));
                } else {
                    config.setGoals(Arrays.asList("--fail-at-end", "package"));
                }
                config.setReactorStyle(RunConfig.ReactorStyle.ALSO_MAKE);
                config.setProperty("skipTests", "true");
                config.setProject(SanityBuildAction.this.nbproject);
                String label = Bundle.build_label(SanityBuildAction.this.nbproject.getProjectDirectory().getNameExt());
                config.setExecutionName(label);
                config.setTaskDisplayName(label);
                RunUtils.run(config);
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)Bundle.ACT_start_validate());
            }
        });
        MavenModelProblemsProvider.RP.execute(toRet);
        return toRet;
    }

    public int hashCode() {
        int hash = SanityBuildAction.class.hashCode();
        hash = 67 * hash + (this.nbproject != null ? this.nbproject.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SanityBuildAction other = (SanityBuildAction)obj;
        return this.nbproject == other.nbproject || this.nbproject != null && this.nbproject.equals(other.nbproject);
    }
}

