/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject.idenative;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.newproject.ArchetypeWizardUtils;
import org.netbeans.modules.maven.newproject.BasicWizardPanel;
import org.netbeans.modules.maven.newproject.idenative.Bundle;
import org.netbeans.modules.maven.spi.newproject.CreateProjectBuilder;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class IDENativeMavenWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor>,
WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final long serialVersionUID = 1L;
    private transient int index;
    private transient List<WizardDescriptor.Panel<WizardDescriptor>> panels;
    private transient WizardDescriptor wiz;
    private final AtomicBoolean hasNextCalled = new AtomicBoolean();
    private final String titlename;
    private final String log;
    private final String packaging;

    public IDENativeMavenWizardIterator(String title, String log, String packaging) {
        this.titlename = title;
        this.log = log;
        this.packaging = packaging;
    }

    public Set instantiate() throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        try {
            handle.progress(Bundle.PRG_Dir());
            ProjectInfo vi = new ProjectInfo((String)this.wiz.getProperty("groupId"), (String)this.wiz.getProperty("artifactId"), (String)this.wiz.getProperty("version"), (String)this.wiz.getProperty("package"));
            String[] splitlog = StringUtils.split((String)this.log, (String)":");
            ArchetypeWizardUtils.logUsage(splitlog[0], splitlog[1], splitlog[2]);
            File projFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
            CreateProjectBuilder builder = this.createBuilder(projFile, vi, handle);
            builder.create();
            handle.progress(Bundle.PRG_FINISH());
            Set<FileObject> set = ArchetypeWizardUtils.openProjects(projFile, null);
            return set;
        }
        finally {
            handle.finish();
        }
    }

    protected CreateProjectBuilder createBuilder(File projFile, ProjectInfo vi, ProgressHandle handle) {
        CreateProjectBuilder builder = new CreateProjectBuilder(projFile, vi.groupId, vi.artifactId, vi.version).setProgressHandle(handle).setPackaging(this.packaging).setPackageName(vi.packageName);
        return builder;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        if (this.titlename != null) {
            wiz.putProperty("NewProjectWizard_Title", (Object)this.titlename);
        }
        this.index = 0;
        ValidationGroup vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz)});
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        ArrayList<String> steps = new ArrayList<String>();
        this.panels.add((WizardDescriptor.Panel<WizardDescriptor>)new BasicWizardPanel(vg, null, true, false));
        steps.add(Bundle.LBL_CreateProjectStep2());
        for (int i = 0; i < this.panels.size(); ++i) {
            JComponent c = (JComponent)this.panels.get(i).getComponent();
            c.putClientProperty("WizardPanel_contentSelectedIndex", i);
            c.putClientProperty("WizardPanel_contentData", steps.toArray(new String[0]));
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return Bundle.NameFormat(this.index + 1, this.panels.size());
    }

    public boolean hasNext() {
        this.hasNextCalled.set(true);
        return this.hasNextImpl();
    }

    private boolean hasNextImpl() {
        return this.index < this.panels.size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        boolean hnc = this.hasNextCalled.getAndSet(false);
        if (!this.hasNextImpl()) {
            throw new NoSuchElementException(MessageFormat.format("index: {0}, panels: {1}, called has next: {2}", this.index, this.panels.size(), hnc));
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels.get(this.index);
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

