/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.netbeans.modules.java.testrunner.ui.api.NodeOpener;
import org.netbeans.modules.java.testrunner.ui.api.UIJavaUtils;
import org.netbeans.modules.junit.ui.api.JUnitCallstackFrameNode;
import org.netbeans.modules.junit.ui.api.JUnitTestMethodNode;
import org.netbeans.modules.maven.junit.ui.MavenJUnitTestMethodNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public final class MavenJUnitNodeOpener
extends NodeOpener {
    private static final Logger LOG = Logger.getLogger(MavenJUnitNodeOpener.class.getName());
    static final Action[] NO_ACTIONS = new Action[0];

    public void openTestsuite(TestsuiteNode node) {
        FileObject fo;
        Node child;
        Children childrens = node.getChildren();
        if (childrens != null && (child = childrens.getNodeAt(0)) != null && child instanceof MavenJUnitTestMethodNode && (fo = ((MavenJUnitTestMethodNode)child).getTestcaseFileObject()) != null) {
            final long[] line = new long[]{0L};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Trees trees = compilationController.getTrees();
                            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                            List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                            for (Tree tree : typeDecls) {
                                Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo.getName())) continue;
                                long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, tree);
                                line[0] = compilationUnitTree.getLineMap().getLineNumber(pos);
                                break;
                            }
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            UIJavaUtils.openFile((FileObject)fo, (int)((int)line[0]));
        }
    }

    public void openTestMethod(final TestMethodNode node) {
        if (!(node instanceof MavenJUnitTestMethodNode)) {
            return;
        }
        FileObject fo = ((MavenJUnitTestMethodNode)node).getTestcaseFileObject();
        if (fo != null) {
            final FileObject[] fo2open = new FileObject[]{fo};
            final long[] line = new long[]{0L};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fo2open[0]);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Trees trees = compilationController.getTrees();
                            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                            List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                            for (Tree tree : typeDecls) {
                                Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo2open[0].getName())) continue;
                                List<ExecutableElement> methodElements = ElementFilter.methodsIn(element.getEnclosedElements());
                                for (Element element2 : methodElements) {
                                    String name = node.getTestcase().getName();
                                    if (!element2.getSimpleName().contentEquals(name.substring(name.lastIndexOf(".") + 1))) continue;
                                    long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, trees.getTree(element2));
                                    line[0] = compilationUnitTree.getLineMap().getLineNumber(pos);
                                    break;
                                }
                                if (line[0] != 0L) break;
                                UIJavaUtils.searchAllMethods((TestMethodNode)node, (FileObject[])fo2open, (long[])line, (CompilationController)compilationController, (Element)element);
                                break;
                            }
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            UIJavaUtils.openFile((FileObject)fo2open[0], (int)((int)line[0]));
        }
    }

    public void openCallstackFrame(Node node, @NonNull String frameInfo) {
        String[] st;
        if (frameInfo.isEmpty() ? !(node instanceof JUnitTestMethodNode) : !(node instanceof JUnitCallstackFrameNode)) {
            return;
        }
        JUnitTestMethodNode methodNode = (JUnitTestMethodNode)UIJavaUtils.getTestMethodNode((Node)node);
        if (!(methodNode instanceof MavenJUnitTestMethodNode)) {
            return;
        }
        LineConvertors.FileLocator locator = methodNode.getTestcase().getSession().getFileLocator();
        if (locator == null) {
            return;
        }
        FileObject testfo = ((MavenJUnitTestMethodNode)methodNode).getTestcaseFileObject();
        if (testfo == null) {
            StringBuilder stack = new StringBuilder();
            if (methodNode.getTestcase().getTrouble() != null) {
                String[] st2 = methodNode.getTestcase().getTrouble().getStackTrace();
                if (st2 != null) {
                    stack.append("\n");
                    for (String s : st2) {
                        stack.append(s).append("\n");
                    }
                } else {
                    stack.append("<none>");
                }
            } else {
                stack.append("<none>");
            }
            LOG.log(Level.INFO, "#221053: unknown location: {0} classname:{1}, stacktrace:", new Object[]{methodNode.getTestcase().getLocation(), methodNode.getTestcase().getClassName(), stack});
        }
        int[] lineNumStorage = new int[1];
        FileObject file = UIJavaUtils.getFile((String)frameInfo, (int[])lineNumStorage, (LineConvertors.FileLocator)locator);
        if (testfo != null && file == null && methodNode.getTestcase().getTrouble() != null && lineNumStorage[0] == -1 && (st = methodNode.getTestcase().getTrouble().getStackTrace()) != null && st.length > 0) {
            for (int index = st.length - 1; !testfo.equals(file) && index != -1; --index) {
                file = UIJavaUtils.getFile((String)st[index], (int[])lineNumStorage, (LineConvertors.FileLocator)locator);
            }
        }
        if (file == null && lineNumStorage[0] == -1 && node instanceof MavenJUnitTestMethodNode) {
            this.openTestMethod((TestMethodNode)((MavenJUnitTestMethodNode)node));
        }
        UIJavaUtils.openFile((FileObject)file, (int)lineNumStorage[0]);
    }
}

