/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.maven.jaxws.nodes.ServiceNode;
import org.netbeans.modules.maven.jaxws.nodes.WsImportFailedMessage;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class JaxWsClientChildren
extends Children.Keys<WsdlService> {
    WsdlModel wsdlModel;
    private JAXWSLightSupport jaxWsSupport;

    public JaxWsClientChildren(JAXWSLightSupport jaxWsSupport, JaxWsService client) {
        this.jaxWsSupport = jaxWsSupport;
    }

    protected void addNotify() {
        final WsdlModeler wsdlModeler = ((JaxWsClientNode)this.getNode()).getWsdlModeler();
        if (wsdlModeler != null) {
            wsdlModeler.setCatalog(this.jaxWsSupport.getCatalog());
            this.wsdlModel = wsdlModeler.getWsdlModel();
            if (this.wsdlModel == null) {
                wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel model) {
                        JaxWsClientChildren.this.wsdlModel = model;
                        ((JaxWsClientNode)JaxWsClientChildren.this.getNode()).changeIcon();
                        if (model == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new WsImportFailedMessage(false, wsdlModeler.getCreationException()));
                        }
                        JaxWsClientChildren.this.updateKeys();
                    }
                });
            } else {
                this.updateKeys();
            }
        }
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    void updateKeys() {
        List keys = null;
        if (this.wsdlModel != null) {
            keys = this.wsdlModel.getServices();
        }
        this.setKeys(keys == null ? new ArrayList() : keys);
    }

    protected Node[] createNodes(WsdlService key) {
        return new Node[]{new ServiceNode(key)};
    }

    void setWsdlModel(WsdlModel wsdlModel) {
        this.wsdlModel = wsdlModel;
    }
}

