/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.modules.web.jsfapi.spi.JsfReferenceImplementationProvider;
import org.openide.util.Exceptions;

public class MavenJsfReferenceImplementationProvider
implements JsfReferenceImplementationProvider {
    static final Map<JsfVersion, String> JSF_VERSION_MAVEN_COORDINATES_MAPPING;

    public Path artifactPathFor(JsfVersion jsfVersion) {
        String[] mavenCoordinates = JSF_VERSION_MAVEN_COORDINATES_MAPPING.get(jsfVersion).split(":");
        if (mavenCoordinates.length != 3) {
            return null;
        }
        String groupId = mavenCoordinates[0];
        String artifactId = mavenCoordinates[1];
        String version = mavenCoordinates[2];
        MavenEmbedder mavenEmbedder = EmbedderFactory.getOnlineEmbedder();
        ArtifactRepository localRepository = mavenEmbedder.getLocalRepository();
        ArtifactRepository remoteRepository = mavenEmbedder.createRemoteRepository("https://repo.maven.apache.org/maven2", "central");
        Artifact jsfRIArtifact = mavenEmbedder.createArtifact(groupId, artifactId, version, "jar");
        try {
            mavenEmbedder.resolve(jsfRIArtifact, Collections.singletonList(remoteRepository), localRepository);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        return Optional.ofNullable(jsfRIArtifact).map(Artifact::getFile).map(File::toPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(null);
    }

    static {
        EnumMap<JsfVersion, String> map = new EnumMap<JsfVersion, String>(JsfVersion.class);
        map.put(JsfVersion.JSF_1_0, "javax.faces:jsf-impl:1.1_02");
        map.put(JsfVersion.JSF_1_1, "javax.faces:jsf-impl:1.1_02");
        map.put(JsfVersion.JSF_1_2, "javax.faces:jsf-impl:1.2");
        map.put(JsfVersion.JSF_2_0, "com.sun.faces:jsf-impl:2.0.11");
        map.put(JsfVersion.JSF_2_1, "com.sun.faces:jsf-impl:2.1.29");
        map.put(JsfVersion.JSF_2_2, "com.sun.faces:jsf-impl:2.2.20");
        map.put(JsfVersion.JSF_2_3, "org.glassfish:jakarta.faces:2.3.19");
        map.put(JsfVersion.JSF_3_0, "org.glassfish:jakarta.faces:3.0.4");
        map.put(JsfVersion.JSF_4_0, "org.glassfish:jakarta.faces:4.0.2");
        JSF_VERSION_MAVEN_COORDINATES_MAPPING = Collections.unmodifiableMap(map);
    }
}

