/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.utils;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class LoggingUtils {
    private static final String UI_LOGGER_NAME = "org.netbeans.ui";
    private static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics";
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui");
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics");

    private LoggingUtils() {
    }

    public static void logUI(ResourceBundle bundle, String message, Object[] params) {
        LoggingUtils.logUsingResourceBundle(UI_LOGGER, bundle, message, params);
    }

    public static void logUI(ResourceBundle bundle, String message, Object[] params, String moduleName) {
        LoggingUtils.logUsingResourceBundle(LoggingUtils.createUiLogger(moduleName), bundle, message, params);
    }

    public static void logUI(Class srcClass, String message, Object[] params) {
        LoggingUtils.logUsingSourceClass(UI_LOGGER, srcClass, message, params);
    }

    public static void logUI(Class srcClass, String message, Object[] params, String moduleName) {
        LoggingUtils.logUsingSourceClass(LoggingUtils.createUiLogger(moduleName), srcClass, message, params);
    }

    public static void logUsage(ResourceBundle bundle, String message, Object[] params) {
        LoggingUtils.logUsingResourceBundle(USG_LOGGER, bundle, message, params);
    }

    public static void logUsage(ResourceBundle bundle, String message, Object[] params, String moduleName) {
        LoggingUtils.logUsingResourceBundle(LoggingUtils.createUsageLogger(moduleName), bundle, message, params);
    }

    public static void logUsage(Class srcClass, String message, Object[] params) {
        LoggingUtils.logUsingSourceClass(USG_LOGGER, srcClass, message, params);
    }

    public static void logUsage(Class srcClass, String message, Object[] params, String moduleName) {
        LoggingUtils.logUsingSourceClass(LoggingUtils.createUsageLogger(moduleName), srcClass, message, params);
    }

    private static void logUsingSourceClass(Logger logger, Class srcClass, String message, Object[] params) {
        LogRecord logRecord = LoggingUtils.createLogRecord(logger, message, params);
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        if (srcClass != null && srcClass.getPackage() != null) {
            logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        }
        logger.log(logRecord);
    }

    private static void logUsingResourceBundle(Logger logger, ResourceBundle bundle, String message, Object[] params) {
        Parameters.notNull((CharSequence)"bundle", (Object)bundle);
        LogRecord logRecord = LoggingUtils.createLogRecord(logger, message, params);
        logRecord.setResourceBundle(bundle);
        logger.log(logRecord);
    }

    static Logger createUiLogger(String moduleName) {
        if (moduleName != null && !"".equals(moduleName.trim())) {
            return Logger.getLogger("org.netbeans.ui." + moduleName);
        }
        return UI_LOGGER;
    }

    static Logger createUsageLogger(String moduleName) {
        if (moduleName != null && !"".equals(moduleName.trim())) {
            return Logger.getLogger("org.netbeans.ui.metrics." + moduleName);
        }
        return USG_LOGGER;
    }

    private static LogRecord createLogRecord(Logger logger, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(logger.getName());
        if (params != null) {
            logRecord.setParameters(params);
        }
        return logRecord;
    }
}

