/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.context.IndexingContext;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.maven.indexer.Bundle;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.openide.util.Cancellable;

public class RepositoryIndexerListener
implements ArtifactScanningListener,
Cancellable {
    private final IndexingContext indexingContext;
    private int count;
    private ProgressHandle handle;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private final RepositoryInfo ri;
    private final Set<File> expectedDirs = new HashSet<File>();
    private final Set<File> encounteredDirs = new HashSet<File>();

    public RepositoryIndexerListener(IndexingContext indexingContext) {
        this.indexingContext = indexingContext;
        this.ri = RepositoryPreferences.getInstance().getRepositoryInfoById(indexingContext.getId());
        Cancellation.register(this);
    }

    public void scanningStarted(IndexingContext ctx) {
        if (this.handle != null) {
            this.handle.finish();
        }
        this.expectedDirs.clear();
        this.encounteredDirs.clear();
        this.handle = ProgressHandle.createHandle((String)Bundle.LBL_indexing_repo(this.ri != null ? this.ri.getName() : this.indexingContext.getId()), (Cancellable)this);
        this.handle.start();
        this.handle.progress(Bundle.LBL_findIndexableDirs());
        this.findIndexableDirs(ctx.getRepository());
        this.handle.switchToDeterminate(this.expectedDirs.size());
    }

    private void findIndexableDirs(File d) {
        if (d == null || d.getName().startsWith(".")) {
            return;
        }
        File[] kids = d.listFiles();
        if (kids == null) {
            return;
        }
        boolean hasFiles = false;
        boolean hasDirs = false;
        for (File f : kids) {
            if (f.isFile() && !f.getName().matches("maven-metadata.*[.]xml")) {
                hasFiles = true;
            }
            if (!f.isDirectory()) continue;
            hasDirs = true;
            this.findIndexableDirs(f);
        }
        if (hasFiles && !hasDirs) {
            this.expectedDirs.add(d);
        }
    }

    public boolean cancel() {
        return this.canceled.compareAndSet(false, true);
    }

    public void artifactDiscovered(ArtifactContext ac) {
        if (this.canceled.get()) {
            throw new Cancellation();
        }
        ++this.count;
        if (this.handle != null) {
            File d;
            String label = ac.getArtifactInfo().getGroupId() + ":" + ac.getArtifactInfo().getArtifactId() + ":" + ac.getArtifactInfo().getVersion();
            File art = ac.getArtifact();
            if (art == null) {
                art = ac.getPom();
            }
            if (art != null && this.expectedDirs.contains(d = art.getParentFile())) {
                this.encounteredDirs.add(d);
            }
            this.handle.progress(label, this.encounteredDirs.size());
        }
    }

    public void artifactError(ArtifactContext ac, Exception e) {
        if (this.canceled.get()) {
            throw new Cancellation();
        }
    }

    public void scanningFinished(IndexingContext ctx, ScanningResult result) {
    }

    void close() {
        if (this.handle != null) {
            this.handle.finish();
        }
    }
}

