/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipError;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.index.ArtifactAvailability;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.DefaultScannerListener;
import org.apache.maven.index.Field;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.IteratorResultSet;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.StringSearchExpression;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.ArtifactDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.Bundle;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.ClassDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.CustomArtifactContextProducer;
import org.netbeans.modules.maven.indexer.FastScanner;
import org.netbeans.modules.maven.indexer.NotifyingIndexCreator;
import org.netbeans.modules.maven.indexer.RemoteIndexTransferListener;
import org.netbeans.modules.maven.indexer.RepositoryIndexerListener;
import org.netbeans.modules.maven.indexer.ResultImpl;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassUsageQuery;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexQueryProvider;
import org.netbeans.modules.maven.indexer.spi.ResultImplementation;
import org.netbeans.modules.maven.indexer.spi.impl.IndexingNotificationProvider;
import org.netbeans.modules.maven.indexer.spi.impl.Redo;
import org.netbeans.modules.maven.indexer.spi.impl.RepositoryIndexerImplementation;
import org.openide.modules.Places;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;

public class NexusRepositoryIndexerImpl
implements RepositoryIndexerImplementation,
RepositoryIndexQueryProvider,
BaseQueries,
ChecksumQueries,
ArchetypeQueries,
DependencyInfoQueries,
ClassesQuery,
ClassUsageQuery,
GenericFindQuery,
ContextLoadedQuery {
    private static final Logger LOGGER = Logger.getLogger(NexusRepositoryIndexerImpl.class.getName());
    private PlexusContainer embedder;
    private Indexer indexer;
    private Scanner scanner;
    private SearchEngine searcher;
    private IndexUpdater remoteIndexUpdater;
    private ArtifactContextProducer contextProducer;
    private final Map<String, IndexingContext> indexingContexts = new ConcurrentHashMap<String, IndexingContext>();
    private boolean inited = false;
    private static final HashMap<String, Mutex> repoMutexMap;
    private static final Set<Mutex> indexingMutexes;
    private static final RequestProcessor RP;
    static final int MAX_RESULT_COUNT = 1024;
    static final int NO_CAP_RESULT_COUNT = -1;

    @Override
    public boolean handlesRepository(RepositoryInfo repo) {
        return true;
    }

    @Override
    public BaseQueries getBaseQueries() {
        return this;
    }

    @Override
    public ChecksumQueries getChecksumQueries() {
        return this;
    }

    @Override
    public ArchetypeQueries getArchetypeQueries() {
        return this;
    }

    @Override
    public DependencyInfoQueries getDependencyInfoQueries() {
        return this;
    }

    @Override
    public ClassesQuery getClassesQuery() {
        return this;
    }

    @Override
    public ClassUsageQuery getClassUsageQuery() {
        return this;
    }

    @Override
    public GenericFindQuery getGenericFindQuery() {
        return this;
    }

    @Override
    public ContextLoadedQuery getContextLoadedQuery() {
        return this;
    }

    private Mutex getRepoMutex(RepositoryInfo repo) {
        return this.getRepoMutex(repo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mutex getRepoMutex(String repoId) {
        HashMap<String, Mutex> hashMap = repoMutexMap;
        synchronized (hashMap) {
            Mutex m = repoMutexMap.get(repoId);
            if (m == null) {
                m = new Mutex();
                repoMutexMap.put(repoId, m);
            }
            return m;
        }
    }

    private void initIndexer() {
        if (!this.inited) {
            try {
                DefaultContainerConfiguration config = new DefaultContainerConfiguration();
                ClassLoader indexerLoader = NexusRepositoryIndexerImpl.class.getClassLoader();
                ClassWorld classWorld = new ClassWorld();
                ClassRealm plexusRealm = classWorld.newRealm("plexus.core", EmbedderFactory.class.getClassLoader());
                plexusRealm.importFrom(indexerLoader, "META-INF/sisu");
                plexusRealm.importFrom(indexerLoader, "org.apache.maven.index");
                plexusRealm.importFrom(indexerLoader, "org.netbeans.modules.maven.indexer");
                config.setClassWorld(classWorld);
                config.setClassPathScanning("index");
                this.embedder = new DefaultPlexusContainer((ContainerConfiguration)config);
                ComponentDescriptor desc = new ComponentDescriptor();
                desc.setRoleClass(ArtifactContextProducer.class);
                desc.setImplementationClass(CustomArtifactContextProducer.class);
                ComponentRequirement req = new ComponentRequirement();
                req.setFieldName("mapper");
                req.setRole(ArtifactPackagingMapper.class.getName());
                desc.addRequirement(req);
                this.embedder.addComponentDescriptor(desc);
                this.indexer = (Indexer)this.embedder.lookup(Indexer.class);
                this.searcher = (SearchEngine)this.embedder.lookup(SearchEngine.class);
                this.remoteIndexUpdater = (IndexUpdater)this.embedder.lookup(IndexUpdater.class);
                this.contextProducer = (ArtifactContextProducer)this.embedder.lookup(ArtifactContextProducer.class);
                this.scanner = new FastScanner(this.contextProducer);
                this.inited = true;
            }
            catch (Exception x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    public Map<String, IndexingContext> getIndexingContexts() {
        return Collections.unmodifiableMap(this.indexingContexts);
    }

    public IndexingContext addIndexingContextForced(String id, String repositoryId, File repository, File indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexers) throws IOException {
        IndexingContext context = this.indexer.createIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, true, true, indexers);
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    public void removeIndexingContext(IndexingContext context, boolean deleteFiles) throws IOException {
        if (this.indexingContexts.containsKey(context.getId())) {
            this.indexingContexts.remove(context.getId());
            this.indexer.closeIndexingContext(context, deleteFiles);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean loadIndexingContext2(RepositoryInfo info) throws IOException {
        block20: {
            index = false;
            if (!NexusRepositoryIndexerImpl.$assertionsDisabled && !this.getRepoMutex(info).isWriteAccess()) {
                throw new AssertionError();
            }
            this.initIndexer();
            context = this.getIndexingContexts().get(info.getId());
            indexUpdateUrl = info.getIndexUpdateUrl();
            if (context == null) ** GOTO lbl21
            contexturl = context.getIndexUpdateUrl();
            contextfile = context.getRepository();
            v0 = repofile = info.getRepositoryPath() != null ? new File(info.getRepositoryPath()) : null;
            if (BaseUtilities.compareObjects((Object)contexturl, (Object)indexUpdateUrl)) break block20;
            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Remote context changed: {0}, unload/load", info.getId());
            this.unloadIndexingContext(info.getId());
            ** GOTO lbl21
        }
        if (BaseUtilities.compareObjects((Object)contextfile, (Object)repofile)) {
            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINER, "Skipping Context: {0}, already loaded.", info.getId());
        } else {
            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Local context changed: {0}, unload/load", info.getId());
            this.unloadIndexingContext(info.getId());
lbl21:
            // 3 sources

            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Loading Context: {0}", info.getId());
            loc = new File(this.getDefaultIndexLocation(), info.getId());
            creators = new ArrayList<Object>();
            try {
                for (IndexCreator creator : this.embedder.lookupList(IndexCreator.class)) {
                    if ("osgi-metadatas".equals(creator.getId())) continue;
                    creators.add(creator);
                }
            }
            catch (ComponentLookupException x) {
                throw new IOException(x);
            }
            if (info.isLocal()) {
                creators.add((Object)new ArtifactDependencyIndexCreator());
                creators.add((Object)new ClassDependencyIndexCreator());
            } else {
                creators.add((Object)new NotifyingIndexCreator());
            }
            try {
                this.addIndexingContextForced(info.getId(), info.getId(), info.isLocal() != false ? new File(info.getRepositoryPath()) : null, loc, info.isRemoteDownloadable() != false ? info.getRepositoryUrl() : null, (String)(info.isRemoteDownloadable() != false ? indexUpdateUrl : null), creators);
                NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "using index creators: {0}", creators);
            }
            catch (IOException ex) {
                NexusRepositoryIndexerImpl.LOGGER.log(Level.INFO, "Found a broken index at " + loc + " with loaded contexts " + this.getIndexingContexts().keySet(), ex);
            }
        }
        currents = new HashSet<String>();
        for (Object info2 : RepositoryPreferences.getInstance().getRepositoryInfos()) {
            currents.add(info2.getId());
        }
        toRemove = new HashSet<String>(this.getIndexingContexts().keySet());
        toRemove.removeAll(currents);
        if (!toRemove.isEmpty()) {
            for (final String repo : toRemove) {
                try {
                    this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            NexusRepositoryIndexerImpl.this.unloadIndexingContext(repo);
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        loc = new File(this.getDefaultIndexLocation(), info.getId());
        try {
            if (!loc.exists() || !new File(loc, "timestamp").exists()) {
                index = true;
                NexusRepositoryIndexerImpl.LOGGER.log(Level.FINER, "Index Not Available: {0} at: {1}", new Object[]{info.getId(), loc.getAbsolutePath()});
            } else if (!DirectoryReader.indexExists((Directory)new SimpleFSDirectory(loc.toPath()))) {
                index = true;
                NexusRepositoryIndexerImpl.LOGGER.log(Level.FINER, "Index Not Available: {0} at: {1}", new Object[]{info.getId(), loc.getAbsolutePath()});
            }
        }
        catch (IOException ex) {
            index = true;
            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINER, "Index Not Available: " + info.getId() + " at: " + loc.getAbsolutePath(), ex);
        }
        return index;
    }

    @CheckForNull
    private IteratorSearchResponse repeatedPagedSearch(Query q, List<IndexingContext> contexts, int count) throws IOException {
        BooleanClause[] c;
        IteratorSearchRequest isr = new IteratorSearchRequest(q, contexts, (ArtifactInfoFilter)new NoJavadocSourceFilter());
        if (count > 0) {
            isr.setCount(count);
        }
        int MAX_MAX_CLAUSE = 2048;
        if (q instanceof BooleanQuery && (c = ((BooleanQuery)q).getClauses()).length == 1) {
            Query q1 = c[0].getQuery();
            if (q1 instanceof PrefixQuery && "u".equals(((PrefixQuery)q1).getPrefix().field())) {
                MAX_MAX_CLAUSE = 65536;
            } else if (q1 instanceof TermQuery && "p".equals(((TermQuery)q1).getTerm().field())) {
                MAX_MAX_CLAUSE = 65536;
            }
        }
        int oldMax = BooleanQuery.getMaxClauseCount();
        try {
            int max = oldMax;
            while (true) {
                try {
                    BooleanQuery.setMaxClauseCount((int)max);
                    IteratorSearchResponse response = this.searcher.searchIteratorPaged(isr, contexts);
                    LOGGER.log(Level.FINE, "passed on {0} clauses processing {1} with {2} hits", new Object[]{max, q, response.getTotalHitsCount()});
                    IteratorSearchResponse iteratorSearchResponse = response;
                    return iteratorSearchResponse;
                }
                catch (BooleanQuery.TooManyClauses exc) {
                    block13: {
                        LOGGER.log(Level.FINE, "TooManyClauses on {0} clauses processing {1}", new Object[]{max, q});
                        if ((max *= 2) <= MAX_MAX_CLAUSE) break block13;
                        LOGGER.log(Level.WARNING, "Encountered more than {0} clauses processing {1}", new Object[]{MAX_MAX_CLAUSE, q});
                        IteratorSearchResponse iteratorSearchResponse = null;
                        BooleanQuery.setMaxClauseCount((int)oldMax);
                        return iteratorSearchResponse;
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            BooleanQuery.setMaxClauseCount((int)oldMax);
        }
    }

    private void unloadIndexingContext(String repo) throws IOException {
        assert (this.getRepoMutex(repo).isWriteAccess());
        LOGGER.log(Level.FINE, "Unloading Context: {0}", repo);
        IndexingContext ic = this.getIndexingContexts().get(repo);
        if (ic != null) {
            this.removeIndexingContext(ic, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void indexLoadedRepo(RepositoryInfo repo, boolean updateLocal) throws IOException {
        Object indexingContext;
        long t;
        boolean fetchFailed;
        Mutex mutex;
        block49: {
            RemoteIndexTransferListener listener;
            block48: {
                mutex = this.getRepoMutex(repo);
                assert (mutex.isWriteAccess());
                Set<Mutex> set = indexingMutexes;
                synchronized (set) {
                    indexingMutexes.add(mutex);
                }
                fetchFailed = false;
                t = System.currentTimeMillis();
                listener = null;
                indexingContext = this.getIndexingContexts().get(repo.getId());
                if (indexingContext != null) break block48;
                LOGGER.log(Level.WARNING, "Indexing context could not be found: {0}", repo.getId());
                if (NexusRepositoryIndexerImpl.isDiag()) {
                    LOGGER.log(Level.INFO, "Indexing of {0} took {1} millis.", new Object[]{repo.getId(), System.currentTimeMillis() - t});
                }
                Set<Mutex> set2 = indexingMutexes;
                synchronized (set2) {
                    indexingMutexes.remove(mutex);
                }
                if (fetchFailed) return;
                RepositoryPreferences.setLastIndexUpdate(repo.getId(), new Date());
                this.fireChange(repo, () -> repo.fireIndexChange());
                return;
            }
            try {
                if (repo.isRemoteDownloadable()) {
                    LOGGER.log(Level.FINE, "Indexing Remote Repository: {0}", repo.getId());
                    listener = new RemoteIndexTransferListener(repo);
                    try {
                        Wagon wagon;
                        String protocol = URI.create(indexingContext.getIndexUpdateUrl()).getScheme();
                        SettingsDecryptionResult settings = ((SettingsDecrypter)this.embedder.lookup(SettingsDecrypter.class)).decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(EmbedderFactory.getOnlineEmbedder().getSettings()));
                        AuthenticationInfo wagonAuth = null;
                        for (Object server : settings.getServers()) {
                            if (!repo.getId().equals(server.getId())) continue;
                            wagonAuth = new AuthenticationInfo();
                            wagonAuth.setUserName(server.getUsername());
                            wagonAuth.setPassword(server.getPassword());
                            wagonAuth.setPassphrase(server.getPassphrase());
                            wagonAuth.setPrivateKey(server.getPrivateKey());
                            break;
                        }
                        ProxyInfo wagonProxy = null;
                        for (Proxy proxy : settings.getProxies()) {
                            if (!proxy.isActive()) continue;
                            wagonProxy = new ProxyInfo();
                            wagonProxy.setHost(proxy.getHost());
                            wagonProxy.setPort(proxy.getPort());
                            wagonProxy.setNonProxyHosts(proxy.getNonProxyHosts());
                            wagonProxy.setUserName(proxy.getUsername());
                            wagonProxy.setPassword(proxy.getPassword());
                            wagonProxy.setType(protocol);
                            break;
                        }
                        if ((wagon = (Wagon)this.embedder.lookup(Wagon.class, protocol)) instanceof HttpWagon) {
                            HttpWagon httpwagon = (HttpWagon)wagon;
                            Properties p = new Properties();
                            p.setProperty("User-Agent", "netBeans/" + System.getProperty("netbeans.buildnumber"));
                            httpwagon.setHttpHeaders(p);
                        }
                        WagonHelper.WagonFetcher fetcher = this.createFetcher(wagon, listener, wagonAuth, wagonProxy);
                        listener.setFetcher((ResourceFetcher)fetcher);
                        IndexUpdateRequest iur = new IndexUpdateRequest(indexingContext, (ResourceFetcher)fetcher);
                        NotifyingIndexCreator nic = null;
                        for (IndexCreator ic : indexingContext.getIndexCreators()) {
                            if (!(ic instanceof NotifyingIndexCreator)) continue;
                            nic = (NotifyingIndexCreator)ic;
                            break;
                        }
                        if (nic != null) {
                            nic.start(listener);
                        }
                        try {
                            this.remoteIndexUpdater.fetchAndUpdateIndex(iur);
                            break block49;
                        }
                        catch (IllegalArgumentException ex) {
                            fetchFailed = true;
                            throw new IOException("Failed to load maven-index for: " + indexingContext.getRepositoryUrl(), ex);
                        }
                        catch (IOException ex) {
                            fetchFailed = true;
                            throw ex;
                        }
                        finally {
                            if (nic != null) {
                                nic.end();
                            }
                        }
                    }
                    finally {
                        listener.close();
                    }
                }
                LOGGER.log(Level.FINE, "Indexing Local Repository: {0}", repo.getId());
                if (!indexingContext.getRepository().exists()) {
                    LOGGER.log(Level.FINE, "Local repository at {0} doesn't exist, no scan.", indexingContext.getRepository());
                    break block49;
                }
                try (RepositoryIndexerListener repoListener = new RepositoryIndexerListener((IndexingContext)indexingContext);){
                    this.scan((IndexingContext)indexingContext, null, repoListener, updateLocal);
                }
            }
            catch (IOException e222222) {
                if (e222222.getCause() instanceof ResourceDoesNotExistException) {
                    this.fireChange(repo, () -> repo.fireNoIndex());
                }
                File tmpFolder = Places.getCacheDirectory();
                String noSpaceLeftMsg = null;
                if (e222222.getMessage().contains("No space left on device")) {
                    noSpaceLeftMsg = Bundle.MSG_NoSpace(tmpFolder.getAbsolutePath(), repo.getName());
                }
                long downloaded = listener != null ? listener.getUnits() * 1024L : -1L;
                long usableSpace = -1L;
                try {
                    FileStore store = Files.getFileStore(tmpFolder.toPath());
                    usableSpace = store.getUsableSpace();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                LOGGER.log(Level.INFO, "Downloaded maven index file has size {0} (zipped). The usable space in {1} is {2}.", new Object[]{downloaded, tmpFolder, usableSpace});
                if (noSpaceLeftMsg == null && downloaded > -1L && downloaded * 15L > usableSpace) {
                    noSpaceLeftMsg = Bundle.MSG_SeemsNoSpace(tmpFolder.getAbsolutePath(), repo.getName());
                }
                if (noSpaceLeftMsg == null) throw e222222;
                LOGGER.log(Level.INFO, null, e222222);
                IndexingNotificationProvider np = (IndexingNotificationProvider)Lookup.getDefault().lookup(IndexingNotificationProvider.class);
                if (np == null) throw e222222;
                np.notifyError(noSpaceLeftMsg);
                this.unloadIndexingContext(repo.getId());
                {
                    catch (Throwable throwable) {
                        if (NexusRepositoryIndexerImpl.isDiag()) {
                            LOGGER.log(Level.INFO, "Indexing of {0} took {1} millis.", new Object[]{repo.getId(), System.currentTimeMillis() - t});
                        }
                        Set<Mutex> set = indexingMutexes;
                        synchronized (set) {
                            indexingMutexes.remove(mutex);
                        }
                        if (fetchFailed) throw throwable;
                        RepositoryPreferences.setLastIndexUpdate(repo.getId(), new Date());
                        this.fireChange(repo, () -> repo.fireIndexChange());
                        throw throwable;
                    }
                }
                if (NexusRepositoryIndexerImpl.isDiag()) {
                    LOGGER.log(Level.INFO, "Indexing of {0} took {1} millis.", new Object[]{repo.getId(), System.currentTimeMillis() - t});
                }
                Set<Mutex> e222222 = indexingMutexes;
                synchronized (e222222) {
                    indexingMutexes.remove(mutex);
                }
                if (fetchFailed) return;
                RepositoryPreferences.setLastIndexUpdate(repo.getId(), new Date());
                this.fireChange(repo, () -> repo.fireIndexChange());
                return;
                catch (Cancellation x) {
                    throw new IOException("canceled indexing", x);
                    catch (ComponentLookupException x2) {
                        throw new IOException("could not find protocol handler for " + repo.getRepositoryUrl(), x2);
                    }
                }
            }
        }
        if (NexusRepositoryIndexerImpl.isDiag()) {
            LOGGER.log(Level.INFO, "Indexing of {0} took {1} millis.", new Object[]{repo.getId(), System.currentTimeMillis() - t});
        }
        indexingContext = indexingMutexes;
        synchronized (indexingContext) {
            indexingMutexes.remove(mutex);
        }
        if (fetchFailed) return;
        RepositoryPreferences.setLastIndexUpdate(repo.getId(), new Date());
        this.fireChange(repo, () -> repo.fireIndexChange());
        return;
    }

    private static boolean isDiag() {
        return Boolean.getBoolean("maven.indexing.diag");
    }

    private void spawnIndexLoadedRepo(final RepositoryInfo repo) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                NexusRepositoryIndexerImpl.this.getRepoMutex(repo).writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        try {
                            NexusRepositoryIndexerImpl.this.indexLoadedRepo(repo, true);
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.INFO, "could not (re-)index " + repo.getId(), ex);
                        }
                        return null;
                    }
                });
            }
        });
    }

    @Override
    public void indexRepo(final RepositoryInfo repo) {
        LOGGER.log(Level.FINER, "Indexing Context: {0}", repo);
        try {
            RemoteIndexTransferListener.addToActive(Thread.currentThread());
            this.getRepoMutex(repo).writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    try {
                        NexusRepositoryIndexerImpl.this.initIndexer();
                        assert (NexusRepositoryIndexerImpl.this.indexer != null);
                        boolean noIndexExists = NexusRepositoryIndexerImpl.this.loadIndexingContext2(repo);
                        NexusRepositoryIndexerImpl.this.indexLoadedRepo(repo, !noIndexExists);
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.INFO, "could not (re-)index " + repo.getId(), x);
                    }
                    return null;
                }
            });
        }
        finally {
            RemoteIndexTransferListener.removeFromActive(Thread.currentThread());
        }
    }

    public void shutdownAll() {
        LOGGER.fine("Shutting Down All Contexts");
        try {
            if (this.inited) {
                for (IndexingContext ic : this.getIndexingContexts().values()) {
                    LOGGER.log(Level.FINER, "Shutting Down: {0}", ic.getId());
                    this.removeIndexingContext(ic, false);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void scan(IndexingContext context, String fromPath, ArtifactScanningListener listener, boolean update) throws IOException {
        File repositoryDirectory = context.getRepository();
        if (repositoryDirectory == null) {
            return;
        }
        if (!repositoryDirectory.exists()) {
            throw new IOException("Repository directory " + repositoryDirectory + " does not exist");
        }
        File tmpDir = new File(Places.getCacheDirectory(), "tmp-" + context.getRepositoryId());
        if (!tmpDir.mkdirs()) {
            throw new IOException("Cannot create temporary directory: " + tmpDir);
        }
        File tmpFile = new File(tmpDir, context.getId() + "-tmp");
        DefaultIndexingContext tmpContext = null;
        try {
            FSDirectory directory = FSDirectory.open((Path)tmpDir.toPath());
            if (update) {
                IndexUtils.copyDirectory((Directory)context.getIndexDirectory(), (Directory)directory);
            }
            tmpContext = new DefaultIndexingContext(context.getId() + "-tmp", context.getRepositoryId(), context.getRepository(), (Directory)directory, context.getRepositoryUrl(), context.getIndexUpdateUrl(), context.getIndexCreators(), true);
            this.scanner.scan(new ScanningRequest((IndexingContext)tmpContext, (ArtifactScanningListener)new DefaultScannerListener((IndexingContext)tmpContext, (IndexerEngine)this.embedder.lookup(IndexerEngine.class), update, listener), fromPath));
            tmpContext.updateTimestamp(true);
            context.replace(tmpContext.getIndexDirectory());
        }
        catch (Exception ex) {
            throw new IOException("Error scanning context " + context.getId() + ": " + ex, ex);
        }
        finally {
            if (tmpContext != null) {
                tmpContext.close(true);
            }
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            FileUtils.deleteDirectory((File)tmpDir);
        }
    }

    @Override
    public void updateIndexWithArtifacts(final RepositoryInfo repo, final Collection<Artifact> artifacts) {
        if (!RepositoryPreferences.isIndexRepositories()) {
            return;
        }
        final ArtifactRepository repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
        try {
            this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    boolean index = NexusRepositoryIndexerImpl.this.loadIndexingContext2(repo);
                    if (index) {
                        return null;
                    }
                    Map<String, IndexingContext> indexingContexts = NexusRepositoryIndexerImpl.this.getIndexingContexts();
                    IndexingContext indexingContext = indexingContexts.get(repo.getId());
                    if (indexingContext == null) {
                        LOGGER.log(Level.WARNING, "Indexing context could not be created: {0}", repo.getId());
                        return null;
                    }
                    if (!indexingContext.getRepository().exists()) {
                        LOGGER.log(Level.FINE, "Local repository at {0} doesn't exist, no update.", indexingContext.getRepository());
                        return null;
                    }
                    HashSet<ArtifactContext> artifactContexts = new HashSet<ArtifactContext>();
                    for (Artifact artifact : artifacts) {
                        File art;
                        String absolutePath;
                        if (artifact.getFile() != null) {
                            absolutePath = artifact.getFile().getAbsolutePath();
                        } else {
                            if (artifact.getVersion() == null) continue;
                            absolutePath = repo.getRepositoryPath() + File.separator + repository.pathOf(artifact);
                        }
                        if (!(art = new File(absolutePath)).exists()) continue;
                        boolean add = artifact.isSnapshot();
                        if (!artifact.isSnapshot()) {
                            BooleanQuery bq = new BooleanQuery();
                            String id = artifact.getGroupId() + "|" + artifact.getArtifactId() + "|" + artifact.getVersion() + "|" + ArtifactInfo.nvl((String)artifact.getClassifier());
                            bq.add(new BooleanClause((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id)), BooleanClause.Occur.MUST));
                            IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(indexingContext), 1024);
                            boolean bl = add = response == null || response.getTotalHitsCount() == 0;
                            if (response != null) {
                                response.close();
                            }
                        }
                        if (add) {
                            LOGGER.log(Level.FINE, "indexing " + artifact.getId());
                            ArtifactContext ac = NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, art);
                            artifactContexts.add(ac);
                            continue;
                        }
                        LOGGER.log(Level.FINE, "Skipped " + artifact.getId() + " already in index.");
                    }
                    try {
                        NexusRepositoryIndexerImpl.this.indexer.addArtifactsToIndex(artifactContexts, indexingContext);
                    }
                    catch (ZipError err) {
                        LOGGER.log(Level.INFO, "#230581 concurrent access to local repository file. Skipping..", err);
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NullPointerException x) {
            LOGGER.log(Level.INFO, "#201057", x);
        }
        this.fireChange(repo, () -> repo.fireIndexChange());
    }

    @Override
    public void deleteArtifactFromIndex(final RepositoryInfo repo, final Artifact artifact) {
        if (!RepositoryPreferences.isIndexRepositories()) {
            return;
        }
        final ArtifactRepository repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
        try {
            this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    String absolutePath;
                    boolean index = NexusRepositoryIndexerImpl.this.loadIndexingContext2(repo);
                    if (index) {
                        return null;
                    }
                    Map<String, IndexingContext> indexingContexts = NexusRepositoryIndexerImpl.this.getIndexingContexts();
                    IndexingContext indexingContext = indexingContexts.get(repo.getId());
                    if (indexingContext == null) {
                        LOGGER.log(Level.WARNING, "Indexing context could not be created: {0}", repo.getId());
                        return null;
                    }
                    if (!indexingContext.getRepository().exists()) {
                        LOGGER.log(Level.FINE, "Local repository at {0} doesn't exist, no update.", indexingContext.getRepository());
                        return null;
                    }
                    if (artifact.getFile() != null) {
                        absolutePath = artifact.getFile().getAbsolutePath();
                    } else if (artifact.getVersion() != null) {
                        absolutePath = repo.getRepositoryPath() + File.separator + repository.pathOf(artifact);
                    } else {
                        return null;
                    }
                    String extension = artifact.getArtifactHandler().getExtension();
                    String pomPath = absolutePath.substring(0, absolutePath.length() - extension.length());
                    pomPath = pomPath + "pom";
                    File pom = new File(pomPath);
                    if (pom.exists()) {
                        NexusRepositoryIndexerImpl.this.indexer.deleteArtifactsFromIndex(Collections.singleton(NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, pom)), indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChange(repo, () -> repo.fireIndexChange());
    }

    private void fireChange(RepositoryInfo repo, Runnable r) {
        if (this.getRepoMutex(repo).isWriteAccess()) {
            RequestProcessor.getDefault().post(() -> this.fireChange(repo, r));
            return;
        }
        assert (!this.getRepoMutex(repo).isWriteAccess() && !this.getRepoMutex(repo).isReadAccess());
        r.run();
    }

    private File getDefaultIndexLocation() {
        return Places.getCacheSubdirectory((String)"mavenindex");
    }

    @Override
    public ResultImplementation<String> getGroups(List<RepositoryInfo> repos) {
        return this.filterGroupIds("", repos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isIndexing(Mutex mutex) {
        Set<Mutex> set = indexingMutexes;
        synchronized (set) {
            return indexingMutexes.contains(mutex);
        }
    }

    private void iterate(List<RepositoryInfo> repos, final RepoAction action, final RepoAction actionSkip, final boolean skipUnIndexed) {
        if (repos == null) {
            repos = RepositoryPreferences.getInstance().getRepositoryInfos();
        }
        for (final RepositoryInfo repo : repos) {
            Mutex mutex = this.getRepoMutex(repo);
            if (skipUnIndexed && NexusRepositoryIndexerImpl.isIndexing(mutex)) {
                try {
                    actionSkip.run(repo, null);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINER, "could not skip " + repo.getId(), ex);
                }
                continue;
            }
            mutex.writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    try {
                        boolean index = NexusRepositoryIndexerImpl.this.loadIndexingContext2(repo);
                        if (skipUnIndexed && index) {
                            if (!RepositoryPreferences.isIndexRepositories()) {
                                return null;
                            }
                            actionSkip.run(repo, null);
                            NexusRepositoryIndexerImpl.this.spawnIndexLoadedRepo(repo);
                            return null;
                        }
                        IndexingContext context = NexusRepositoryIndexerImpl.this.getIndexingContexts().get(repo.getId());
                        if (context == null) {
                            if (skipUnIndexed) {
                                actionSkip.run(repo, null);
                            }
                            return null;
                        }
                        action.run(repo, context);
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.INFO, "could not process " + repo.getId(), x);
                    }
                    return null;
                }
            });
        }
    }

    private ResultImplementation<String> filterGroupIds(final String prefix, List<RepositoryInfo> repos) {
        Redo<String> redo = new Redo<String>(){

            @Override
            public void run(ResultImpl<String> result) {
                NexusRepositoryIndexerImpl.this.filterGroupIds(prefix, result, result.getSkipped(), false);
            }
        };
        ResultImpl<String> result = new ResultImpl<String>(redo);
        return this.filterGroupIds(prefix, result, repos, true);
    }

    private ResultImplementation<String> filterGroupIds(final String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final TreeSet<String> groups = new TreeSet<String>(result.getResults());
        final ArrayList slowCheck = new ArrayList();
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                Set all = context.getAllGroups();
                if (all.size() > 0) {
                    if (prefix.length() == 0) {
                        groups.addAll(all);
                    } else {
                        for (String gr : all) {
                            if (!gr.startsWith(prefix)) continue;
                            groups.add(gr);
                        }
                    }
                } else {
                    slowCheck.add(repo);
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(groups);
        return result;
    }

    @Override
    public ResultImplementation<String> getGAVsForPackaging(final String packaging, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(new Redo<String>(){

            @Override
            public void run(ResultImpl<String> result) {
                NexusRepositoryIndexerImpl.this.getGAVsForPackaging(packaging, result, result.getSkipped(), false);
            }
        });
        return this.getGAVsForPackaging(packaging, result, repos, true);
    }

    private ResultImplementation<String> getGAVsForPackaging(final String packaging, final ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final ArrayList<String> infos = new ArrayList<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, packaging)), BooleanClause.Occur.MUST));
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), -1);
                if (response != null) {
                    try {
                        for (ArtifactInfo ai : response.iterator()) {
                            String gav = ai.getGroupId() + ":" + ai.getArtifactId() + ":" + ai.getVersion();
                            if (infos.contains(gav)) continue;
                            infos.add(gav);
                        }
                    }
                    finally {
                        result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(response.getTotalHitsCount());
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> getRecords(final String groupId, final String artifactId, final String version, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(new Redo<NBVersionInfo>(){

            @Override
            public void run(ResultImpl<NBVersionInfo> result) {
                NexusRepositoryIndexerImpl.this.getRecords(groupId, artifactId, version, result, result.getSkipped(), false);
            }
        });
        return this.getRecords(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> getRecords(final String groupId, final String artifactId, final String version, final ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                String id = groupId + "|" + artifactId + "|" + version + "|";
                bq.add(new BooleanClause((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id)), BooleanClause.Occur.MUST));
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), 1024);
                if (response != null) {
                    try {
                        for (ArtifactInfo ai : response.iterator()) {
                            infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                        }
                    }
                    finally {
                        result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(response.getTotalHitsCount());
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<String> getArtifacts(final String groupId, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(new Redo<String>(){

            @Override
            public void run(ResultImpl<String> result) {
                NexusRepositoryIndexerImpl.this.getArtifacts(groupId, result, result.getSkipped(), false);
            }
        });
        return this.getArtifacts(groupId, result, repos, true);
    }

    private ResultImplementation<String> getArtifacts(final String groupId, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                String id = groupId + "|";
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), -1);
                if (response != null) {
                    try {
                        for (ArtifactInfo artifactInfo : response.getResults()) {
                            artifacts.add(artifactInfo.getArtifactId());
                        }
                    }
                    finally {
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> getVersions(final String groupId, final String artifactId, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(new Redo<NBVersionInfo>(){

            @Override
            public void run(ResultImpl<NBVersionInfo> result) {
                NexusRepositoryIndexerImpl.this.getVersions(groupId, artifactId, result, result.getSkipped(), false);
            }
        });
        return this.getVersions(groupId, artifactId, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> getVersions(final String groupId, final String artifactId, final ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                String id = groupId + "|" + artifactId + "|";
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), 1024);
                if (response != null) {
                    try {
                        for (ArtifactInfo ai : response.iterator()) {
                            infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                        }
                    }
                    finally {
                        result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(response.getTotalHitsCount());
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findVersionsByClass(final String className, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(new Redo<NBVersionInfo>(){

            @Override
            public void run(ResultImpl<NBVersionInfo> result) {
                NexusRepositoryIndexerImpl.this.findVersionsByClass(className, result, result.getSkipped(), false);
            }
        });
        return this.findVersionsByClass(className, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findVersionsByClass(final String className, final ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                String clsname = className.replace(".", "/");
                while (!clsname.isEmpty() && (clsname.startsWith("*") || clsname.startsWith("?"))) {
                    clsname = clsname.substring(1);
                }
                if (clsname.isEmpty()) {
                    return;
                }
                Query q = NexusRepositoryIndexerImpl.setBooleanRewrite(NexusRepositoryIndexerImpl.this.constructQuery(MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH)));
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch(q, Collections.singletonList(context), 1024);
                if (response != null) {
                    try {
                        infos.addAll(NexusRepositoryIndexerImpl.this.postProcessClasses(response.getResults(), clsname));
                    }
                    finally {
                        result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(response.getTotalHitsCount());
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    private Query constructQuery(Field f, String qs) {
        return this.indexer.constructQuery(f, (SearchExpression)new StringSearchExpression(qs));
    }

    @Override
    public ResultImplementation<RepositoryQueries.ClassUsage> findClassUsages(final String className, @NullAllowed List<RepositoryInfo> repos) {
        ResultImpl<RepositoryQueries.ClassUsage> result = new ResultImpl<RepositoryQueries.ClassUsage>(new Redo<RepositoryQueries.ClassUsage>(){

            @Override
            public void run(ResultImpl<RepositoryQueries.ClassUsage> result) {
                NexusRepositoryIndexerImpl.this.findClassUsages(className, result, result.getSkipped(), false);
            }
        });
        return this.findClassUsages(className, result, repos, true);
    }

    private ResultImplementation<RepositoryQueries.ClassUsage> findClassUsages(final String className, ResultImpl<RepositoryQueries.ClassUsage> result, @NullAllowed List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<RepositoryInfo> localRepos = new ArrayList<RepositoryInfo>();
        if (repos == null) {
            repos = RepositoryPreferences.getInstance().getRepositoryInfos();
        }
        for (RepositoryInfo repo : repos) {
            if (!repo.isLocal()) continue;
            localRepos.add(repo);
        }
        final ArrayList<RepositoryQueries.ClassUsage> results = new ArrayList<RepositoryQueries.ClassUsage>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(localRepos, new RepoAction(){

            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                ClassDependencyIndexCreator.search(className, NexusRepositoryIndexerImpl.this.indexer, Collections.singletonList(context), results);
            }
        }, skipAction, skipUnIndexed);
        Collections.sort(results, new Comparator<RepositoryQueries.ClassUsage>(){

            @Override
            public int compare(RepositoryQueries.ClassUsage r1, RepositoryQueries.ClassUsage r2) {
                return r1.getArtifact().compareTo(r2.getArtifact());
            }
        });
        result.setResults(results);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findDependencyUsage(final String groupId, final String artifactId, final String version, @NullAllowed List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(new Redo<NBVersionInfo>(){

            @Override
            public void run(ResultImpl<NBVersionInfo> result) {
                NexusRepositoryIndexerImpl.this.findDependencyUsage(groupId, artifactId, version, result, result.getSkipped(), false);
            }
        });
        return this.findDependencyUsage(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findDependencyUsage(String groupId, String artifactId, String version, final ResultImpl<NBVersionInfo> result, @NullAllowed List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final Query q = ArtifactDependencyIndexCreator.query(groupId, artifactId, version);
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch(q, Collections.singletonList(context), 1024);
                if (response != null) {
                    try {
                        for (ArtifactInfo ai : response.iterator()) {
                            infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                        }
                    }
                    finally {
                        result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(response.getTotalHitsCount());
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBGroupInfo> findDependencyUsageGroups(final String groupId, final String artifactId, final String version, List<RepositoryInfo> repos) {
        ResultImpl<NBGroupInfo> result = new ResultImpl<NBGroupInfo>(new Redo<NBGroupInfo>(){

            @Override
            public void run(ResultImpl<NBGroupInfo> result) {
                NexusRepositoryIndexerImpl.this.findDependencyUsageGroups(groupId, artifactId, version, result, result.getSkipped(), false);
            }
        });
        return this.findDependencyUsageGroups(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBGroupInfo> findDependencyUsageGroups(String groupId, String artifactId, String version, ResultImpl<NBGroupInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        HashMap<String, NBGroupInfo> groupMap = new HashMap<String, NBGroupInfo>();
        HashMap<String, NBArtifactInfo> artifactMap = new HashMap<String, NBArtifactInfo>();
        ArrayList<NBGroupInfo> groupInfos = new ArrayList<NBGroupInfo>(result.getResults());
        ResultImpl<NBVersionInfo> res = new ResultImpl<NBVersionInfo>(new Redo<NBVersionInfo>(){

            @Override
            public void run(ResultImpl<NBVersionInfo> result) {
            }
        });
        this.findDependencyUsage(groupId, artifactId, version, res, repos, skipUnIndexed);
        NexusRepositoryIndexerImpl.convertToNBGroupInfo(res.getResults(), groupMap, artifactMap, groupInfos);
        if (res.isPartial()) {
            result.addSkipped(res.getSkipped());
        }
        result.setResults(groupInfos);
        return result;
    }

    private static void convertToNBGroupInfo(Collection<NBVersionInfo> artifactInfos, Map<String, NBGroupInfo> groupMap, Map<String, NBArtifactInfo> artifactMap, List<NBGroupInfo> groupInfos) {
        for (NBVersionInfo ai : artifactInfos) {
            NBArtifactInfo ua;
            String groupId = ai.getGroupId();
            String artId = ai.getArtifactId();
            NBGroupInfo ug = groupMap.get(groupId);
            if (ug == null) {
                ug = new NBGroupInfo(groupId);
                groupInfos.add(ug);
                groupMap.put(groupId, ug);
            }
            if ((ua = artifactMap.get(artId)) == null) {
                ua = new NBArtifactInfo(artId);
                ug.addArtifactInfo(ua);
                artifactMap.put(artId, ua);
            }
            ua.addVersionInfo(ai);
        }
    }

    @Override
    public ResultImplementation<NBVersionInfo> findBySHA1(final String sha1, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(new Redo<NBVersionInfo>(){

            @Override
            public void run(ResultImpl<NBVersionInfo> result) {
                NexusRepositoryIndexerImpl.this.findBySHA1(sha1, result, result.getSkipped(), false);
            }
        });
        return this.findBySHA1(sha1, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findBySHA1(final String sha1, final ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite(NexusRepositoryIndexerImpl.this.constructQuery(MAVEN.SHA1, sha1)), BooleanClause.Occur.SHOULD));
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), 1024);
                if (response != null) {
                    try {
                        for (ArtifactInfo ai : response.iterator()) {
                            infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                        }
                    }
                    finally {
                        result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(response.getTotalHitsCount());
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findArchetypes(List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(new Redo<NBVersionInfo>(){

            @Override
            public void run(ResultImpl<NBVersionInfo> result) {
                NexusRepositoryIndexerImpl.this.findArchetypes(result, result.getSkipped(), false);
            }
        });
        return this.findArchetypes(result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findArchetypes(final ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-archetype")), BooleanClause.Occur.MUST));
                FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), -1);
                if (response != null) {
                    try {
                        for (ArtifactInfo ai : response.iterator()) {
                            infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                        }
                    }
                    finally {
                        result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(response.getTotalHitsCount());
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<String> filterPluginArtifactIds(final String groupId, final String prefix, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(new Redo<String>(){

            @Override
            public void run(ResultImpl<String> result) {
                NexusRepositoryIndexerImpl.this.filterPluginArtifactIds(groupId, prefix, result, result.getSkipped(), false);
            }
        });
        return this.filterPluginArtifactIds(groupId, prefix, result, repos, true);
    }

    private ResultImplementation<String> filterPluginArtifactIds(final String groupId, final String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                String id = groupId + "|" + prefix;
                bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST));
                bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                IteratorSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), -1);
                if (response != null) {
                    try {
                        for (ArtifactInfo artifactInfo : response.getResults()) {
                            artifacts.add(artifactInfo.getArtifactId());
                        }
                    }
                    finally {
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<String> filterPluginGroupIds(final String prefix, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(new Redo<String>(){

            @Override
            public void run(ResultImpl<String> result) {
                NexusRepositoryIndexerImpl.this.filterPluginGroupIds(prefix, result, result.getSkipped(), false);
            }
        });
        return this.filterPluginGroupIds(prefix, result, repos, true);
    }

    private ResultImplementation<String> filterPluginGroupIds(final String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                IteratorSearchResponse response;
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST));
                if (prefix.length() > 0) {
                    bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.GROUP_ID, prefix))), BooleanClause.Occur.MUST));
                }
                if ((response = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), -1)) != null) {
                    try {
                        for (ArtifactInfo artifactInfo : response.getResults()) {
                            artifacts.add(artifactInfo.getGroupId());
                        }
                    }
                    finally {
                        response.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> find(final List<QueryField> fields, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(new Redo<NBVersionInfo>(){

            @Override
            public void run(ResultImpl<NBVersionInfo> result) {
                NexusRepositoryIndexerImpl.this.find(fields, result, result.getSkipped(), false);
            }
        });
        return this.find(fields, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> find(final List<QueryField> fields, final ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery bq = new BooleanQuery();
                for (QueryField field : fields) {
                    Object q;
                    BooleanClause.Occur occur;
                    block22: {
                        occur = field.getOccur() == 1 ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
                        String fieldName = NexusRepositoryIndexerImpl.this.toNexusField(field.getField());
                        String one = field.getValue();
                        while (!one.isEmpty() && (one.startsWith("*") || one.startsWith("?"))) {
                            one = one.substring(1);
                        }
                        if (one.isEmpty() || fieldName == null) continue;
                        if (ArtifactInfo.NAMES.equals(fieldName)) {
                            try {
                                String clsname = one.replace(".", "/");
                                q = NexusRepositoryIndexerImpl.this.constructQuery(MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH));
                                break block22;
                            }
                            catch (IllegalArgumentException iae) {
                                String clsname = QueryParser.escape((String)one.replace(".", "/"));
                                try {
                                    q = NexusRepositoryIndexerImpl.this.constructQuery(MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH));
                                    break block22;
                                }
                                catch (IllegalArgumentException iae2) {
                                    continue;
                                }
                            }
                        }
                        if (ArtifactInfo.ARTIFACT_ID.equals(fieldName)) {
                            String aid = one.replaceAll("-", "?").replaceAll("\\.", "?");
                            try {
                                q = NexusRepositoryIndexerImpl.this.constructQuery(MAVEN.ARTIFACT_ID, aid);
                                break block22;
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    q = NexusRepositoryIndexerImpl.this.constructQuery(MAVEN.ARTIFACT_ID, QueryParser.escape((String)aid));
                                    break block22;
                                }
                                catch (IllegalArgumentException iae2) {
                                    continue;
                                }
                            }
                        }
                        if (ArtifactInfo.GROUP_ID.equals(fieldName)) {
                            String gid = one.replaceAll("-", "?").replaceAll("\\.", "?");
                            try {
                                q = NexusRepositoryIndexerImpl.this.constructQuery(MAVEN.GROUP_ID, gid);
                                break block22;
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    q = NexusRepositoryIndexerImpl.this.constructQuery(MAVEN.GROUP_ID, QueryParser.escape((String)gid));
                                    break block22;
                                }
                                catch (IllegalArgumentException iae2) {
                                    continue;
                                }
                            }
                        }
                        q = field.getMatch() == 0 ? new TermQuery(new Term(fieldName, one)) : new PrefixQuery(new Term(fieldName, one));
                    }
                    bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite(q), occur));
                }
                IteratorSearchResponse resp = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((Query)bq, Collections.singletonList(context), 1024);
                if (resp != null) {
                    try {
                        for (ArtifactInfo ai : resp.iterator()) {
                            infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                        }
                    }
                    finally {
                        result.addReturnedResultCount(resp.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(resp.getTotalHitsCount());
                        resp.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    private void doSortIssue226100(List<NBVersionInfo> infos) {
        try {
            Collections.sort(infos);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void doLogError226100(List<NBVersionInfo> infos, Exception ex) throws RuntimeException {
        StringBuilder versions = new StringBuilder();
        for (NBVersionInfo info : infos) {
            versions.append(info.getVersion()).append(",");
        }
        String message = "Issue #226100: Versions compared are:" + versions.toString();
        LOGGER.log(Level.WARNING, message);
        boolean rethrow = false;
        if (!$assertionsDisabled) {
            rethrow = false;
            if (!false) {
                throw new AssertionError();
            }
        }
        if (rethrow) {
            throw new RuntimeException(message, ex);
        }
    }

    @Override
    public List<RepositoryInfo> getLoaded(List<RepositoryInfo> repos) {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>(repos.size());
        for (RepositoryInfo repo : repos) {
            File loc = new File(this.getDefaultIndexLocation(), repo.getId());
            try {
                if (!loc.exists() || !new File(loc, "timestamp").exists() || !DirectoryReader.indexExists((Directory)new SimpleFSDirectory(loc.toPath()))) continue;
                toRet.add(repo);
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINER, "Index Not Available: " + repo.getId() + " at: " + loc.getAbsolutePath(), ex);
            }
        }
        return toRet;
    }

    private String toNexusField(String field) {
        if ("artifactId".equals(field)) {
            return ArtifactInfo.ARTIFACT_ID;
        }
        if ("groupId".equals(field)) {
            return ArtifactInfo.GROUP_ID;
        }
        if ("version".equals(field)) {
            return ArtifactInfo.VERSION;
        }
        if ("classes".equals(field)) {
            return ArtifactInfo.NAMES;
        }
        if ("name".equals(field)) {
            return ArtifactInfo.NAME;
        }
        if ("description".equals(field)) {
            return ArtifactInfo.DESCRIPTION;
        }
        if ("packaging".equals(field)) {
            return ArtifactInfo.PACKAGING;
        }
        return field;
    }

    private Collection<NBVersionInfo> postProcessClasses(IteratorResultSet artifactInfos, String classname) {
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        int patter = 40;
        boolean isPath = classname.contains("/");
        if (isPath) {
            for (ArtifactInfo i : artifactInfos) {
                toRet.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(i));
            }
            return toRet;
        }
        String pattStr = ".*/" + classname + "$.*";
        Pattern patt = Pattern.compile(pattStr, patter);
        ArrayList<ArtifactInfo> altArtifactInfos = new ArrayList<ArtifactInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            Matcher m = patt.matcher(ai.getClassNames());
            if (!m.matches()) continue;
            altArtifactInfos.add(ai);
        }
        for (ArtifactInfo i : altArtifactInfos) {
            toRet.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(i));
        }
        return toRet;
    }

    static List<NBVersionInfo> convertToNBVersionInfo(Collection<ArtifactInfo> artifactInfos) {
        ArrayList<NBVersionInfo> bVersionInfos = new ArrayList<NBVersionInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            NBVersionInfo nbvi = NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai);
            if (nbvi == null) continue;
            bVersionInfos.add(nbvi);
        }
        return bVersionInfos;
    }

    static NBVersionInfo convertToNBVersionInfo(ArtifactInfo ai) {
        if ("javadoc".equals(ai.getClassifier()) || "sources".equals(ai.getClassifier())) {
            return null;
        }
        NBVersionInfo nbvi = new NBVersionInfo(ai.getRepository(), ai.getGroupId(), ai.getArtifactId(), ai.getVersion(), ai.getFileExtension(), ai.getPackaging(), ai.getName(), ai.getDescription(), ai.getClassifier());
        nbvi.setJavadocExists(ai.getJavadocExists() == ArtifactAvailability.PRESENT);
        nbvi.setSourcesExists(ai.getSourcesExists() == ArtifactAvailability.PRESENT);
        nbvi.setSignatureExists(ai.getSignatureExists() == ArtifactAvailability.PRESENT);
        nbvi.setLastModified(ai.getLastModified());
        nbvi.setSize(ai.getSize());
        nbvi.setLuceneScore(ai.getLuceneScore());
        return nbvi;
    }

    private static Query setBooleanRewrite(Query q) {
        if (q instanceof MultiTermQuery) {
            ((MultiTermQuery)q).setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
        } else if (q instanceof BooleanQuery) {
            for (BooleanClause c : ((BooleanQuery)q).getClauses()) {
                NexusRepositoryIndexerImpl.setBooleanRewrite(c.getQuery());
            }
        }
        return q;
    }

    private WagonHelper.WagonFetcher createFetcher(final Wagon wagon, TransferListener listener, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) {
        if (NexusRepositoryIndexerImpl.isDiag()) {
            return new WagonHelper.WagonFetcher(wagon, listener, authenticationInfo, proxyInfo){

                public InputStream retrieve(String name) throws IOException, FileNotFoundException {
                    String id = wagon.getRepository().getId();
                    if (name.contains("properties") && System.getProperty("maven.diag.index.properties." + id) != null) {
                        LOGGER.log(Level.INFO, "maven indexer will use local properties file: {0}", System.getProperty("maven.diag.index.properties." + id));
                        return new FileInputStream(new File(System.getProperty("maven.diag.index.properties." + id)));
                    }
                    if (name.contains(".gz") && System.getProperty("maven.diag.index.gz." + id) != null) {
                        LOGGER.log(Level.INFO, "maven indexer will use gz file: {0}", System.getProperty("maven.diag.index.gz." + id));
                        return new FileInputStream(new File(System.getProperty("maven.diag.index.gz." + id)));
                    }
                    return super.retrieve(name);
                }
            };
        }
        return new WagonHelper.WagonFetcher(wagon, listener, authenticationInfo, proxyInfo);
    }

    static {
        Class<RepositoryQueries> c = RepositoryQueries.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (ClassNotFoundException x) {
            throw new ExceptionInInitializerError(x);
        }
        repoMutexMap = new HashMap(4);
        indexingMutexes = new HashSet<Mutex>();
        RP = new RequestProcessor("indexing", 1);
    }

    private static class NoJavadocSourceFilter
    implements ArtifactInfoFilter {
        private NoJavadocSourceFilter() {
        }

        public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
            return !"javadoc".equals(ai.getClassifier()) && !"sources".equals(ai.getClassifier());
        }
    }

    private static class SkippedAction
    implements RepoAction {
        private final ResultImpl<?> result;

        private SkippedAction(ResultImpl<?> result) {
            this.result = result;
        }

        @Override
        public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
            this.result.addSkipped(repo);
        }
    }

    private static interface RepoAction {
        public void run(RepositoryInfo var1, IndexingContext var2) throws IOException;
    }
}

