/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.errors;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class EnablePreviewMavenProj
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.preview.feature.disabled.plural"));
    private static final String ENABLE_PREVIEW_FLAG = "--enable-preview";

    public Set<String> getCodes() {
        return Collections.unmodifiableSet(ERROR_CODES);
    }

    @NonNull
    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (SourceVersion.latest() != compilationInfo.getSourceVersion()) {
            return Collections.emptyList();
        }
        ResolveMvnFix fix = null;
        FileObject file = compilationInfo.getFileObject();
        if (file != null) {
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            fix = this.isMavenProject(prj) ? new ResolveMvnFix(prj) : null;
        }
        return fix != null ? Collections.singletonList(fix) : Collections.emptyList();
    }

    public String getId() {
        return EnablePreviewMavenProj.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(EnablePreviewMavenProj.class, (String)"FIX_EnablePreviewFeature");
    }

    public String getDescription() {
        return NbBundle.getMessage(EnablePreviewMavenProj.class, (String)"FIX_EnablePreviewFeature");
    }

    public void cancel() {
    }

    private boolean isMavenProject(Project prj) {
        FileObject pom = prj.getProjectDirectory().getFileObject("pom.xml");
        return pom != null && pom.isValid();
    }

    private static class AddMvnCompilerPluginForEnablePreview
    implements ModelOperation<POMModel> {
        private static final String MAVEN_COMPILER_GROUP_ID = "org.apache.maven.plugins";
        private static final String MAVEN_COMPILER_ARTIFACT_ID = "maven-compiler-plugin";
        private static final String COMPILER_ID_PROPERTY = "compilerId";
        private static final String COMPILER_ARG = "compilerArgs";
        private static final String MAVEN_COMPILER_VERSION = "3.3";
        private static final String ARG = "arg";
        private POMComponentFactory factory;

        private AddMvnCompilerPluginForEnablePreview() {
        }

        public void performOperation(POMModel model) {
            Plugin oldPlugin;
            this.factory = model.getFactory();
            org.netbeans.modules.maven.model.pom.Project proj = model.getProject();
            Build build = model.getProject().getBuild();
            if (build == null) {
                build = this.factory.createBuild();
                proj.setBuild(build);
            }
            if ((oldPlugin = this.searchMavenCompilerPlugin(build)) == null) {
                build.addPlugin(this.createMavenCompilerPlugin());
            } else {
                Plugin newPlugin = this.updateMavenCompilerPlugin(oldPlugin);
                build.removePlugin(oldPlugin);
                build.addPlugin(newPlugin);
            }
        }

        private Plugin searchMavenCompilerPlugin(Build build) {
            List plugins = build.getPlugins();
            if (plugins != null) {
                for (Plugin plugin : plugins) {
                    if (!MAVEN_COMPILER_GROUP_ID.equals(plugin.getGroupId()) || !MAVEN_COMPILER_ARTIFACT_ID.equals(plugin.getArtifactId())) continue;
                    return plugin;
                }
            }
            return null;
        }

        private Plugin createMavenCompilerPlugin() {
            Plugin plugin = this.factory.createPlugin();
            plugin.setGroupId(MAVEN_COMPILER_GROUP_ID);
            plugin.setArtifactId(MAVEN_COMPILER_ARTIFACT_ID);
            plugin.setVersion(MAVEN_COMPILER_VERSION);
            plugin.setConfiguration(this.createConfiguration());
            Configuration config = this.factory.createConfiguration();
            POMExtensibilityElement compilerArgs = this.factory.createPOMExtensibilityElement(POMQName.createQName((String)COMPILER_ARG));
            compilerArgs.setChildElementText(COMPILER_ID_PROPERTY, EnablePreviewMavenProj.ENABLE_PREVIEW_FLAG, POMQName.createQName((String)ARG));
            config.addExtensibilityElement(compilerArgs);
            plugin.setConfiguration(config);
            return plugin;
        }

        private Configuration createConfiguration() {
            Configuration configuration = this.factory.createConfiguration();
            return configuration;
        }

        private Plugin updateMavenCompilerPlugin(Plugin oldPlugin) {
            Configuration currenConfig = oldPlugin.getConfiguration();
            Configuration newConfiguration = this.createConfiguration();
            boolean isCompilerArgsElementPresent = false;
            if (currenConfig != null) {
                for (POMExtensibilityElement element : currenConfig.getConfigurationElements()) {
                    POMExtensibilityElement newElement = this.factory.createPOMExtensibilityElement(element.getQName());
                    String elementText = element.getElementText();
                    if (elementText.trim().length() > 0) {
                        newElement.setElementText(element.getElementText());
                    }
                    if (newElement.getQName().getLocalPart().equals(COMPILER_ARG)) {
                        isCompilerArgsElementPresent = true;
                        POMExtensibilityElement compilerArgs = this.factory.createPOMExtensibilityElement(POMQName.createQName((String)COMPILER_ARG));
                        newElement.setChildElementText(COMPILER_ID_PROPERTY, EnablePreviewMavenProj.ENABLE_PREVIEW_FLAG, POMQName.createQName((String)ARG));
                    }
                    for (POMExtensibilityElement childElement : element.getAnyElements()) {
                        POMExtensibilityElement newChildElement = this.factory.createPOMExtensibilityElement(childElement.getQName());
                        newChildElement.setElementText(childElement.getElementText());
                        newElement.addExtensibilityElement(newChildElement);
                    }
                    newConfiguration.addExtensibilityElement(newElement);
                }
                if (!isCompilerArgsElementPresent) {
                    POMExtensibilityElement compilerArgs = this.factory.createPOMExtensibilityElement(POMQName.createQName((String)COMPILER_ARG));
                    compilerArgs.setChildElementText(COMPILER_ID_PROPERTY, EnablePreviewMavenProj.ENABLE_PREVIEW_FLAG, POMQName.createQName((String)ARG));
                    newConfiguration.addExtensibilityElement(compilerArgs);
                }
            }
            Plugin newPlugin = this.factory.createPlugin();
            newPlugin.setGroupId(oldPlugin.getGroupId());
            newPlugin.setArtifactId(oldPlugin.getArtifactId());
            newPlugin.setVersion(oldPlugin.getVersion());
            newPlugin.setConfiguration(newConfiguration);
            return newPlugin;
        }
    }

    private static final class ResolveMvnFix
    implements Fix {
        private final Project prj;

        ResolveMvnFix(@NonNull Project prj) {
            Parameters.notNull((CharSequence)"prj", (Object)prj);
            this.prj = prj;
        }

        public String getText() {
            return NbBundle.getMessage(EnablePreviewMavenProj.class, (String)"FIX_EnablePreviewFeature");
        }

        public ChangeInfo implement() throws Exception {
            try {
                final FileObject pom = this.prj.getProjectDirectory().getFileObject("pom.xml");
                pom.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        ArrayList<AddMvnCompilerPluginForEnablePreview> operations = new ArrayList<AddMvnCompilerPluginForEnablePreview>();
                        operations.add(new AddMvnCompilerPluginForEnablePreview());
                        Utilities.performPOMModelOperations((FileObject)pom, operations);
                    }
                });
            }
            catch (IOException pom) {
                // empty catch block
            }
            ProjectConfiguration cfg = ((ProjectConfigurationProvider)this.prj.getLookup().lookup(ProjectConfigurationProvider.class)).getActiveConfiguration();
            for (String action : new String[]{"run", "debug", "profile"}) {
                NetbeansActionMapping mapp = ModelHandle2.getMapping((String)action, (Project)this.prj, (ProjectConfiguration)cfg);
                Map properties = mapp.getProperties();
                for (Map.Entry entry : properties.entrySet()) {
                    if (!((String)entry.getKey()).equals("exec.args") || ((String)entry.getValue()).contains("--enable-preview ")) continue;
                    properties.put(entry.getKey(), "--enable-preview " + (String)entry.getValue());
                }
                if (mapp == null) continue;
                ModelHandle2.putMapping((NetbeansActionMapping)mapp, (Project)this.prj, (ProjectConfiguration)cfg);
            }
            return null;
        }
    }
}

