/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.groovy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class GroovyReplaceTokenProvider
implements ReplaceTokenProvider,
ActionConvertor {
    private static final String CLASSNAME = "className";
    private static final String CLASSNAME_EXT = "classNameWithExtension";
    private static final String PACK_CLASSNAME = "packageClassName";
    private static final String CLASSPATHSCOPE = "classPathScope";
    private final Project project;

    public GroovyReplaceTokenProvider(Project project) {
        this.project = project;
    }

    public Map<String, String> createReplacements(String action, Lookup lookup) {
        SingleMethod m;
        FileObject fo = (FileObject)lookup.lookup(FileObject.class);
        if (fo == null && (m = (SingleMethod)lookup.lookup(SingleMethod.class)) != null) {
            fo = m.getFile();
        }
        if (this.isGroovyFile(fo)) {
            for (SourceGroup group : ProjectUtils.getSources((Project)this.project).getSourceGroups("groovy")) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                if (relPath == null) continue;
                HashMap<String, String> replaceMap = new HashMap<String, String>();
                replaceMap.put(CLASSNAME_EXT, fo.getNameExt());
                replaceMap.put(CLASSNAME, fo.getName());
                String pack = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo.getParent());
                if (pack != null) {
                    replaceMap.put(PACK_CLASSNAME, (pack + (pack.length() > 0 ? "." : "") + fo.getName()).replace('/', '.'));
                } else {
                    replaceMap.put(PACK_CLASSNAME, fo.getName());
                }
                replaceMap.put(CLASSPATHSCOPE, group.getName().equals("82GroovyTestSourceRoot") ? "test" : "runtime");
                return replaceMap;
            }
        }
        return Collections.emptyMap();
    }

    public String convert(String action, Lookup lookup) {
        FileObject fo;
        if (("run.single".equals(action) || "debug.single".equals(action)) && this.isGroovyFile(fo = (FileObject)lookup.lookup(FileObject.class))) {
            if (this.isInTestFolder(fo)) {
                return null;
            }
            return action + ".main";
        }
        return null;
    }

    private boolean isInTestFolder(FileObject file) {
        return file.getPath().indexOf("/test/groovy") != -1;
    }

    private boolean isGroovyFile(FileObject file) {
        return file != null && "text/x-groovy".equals(file.getMIMEType());
    }
}

