/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.netbeans.modules.maven.embedder.ArtifactFixer;
import org.netbeans.modules.maven.embedder.impl.NbVersionResolver2;
import org.openide.util.Lookup;

public class NbWorkspaceReader
implements WorkspaceReader {
    private final WorkspaceRepository repo = new WorkspaceRepository("ide", this.getClass());
    private final NbVersionResolver2 resolver;
    private final Collection<? extends ArtifactFixer> fixers = Lookup.getDefault().lookupAll(ArtifactFixer.class);
    boolean silence = false;

    public NbWorkspaceReader(NbVersionResolver2 resolver) {
        this.resolver = resolver;
    }

    public WorkspaceRepository getRepository() {
        return this.repo;
    }

    public File findArtifact(Artifact artifact) {
        Artifact a;
        if (this.silence) {
            return null;
        }
        if (!(this.resolver == null || (a = this.resolver.getResolvingArtifact()) == null || Objects.equals(a.getClassifier(), artifact.getClassifier()) && Objects.equals(a.getExtension(), artifact.getExtension()) && Objects.equals(a.getVersion(), artifact.getVersion()))) {
            HashMap<String, String> hashMap = new HashMap<String, String>(artifact.getProperties());
            hashMap.put("nbResolvingArtifact.group", artifact.getGroupId());
            hashMap.put("nbResolvingArtifact.id", artifact.getArtifactId());
            hashMap.put("nbResolvingArtifact.classifier", a.getClassifier());
            hashMap.put("nbResolvingArtifact.extension", a.getExtension());
            artifact = artifact.setProperties(hashMap);
        }
        for (ArtifactFixer artifactFixer : this.fixers) {
            File f = artifactFixer.resolve(artifact);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        Artifact a;
        if (this.silence) {
            return Collections.emptyList();
        }
        if (!(this.resolver == null || (a = this.resolver.getResolvingArtifact()) == null || Objects.equals(a.getClassifier(), artifact.getClassifier()) && Objects.equals(a.getExtension(), artifact.getExtension()) && Objects.equals(a.getVersion(), artifact.getVersion()))) {
            HashMap<String, String> hashMap = new HashMap<String, String>(artifact.getProperties());
            hashMap.put("nbResolvingArtifact.group", artifact.getGroupId());
            hashMap.put("nbResolvingArtifact.id", artifact.getArtifactId());
            hashMap.put("nbResolvingArtifact.classifier", a.getClassifier());
            hashMap.put("nbResolvingArtifact.extension", a.getExtension());
            artifact = artifact.setProperties(hashMap);
        }
        for (ArtifactFixer artifactFixer : this.fixers) {
            File f = artifactFixer.resolve(artifact);
            if (f == null) continue;
            return Collections.singletonList(artifact.getBaseVersion());
        }
        return Collections.emptyList();
    }

    void normal() {
        this.silence = false;
    }

    void silence() {
        this.silence = true;
    }
}

