/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.jruby.util.ByteList;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.PositioningComposerImpl;
import org.jvyamlb.PositioningParser;
import org.jvyamlb.PositioningParserImpl;
import org.jvyamlb.PositioningScanner;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.events.Event;
import org.jvyamlb.exceptions.PositionedComposerException;
import org.jvyamlb.exceptions.PositionedParserException;
import org.jvyamlb.exceptions.PositionedScannerException;
import org.jvyamlb.nodes.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.util.NbBundle;

public class YamlParser
extends Parser {
    private static final Logger LOGGER = Logger.getLogger(YamlParser.class.getName());
    private static final int MAX_LENGTH = 524288;
    private YamlParserResult lastResult;

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void cancel() {
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    private static String asString(CharSequence sequence) {
        if (sequence instanceof String) {
            return (String)sequence;
        }
        return sequence.toString();
    }

    private boolean isTooLarge(String source) {
        return source.length() > 524288;
    }

    private YamlParserResult resultForTooLargeFile(Snapshot snapshot) {
        YamlParserResult result = new YamlParserResult(Collections.emptyList(), this, snapshot, false, null, null);
        DefaultError error = new DefaultError(null, NbBundle.getMessage(YamlParser.class, (String)"TooLarge"), null, snapshot.getSource().getFileObject(), 0, 0, Severity.WARNING);
        result.addError((Error)error);
        return result;
    }

    static String replacePhpFragments(String source) {
        int startReplace = source.indexOf("<?");
        if (startReplace == -1) {
            return source;
        }
        StringBuilder result = new StringBuilder(source);
        while (startReplace > -1) {
            int endReplace = result.indexOf("?>", startReplace);
            if (endReplace > -1) {
                StringBuilder spaces = new StringBuilder(++endReplace - startReplace);
                for (int i = 0; i <= endReplace - startReplace; ++i) {
                    spaces.append(' ');
                }
                result.replace(startReplace, endReplace + 1, spaces.toString());
                startReplace = result.indexOf("<?", endReplace);
                continue;
            }
            startReplace = -1;
        }
        return result.toString();
    }

    static String replaceMustache(String source) {
        int startReplace = source.indexOf("{{");
        if (startReplace == -1) {
            return source;
        }
        StringBuilder result = new StringBuilder(source);
        while (startReplace > -1) {
            int endReplace = result.indexOf("}}", startReplace);
            if (endReplace > -1) {
                StringBuilder spaces = new StringBuilder(++endReplace - startReplace);
                for (int i = 0; i <= endReplace - startReplace; ++i) {
                    spaces.append(' ');
                }
                result.replace(startReplace, endReplace + 1, spaces.toString());
                startReplace = result.indexOf("{{", endReplace);
                continue;
            }
            startReplace = -1;
        }
        return result.toString();
    }

    private static String replaceCommonSpecialCharacters(String source) {
        source = source.replace('@', '_');
        source = source.replace('?', '_');
        source = source.replaceAll("!(?!(omap|!omap))", "_");
        return source;
    }

    private static String replaceInlineRegexBrackets(String source) {
        Pattern p = Pattern.compile("\\^/.*?\\[.*?\\].*?,");
        Matcher m = p.matcher(source);
        while (m.find()) {
            String found = m.group();
            String replaced = found.replace('[', '_').replace(']', '_');
            source = source.replace(found, replaced);
        }
        return source;
    }

    YamlParserResult parse(String source, final Snapshot snapshot) {
        source = YamlParser.replacePhpFragments(source);
        source = YamlParser.replaceMustache(source);
        source = YamlParser.replaceCommonSpecialCharacters(source);
        source = YamlParser.replaceInlineRegexBrackets(source);
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            Node node;
            ByteList byteList;
            if (this.isTooLarge(source)) {
                return this.resultForTooLargeFile(snapshot);
            }
            int[] byteToUtf8 = null;
            int[] utf8toByte = null;
            byte[] bytes = source.getBytes("UTF-8");
            if (bytes.length == source.length()) {
                byteList = new ByteList(bytes);
            } else {
                int i;
                ByteArrayOutputStream out = new ByteArrayOutputStream(2 * source.length());
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                utf8toByte = new int[source.length()];
                int currentPos = 0;
                int n = source.length();
                for (i = 0; i < n; ++i) {
                    writer.write(source.charAt(i));
                    writer.flush();
                    utf8toByte[i] = currentPos;
                    currentPos = out.size();
                }
                if (currentPos > 0) {
                    byteToUtf8 = new int[currentPos];
                    n = utf8toByte.length;
                    for (i = 0; i < n; ++i) {
                        byteToUtf8[utf8toByte[i]] = i;
                    }
                    int last = 0;
                    int n2 = byteToUtf8.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int p = byteToUtf8[i2];
                        if (p == 0) {
                            byteToUtf8[i2] = last;
                            continue;
                        }
                        last = p;
                    }
                } else {
                    byteToUtf8 = new int[]{};
                }
                byteList = new ByteList(out.toByteArray());
            }
            final ArrayList errors = new ArrayList();
            PositioningScannerImpl scanner = new PositioningScannerImpl(byteList){

                protected void scannerException(String when, String what, String note) {
                    try {
                        super.scannerException(when, what, note);
                    }
                    catch (PositionedScannerException pse) {
                        int pos = pse.getPosition().offset;
                        String message = pse.getMessage();
                        if (message != null && message.length() > 0) {
                            errors.add(YamlParser.this.processError(message, snapshot, pos));
                        }
                        ++this.pointer;
                    }
                }
            };
            PositioningParserImpl parser = new PositioningParserImpl((PositioningScanner)scanner){

                protected ParserImpl.ProductionEnvironment getEnvironment(YAMLConfig cfg) {
                    return new PositioningParserImpl.PositioningProductionEnvironment(cfg){

                        protected void parserException(String when, String what, String note, org.jvyamlb.tokens.Token t) {
                            block2: {
                                try {
                                    super.parserException(when, what, note, t);
                                }
                                catch (PositionedParserException ppe) {
                                    int pos = ppe.getPosition().offset;
                                    String message = ppe.getMessage();
                                    if (message == null || message.length() <= 0) break block2;
                                    errors.add(YamlParser.this.processError(message, snapshot, pos));
                                }
                            }
                        }
                    };
                }
            };
            PositioningComposerImpl composer = new PositioningComposerImpl((PositioningParser)parser, (Resolver)new ResolverImpl()){

                protected void composerException(String when, String what, String note, Event e) {
                    block2: {
                        try {
                            super.composerException(when, what, note, e);
                        }
                        catch (PositionedComposerException pce) {
                            int pos = pce.getPosition().offset;
                            String message = pce.getMessage();
                            if (message == null || message.length() <= 0) break block2;
                            errors.add(YamlParser.this.processError(message, snapshot, pos));
                        }
                    }
                }
            };
            Iterator iterator = composer.eachNode();
            while (iterator.hasNext() && (node = (Node)iterator.next()) != null) {
                nodes.add(node);
            }
            YamlParserResult result = new YamlParserResult(nodes, this, snapshot, true, byteToUtf8, utf8toByte);
            if (!errors.isEmpty()) {
                result.addError((Error)errors.get(0));
            }
            return result;
        }
        catch (Exception ex) {
            YamlParserResult result = new YamlParserResult(Collections.emptyList(), this, snapshot, false, null, null);
            String message = ex.getMessage();
            if (message != null && message.length() > 0) {
                result.addError((Error)this.processError(message, snapshot, 0));
            }
            return result;
        }
    }

    private DefaultError processError(String message, Snapshot snapshot, int pos) {
        if (message.startsWith("ScannerException null ")) {
            message = message.substring(22);
        } else if (message.startsWith("ParserException ")) {
            message = message.substring(16);
        }
        char firstChar = message.charAt(0);
        char upcasedChar = Character.toUpperCase(firstChar);
        if (firstChar != upcasedChar) {
            message = upcasedChar + message.substring(1);
        }
        return new DefaultError(null, message, null, snapshot.getSource().getFileObject(), pos, pos, Severity.ERROR);
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        String source = YamlParser.asString(snapshot.getText());
        if (this.isTooLarge(source)) {
            LOGGER.log(Level.FINE, "Skipping {0}, too large to parse (length: {1})", new Object[]{snapshot.getSource().getFileObject(), source.length()});
            this.lastResult = this.resultForTooLargeFile(snapshot);
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            TokenHierarchy hi = TokenHierarchy.create((CharSequence)source, YamlTokenId.language());
            TokenSequence ts = hi.tokenSequence();
            int offset = 0;
            ts.move(offset);
            while (ts.moveNext()) {
                Token t = ts.token();
                TokenId id = t.id();
                if (id == YamlTokenId.RUBY_EXPR) {
                    String marker = "__";
                    sb.append(marker);
                    int n = t.length() - marker.length();
                    for (int i = 0; i < n; ++i) {
                        sb.append(' ');
                    }
                    continue;
                }
                if (id == YamlTokenId.RUBY || id == YamlTokenId.RUBYCOMMENT || id == YamlTokenId.DELIMITER) {
                    for (int i = 0; i < t.length(); ++i) {
                        sb.append(' ');
                    }
                    continue;
                }
                sb.append(t.text().toString());
            }
            source = sb.toString();
            this.lastResult = this.parse(source, snapshot);
        }
        catch (Exception ioe) {
            this.lastResult = new YamlParserResult(Collections.emptyList(), this, snapshot, false, null, null);
        }
    }
}

