/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLElementFactory;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLExpressionFactory;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.grammar.HCLParser;

public final class HCLBlockFactory
extends HCLElementFactory {
    private final HCLExpressionFactory exprFactory;
    private int group = 0;
    private ParserRuleContext prev = null;

    public HCLBlockFactory(Consumer<HCLElementFactory.CreateContext> createAction) {
        super(createAction);
        this.exprFactory = new HCLExpressionFactory(createAction);
    }

    public HCLBlockFactory() {
        this(null);
    }

    public final HCLDocument process(HCLParser.ConfigFileContext ctx) {
        return new HCLDocument(ctx.body() != null ? this.body(ctx.body()) : List.of());
    }

    protected HCLBlock block(HCLParser.BlockContext ctx) {
        ArrayList<HCLElement> elements = new ArrayList<HCLElement>();
        if (ctx.body() != null) {
            elements.addAll(this.body(ctx.body()));
        }
        ArrayList<HCLIdentifier> decl = new ArrayList<HCLIdentifier>(4);
        if (ctx.children != null) {
            for (ParseTree pt : ctx.children) {
                HCLParser.StringLitContext slit;
                String sid;
                TerminalNode tn;
                Token token;
                if (pt instanceof TerminalNode && (token = (tn = (TerminalNode)pt).getSymbol()).getType() == 41) {
                    HCLIdentifier attrName = this.created(new HCLIdentifier.SimpleId(token.getText()), token);
                    if (pt instanceof ErrorNode) {
                        if (this.prev != null) {
                            this.group += this.prev.stop.getLine() + 1 < token.getLine() ? 1 : 0;
                        }
                        HCLAttribute attr = this.created(new HCLAttribute(attrName, null), token, token, this.group);
                        elements.add(attr);
                    } else {
                        decl.add(attrName);
                    }
                }
                if (!(pt instanceof HCLParser.StringLitContext) || (sid = (slit = (HCLParser.StringLitContext)pt).getText()).length() <= 1) continue;
                sid = sid.substring(1, sid.length() - (sid.endsWith("\"") ? 1 : 0));
                HCLIdentifier id = this.created(new HCLIdentifier.StringId(sid), slit);
                decl.add(id);
            }
        }
        return this.created(new HCLBlock(decl, elements), ctx);
    }

    protected List<HCLElement> body(HCLParser.BodyContext ctx) {
        ArrayList<HCLElement> c = new ArrayList<HCLElement>();
        if (ctx.children != null) {
            for (ParseTree pt : ctx.children) {
                ErrorNode en;
                Token token;
                HCLAttribute attr;
                if (pt instanceof HCLParser.AttributeContext) {
                    HCLParser.AttributeContext actx = (HCLParser.AttributeContext)pt;
                    if (this.prev != null) {
                        this.group += this.prev.stop.getLine() + 1 < actx.start.getLine() ? 1 : 0;
                    }
                    HCLIdentifier attrName = this.created(new HCLIdentifier.SimpleId(actx.IDENTIFIER().getText()), actx.IDENTIFIER().getSymbol());
                    HCLExpression attrValue = this.exprFactory.process(actx.expression());
                    attr = this.created(new HCLAttribute(attrName, attrValue), actx, this.group);
                    c.add(attr);
                    this.prev = actx;
                    continue;
                }
                if (pt instanceof HCLParser.BlockContext) {
                    HCLParser.BlockContext bct = (HCLParser.BlockContext)pt;
                    c.add(this.block(bct));
                    continue;
                }
                if (!(pt instanceof ErrorNode) || (token = (en = (ErrorNode)pt).getSymbol()).getType() != 41) continue;
                if (this.prev != null) {
                    this.group += this.prev.stop.getLine() + 1 < token.getLine() ? 1 : 0;
                }
                HCLIdentifier attrName = this.created(new HCLIdentifier.SimpleId(token.getText()), token);
                attr = new HCLAttribute(attrName, null);
                c.add(attr);
            }
        }
        return c;
    }
}

