/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.nodejs.editor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.nodejs.editor.Bundle;
import org.netbeans.modules.javascript2.nodejs.spi.NodeJsSupport;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class NodeJsDataProvider {
    private static final Logger LOG = Logger.getLogger(NodeJsDataProvider.class.getSimpleName());
    private static RequestProcessor RP = new RequestProcessor(NodeJsDataProvider.class);
    private boolean loadingStarted = false;
    private ProgressHandle progress;
    private static final String API_ALL_HTML_FILE = "all.html";
    private static final String CACHE_FOLDER_NAME = "nodejs-doc";
    private static final String API_ALL_JSON_FILE = "all.json";
    protected static final String BACKUP_API_FILE = "nodejs-doc" + "/latest/" + "all.json";
    private static final int URL_CONNECTION_TIMEOUT = 1000;
    private static final int URL_READ_TIMEOUT = 3000;
    private static final String AP_STRING = "&#39;";
    private static final String REQUIRE_STRING = "= require(&#39;";
    private static final String JS_EXT = "js";
    private static final String MODULES = "modules";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "desc";
    private static final String GLOBALS = "globals";
    private static final String VARS = "vars";
    private static final String PARAMS = "params";
    private static final String METHODS = "methods";
    private static final String PROPERTIES = "properties";
    private static final String CLASSES = "classes";
    private static final String EVENTS = "events";
    private static final String MODULE_VERSION = "version";
    private static final String MODULE_DESCRIPTION = "description";
    private static final WeakHashMap<Project, NodeJsDataProvider> cache = new WeakHashMap();
    private static NodeJsDataProvider noProjectInstance = null;
    private static String docApiFilePath = BACKUP_API_FILE;
    private FileObject docFolder;
    private String docUrl = "https://nodejs.org/api/";
    private boolean isSupportEnabled;
    private ProjectSupportChangeListener listener;
    private File apiFile = null;

    private NodeJsDataProvider(Project project) {
        this.isSupportEnabled = project == null;
        this.docFolder = null;
        if (project != null) {
            NodeJsSupport support = null;
            support = (NodeJsSupport)project.getLookup().lookup(NodeJsSupport.class);
            if (support != null) {
                this.listener = new ProjectSupportChangeListener(project);
                support.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)support));
                this.isSupportEnabled = support.isSupportEnabled();
                this.docFolder = support.getDocumentationFolder();
                if (support.getDocumentationUrl() != null) {
                    this.docUrl = support.getDocumentationUrl();
                }
                if (support.getVersion() != null) {
                    docApiFilePath = CACHE_FOLDER_NAME + File.separator + support.getVersion().toString() + File.separator + API_ALL_JSON_FILE;
                }
            }
        }
    }

    public static synchronized NodeJsDataProvider getDefault(FileObject fo) {
        assert (fo != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            if (noProjectInstance == null) {
                noProjectInstance = new NodeJsDataProvider(null);
            }
            return noProjectInstance;
        }
        NodeJsDataProvider instance = cache.get(project);
        if (instance == null) {
            instance = new NodeJsDataProvider(project);
            cache.put(project, instance);
        }
        return instance;
    }

    public boolean isSupportEnabled() {
        return this.isSupportEnabled;
    }

    private URL getDocumentationURL() {
        URL result = null;
        try {
            result = new URL(this.docUrl);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public FileObject getFolderWithRuntimeSources() {
        if (this.docFolder != null) {
            return this.docFolder.getFileObject("../lib");
        }
        return null;
    }

    public Collection<String> getRuntimeModules() {
        String content;
        FileObject libFolder;
        HashSet<String> modules = new HashSet<String>();
        if (this.docFolder != null && (libFolder = this.getFolderWithRuntimeSources()) != null) {
            FileObject[] children = libFolder.getChildren();
            for (int i = 0; i < children.length; ++i) {
                FileObject module = children[i];
                if (module.isFolder() || !JS_EXT.equals(module.getExt()) || module.getName().charAt(0) == '_') continue;
                modules.add(module.getName());
            }
            if (!modules.isEmpty()) {
                return modules;
            }
        }
        if ((content = this.getContentApiFile()) != null) {
            int index = 0;
            int lenghtOfRequire = REQUIRE_STRING.length();
            index = content.indexOf(REQUIRE_STRING, index);
            while (index != -1) {
                int end;
                if (content.charAt(index += lenghtOfRequire) != '.' && (end = content.indexOf(AP_STRING, index)) > -1) {
                    String module = content.substring(index, end);
                    modules.add(module);
                }
                index = content.indexOf(REQUIRE_STRING, index);
            }
        }
        return modules;
    }

    public Collection<FileObject> getLocalModules(FileObject forFile) {
        HashSet<FileObject> modules = new HashSet<FileObject>();
        Project project = FileOwnerQuery.getOwner((FileObject)forFile);
        FileObject nodeModulesFolder = null;
        FileObject parent = forFile.getParent();
        if (project != null) {
            FileObject projectDirectory = project.getProjectDirectory();
            String pathToProject = projectDirectory.getPath();
            while (parent.getPath().startsWith(pathToProject) && nodeModulesFolder == null) {
                nodeModulesFolder = parent.getFileObject("node_modules");
                parent = parent.getParent();
            }
        }
        if (nodeModulesFolder != null) {
            Enumeration moduleFolders = nodeModulesFolder.getFolders(false);
            while (moduleFolders.hasMoreElements()) {
                FileObject moduleFolder = (FileObject)moduleFolders.nextElement();
                if (moduleFolder.getFileObject("package", "json") == null) continue;
                modules.add(moduleFolder);
            }
        }
        return modules;
    }

    public Map<String, Collection<String>> getAllEvents() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        String content = this.getContentApiFile();
        if (content != null && !content.isEmpty()) {
            JSONArray vars;
            JSONArray modules;
            JSONObject root = (JSONObject)JSONValue.parse((String)content);
            JSONArray globals = this.getJSONArrayProperty(root, GLOBALS);
            if (globals != null) {
                for (Object jsonValue : globals) {
                    if (!(jsonValue instanceof JSONObject)) continue;
                    this.getNameOfEventsRecursively((JSONObject)jsonValue, result);
                }
            }
            if ((modules = this.getJSONArrayProperty(root, MODULES)) != null) {
                for (Object jsonValue : modules) {
                    if (!(jsonValue instanceof JSONObject)) continue;
                    this.getNameOfEventsRecursively((JSONObject)jsonValue, result);
                }
            }
            if ((vars = this.getJSONArrayProperty(root, VARS)) != null) {
                for (Object jsonValue : vars) {
                    if (!(jsonValue instanceof JSONObject)) continue;
                    this.getNameOfEventsRecursively((JSONObject)jsonValue, result);
                }
            }
        }
        return result;
    }

    private void getNameOfEventsRecursively(JSONObject object, Map<String, Collection<String>> result) {
        JSONArray classes;
        JSONArray events = this.getJSONArrayProperty(object, EVENTS);
        if (events != null) {
            String objectName = this.getJSONStringProperty(object, NAME);
            StringBuilder docHeader = new StringBuilder();
            docHeader.append("<h2>").append(objectName).append("</h2>");
            for (Object jsonValue : events) {
                String documentation;
                if (!(jsonValue instanceof JSONObject)) continue;
                JSONObject event = (JSONObject)jsonValue;
                String name = this.getJSONStringProperty(event, NAME);
                Collection<String> documentations = result.get(name);
                if (documentations == null) {
                    documentations = new ArrayList<String>();
                    result.put(name, documentations);
                }
                if ((documentation = this.getJSONStringProperty(event, DESCRIPTION)) == null || documentation.isEmpty()) continue;
                documentations.add(docHeader.toString() + documentation);
            }
        }
        if ((classes = this.getJSONArrayProperty(object, CLASSES)) != null) {
            for (Object jsonValue : classes) {
                if (!(jsonValue instanceof JSONObject)) continue;
                this.getNameOfEventsRecursively((JSONObject)jsonValue, result);
            }
        }
    }

    public String getDocForModule(String moduleName) {
        JSONArray modules = this.getModules();
        if (modules != null) {
            for (int i = 0; i < modules.size(); ++i) {
                JSONObject jsonModule;
                Object jsonValue = modules.get(i);
                if (jsonValue == null || !(jsonValue instanceof JSONObject) || (jsonValue = (jsonModule = (JSONObject)jsonValue).get((Object)NAME)) == null || !(jsonValue instanceof String) || !moduleName.equals(((String)jsonValue).toLowerCase()) || (jsonValue = jsonModule.get((Object)DESCRIPTION)) == null || !(jsonValue instanceof String)) continue;
                return (String)jsonValue;
            }
        }
        return null;
    }

    public String getDocForLocalModule(FileObject moduleFolder) {
        FileObject packageFO = moduleFolder.getFileObject("package", "json");
        if (packageFO != null) {
            JSONObject root;
            String content = null;
            try {
                content = this.getFileContent(FileUtil.toFile((FileObject)packageFO));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (content != null && !content.isEmpty() && (root = (JSONObject)JSONValue.parse((String)content)) != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(Bundle.NodeJsDataprovider_lbl_name()).append(" <b>").append(this.getJSONStringProperty(root, NAME)).append("</b><br/>");
                sb.append(Bundle.NodeJsDataprovider_lbl_version()).append(" ").append(this.getJSONStringProperty(root, MODULE_VERSION)).append("<br/><br/>");
                sb.append(this.getJSONStringProperty(root, MODULE_DESCRIPTION));
                return sb.toString();
            }
        }
        return null;
    }

    public Collection<JsObject> getGlobalObjects(ModelElementFactory factory) {
        String content = this.getContentApiFile();
        if (content != null && !content.isEmpty()) {
            File apiFile = this.getCachedAPIFile();
            JsFunction globalObject = factory.newGlobalObject(FileUtil.toFileObject((File)apiFile), (int)apiFile.length());
            JSONObject root = (JSONObject)JSONValue.parse((String)content);
            if (root != null) {
                JSONArray vars;
                JSONArray globals = this.getJSONArrayProperty(root, GLOBALS);
                if (globals != null) {
                    for (Object jsonValue : globals) {
                        JSONObject global;
                        String name;
                        if (!(jsonValue instanceof JSONObject) || (name = this.getJSONStringProperty(global = (JSONObject)jsonValue, NAME)) == null) continue;
                        JsObject property = this.createProperty(factory, (JsObject)globalObject, global);
                        this.addProperties(factory, property, (DeclarationScope)globalObject, global);
                        this.addMethods(factory, property, (DeclarationScope)globalObject, global);
                    }
                }
                if ((vars = this.getJSONArrayProperty(root, VARS)) != null) {
                    for (Object jsonValue : vars) {
                        JSONObject var;
                        String name;
                        if (!(jsonValue instanceof JSONObject) || (name = this.getJSONStringProperty(var = (JSONObject)jsonValue, NAME)) == null) continue;
                        JsObject property = this.createProperty(factory, (JsObject)globalObject, var);
                        this.addProperties(factory, property, (DeclarationScope)globalObject, var);
                        this.addMethods(factory, property, (DeclarationScope)globalObject, var);
                    }
                }
                this.addMethods(factory, (JsObject)globalObject, (DeclarationScope)globalObject, root);
            }
            return Collections.singletonList(globalObject);
        }
        return Collections.emptyList();
    }

    private void addMethods(ModelElementFactory factory, JsObject toObject, DeclarationScope scope, JSONObject fromObject) {
        JSONArray methods = this.getJSONArrayProperty(fromObject, METHODS);
        if (methods != null) {
            for (Object methodO : methods) {
                if (!(methodO instanceof JSONObject)) continue;
                JSONObject method = (JSONObject)methodO;
                String methodName = this.getJSONStringProperty(method, NAME);
                JSONArray signatures = this.getJSONArrayProperty(method, "signatures");
                String doc = this.getJSONStringProperty(method, DESCRIPTION);
                if (methodName == null || signatures == null) continue;
                for (Object signature : signatures) {
                    JSONArray params = this.getJSONArrayProperty((JSONObject)signature, PARAMS);
                    ArrayList<String> paramNames = new ArrayList<String>();
                    if (params != null && !params.isEmpty()) {
                        for (Object param : params) {
                            String paramName = this.getJSONStringProperty((JSONObject)param, NAME);
                            if (paramName == null) continue;
                            paramNames.add(paramName);
                        }
                    }
                    JsFunction object = factory.newFunction(scope, toObject, methodName, paramNames, "NodeJS");
                    if (doc != null) {
                        object.setDocumentation(Documentation.create((String)doc, (URL)this.getDocumentationURL(methodName, paramNames)));
                    }
                    toObject.addProperty(object.getName(), (JsObject)object);
                    this.addProperties(factory, (JsObject)object, (DeclarationScope)object, method);
                    this.addMethods(factory, (JsObject)object, (DeclarationScope)object, method);
                }
            }
        }
    }

    private JsObject createProperty(ModelElementFactory factory, JsObject parent, JSONObject jsonObject) {
        String propertyName = this.getJSONStringProperty(jsonObject, NAME);
        if (propertyName != null) {
            JsObject object = factory.newObject(parent, propertyName, OffsetRange.NONE, true, "NodeJS");
            parent.addProperty(object.getName(), object);
            String doc = this.getJSONStringProperty(jsonObject, DESCRIPTION);
            if (doc != null) {
                object.setDocumentation(Documentation.create((String)doc, (URL)this.getDocumentationURL(propertyName)));
            }
            return object;
        }
        return null;
    }

    private void addProperties(ModelElementFactory factory, JsObject toObject, DeclarationScope scope, JSONObject fromObject) {
        JSONArray properties = this.getJSONArrayProperty(fromObject, PROPERTIES);
        if (properties != null) {
            for (Object propertyO : properties) {
                JSONObject property;
                JsObject newProperty;
                if (!(propertyO instanceof JSONObject) || (newProperty = this.createProperty(factory, toObject, property = (JSONObject)propertyO)) == null) continue;
                this.addProperties(factory, newProperty, scope, property);
                this.addMethods(factory, newProperty, scope, property);
            }
        }
    }

    private String getJSONStringProperty(JSONObject object, String property) {
        Object value = object.get((Object)property);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private JSONArray getJSONArrayProperty(JSONObject object, String property) {
        Object value = object.get((Object)property);
        if (value != null && value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return null;
    }

    private URL getDocumentationURL(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.docUrl).append(API_ALL_HTML_FILE).append("#all_");
        String alteredName = name;
        while (alteredName.charAt(0) == '_') {
            alteredName = alteredName.substring(1);
        }
        sb.append(alteredName.toLowerCase());
        URL result = null;
        try {
            result = new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    private URL getDocumentationURL(String name, Collection<String> params) {
        URL result = this.getDocumentationURL(name);
        if (result != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(result.toExternalForm());
            for (String param : params) {
                sb.append('_').append(param);
            }
            result = null;
            try {
                result = new URL(sb.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }

    private JSONArray getModules() {
        Object jsonValue;
        JSONObject root;
        String content = this.getContentApiFile();
        if (content != null && !content.isEmpty() && (root = (JSONObject)JSONValue.parse((String)content)) != null && (jsonValue = root.get((Object)MODULES)) != null && jsonValue instanceof JSONArray) {
            return (JSONArray)jsonValue;
        }
        return null;
    }

    private void loadURL(URL url, Writer writer, Charset charset) throws IOException {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        URLConnection con = url.openConnection();
        con.setConnectTimeout(1000);
        con.setReadTimeout(3000);
        con.connect();
        try (InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(con.getInputStream()), charset);){
            int read;
            char[] buf = new char[2048];
            while ((read = r.read(buf)) != -1) {
                writer.write(buf, 0, read);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            int read;
            char[] buf = new char[2048];
            while ((read = r.read(buf)) != -1) {
                sb.append(buf, 0, read);
            }
        }
        return sb.toString();
    }

    private File getCachedAPIFile() {
        if (this.apiFile != null) {
            return this.apiFile;
        }
        if (this.docFolder != null) {
            for (FileObject folder : Collections.list(this.docFolder.getFolders(false))) {
                FileObject fo = folder.getFileObject(API_ALL_JSON_FILE);
                if (fo == null) continue;
                this.apiFile = FileUtil.toFile((FileObject)fo);
                return this.apiFile;
            }
        }
        File cacheFile = Places.getCacheSubfile((String)docApiFilePath);
        return cacheFile;
    }

    private String getContentApiFile() {
        String result = null;
        try {
            File cacheFile = this.getCachedAPIFile();
            if (!cacheFile.exists() && this.isSupportEnabled()) {
                if (!this.loadingStarted) {
                    this.startLoading();
                }
                this.loadDoc(cacheFile);
                this.stopLoading();
                LOG.log(Level.FINE, "Loading doc finished.");
            }
            result = cacheFile.exists() ? this.getFileContent(cacheFile) : null;
        }
        catch (IOException | URISyntaxException ex) {
            this.stopLoading();
            LOG.log(Level.INFO, "Cannot load NodeJS documentation from \"{0}\".", new Object[]{this.getDocumentationURL()});
            LOG.log(Level.INFO, "", ex);
        }
        return result;
    }

    private void startLoading() {
        LOG.fine("start loading doc");
        this.loadingStarted = true;
        this.progress = ProgressHandle.createHandle((String)Bundle.doc_building());
        this.progress.start(1);
    }

    private void stopLoading() {
        this.loadingStarted = false;
        if (this.progress != null) {
            this.progress.progress(1);
            this.progress.finish();
            this.progress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDoc(File cacheFile) throws URISyntaxException, MalformedURLException, IOException {
        LOG.fine("start loading doc");
        URL url = new URL(this.getDocumentationURL().toExternalForm() + API_ALL_JSON_FILE);
        File file = cacheFile;
        synchronized (file) {
            String tmpFileName = cacheFile.getAbsolutePath() + ".tmp";
            File tmpFile = new File(tmpFileName);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), StandardCharsets.UTF_8);){
                this.loadURL(url, writer, StandardCharsets.UTF_8);
                ((Writer)writer).close();
                tmpFile.renameTo(cacheFile);
            }
            finally {
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
        }
    }

    public String getDocumentationForGlobalObject(String nameObject) {
        String content = this.getContentApiFile();
        if (content != null && !content.isEmpty()) {
            File apiFile = this.getCachedAPIFile();
            JSONObject root = (JSONObject)JSONValue.parse((String)content);
            if (root != null) {
                JSONArray vars;
                JSONArray globals = this.getJSONArrayProperty(root, GLOBALS);
                if (globals != null) {
                    for (Object jsonValue : globals) {
                        JSONObject global;
                        String name;
                        if (!(jsonValue instanceof JSONObject) || (name = this.getJSONStringProperty(global = (JSONObject)jsonValue, NAME)) == null || !name.equals(nameObject)) continue;
                        String doc = this.getJSONStringProperty(global, DESCRIPTION);
                        return doc;
                    }
                }
                if ((vars = this.getJSONArrayProperty(root, VARS)) != null) {
                    for (Object jsonValue : vars) {
                        JSONObject var;
                        String name;
                        if (!(jsonValue instanceof JSONObject) || (name = this.getJSONStringProperty(var = (JSONObject)jsonValue, NAME)) == null || !name.equals(nameObject)) continue;
                        String doc = this.getJSONStringProperty(var, DESCRIPTION);
                        return doc;
                    }
                }
            }
        }
        return null;
    }

    String getDocumentation(String fqn) {
        String moduleName = fqn.startsWith("nm$_") ? fqn.substring("nm$_".length()) : fqn;
        String[] parts = moduleName.split("\\.");
        if (parts.length > 2 && parts[0].equals(parts[1])) {
            parts = Arrays.copyOfRange(parts, 1, parts.length);
        }
        JSONArray modules = this.getModules();
        JSONObject module = null;
        if (modules != null) {
            Object moduleObject;
            String name;
            Iterator iterator = modules.iterator();
            while (iterator.hasNext() && ((name = this.getJSONStringProperty(module = (JSONObject)(moduleObject = iterator.next()), NAME)) == null || !name.equals(parts[0]))) {
                module = null;
            }
        }
        if (module != null) {
            JSONObject property = module;
            for (int i = 1; i < parts.length && ("prototype".equals(parts[i]) || "exports".equals(parts[i]) || "module".equals(parts[i]) || (property = this.findProperty(property, parts[i])) != null); ++i) {
            }
            return property == null ? null : this.getJSONStringProperty(property, DESCRIPTION);
        }
        return null;
    }

    private JSONObject findProperty(JSONObject parent, String name) {
        String propertyName;
        JSONObject property;
        JSONArray properties = this.getJSONArrayProperty(parent, PROPERTIES);
        if (properties != null) {
            for (Object propertyTmp : properties) {
                property = (JSONObject)propertyTmp;
                propertyName = this.getJSONStringProperty(property, NAME);
                if (propertyName == null || !propertyName.equals(name)) continue;
                return property;
            }
        }
        if ((properties = this.getJSONArrayProperty(parent, METHODS)) != null) {
            for (Object propertyTmp : properties) {
                property = (JSONObject)propertyTmp;
                propertyName = this.getJSONStringProperty(property, NAME);
                if (propertyName == null || !propertyName.equals(name)) continue;
                return property;
            }
        }
        if ((properties = this.getJSONArrayProperty(parent, CLASSES)) != null) {
            String className = this.getJSONStringProperty(parent, NAME) + '.' + name;
            for (Object propertyTmp : properties) {
                JSONObject property2 = (JSONObject)propertyTmp;
                String propertyName2 = this.getJSONStringProperty(property2, NAME);
                if (propertyName2 == null || !propertyName2.equals(className) && !propertyName2.equals(name)) continue;
                return property2;
            }
        }
        return null;
    }

    private class ProjectSupportChangeListener
    implements ChangeListener {
        private final Project project;

        public ProjectSupportChangeListener(Project project) {
            this.project = project;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            cache.remove(this.project);
        }
    }
}

