/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model.api;

import com.oracle.js.parser.ir.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.DeclarationScopeImpl;
import org.netbeans.modules.javascript2.model.EmbeddingHelper;
import org.netbeans.modules.javascript2.model.JsFunctionImpl;
import org.netbeans.modules.javascript2.model.JsFunctionReference;
import org.netbeans.modules.javascript2.model.JsObjectImpl;
import org.netbeans.modules.javascript2.model.JsObjectReference;
import org.netbeans.modules.javascript2.model.ModelBuilder;
import org.netbeans.modules.javascript2.model.ModelExtender;
import org.netbeans.modules.javascript2.model.ParameterObject;
import org.netbeans.modules.javascript2.model.SemiTypeResolverVisitor;
import org.netbeans.modules.javascript2.model.api.Index;
import org.netbeans.modules.javascript2.model.api.IndexedElement;
import org.netbeans.modules.javascript2.model.api.JsArray;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsReference;
import org.netbeans.modules.javascript2.model.api.JsWith;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.model.spi.TypeNameConvertor;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.api.Type;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.openide.filesystems.FileObject;

public class ModelUtils {
    public static final String PROTOTYPE = "prototype";
    public static final String CONSTRUCTOR = "constructor";
    public static final String THIS = "this";
    public static final String ARGUMENTS = "arguments";
    private static final String GENERATED_FUNCTION_PREFIX = "L#";
    private static final String GENERATED_ANONYM_PREFIX = "Anonym#";
    private static final List<String> KNOWN_TYPES = Arrays.asList("Array", "String", "Boolean", "Number", "undefined");
    private static final int MAX_RECURSION_DEEP_RESOLVING_ASSIGNMENTS = 10;
    private static final String GLOBAL_DIRECTIVE = "global";
    private static final Logger LOG = Logger.getLogger(ModelUtils.class.getName());
    private static final Collection<JsTokenId> CTX_DELIMITERS = Arrays.asList(JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_CURLY, JsTokenId.OPERATOR_SEMICOLON);
    private static int deepRA = 0;
    private static final List<String> knownGlobalObjects = Arrays.asList("window", "document", "console", "clearInterval", "clearTimeout", "event", "frames", "history", "Image", "location", "name", "navigator", "Option", "parent", "screen", "setInterval", "setTimeout", "XMLHttpRequest", "JSON", "Date", "undefined", "Math", "Array", "Object", "Boolean", "null", "Number", "RegExp", "String", "undefined", "unresolved", "NaN", "Infinity");

    public static JsObjectImpl getJsObject(ModelBuilder builder, List<Identifier> fqName, boolean isLHS) {
        int index;
        if (fqName == null || fqName.isEmpty()) {
            return null;
        }
        JsObject result = builder.getCurrentObject();
        JsObject tmpObject = null;
        String firstName = fqName.get(0).getName();
        while (tmpObject == null && result != null && result.getParent() != null) {
            if (result instanceof JsFunctionImpl) {
                tmpObject = ((JsFunctionImpl)result).getParameter(firstName);
            }
            if (tmpObject == null) {
                if (result.getProperty(firstName) != null) {
                    tmpObject = result;
                }
                result = result.getParent();
                continue;
            }
            result = tmpObject;
        }
        if (tmpObject == null) {
            JsObjectImpl current = builder.getCurrentObject();
            if (current instanceof JsWith) {
                tmpObject = current;
            } else {
                for (JsFunctionImpl scope = builder.getCurrentDeclarationFunction(); scope != null && tmpObject == null && scope.getParentScope() != null; scope = scope.getParentScope()) {
                    if (scope instanceof JsFunction) {
                        tmpObject = ((JsFunction)scope).getParameter(firstName);
                    }
                    if (tmpObject != null) continue;
                    tmpObject = ((JsObject)scope).getProperty(firstName);
                }
                if (tmpObject == null) {
                    tmpObject = builder.getGlobal();
                } else {
                    result = tmpObject;
                }
            }
        }
        int n = index = tmpObject instanceof ParameterObject ? 1 : 0;
        while (index < fqName.size()) {
            Identifier name = fqName.get(index);
            if (name != null && (result = tmpObject.getProperty(name.getName())) == null) {
                result = new JsObjectImpl(tmpObject, name, name.getOffsetRange(), index < fqName.size() - 1 ? false : isLHS, tmpObject.getMimeType(), tmpObject.getSourceLabel());
                tmpObject.addProperty(name.getName(), result);
            }
            tmpObject = result;
            ++index;
        }
        return result;
    }

    public static boolean isGlobal(JsObject object) {
        return object != null && object.getJSKind() == JsElement.Kind.FILE;
    }

    public static boolean isDescendant(JsObject possibleDescendant, JsObject possibleAncestor) {
        JsObject parent;
        for (parent = possibleDescendant; parent != null && !parent.equals(possibleAncestor); parent = parent.getParent()) {
        }
        return parent != null;
    }

    public static JsObject findJsObject(Model model, int offset) {
        JsObject global = model.getGlobalObject();
        JsObject result = ModelUtils.findJsObject(global, offset);
        if (result == null) {
            result = global;
        }
        return result;
    }

    public static JsObject findJsObject(JsObject object, int offset) {
        HashSet<String> visited = new HashSet<String>();
        return ModelUtils.findJsObject(object, offset, visited);
    }

    public static void copyOccurrences(JsObject from, JsObject to) {
        for (Occurrence oc : from.getOccurrences()) {
            to.addOccurrence(oc.getOffsetRange());
        }
    }

    public static JsObject findJsObject(JsObject object, int offset, Set<String> visited) {
        JsObjectImpl jsObject = (JsObjectImpl)object;
        visited.add(jsObject.getFullyQualifiedName());
        JsObject result = null;
        JsObject tmpObject = null;
        if (jsObject.containsOffset(offset)) {
            result = jsObject;
            for (JsObject jsObject2 : jsObject.getProperties().values()) {
                JsElement.Kind kind = jsObject2.getJSKind();
                if (!(kind != JsElement.Kind.OBJECT && kind != JsElement.Kind.ANONYMOUS_OBJECT && kind != JsElement.Kind.OBJECT_LITERAL && kind != JsElement.Kind.FUNCTION && kind != JsElement.Kind.METHOD && kind != JsElement.Kind.CONSTRUCTOR && kind != JsElement.Kind.WITH_OBJECT || visited.contains(jsObject2.getFullyQualifiedName()))) {
                    tmpObject = ModelUtils.findJsObject(jsObject2, offset, visited);
                }
                if (tmpObject == null) continue;
                result = tmpObject;
                break;
            }
            if (object.getJSKind() == JsElement.Kind.WITH_OBJECT) {
                for (JsWith jsWith : ((JsWith)object).getInnerWiths()) {
                    if (!visited.contains(jsWith.getFullyQualifiedName())) {
                        tmpObject = ModelUtils.findJsObject(jsWith, offset, visited);
                    }
                    if (tmpObject == null) continue;
                    result = tmpObject;
                    break;
                }
            }
            if (object instanceof JsArray) {
                JsArray array = (JsArray)object;
                block2: for (TypeUsage typeUsage : array.getTypesInArray()) {
                    int anonymOffset;
                    if (!typeUsage.getType().startsWith("@anonym;") || (anonymOffset = Integer.parseInt(typeUsage.getType().substring("@anonym;".length()))) <= 0) continue;
                    DeclarationScope scope = ModelUtils.getDeclarationScope(array);
                    for (JsObject jsObject3 : ((JsObject)scope).getProperties().values()) {
                        JsElement.Kind kind = jsObject3.getJSKind();
                        if (kind == JsElement.Kind.ANONYMOUS_OBJECT && !visited.contains(jsObject3.getFullyQualifiedName())) {
                            tmpObject = ModelUtils.findJsObject(jsObject3, offset, visited);
                        }
                        if (tmpObject == null) continue;
                        result = tmpObject;
                        continue block2;
                    }
                }
            }
        }
        return result;
    }

    public static JsObject findJsObjectByName(JsObject global, String fqName) {
        JsObject result = global;
        StringTokenizer stringTokenizer = new StringTokenizer(fqName, ".");
        while (stringTokenizer.hasMoreTokens() && result != null) {
            String token = stringTokenizer.nextToken();
            JsObject property = result.getProperty(token);
            if (property == null) {
                if ((result = result instanceof JsFunction ? ((JsFunction)result).getParameter(token) : null) != null) continue;
                break;
            }
            result = property;
        }
        return result;
    }

    public static JsObject findJsObjectByName(Model model, String fqName) {
        return ModelUtils.findJsObjectByName(model.getGlobalObject(), fqName);
    }

    public static JsObject getGlobalObject(JsObject jsObject) {
        JsObject result = jsObject;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    public static DeclarationScope getDeclarationScope(JsObject object) {
        assert (object != null);
        JsObject result = object;
        while (result.getParent() != null && !(result.getParent() instanceof DeclarationScope)) {
            result = result.getParent();
        }
        if (result.getParent() != null && result.getParent() instanceof DeclarationScope) {
            result = result.getParent();
        }
        if (!(result instanceof DeclarationScope)) {
            result = ModelUtils.getGlobalObject(object);
        }
        return (DeclarationScope)result;
    }

    public static DeclarationScope getDeclarationScope(Model model, int offset) {
        JsObject global = model.getGlobalObject();
        DeclarationScope result = ModelUtils.getDeclarationScope((DeclarationScope)global, offset);
        if (result == null) {
            result = (DeclarationScope)global;
        }
        return result;
    }

    public static DeclarationScope getDeclarationScope(DeclarationScope scope, int offset) {
        DeclarationScopeImpl dScope = (DeclarationScopeImpl)scope;
        DeclarationScopeImpl result = null;
        if (result == null && dScope.getOffsetRange().containsInclusive(offset)) {
            result = dScope;
            boolean deep = true;
            block0: while (deep) {
                deep = false;
                for (DeclarationScope innerScope : result.getChildrenScopes()) {
                    if (!(innerScope instanceof DeclarationScopeImpl) || !((DeclarationScopeImpl)innerScope).getOffsetRange().containsInclusive(offset)) continue;
                    result = innerScope;
                    deep = true;
                    continue block0;
                }
            }
        }
        return result;
    }

    public static OffsetRange documentOffsetRange(org.netbeans.modules.javascript2.types.spi.ParserResult result, int start, int end) {
        int lStart = LexUtilities.getLexerOffset((ParserResult)result, (int)start);
        int lEnd = LexUtilities.getLexerOffset((ParserResult)result, (int)end);
        if (lStart == -1 || lEnd == -1) {
            return OffsetRange.NONE;
        }
        if (lEnd < lStart) {
            int length = lStart - lEnd;
            lEnd = lStart + length;
        }
        return new OffsetRange(lStart, lEnd);
    }

    public static Collection<? extends JsObject> getVariables(DeclarationScope inScope) {
        HashMap<String, JsObject> result = new HashMap<String, JsObject>();
        while (inScope != null) {
            for (JsObject jsObject : ((JsObject)inScope).getProperties().values()) {
                if (result.containsKey(jsObject.getName()) || !jsObject.getModifiers().contains(Modifier.PRIVATE)) continue;
                result.put(jsObject.getName(), jsObject);
            }
            if (inScope instanceof JsFunction) {
                for (JsObject jsObject : ((JsFunction)inScope).getParameters()) {
                    if (result.containsKey(jsObject.getName())) continue;
                    result.put(jsObject.getName(), jsObject);
                }
            }
            for (JsObject jsObject : ((JsObject)inScope).getProperties().values()) {
                if (result.containsKey(jsObject.getName())) continue;
                result.put(jsObject.getName(), jsObject);
            }
            if (inScope.getParentScope() != null && !result.containsKey(((JsObject)inScope).getName())) {
                result.put(((JsObject)inScope).getName(), (JsObject)inScope);
            }
            inScope = inScope.getParentScope();
        }
        return result.values();
    }

    public static JsObject getScopeVariable(DeclarationScope inScope, String name) {
        for (DeclarationScope curScope = inScope; curScope != null; curScope = curScope.getParentScope()) {
            JsObject param;
            JsObject prop = ((JsObject)curScope).getProperty(name);
            if (prop != null && prop.getModifiers().contains(Modifier.PRIVATE)) {
                return prop;
            }
            if (curScope instanceof JsFunction && (param = ((JsFunction)curScope).getParameter(name)) != null) {
                return param;
            }
            if (prop != null) {
                return prop;
            }
            if (!name.equals(((JsObject)inScope).getName())) continue;
            return (JsObject)inScope;
        }
        return null;
    }

    public static Collection<? extends JsObject> getVariables(Model model, int offset) {
        DeclarationScope scope = ModelUtils.getDeclarationScope(model, offset);
        return ModelUtils.getVariables(scope);
    }

    public static JsObject getJsObjectByName(DeclarationScope inScope, String simpleName) {
        Collection<? extends JsObject> variables = ModelUtils.getVariables(inScope);
        for (JsObject jsObject : variables) {
            if (!simpleName.equals(jsObject.getName())) continue;
            return jsObject;
        }
        return null;
    }

    private static Collection<TypeUsage> tryResolveWindowProperty(Model model, Index jsIndex, String name) {
        String fqn = null;
        int offset = -1;
        for (IndexedElement indexedElement : jsIndex.getProperties("window")) {
            if (!indexedElement.getName().equals(name)) continue;
            offset = indexedElement.getOffset();
            fqn = "window." + name;
            break;
        }
        if (fqn == null) {
            for (IndexedElement indexedElement : jsIndex.getProperties("Window.prototype")) {
                if (!indexedElement.getName().equals(name)) continue;
                offset = indexedElement.getOffset();
                fqn = "Window.prototype." + name;
                break;
            }
        }
        if (fqn != null) {
            ArrayList<TypeUsage> fromAssignment = new ArrayList<TypeUsage>();
            ModelUtils.resolveAssignments(model, jsIndex, fqn, offset, fromAssignment);
            if (fromAssignment.isEmpty()) {
                fromAssignment.add(new TypeUsage(fqn));
            }
            return fromAssignment;
        }
        return null;
    }

    public static Collection<TypeUsage> resolveSemiTypeOfExpression(ModelBuilder builder, Node expression) {
        Set<TypeUsage> result = new HashSet<TypeUsage>();
        SemiTypeResolverVisitor visitor = new SemiTypeResolverVisitor();
        if (expression != null) {
            result = visitor.getSemiTypes(expression, builder);
        }
        if (builder.getCurrentWith() != null) {
            HashSet<TypeUsage> withResult = new HashSet<TypeUsage>();
            String withSemi = "@with;" + builder.getCurrentWith().getFullyQualifiedName();
            for (TypeUsage type : result) {
                if (!KNOWN_TYPES.contains(type.getType())) {
                    withResult.add(new TypeUsage(withSemi + type.getType(), type.getOffset(), type.isResolved()));
                    continue;
                }
                withResult.add(type);
            }
            result = withResult;
        }
        return result;
    }

    public static Collection<TypeUsage> resolveTypeFromSemiType(JsObject object, TypeUsage type) {
        HashSet<TypeUsage> result = new HashSet<TypeUsage>();
        if (type.isResolved()) {
            result.add(type);
        } else if ("undefined".equals(type.getType())) {
            if (object.getJSKind() == JsElement.Kind.CONSTRUCTOR) {
                if (object.getParent().getJSKind() == JsElement.Kind.CLASS) {
                    result.add(new TypeUsage(object.getParent().getFullyQualifiedName(), type.getOffset(), true));
                } else {
                    result.add(new TypeUsage(object.getFullyQualifiedName(), type.getOffset(), true));
                }
            } else {
                result.add(new TypeUsage("undefined", type.getOffset(), true));
            }
        } else if (EmbeddingHelper.containsGeneratedIdentifier(type.getType())) {
            result.add(new TypeUsage("undefined", type.getOffset(), true));
        } else if ("@this;".equals(type.getType())) {
            JsObject parent = ModelUtils.resolveThis(object);
            if (parent != null) {
                result.add(new TypeUsage(parent.getFullyQualifiedName(), type.getOffset(), true));
            }
        } else if (type.getType().startsWith("@this;")) {
            JsObject parent = ModelUtils.resolveThis(object);
            if (parent != null) {
                Collection<TypeUsage> locally = ModelUtils.resolveSemiTypeChain(parent, type.getType().substring(6));
                if (locally.isEmpty()) {
                    result.add(new TypeUsage(type.getType().replace("@this;", parent.getFullyQualifiedName()), type.getOffset(), false));
                } else {
                    TypeUsage localType;
                    if (locally.size() == 1 && (localType = locally.iterator().next()).isResolved()) {
                        JsFunctionImpl function;
                        JsObject rObject = ModelUtils.findJsObjectByName(ModelUtils.getGlobalObject(object), localType.getType());
                        JsFunction jsFunction = rObject instanceof JsFunctionImpl ? (JsFunctionImpl)rObject : (function = rObject instanceof JsFunctionReference ? ((JsFunctionReference)rObject).getOriginal() : null);
                        if (function != null && function.getParent() != null && object != null && function.getParent().equals(object.getParent()) && object.getDeclarationName() != null) {
                            object.getParent().addProperty(object.getName(), new JsFunctionReference(object.getParent(), object.getDeclarationName(), function, true, null));
                        }
                    }
                    result.addAll(locally);
                }
            }
        } else if (type.getType().startsWith("@new;")) {
            result.addAll(ModelUtils.resolveSemiTypeCallChain(object, type));
        } else if (type.getType().startsWith("@call;")) {
            result.addAll(ModelUtils.resolveSemiTypeCallChain(object, type));
        } else if (type.getType().startsWith("@anonym;")) {
            int start;
            JsObject byOffset;
            String offsetPart = type.getType().substring(8);
            String rest = "";
            int index = offsetPart.indexOf("@");
            if (index > -1) {
                rest = offsetPart.substring(index);
                offsetPart = offsetPart.substring(0, index);
            }
            if ((byOffset = ModelUtils.findJsObject(object, start = Integer.parseInt(offsetPart))) == null) {
                JsObject jsObject = ModelUtils.getGlobalObject(object);
                byOffset = ModelUtils.findJsObject(jsObject, start);
            }
            if (byOffset != null && byOffset.isAnonymous()) {
                if (rest.isEmpty()) {
                    result.add(new TypeUsage(byOffset.getFullyQualifiedName(), byOffset.getOffset(), true));
                } else {
                    String string2 = "@exp;" + byOffset.getFullyQualifiedName().replace(".", "@pro;");
                    string2 = string2 + rest;
                    result.add(new TypeUsage(string2, byOffset.getOffset(), false));
                }
            }
        } else if (type.getType().startsWith("@var;")) {
            String name = type.getType().substring(5);
            DeclarationScope declarationScope = object instanceof DeclarationScope ? (DeclarationScope)object : ModelUtils.getDeclarationScope(object);
            ArrayList<? extends JsObject> variables = new ArrayList<JsObject>(ModelUtils.getVariables(declarationScope));
            if (!(object instanceof DeclarationScope) && object.getParent() != null && !(object.getParent() instanceof DeclarationScope)) {
                variables.addAll(object.getParent().getProperties().values());
            }
            if (declarationScope != null) {
                boolean resolved = false;
                for (JsObject jsObject : variables) {
                    String newVarType;
                    if (!jsObject.getName().equals(name)) continue;
                    if (!jsObject.getAssignments().isEmpty()) {
                        newVarType = "@exp;" + jsObject.getFullyQualifiedName().replace(".", "@pro;");
                        result.add(new TypeUsage(newVarType, type.getOffset(), false));
                        resolved = true;
                        break;
                    }
                    if (jsObject.getJSKind() == JsElement.Kind.PARAMETER) continue;
                    if (jsObject.getJSKind().isFunction() && object.getAssignments().size() == 1 && object.getParent() != null && object.getDeclarationName() != null) {
                        JsObject jsObject2 = object.getParent().getProperty(object.getName());
                        JsFunctionReference newProperty = new JsFunctionReference(object.getParent(), object.getDeclarationName(), (JsFunction)jsObject, true, (Set<Modifier>)jsObject2.getModifiers());
                        for (Occurrence occurrence : jsObject2.getOccurrences()) {
                            newProperty.addOccurrence(occurrence.getOffsetRange());
                        }
                        object.getParent().addProperty(object.getName(), newProperty);
                    } else {
                        newVarType = jsObject.getFullyQualifiedName();
                        result.add(new TypeUsage(newVarType, type.getOffset(), false));
                    }
                    resolved = true;
                    break;
                }
                if (!resolved && declarationScope instanceof JsFunction) {
                    boolean bl;
                    Collection<? extends JsObject> parameters = ((JsFunction)declarationScope).getParameters();
                    boolean bl2 = false;
                    for (JsObject jsObject : parameters) {
                        if (!name.equals(jsObject.getName())) continue;
                        Collection<? extends TypeUsage> assignments = jsObject.getAssignmentForOffset(jsObject.getOffset());
                        result.addAll(assignments);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        result.add(new TypeUsage(name, type.getOffset(), false));
                    }
                }
            }
        } else if (type.getType().startsWith("@param;")) {
            String functionName = type.getType().substring(7);
            int index = functionName.indexOf(":");
            if (index > 0) {
                JsObject jsObject;
                String fqn = functionName.substring(0, index);
                JsObject globalObject = ModelUtils.getGlobalObject(object);
                JsObject function = ModelUtils.findJsObjectByName(globalObject, fqn);
                if (function instanceof JsFunction && (jsObject = ((JsFunction)function).getParameter(functionName.substring(index + 1))) != null) {
                    result.addAll(jsObject.getAssignments());
                }
            }
        } else {
            result.add(type);
        }
        return result;
    }

    private static JsObject resolveThis(JsObject object) {
        JsObject grandParent;
        JsObject parent = object.getJSKind() == JsElement.Kind.CONSTRUCTOR ? object : (object.getParent() != null && object.getParent().getJSKind() != JsElement.Kind.FILE ? object.getParent() : object);
        if (parent != null && (parent.getJSKind() == JsElement.Kind.FUNCTION || parent.getJSKind() == JsElement.Kind.METHOD) && parent.getParent().getJSKind() != JsElement.Kind.FILE && (grandParent = parent.getParent()) != null && (grandParent.getJSKind() == JsElement.Kind.OBJECT_LITERAL || PROTOTYPE.equals(grandParent.getName())) && PROTOTYPE.equals((parent = grandParent).getName()) && parent.getParent() != null) {
            parent = parent.getParent();
        }
        while (parent != null && parent.getParent() != null && parent.getModifiers().contains(Modifier.PROTECTED)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private static Collection<TypeUsage> resolveSemiTypeCallChain(JsObject object, TypeUsage type) {
        HashSet<TypeUsage> result = new HashSet<TypeUsage>();
        DeclarationScope declarationScope = ModelUtils.getDeclarationScope(object);
        JsObject function = null;
        boolean calledNew = false;
        int index = -1;
        int dotIndex = -1;
        if (type.getType().startsWith("@call;")) {
            index = 6;
        } else if (type.getType().startsWith("@new;")) {
            index = 5;
            calledNew = true;
        }
        String name = type.getType().substring(index);
        if (declarationScope != null) {
            index = name.indexOf("@");
            if (index > -1) {
                name = name.substring(0, index);
            }
            Collection<? extends JsObject> variables = ModelUtils.getVariables(declarationScope);
            dotIndex = name.indexOf(46);
            String firstSpace = dotIndex == -1 ? name : name.substring(0, name.indexOf(46));
            for (JsObject jsObject : variables) {
                if (!jsObject.getName().equals(firstSpace)) continue;
                function = jsObject;
                break;
            }
        }
        if (dotIndex != -1 && function != null) {
            function = ModelUtils.findJsObjectByName(function, name.substring(dotIndex + 1));
        }
        if (function != null) {
            if (index == -1) {
                if (function instanceof JsFunction) {
                    if (calledNew) {
                        result.add(new TypeUsage(function.getFullyQualifiedName(), type.getOffset(), true));
                    } else {
                        result.addAll(((JsFunction)function).getReturnTypes());
                    }
                } else if (calledNew) {
                    result.add(new TypeUsage(function.getFullyQualifiedName(), type.getOffset(), true));
                } else {
                    result.add(type);
                }
            } else {
                result.add(new TypeUsage(type.getType().replace(name, function.getFullyQualifiedName()), type.getOffset(), false));
            }
        } else {
            result.add(type);
        }
        return result;
    }

    private static Collection<TypeUsage> resolveSemiTypeChain(JsObject object, String chain) {
        String part;
        int index;
        HashSet<TypeUsage> result = new HashSet<TypeUsage>();
        if (chain.isEmpty()) {
            return result;
        }
        if (PROTOTYPE.equals(object.getName()) && (object = object.getParent()) == null) {
            return result;
        }
        String[] parts = chain.substring(1).split("@");
        JsObject resultObject = null;
        JsObject testObject = object;
        String kind = "";
        String[] stringArray = parts;
        int n = stringArray.length;
        for (int i = 0; i < n && (index = (part = stringArray[i]).indexOf(";")) > 0; ++i) {
            JsObject prototype;
            kind = part.substring(0, index);
            String name = part.substring(index + 1);
            resultObject = testObject.getProperty(name);
            if (resultObject == null && (prototype = testObject.getProperty(PROTOTYPE)) != null) {
                resultObject = prototype.getProperty(name);
            }
            if (resultObject == null) break;
            testObject = resultObject;
        }
        if (resultObject != null) {
            if (resultObject instanceof JsFunction) {
                if ("call".endsWith(kind)) {
                    ModelUtils.addUniqueType(result, ((JsFunction)resultObject).getReturnTypes());
                } else {
                    ModelUtils.addUniqueType(result, new TypeUsage(resultObject.getFullyQualifiedName(), -1, true));
                }
            } else {
                Collection<? extends TypeUsage> assignments = resultObject.getAssignments();
                if (assignments.isEmpty()) {
                    ModelUtils.addUniqueType(result, new TypeUsage(resultObject.getFullyQualifiedName(), -1, true));
                } else {
                    ModelUtils.addUniqueType(result, resultObject.getAssignments());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<TypeUsage> resolveTypeFromExpression(Model model, @NullAllowed Index jsIndex, List<String> exp, int offset, boolean includeAllPossible) {
        ArrayList<JsObject> localObjects = new ArrayList<JsObject>();
        ArrayList<JsObject> lastResolvedObjects = new ArrayList<JsObject>();
        ArrayList<TypeUsage> lastResolvedTypes = new ArrayList<TypeUsage>();
        block0: for (int i = exp.size() - 1; i > -1; --i) {
            Object name;
            String kind = exp.get(i);
            if (((String)(name = exp.get(--i))).startsWith("@ano:")) {
                String[] parts = ((String)name).split(":");
                int anoOffset = Integer.parseInt(parts[1]);
                JsObject anonym = ModelUtils.findJsObject(model, anoOffset);
                lastResolvedObjects.add(anonym);
                continue;
            }
            if (THIS.equals(name)) {
                JsObject thisObject;
                JsObject first = thisObject = ModelUtils.findJsObject(model, offset);
                while (thisObject != null && thisObject.getParent() != null && thisObject.getParent().getJSKind() != JsElement.Kind.FILE && thisObject.getJSKind() != JsElement.Kind.CONSTRUCTOR && thisObject.getJSKind() != JsElement.Kind.ANONYMOUS_OBJECT && thisObject.getJSKind() != JsElement.Kind.OBJECT_LITERAL) {
                    thisObject = thisObject.getParent();
                }
                if ((thisObject == null || thisObject.getParent() == null) && first != null) {
                    thisObject = first;
                }
                if (thisObject != null) {
                    name = thisObject.getName();
                }
            }
            if (i == exp.size() - 2) {
                Object windowProperty;
                JsObject localObject = null;
                int index = ((String)name).lastIndexOf(46);
                Collection<? extends TypeUsage> typeFromWith = ModelUtils.getTypeFromWith(model, offset);
                if (!typeFromWith.isEmpty()) {
                    String firstNamePart = index == -1 ? name : ((String)name).substring(0, index);
                    Object changedName = name;
                    for (TypeUsage typeUsage : typeFromWith) {
                        String string = typeUsage.getType();
                        localObject = ModelUtils.findJsObjectByName(model, string);
                        if (localObject != null && localObject.getProperty(firstNamePart) != null) {
                            changedName = localObject.getFullyQualifiedName() + "." + (String)name;
                            continue;
                        }
                        lastResolvedTypes.add(new TypeUsage(string + "." + (String)name, -1, true));
                    }
                    name = changedName;
                }
                if (index > -1) {
                    localObject = ModelUtils.findJsObjectByName(model, (String)name);
                    if (localObject != null) {
                        localObjects.add(localObject);
                    }
                } else {
                    String string;
                    Object localFunc;
                    boolean canBeWindowsProp = true;
                    for (JsObject jsObject : model.getVariables(offset)) {
                        if (!jsObject.getName().equals(name)) continue;
                        localObjects.add(jsObject);
                        localObject = jsObject;
                        break;
                    }
                    if (localObject != null && localObject.getJSKind().isFunction() && i - 2 > -1 && (localFunc = (JsFunction)localObject).getParameter(string = exp.get(i - 2)) != null) {
                        canBeWindowsProp = false;
                    }
                    localFunc = ModelExtender.getDefault().getExtendingGlobalObjects(model.getGlobalObject().getFileObject()).iterator();
                    block4: while (localFunc.hasNext()) {
                        JsObject jsObject = localFunc.next();
                        assert (jsObject != null);
                        for (JsObject jsObject2 : jsObject.getProperties().values()) {
                            if (!jsObject2.getName().equals(name)) continue;
                            lastResolvedTypes.add(new TypeUsage(jsObject2.getName(), -1, true));
                            continue block4;
                        }
                    }
                    if (jsIndex != null && canBeWindowsProp && (windowProperty = ModelUtils.tryResolveWindowProperty(model, jsIndex, (String)name)) != null && !windowProperty.isEmpty()) {
                        lastResolvedTypes.addAll((Collection<TypeUsage>)windowProperty);
                    }
                }
                if (localObject == null || localObject.getJSKind() != JsElement.Kind.PARAMETER && (ModelUtils.isGlobal(localObject.getParent()) || localObject.getJSKind() != JsElement.Kind.VARIABLE)) {
                    ArrayList fromAssignments = new ArrayList();
                    if ("@pro".equals(kind) && jsIndex != null) {
                        ModelUtils.resolveAssignments(model, jsIndex, (String)name, -1, (List<TypeUsage>)fromAssignments);
                    }
                    lastResolvedTypes.addAll(fromAssignments);
                    if (!typeFromWith.isEmpty()) {
                        windowProperty = typeFromWith.iterator();
                        while (windowProperty.hasNext()) {
                            void var17_44;
                            TypeUsage typeUsage = windowProperty.next();
                            String string = typeUsage.getType();
                            if (string.startsWith("@exp;")) {
                                String string3 = string.substring(5);
                                string3 = string3.replace("@pro;", ".");
                            }
                            ModelUtils.resolveAssignments(model, jsIndex, (String)var17_44, typeUsage.getOffset(), (List<TypeUsage>)fromAssignments);
                            Iterator iterator = fromAssignments.iterator();
                            while (iterator.hasNext()) {
                                String string4;
                                TypeUsage typeUsage1 = (TypeUsage)iterator.next();
                                String string5 = string4 = localObject != null ? localObject.getFullyQualifiedName() : null;
                                if (string4 != null && ((String)name).startsWith(string4) && ((String)name).length() > string4.length()) {
                                    lastResolvedTypes.add(new TypeUsage(typeUsage1.getType() + kind + ";" + ((String)name).substring(string4.length() + 1), typeUsage.getOffset(), false));
                                    continue;
                                }
                                if (!typeUsage1.getType().equals(name)) {
                                    lastResolvedTypes.add(new TypeUsage(typeUsage1.getType() + kind + ";" + (String)name, typeUsage.getOffset(), false));
                                    continue;
                                }
                                lastResolvedTypes.add(typeUsage1);
                            }
                        }
                    }
                }
                if (localObjects.isEmpty()) continue;
                for (JsObject lObject : localObjects) {
                    if (lObject.getAssignmentForOffset(offset).isEmpty()) {
                        JsObject jsObject;
                        boolean bl;
                        boolean bl2 = bl = lObject.getJSKind() == JsElement.Kind.OBJECT_LITERAL;
                        if (lObject instanceof JsObjectReference && (jsObject = ((JsObjectReference)lObject).getOriginal()) != null) {
                            Object object = name = jsObject.getDeclarationName() != null ? jsObject.getDeclarationName().getName() : jsObject.getName();
                        }
                        if (bl) {
                            lastResolvedTypes.add(new TypeUsage((String)name, -1, true));
                        }
                    }
                    if ("@mtd".equals(kind)) {
                        int n;
                        if (lObject.getJSKind().isFunction()) {
                            lastResolvedTypes.addAll(((JsFunction)lObject).getReturnTypes());
                        }
                        int n2 = -1;
                        for (Occurrence occurrence : lObject.getOccurrences()) {
                            if (n >= occurrence.getOffsetRange().getStart() || occurrence.getOffsetRange().getStart() > offset) continue;
                            n = occurrence.getOffsetRange().getStart();
                        }
                        Collection<TypeUsage> collection = model.getReturnTypesFromFrameworks(lObject.getName(), n);
                        if (collection != null && !collection.isEmpty()) {
                            lastResolvedTypes.addAll(collection);
                        }
                        if (jsIndex == null) continue;
                        Collection<? extends IndexResult> collection2 = jsIndex.findByFqn((String)name, Index.TERMS_BASIC_INFO);
                        Iterator<? extends IndexResult> iterator = collection2.iterator();
                        while (iterator.hasNext()) {
                            IndexedElement indexedElement = IndexedElement.create(iterator.next());
                            if (!(indexedElement instanceof IndexedElement.FunctionIndexedElement)) continue;
                            IndexedElement.FunctionIndexedElement iFunction = (IndexedElement.FunctionIndexedElement)indexedElement;
                            for (String type : iFunction.getReturnTypes()) {
                                lastResolvedTypes.add(new TypeUsage(type, -1, false));
                            }
                        }
                        continue;
                    }
                    if ("@arr".equals(kind) && lObject instanceof JsArray) {
                        lastResolvedTypes.addAll(((JsArray)lObject).getTypesInArray());
                        continue;
                    }
                    Collection<? extends TypeUsage> collection = lObject.getAssignmentForOffset(offset);
                    lastResolvedObjects.add(lObject);
                    if (collection.isEmpty()) continue;
                    ModelUtils.resolveAssignments(model, lObject, offset, lastResolvedObjects, lastResolvedTypes);
                    continue block0;
                }
                continue;
            }
            ArrayList<JsObject> newResolvedObjects = new ArrayList<JsObject>();
            ArrayList<TypeUsage> newResolvedTypes = new ArrayList<TypeUsage>();
            for (JsObject localObject : lastResolvedObjects) {
                JsObject property = localObject.getProperty((String)name);
                if (property == null) continue;
                if ("@mtd".equals(kind)) {
                    if (!property.getJSKind().isFunction()) continue;
                    Collection<? extends TypeUsage> collection = ((JsFunction)property).getReturnTypes();
                    newResolvedTypes.addAll(collection);
                    continue;
                }
                if ("@arr".equals(kind)) {
                    if (!(property instanceof JsArray)) continue;
                    newResolvedTypes.addAll(((JsArray)property).getTypesInArray());
                    continue;
                }
                Collection<? extends TypeUsage> collection = property.getAssignmentForOffset(offset);
                if (collection.isEmpty()) {
                    newResolvedObjects.add(property);
                    continue;
                }
                newResolvedTypes.addAll(collection);
                if (property.getProperties().isEmpty()) continue;
                newResolvedObjects.add(property);
            }
            for (TypeUsage typeUsage : lastResolvedTypes) {
                if (jsIndex != null) {
                    void var17_49;
                    boolean checkProperty;
                    void var16_36;
                    void var16_34;
                    ArrayList<Object> prototypeChain = new ArrayList<Object>();
                    String string = typeUsage.getType();
                    if (string.contains("@exp;")) {
                        String string6 = string.substring(string.indexOf("@exp;") + "@exp;".length());
                    }
                    if (var16_34.contains("@pro;")) {
                        String string7 = var16_34.replace("@pro;", ".");
                    }
                    prototypeChain.add(var16_36);
                    prototypeChain.addAll(ModelUtils.findPrototypeChain((String)var16_36, jsIndex));
                    Object var17_48 = null;
                    Object var18_60 = null;
                    for (String string8 : prototypeChain) {
                        void var17_52;
                        String string9 = string8 + "." + (String)name;
                        Collection<? extends IndexResult> collection = jsIndex.findByFqn(string9, "flag", "return", "array", "assign");
                        if (collection.isEmpty() && !string8.endsWith(".prototype")) {
                            String string10 = string8 + ".prototype." + (String)name;
                            Collection<? extends IndexResult> collection3 = jsIndex.findByFqn(string10, "flag", "return", "array", "assign");
                        }
                        if (!var17_52.isEmpty()) break;
                        Object var18_65 = null;
                    }
                    boolean bl = checkProperty = (var17_49 == null || var17_49.isEmpty()) && !"@mtd".equals(kind);
                    if (var17_49 != null) {
                        for (IndexResult indexResult : var17_49) {
                            Collection<TypeUsage> resolvedTypes;
                            JsElement.Kind jsKind = IndexedElement.Flag.getJsKind(Integer.parseInt(indexResult.getValue("flag")));
                            if ("@mtd".equals(kind) && jsKind.isFunction()) {
                                resolvedTypes = IndexedElement.getReturnTypes(indexResult);
                                ModelUtils.addUniqueType(newResolvedTypes, resolvedTypes);
                                continue;
                            }
                            if ("@arr".equals(kind)) {
                                resolvedTypes = IndexedElement.getArrayTypes(indexResult);
                                ModelUtils.addUniqueType(newResolvedTypes, resolvedTypes);
                                continue;
                            }
                            checkProperty = true;
                        }
                    }
                    if (checkProperty) {
                        void var18_66;
                        void var20_77 = var18_66 != null ? var18_66 : (String)var16_36 + "." + (String)name;
                        ArrayList<TypeUsage> fromAssignment = new ArrayList<TypeUsage>();
                        ModelUtils.resolveAssignments(model, jsIndex, (String)var20_77, -1, fromAssignment);
                        if (fromAssignment.isEmpty()) {
                            ModelUtils.addUniqueType(newResolvedTypes, new TypeUsage((String)var20_77));
                        } else {
                            ModelUtils.addUniqueType(newResolvedTypes, fromAssignment);
                        }
                    }
                }
                block16: for (JsObject jsObject : ModelExtender.getDefault().getExtendingGlobalObjects(model.getGlobalObject().getFileObject())) {
                    for (JsObject jsObject3 : jsObject.getProperties().values()) {
                        if (!jsObject3.getName().equals(typeUsage.getType())) continue;
                        JsObject property = jsObject3.getProperty((String)name);
                        if (property == null) continue block16;
                        JsElement.Kind kind2 = property.getJSKind();
                        if ("@mtd".equals(kind) && kind2.isFunction()) {
                            newResolvedTypes.addAll(((JsFunction)property).getReturnTypes());
                            continue block16;
                        }
                        newResolvedObjects.add(property);
                        continue block16;
                    }
                }
            }
            lastResolvedObjects = newResolvedObjects;
            lastResolvedTypes = newResolvedTypes;
        }
        HashMap<String, TypeUsage> resultTypes = new HashMap<String, TypeUsage>();
        for (TypeUsage typeUsage : lastResolvedTypes) {
            if (resultTypes.containsKey(typeUsage.getType())) continue;
            resultTypes.put(typeUsage.getType(), typeUsage);
        }
        for (JsObject jsObject : lastResolvedObjects) {
            String fqn;
            if (!jsObject.isDeclared() || resultTypes.containsKey(fqn = jsObject.getFullyQualifiedName()) || !includeAllPossible && !ModelUtils.hasDeclaredProperty(jsObject)) continue;
            resultTypes.put(fqn, new TypeUsage(fqn, offset));
        }
        return resultTypes.values();
    }

    public static boolean hasDeclaredProperty(JsObject jsObject) {
        boolean result = false;
        Iterator<? extends JsObject> it = jsObject.getProperties().values().iterator();
        while (!result && it.hasNext()) {
            JsObject property = it.next();
            result = property.isDeclared();
            if (result) continue;
            result = ModelUtils.hasDeclaredProperty(property);
        }
        return result;
    }

    public static List<String> expressionFromType(TypeUsage type) {
        String sexp = type.getType();
        if ((sexp.startsWith("@exp;") || sexp.startsWith("@new;") || sexp.startsWith("@arr;") || sexp.contains("@pro;") || sexp.startsWith("@call;") || sexp.startsWith("@with;")) && sexp.length() > 5) {
            if (sexp.charAt(0) == '@') {
                int start = sexp.startsWith("@call;") || sexp.startsWith("@arr;") || sexp.startsWith("@with;") ? 1 : (sexp.charAt(5) == '@' ? 6 : 5);
                sexp = sexp.substring(start);
            }
            ArrayList<String> nExp = new ArrayList<String>();
            String[] split = sexp.split("@");
            for (int i = split.length - 1; i > -1; --i) {
                nExp.add(split[i].substring(split[i].indexOf(59) + 1));
                if (split[i].startsWith("arr;")) {
                    nExp.add("@arr");
                    continue;
                }
                if (split[i].startsWith("call;")) {
                    nExp.add("@mtd");
                    continue;
                }
                if (split[i].startsWith("with;")) {
                    nExp.add("@with");
                    continue;
                }
                nExp.add("@pro");
            }
            return nExp;
        }
        return Collections.singletonList(type.getType());
    }

    public static TypeUsage createResolvedType(JsObject parent, TypeUsage typeHere) {
        int invokeCount = 0;
        String fqn = ModelUtils.getFQNFromType((Type)typeHere);
        ArrayList<TypeUsage> alreadyResolved = new ArrayList<TypeUsage>();
        return ModelUtils.resolveTypes(parent, fqn, typeHere.getOffset(), alreadyResolved, invokeCount);
    }

    private static TypeUsage resolveTypes(JsObject parent, String fqn, int offset, List<TypeUsage> alreadyResolved, int invokeCount) {
        ++invokeCount;
        String name = fqn;
        StringBuilder props = new StringBuilder();
        int indx = fqn.indexOf(".");
        if (indx != -1) {
            name = fqn.substring(0, indx);
            props.append(fqn.substring(indx + 1));
        }
        ArrayList<TypeUsage> localResolved = new ArrayList<TypeUsage>();
        ModelUtils.resolveAssignments(parent, name, offset, localResolved, props);
        List diff = localResolved.stream().filter(type -> !alreadyResolved.contains(type)).collect(Collectors.toList());
        if (!diff.isEmpty()) {
            alreadyResolved.addAll(diff);
            boolean typeResolved = false;
            for (TypeUsage type2 : localResolved) {
                String partfqn;
                String newObjectName;
                JsObject object;
                if (!type2.isResolved() || (object = ModelUtils.searchJsObjectByName(parent, newObjectName = type2.getType())) == null || object == parent || (partfqn = props.toString()).trim().equals("")) continue;
                String[] tokens = partfqn.split("\\.");
                block1: for (int i = 0; i < tokens.length; ++i) {
                    object = ModelUtils.searchJsObjectByName(parent, newObjectName);
                    for (JsObject jsObject : object.getProperties().values()) {
                        if (!jsObject.getName().equals(tokens[i]) || !jsObject.isDeclared()) continue;
                        if (jsObject.getAssignmentCount() > 0) {
                            if (invokeCount == 10) {
                                LOG.log(Level.WARNING, "StackOverFlowError : {0} : {1}", new Object[]{object.getFullyQualifiedName(), object.getFileObject()});
                            }
                            return ModelUtils.resolveTypes(object, String.join((CharSequence)".", Arrays.copyOfRange(tokens, i, tokens.length)), offset, alreadyResolved, invokeCount);
                        }
                        object = jsObject;
                        newObjectName = newObjectName + "." + jsObject.getName();
                        if (i != tokens.length - 1) continue block1;
                        typeResolved = true;
                        continue block1;
                    }
                }
                if (!typeResolved) continue;
                return new TypeUsage(newObjectName, type2.getOffset(), true);
            }
        }
        return new TypeUsage(fqn, offset, false);
    }

    private static void resolveAssignments(JsObject jsObject, String fqn, int offset, List<TypeUsage> resolved, StringBuilder nestedProperties) {
        int invokeCount = 0;
        HashSet<String> alreadyProcessed = new HashSet<String>();
        for (TypeUsage type : resolved) {
            alreadyProcessed.add(type.getType());
        }
        ModelUtils.resolveAssignments(jsObject, fqn, offset, resolved, alreadyProcessed, nestedProperties, invokeCount);
    }

    private static void resolveAssignments(JsObject parent, String fqn, int offset, List<TypeUsage> resolved, Set<String> alreadyProcessed, StringBuilder nestedProperties, int invokeCount) {
        if (!alreadyProcessed.contains(fqn)) {
            ++invokeCount;
            alreadyProcessed.add(fqn);
            String fqnCorrected = ModelUtils.getFQNFromType((Type)new TypeUsage(fqn, offset, false));
            int index = fqnCorrected.indexOf(".");
            if (index != -1) {
                nestedProperties.insert(0, fqnCorrected.substring(index + 1) + ".");
                fqnCorrected = fqnCorrected.substring(0, index);
            }
            if (!fqnCorrected.startsWith("@")) {
                ArrayList<TypeUsage> toProcess = new ArrayList<TypeUsage>();
                JsObject object = ModelUtils.searchJsObjectByName(parent, fqnCorrected);
                if (object != null && ((JsObjectImpl)object).getAssignmentCount() > 0) {
                    for (TypeUsage typeUsage : ((JsObjectImpl)object).getAssignments()) {
                        if (!typeUsage.isResolved()) {
                            for (TypeUsage resolvedType : ModelUtils.resolveTypeFromSemiType(object, typeUsage)) {
                                toProcess.add(resolvedType);
                            }
                            continue;
                        }
                        toProcess.add(typeUsage);
                    }
                    for (TypeUsage typeUsage : toProcess) {
                        if (alreadyProcessed.contains(typeUsage.getType())) continue;
                        if (invokeCount == 10) {
                            LOG.log(Level.WARNING, "StackOverFlowError : {0} : {1}", new Object[]{object.getFullyQualifiedName(), object.getFileObject()});
                        }
                        ModelUtils.resolveAssignments(parent, typeUsage.getType(), typeUsage.getOffset(), resolved, alreadyProcessed, nestedProperties, invokeCount);
                    }
                } else {
                    ModelUtils.addUniqueType(resolved, new TypeUsage(fqnCorrected, offset, true));
                }
            } else {
                ModelUtils.addUniqueType(resolved, new TypeUsage(fqnCorrected, offset, false));
            }
        }
    }

    private static JsObject searchJsObjectByName(JsObject parent, String fqn) {
        JsObject object = ModelUtils.findJsObjectByName(parent, fqn);
        if (object == null && !ModelUtils.isGlobal(parent) && parent.getParent() != null) {
            parent = parent.getParent();
            return ModelUtils.searchJsObjectByName(parent, fqn);
        }
        return object;
    }

    public static Collection<TypeUsage> resolveTypes(Collection<? extends TypeUsage> unresolved, Model model, Index jsIndex, boolean includeAllPossible) {
        ArrayList<Object> types = new ArrayList<TypeUsage>(unresolved);
        if (types.size() == 1 && ((TypeUsage)types.iterator().next()).isResolved()) {
            return types;
        }
        HashSet<String> original = null;
        int cycle = 0;
        boolean resolvedAll = false;
        while (!resolvedAll && cycle < 10) {
            ++cycle;
            resolvedAll = true;
            ArrayList<TypeUsage> resolved = new ArrayList<TypeUsage>();
            for (TypeUsage typeUsage : types) {
                if (!typeUsage.isResolved()) {
                    if (original == null) {
                        original = new HashSet<String>(unresolved.size());
                        for (TypeUsage typeUsage2 : unresolved) {
                            original.add(typeUsage2.getType());
                        }
                    }
                    resolvedAll = false;
                    List<String> nExp = ModelUtils.expressionFromType(typeUsage);
                    if (nExp.size() > 1) {
                        ModelUtils.addUniqueType(resolved, original, ModelUtils.resolveTypeFromExpression(model, jsIndex, nExp, typeUsage.getOffset(), includeAllPossible));
                        continue;
                    }
                    ModelUtils.addUniqueType(resolved, new TypeUsage(typeUsage.getType(), typeUsage.getOffset(), true));
                    continue;
                }
                ModelUtils.addUniqueType(resolved, typeUsage);
            }
            types.clear();
            types = new ArrayList(resolved);
        }
        return types;
    }

    private static void resolveAssignments(Model model, JsObject jsObject, int offset, List<JsObject> resolvedObjects, List<TypeUsage> resolvedTypes) {
        Collection<? extends TypeUsage> assignments = jsObject.getAssignmentForOffset(offset);
        for (TypeUsage typeUsage : assignments) {
            if (typeUsage.isResolved()) {
                resolvedTypes.add(typeUsage);
                continue;
            }
            String type = typeUsage.getType();
            if (type.startsWith("@with;")) {
                List<String> expression = ModelUtils.expressionFromType(typeUsage);
                Collection<? extends TypeUsage> typesFromWith = ModelUtils.getTypeFromWith(model, typeUsage.getOffset());
                expression.remove(expression.size() - 1);
                expression.remove(expression.size() - 1);
                StringBuilder sb = new StringBuilder();
                for (int i = expression.size() - 1; i > 0; --i) {
                    sb.append(expression.get(i--));
                    sb.append(";");
                    sb.append(expression.get(i));
                }
                for (TypeUsage typeUsage2 : typesFromWith) {
                    resolvedTypes.add(new TypeUsage("@exp;" + typeUsage2.getType() + sb.toString(), typeUsage.getOffset(), false));
                }
                resolvedTypes.add(new TypeUsage(sb.toString(), typeUsage.getOffset(), false));
                continue;
            }
            JsObject byOffset = ModelUtils.findObjectForOffset(typeUsage.getType(), offset, model);
            if (byOffset != null) {
                if (jsObject.getName().equals(byOffset.getName())) continue;
                resolvedObjects.add(byOffset);
                ModelUtils.resolveAssignments(model, byOffset, offset, resolvedObjects, resolvedTypes);
                continue;
            }
            resolvedTypes.add(typeUsage);
        }
    }

    private static void resolveAssignments(Model model, Index jsIndex, String fqn, int offset, List<TypeUsage> resolved) {
        HashSet<String> alreadyProcessed = new HashSet<String>();
        deepRA = 0;
        for (TypeUsage type : resolved) {
            alreadyProcessed.add(type.getType());
        }
        ModelUtils.resolveAssignments(model, jsIndex, fqn, offset, resolved, alreadyProcessed);
    }

    private static void resolveAssignments(Model model, Index jsIndex, String fqn, int offset, List<TypeUsage> resolved, Set<String> alreadyProcessed) {
        if (!alreadyProcessed.contains(fqn)) {
            alreadyProcessed.add(fqn);
            ++deepRA;
            String fqnCorrected = fqn;
            if (fqnCorrected.startsWith("@exp;") && !fqnCorrected.contains("@call;")) {
                fqnCorrected = fqnCorrected.substring(fqnCorrected.indexOf("@exp;") + "@exp;".length());
                fqnCorrected = fqnCorrected.replace("@pro;", ".");
            }
            if (!fqnCorrected.startsWith("@")) {
                if (jsIndex != null) {
                    Collection<? extends TypeUsage> collection;
                    JsObject found;
                    Collection<? extends IndexResult> indexResults = jsIndex.findByFqn(fqnCorrected, "assign");
                    boolean hasAssignments = false;
                    boolean isType = false;
                    block0: for (IndexResult indexResult : indexResults) {
                        Collection<TypeUsage> assignments2 = IndexedElement.getAssignments(indexResult);
                        if (assignments2.isEmpty()) continue;
                        hasAssignments = true;
                        for (TypeUsage typeUsage : assignments2) {
                            if (resolved.size() > 10) {
                                resolved.clear();
                                continue block0;
                            }
                            if (alreadyProcessed.contains(typeUsage.getType()) || deepRA >= 10) continue;
                            ModelUtils.resolveAssignments(model, jsIndex, typeUsage.getType(), typeUsage.getOffset(), resolved, alreadyProcessed);
                        }
                    }
                    if (indexResults.isEmpty() && (found = ModelUtils.findJsObjectByName(model.getGlobalObject(), fqnCorrected)) != null && !(collection = found.getAssignments()).isEmpty()) {
                        hasAssignments = true;
                        ArrayList<TypeUsage> toProcess = new ArrayList<TypeUsage>();
                        for (TypeUsage typeUsage : collection) {
                            if (!typeUsage.isResolved()) {
                                for (TypeUsage resolvedType : ModelUtils.resolveTypeFromSemiType(found, typeUsage)) {
                                    toProcess.add(resolvedType);
                                }
                                continue;
                            }
                            toProcess.add(typeUsage);
                        }
                        for (TypeUsage typeUsage : toProcess) {
                            if (alreadyProcessed.contains(typeUsage.getType()) || deepRA >= 10) continue;
                            ModelUtils.resolveAssignments(model, jsIndex, typeUsage.getType(), typeUsage.getOffset(), resolved, alreadyProcessed);
                        }
                    }
                    Collection<IndexedElement> properties = jsIndex.getProperties(fqnCorrected);
                    for (IndexedElement property : properties) {
                        if (!property.getFQN().startsWith(fqnCorrected) || !property.isDeclared() && !PROTOTYPE.equals(property.getName())) continue;
                        isType = true;
                        break;
                    }
                    if (!hasAssignments || isType) {
                        ModelUtils.addUniqueType(resolved, new TypeUsage(fqnCorrected, offset, true));
                    }
                }
            } else {
                ModelUtils.addUniqueType(resolved, new TypeUsage(fqn, offset, false));
            }
        }
    }

    public static JsObject findObjectForOffset(String name, int offset, Model model) {
        for (JsObject jsObject : model.getVariables(offset)) {
            if (!jsObject.getName().equals(name)) continue;
            return jsObject;
        }
        return null;
    }

    public static Collection<String> findPrototypeChain(String fqn, Index jsIndex) {
        Collection<String> chain = ModelUtils.findPrototypeChain(fqn, jsIndex, new HashSet<String>());
        return chain;
    }

    private static Collection<String> findPrototypeChain(String fqn, Index jsIndex, Set<String> alreadyCheck) {
        HashSet<String> result = new HashSet<String>();
        if (!alreadyCheck.contains(fqn)) {
            alreadyCheck.add(fqn);
            Collection<? extends IndexResult> indexResults = jsIndex.findByFqn(fqn + "." + PROTOTYPE, "assign");
            for (IndexResult indexResult : indexResults) {
                Collection<TypeUsage> assignments = IndexedElement.getAssignments(indexResult);
                for (TypeUsage typeUsage : assignments) {
                    result.add(typeUsage.getType());
                }
                for (TypeUsage typeUsage : assignments) {
                    result.addAll(ModelUtils.findPrototypeChain(typeUsage.getType(), jsIndex, alreadyCheck));
                }
            }
        }
        if (result.isEmpty()) {
            result.add("Object");
        }
        return result;
    }

    public static Collection<? extends TypeUsage> getTypeFromWith(Model model, int offset) {
        JsObject jsObject;
        JsObject previous = jsObject = ModelUtils.findJsObject(model, offset);
        while (jsObject != null && jsObject.isAnonymous() && jsObject.getJSKind() != JsElement.Kind.WITH_OBJECT && !(jsObject = ModelUtils.findJsObject(model, jsObject.getOffset() - 1)).getFullyQualifiedName().endsWith(previous.getFullyQualifiedName())) {
            previous = jsObject;
        }
        while (jsObject != null && jsObject.getJSKind() != JsElement.Kind.WITH_OBJECT) {
            jsObject = jsObject.getParent();
        }
        if (jsObject != null && jsObject.getJSKind() == JsElement.Kind.WITH_OBJECT) {
            ArrayList<TypeUsage> types = new ArrayList<TypeUsage>();
            JsWith wObject = (JsWith)jsObject;
            Collection<TypeUsage> withTypes = wObject.getTypes();
            types.addAll(withTypes);
            while (wObject.getOuterWith() != null) {
                wObject = wObject.getOuterWith();
                withTypes = wObject.getTypes();
                types.addAll(withTypes);
            }
            return types;
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection<Identifier> getDefinedGlobal(Snapshot snapshot, int offset) {
        ArrayList<Identifier> names = new ArrayList<Identifier>();
        List<JsTokenId> findToken = Arrays.asList(JsTokenId.BLOCK_COMMENT);
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)snapshot, (int)offset);
        if (ts == null) {
            return names;
        }
        ts.move(0);
        Token token = LexUtilities.findNextIncluding((TokenSequence)ts, findToken);
        while (token != null && token.id() == JsTokenId.BLOCK_COMMENT) {
            int iOffset = ts.offset();
            String text = token.text().toString();
            text = text.substring(2);
            iOffset += 2;
            while (!text.isEmpty() && text.charAt(0) == ' ') {
                text = text.substring(1);
                ++iOffset;
            }
            if (text.startsWith(GLOBAL_DIRECTIVE) && text.length() > GLOBAL_DIRECTIVE.length() && text.charAt(GLOBAL_DIRECTIVE.length()) == ' ') {
                String[] parts;
                text = text.substring(GLOBAL_DIRECTIVE.length() + 1);
                iOffset = iOffset + GLOBAL_DIRECTIVE.length() + 1;
                String[] stringArray = parts = text.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String part;
                    String name = part = stringArray[i];
                    int nameOffset = iOffset;
                    while (!name.isEmpty() && name.charAt(0) == ' ') {
                        name = name.substring(1);
                        ++nameOffset;
                    }
                    if ((name = name.trim()).indexOf(42) > 0) {
                        name = name.substring(0, name.indexOf(42)).trim();
                    }
                    if (name.indexOf(58) > 0) {
                        name = name.substring(0, name.indexOf(58)).trim();
                    }
                    if (!name.isEmpty()) {
                        names.add(new Identifier(name, new OffsetRange(nameOffset, nameOffset + name.length())));
                    }
                    iOffset = iOffset + part.length() + 1;
                }
            }
            if (!ts.moveNext()) break;
            token = LexUtilities.findNextIncluding((TokenSequence)ts, findToken);
        }
        return names;
    }

    public static List<? extends JsObject> getExtendingGlobalObjects(FileObject fo) {
        return ModelExtender.getDefault().getExtendingGlobalObjects(fo);
    }

    public static void addUniqueType(Collection<TypeUsage> where, Set<String> forbidden, TypeUsage type) {
        String typeName = type.getType();
        if (forbidden.contains(typeName)) {
            return;
        }
        for (TypeUsage utype : where) {
            if (!utype.getType().equals(typeName)) continue;
            return;
        }
        where.add(type);
    }

    public static void addUniqueType(Collection<TypeUsage> where, TypeUsage type) {
        ModelUtils.addUniqueType(where, Collections.emptySet(), type);
    }

    public static void addUniqueType(Collection<TypeUsage> where, Set<String> forbidden, Collection<TypeUsage> what) {
        for (TypeUsage type : what) {
            ModelUtils.addUniqueType(where, forbidden, type);
        }
    }

    public static void addUniqueType(Collection<TypeUsage> where, Collection<TypeUsage> what) {
        ModelUtils.addUniqueType(where, Collections.emptySet(), what);
    }

    public static void addDocTypesOccurence(JsObject jsObject, JsDocumentationHolder docHolder) {
        if (docHolder.getOccurencesMap().containsKey(jsObject.getFullyQualifiedName())) {
            for (OffsetRange offsetRange : (List)docHolder.getOccurencesMap().get(jsObject.getFullyQualifiedName())) {
                ((JsObjectImpl)jsObject).addOccurrence(offsetRange);
            }
        }
    }

    public static String getDisplayName(String typeName) {
        String displayName = typeName;
        if (displayName.startsWith("@param;") || displayName.contains("With$") || displayName.contains("Anonym$")) {
            displayName = "";
        } else {
            if (displayName.contains(GENERATED_FUNCTION_PREFIX)) {
                displayName = ModelUtils.removeGeneratedFromFQN(displayName, GENERATED_FUNCTION_PREFIX);
            }
            if (displayName.contains(GENERATED_ANONYM_PREFIX)) {
                displayName = ModelUtils.removeGeneratedFromFQN(displayName, GENERATED_ANONYM_PREFIX);
            }
        }
        return displayName;
    }

    public static String getDisplayName(Type type) {
        TypeNameConvertor convertor;
        List<TypeNameConvertor> convertors = ModelExtender.getDefault().getTypeNameConvertors();
        String displayName = null;
        Iterator<TypeNameConvertor> iterator = convertors.iterator();
        while (iterator.hasNext() && ((displayName = (convertor = iterator.next()).getDisplayName(type)) == null || displayName.isEmpty() || displayName.equals(type.getType()))) {
        }
        if (displayName == null || displayName.isEmpty() || displayName.equals(type.getType())) {
            displayName = ModelUtils.getDisplayName(type.getType());
        }
        return displayName;
    }

    private static String removeGeneratedFromFQN(String fqn, String generated) {
        String[] parts = fqn.split("\\.");
        String part = parts[parts.length - 1];
        if (part.contains(generated)) {
            try {
                Integer.parseInt(part.substring(generated.length()));
                return "";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            part = parts[i];
            boolean add = true;
            if (part.startsWith(generated) || i == 0 && part.contains(generated)) {
                try {
                    Integer.parseInt(part.substring(part.indexOf(generated) + generated.length()));
                    add = false;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!add) continue;
            sb.append(part);
            if (i >= parts.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static boolean isKnownGLobalType(String type) {
        return knownGlobalObjects.contains(type);
    }

    public static List<String> resolveExpressionChain(Snapshot snapshot, int offset, boolean lookBefore) {
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)offset);
        if (ts == null) {
            return Collections.emptyList();
        }
        ts.move(offset);
        if (ts.movePrevious() && (ts.moveNext() || ts.offset() + ts.token().length() == snapshot.getText().length())) {
            if (!lookBefore && ts.token().id() != JsTokenId.OPERATOR_DOT && ts.token().id() != JsTokenId.OPERATOR_OPTIONAL_ACCESS) {
                ts.movePrevious();
            }
            Token token = lookBefore ? LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.EOL)) : ts.token();
            int parenBalancer = 0;
            int partType = 0;
            boolean wasLastDot = lookBefore;
            int offsetFirstRightParen = -1;
            ArrayList<String> exp = new ArrayList<String>();
            while (token.id() != JsTokenId.OPERATOR_SEMICOLON && token.id() != JsTokenId.BRACKET_RIGHT_CURLY && token.id() != JsTokenId.BRACKET_LEFT_CURLY && token.id() != JsTokenId.BRACKET_LEFT_PAREN && token.id() != JsTokenId.BLOCK_COMMENT && token.id() != JsTokenId.LINE_COMMENT && token.id() != JsTokenId.OPERATOR_ASSIGNMENT && token.id() != JsTokenId.OPERATOR_PLUS) {
                if (token.id() == JsTokenId.WHITESPACE) {
                    int helpOffset = ts.offset();
                    if (ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.EOL))).id() != JsTokenId.BRACKET_RIGHT_PAREN && token.id() != JsTokenId.IDENTIFIER && token.id() != JsTokenId.PRIVATE_IDENTIFIER && token.id() != JsTokenId.OPERATOR_DOT && token.id() != JsTokenId.OPERATOR_OPTIONAL_ACCESS) {
                        ts.move(helpOffset);
                        ts.moveNext();
                        token = ts.token();
                        break;
                    }
                }
                if (token.id() != JsTokenId.EOL) {
                    if (token.id() != JsTokenId.OPERATOR_DOT && token.id() != JsTokenId.OPERATOR_OPTIONAL_ACCESS) {
                        if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                            ++parenBalancer;
                            partType = 1;
                            if (offsetFirstRightParen == -1) {
                                offsetFirstRightParen = ts.offset();
                            }
                            while (parenBalancer > 0 && ts.movePrevious()) {
                                token = ts.token();
                                if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                                    ++parenBalancer;
                                    continue;
                                }
                                if (token.id() != JsTokenId.BRACKET_LEFT_PAREN) continue;
                                --parenBalancer;
                            }
                        } else if (token.id() == JsTokenId.BRACKET_RIGHT_BRACKET) {
                            ++parenBalancer;
                            partType = 2;
                            while (parenBalancer > 0 && ts.movePrevious()) {
                                token = ts.token();
                                if (token.id() == JsTokenId.BRACKET_RIGHT_BRACKET) {
                                    ++parenBalancer;
                                    continue;
                                }
                                if (token.id() != JsTokenId.BRACKET_LEFT_BRACKET) continue;
                                --parenBalancer;
                            }
                        } else {
                            if (parenBalancer == 0 && "operator".equals(((JsTokenId)token.id()).primaryCategory())) {
                                return exp;
                            }
                            exp.add(token.text().toString());
                            switch (partType) {
                                case 0: {
                                    exp.add("@pro");
                                    break;
                                }
                                case 1: {
                                    exp.add("@mtd");
                                    offsetFirstRightParen = -1;
                                    break;
                                }
                                case 2: {
                                    exp.add("@arr");
                                    break;
                                }
                            }
                            partType = 0;
                            wasLastDot = false;
                        }
                    } else {
                        wasLastDot = true;
                    }
                } else if (!wasLastDot && ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))).id() != JsTokenId.OPERATOR_DOT && token.id() != JsTokenId.OPERATOR_OPTIONAL_ACCESS) break;
                if (!ts.movePrevious()) break;
                token = ts.token();
            }
            if (token.id() == JsTokenId.WHITESPACE) {
                if (ts.movePrevious()) {
                    token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT, JsTokenId.EOL));
                    if (token.id() == JsTokenId.KEYWORD_NEW && !exp.isEmpty()) {
                        exp.remove(exp.size() - 1);
                        exp.add("@pro");
                    } else if (!lookBefore && offsetFirstRightParen > -1) {
                        exp.addAll(ModelUtils.resolveExpressionChain(snapshot, offsetFirstRightParen - 1, true));
                    }
                }
            } else if (exp.isEmpty() && !lookBefore && offsetFirstRightParen > -1) {
                exp.addAll(ModelUtils.resolveExpressionChain(snapshot, offsetFirstRightParen - 1, true));
            } else if (wasLastDot && !lookBefore && token.id() == JsTokenId.BRACKET_RIGHT_CURLY) {
                int balancer = 1;
                while (balancer > 0 && ts.movePrevious()) {
                    token = ts.token();
                    if (token.id() == JsTokenId.BRACKET_RIGHT_CURLY) {
                        ++balancer;
                        continue;
                    }
                    if (token.id() != JsTokenId.BRACKET_LEFT_CURLY) continue;
                    --balancer;
                }
                exp.add("@ano:" + ts.offset());
                exp.add("@pro");
            }
            return exp;
        }
        return Collections.emptyList();
    }

    public static void moveProperty(JsObject newParent, JsObject property) {
        Object newProperty = newParent.getProperty(property.getName());
        if (property.getParent() != null) {
            property.getParent().getProperties().remove(property.getName());
        }
        if (newProperty == null) {
            ((JsObjectImpl)property).setParent(newParent);
            newParent.addProperty(property.getName(), (JsObject)property);
        } else {
            if (property.isDeclared() && !newProperty.isDeclared()) {
                Object tmpProperty = newProperty;
                newParent.addProperty(property.getName(), (JsObject)property);
                ((JsObjectImpl)property).setParent(newParent);
                newProperty = property;
                property = tmpProperty;
            }
            JsObjectImpl.moveOccurrenceOfProperties((JsObjectImpl)newProperty, (JsObject)property);
            for (Occurrence occurrence : property.getOccurrences()) {
                newProperty.addOccurrence(occurrence.getOffsetRange());
            }
            ArrayList<? extends JsObject> propertiesToMove = new ArrayList<JsObject>(property.getProperties().values());
            for (JsObject jsObject : propertiesToMove) {
                ModelUtils.moveProperty((JsObject)newProperty, jsObject);
            }
        }
    }

    public static void changeDeclarationScope(JsObject where, DeclarationScope newScope) {
        ModelUtils.changeDeclarationScope(where, newScope, new HashSet<String>());
    }

    private static void changeDeclarationScope(JsObject where, DeclarationScope newScope, Set<String> done) {
        if (!done.contains(where.getFullyQualifiedName())) {
            done.add(where.getFullyQualifiedName());
            if (where instanceof DeclarationScope) {
                if (where.isDeclared()) {
                    DeclarationScope scope = (DeclarationScope)where;
                    DeclarationScope declarationScope = scope.getParentScope();
                    if (declarationScope != null) {
                        declarationScope.getChildrenScopes().remove(scope);
                        if (scope instanceof DeclarationScopeImpl) {
                            ((DeclarationScopeImpl)scope).setParentScope(newScope);
                        }
                    }
                    newScope.addDeclaredScope(scope);
                }
            } else {
                for (JsObject jsObject : where.getProperties().values()) {
                    ModelUtils.changeDeclarationScope(jsObject, newScope, done);
                }
            }
        }
    }

    public static boolean wasProcessed(JsObject object, Set<String> processedObjects) {
        if (processedObjects.contains(object.getFullyQualifiedName())) {
            return true;
        }
        if (object instanceof JsReference) {
            JsObject original = ((JsReference)object).getOriginal();
            boolean isOrginalReachable = !original.isAnonymous() && !original.getName().equals(object.getName());
            for (JsObject origParent = original.getParent(); origParent != null && isOrginalReachable; origParent = origParent.getParent()) {
                if (!origParent.isAnonymous() || origParent.getParent() != null && origParent.getParent().getParent() == null) continue;
                isOrginalReachable = false;
            }
            if (isOrginalReachable) {
                processedObjects.add(object.getFullyQualifiedName());
                return true;
            }
            if (processedObjects.contains(original.getFullyQualifiedName())) {
                return true;
            }
            processedObjects.add(object.getFullyQualifiedName());
            processedObjects.add(original.getFullyQualifiedName());
        } else if (object.getJSKind() != JsElement.Kind.FILE) {
            processedObjects.add(object.getFullyQualifiedName());
        }
        return false;
    }

    public static String getFQNFromType(Type type) {
        String fqn = type.getType();
        if (fqn.startsWith("@exp;")) {
            fqn = fqn.substring("@exp;".length());
        } else if (fqn.startsWith("@pro;")) {
            fqn = fqn.substring("@pro;".length());
        }
        if (fqn.contains("@pro;")) {
            fqn = fqn.replace("@pro;", ".");
        }
        return fqn;
    }

    private static enum State {
        INIT;

    }
}

