/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.ui.breakpoints;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.ui.JSUtils;
import org.netbeans.modules.javascript2.debug.ui.breakpoints.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JSLineBreakpointCustomizerPanel
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private static final int MAX_SAVED_CONDITIONS = 10;
    private static final RequestProcessor RP = new RequestProcessor(JSLineBreakpointCustomizerPanel.class);
    private final Controller controller;
    private final JSLineBreakpoint lb;
    private boolean createBreakpoint;
    private JCheckBox conditionCheckBox;
    private JComboBox conditionComboBox;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JSeparator jSeparator1;
    private JLabel lineLabel;
    private JTextField lineTextField;

    private static JSLineBreakpoint createBreakpoint() {
        Line line = JSUtils.getCurrentLine();
        if (line == null) {
            return null;
        }
        return JSUtils.createLineBreakpoint(line);
    }

    public JSLineBreakpointCustomizerPanel() {
        this(JSLineBreakpointCustomizerPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public JSLineBreakpointCustomizerPanel(JSLineBreakpoint lb) {
        this.lb = lb;
        this.initComponents();
        this.controller = this.createController();
        if (lb != null) {
            Line line = JSUtils.getLine(lb);
            FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
            if (fo != null) {
                File file = FileUtil.toFile((FileObject)fo);
                if (file != null) {
                    this.fileTextField.setText(file.getAbsolutePath());
                } else {
                    this.fileTextField.setText(fo.toURL().toExternalForm());
                }
            }
            this.lineTextField.setText(Integer.toString(line.getLineNumber() + 1));
            Object[] conditions = JSLineBreakpointCustomizerPanel.getSavedConditions();
            this.conditionComboBox.setModel(new DefaultComboBoxModel<Object>(conditions));
            String condition = lb.getCondition();
            if (condition != null && !condition.isEmpty()) {
                this.conditionCheckBox.setSelected(true);
                this.conditionComboBox.setEnabled(true);
                this.conditionComboBox.getEditor().setItem(condition);
            } else {
                this.conditionCheckBox.setSelected(false);
                this.conditionComboBox.setEnabled(false);
            }
        }
    }

    private static Object[] getSavedConditions() {
        return Properties.getDefault().getProperties("debugger.javascript").getArray("BPConditions", new Object[0]);
    }

    private static void saveCondition(String condition) {
        Object[] savedConditions = JSLineBreakpointCustomizerPanel.getSavedConditions();
        Object[] conditions = null;
        boolean containsCondition = false;
        for (int i = 0; i < savedConditions.length; ++i) {
            Object c = savedConditions[i];
            if (!condition.equals(c)) continue;
            containsCondition = true;
            conditions = savedConditions;
            if (i <= 0) break;
            System.arraycopy(conditions, 0, conditions, 1, i);
            conditions[0] = condition;
            break;
        }
        if (!containsCondition) {
            if (savedConditions.length < 10) {
                conditions = new Object[savedConditions.length + 1];
                conditions[0] = condition;
                System.arraycopy(savedConditions, 0, conditions, 1, savedConditions.length);
            } else {
                conditions = savedConditions;
                System.arraycopy(conditions, 0, conditions, 1, conditions.length - 1);
                conditions[0] = condition;
            }
        }
        Properties.getDefault().getProperties("debugger.javascript").setArray("BPConditions", conditions);
    }

    protected Controller createController() {
        return new CustomizerController();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    protected RequestProcessor getUpdateRP() {
        return RP;
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.lineLabel = new JLabel();
        this.lineTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.conditionCheckBox = new JCheckBox();
        this.conditionComboBox = new JComboBox();
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(JSLineBreakpointCustomizerPanel.class, (String)"JSLineBreakpointCustomizerPanel.fileLabel.text"));
        this.fileTextField.setToolTipText(NbBundle.getMessage(JSLineBreakpointCustomizerPanel.class, (String)"JSLineBreakpointCustomizerPanel.fileTextField.toolTipText"));
        this.lineLabel.setLabelFor(this.lineTextField);
        Mnemonics.setLocalizedText((JLabel)this.lineLabel, (String)NbBundle.getMessage(JSLineBreakpointCustomizerPanel.class, (String)"JSLineBreakpointCustomizerPanel.lineLabel.text"));
        this.lineTextField.setToolTipText(NbBundle.getMessage(JSLineBreakpointCustomizerPanel.class, (String)"JSLineBreakpointCustomizerPanel.lineTextField.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.conditionCheckBox, (String)NbBundle.getMessage(JSLineBreakpointCustomizerPanel.class, (String)"JSLineBreakpointCustomizerPanel.conditionCheckBox.text"));
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSLineBreakpointCustomizerPanel.this.conditionCheckBoxActionPerformed(evt);
            }
        });
        this.conditionComboBox.setEditable(true);
        this.conditionComboBox.setToolTipText(NbBundle.getMessage(JSLineBreakpointCustomizerPanel.class, (String)"JSLineBreakpointCustomizerPanel.conditionComboBox.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.conditionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.conditionComboBox, 0, 330, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineLabel).addComponent(this.fileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileTextField).addComponent(this.lineTextField)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lineLabel).addComponent(this.lineTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.conditionCheckBox).addComponent(this.conditionComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void conditionCheckBoxActionPerformed(ActionEvent evt) {
        this.conditionComboBox.setEnabled(this.conditionCheckBox.isSelected());
        if (this.conditionCheckBox.isSelected()) {
            this.conditionComboBox.requestFocusInWindow();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerLineBreakpointJavaScript");
    }

    private static String toURL(String filePath) {
        URI uri = null;
        try {
            uri = URI.create(filePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uri == null || !uri.isAbsolute()) {
            File f = new File(filePath);
            uri = f.toURI();
        }
        try {
            return uri.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return filePath;
        }
    }

    private class CustomizerController
    implements Controller {
        private CustomizerController() {
        }

        public boolean ok() {
            int lineNumber;
            JSLineBreakpoint lb = JSLineBreakpointCustomizerPanel.this.lb;
            String fileStr = JSLineBreakpointCustomizerPanel.toURL(JSLineBreakpointCustomizerPanel.this.fileTextField.getText());
            try {
                lineNumber = Integer.parseInt(JSLineBreakpointCustomizerPanel.this.lineTextField.getText());
            }
            catch (NumberFormatException nfex) {
                return false;
            }
            Line line = JSUtils.getLine(fileStr, --lineNumber);
            if (line == null) {
                return false;
            }
            if (lb != null) {
                this.updateBreakpoint(line);
            } else {
                lb = JSUtils.createLineBreakpoint(line);
            }
            String condition = null;
            if (JSLineBreakpointCustomizerPanel.this.conditionCheckBox.isSelected()) {
                condition = JSLineBreakpointCustomizerPanel.this.conditionComboBox.getSelectedItem().toString().trim();
            }
            if (condition != null && !condition.isEmpty()) {
                lb.setCondition(condition);
                JSLineBreakpointCustomizerPanel.saveCondition(condition);
            } else {
                lb.setCondition(null);
            }
            if (JSLineBreakpointCustomizerPanel.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)lb);
            }
            return true;
        }

        private void updateBreakpoint(final Line line) {
            JSLineBreakpointCustomizerPanel.this.getUpdateRP().post(new Runnable(){

                @Override
                public void run() {
                    JSLineBreakpointCustomizerPanel.this.lb.setLineHandler(JSUtils.createLineHandler(line));
                }
            });
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

