/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.commands.Scripts;
import org.netbeans.modules.javascript.v8debug.Bundle;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript2.debug.sources.SourceContent;
import org.netbeans.modules.javascript2.debug.sources.SourceFilesCache;
import org.netbeans.modules.web.common.sourcemap.SourceMapsScanner;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class ScriptsHandler {
    private static final Logger LOG = Logger.getLogger(ScriptsHandler.class.getName());
    private static final int DEFAULT_FIRST_LINE_COLUMN_SHIFT = 62;
    private static final boolean USE_SOURCE_MAPS = Boolean.parseBoolean(System.getProperty("javascript.debugger.useSourceMaps", "true"));
    private final Map<Long, V8Script> scriptsById = new HashMap<Long, V8Script>();
    private final Map<URL, V8Script> scriptsByURL = new HashMap<URL, V8Script>();
    private final Map<URL, Integer> scriptsFirstLineShifts = new HashMap<URL, Integer>();
    private final boolean doPathTranslation;
    private final int numPrefixes;
    @NullAllowed
    private final String[] localPathPrefixes;
    private final char localPathSeparator;
    @NullAllowed
    private final FileObject[] localRoots;
    @NullAllowed
    private final FileObject[] localPathExclusionFilters;
    @NullAllowed
    private final String[] serverPathPrefixes;
    private final char serverPathSeparator;
    private final String remotePathPrefix;
    private final V8Debugger dbg;
    private final SourceMapsTranslator smt;

    ScriptsHandler(@NullAllowed List<String> localPaths, @NullAllowed List<String> serverPaths, Collection<String> localPathExclusionFilters, @NullAllowed V8Debugger dbg) {
        FileObject localRoot;
        int i;
        this.remotePathPrefix = dbg != null ? dbg.getHost() + "_" + dbg.getPort() + "/" : "";
        if (!localPaths.isEmpty() && !serverPaths.isEmpty()) {
            int n;
            this.doPathTranslation = true;
            this.numPrefixes = n = localPaths.size();
            this.localPathPrefixes = new String[n];
            this.serverPathPrefixes = new String[n];
            for (i = 0; i < n; ++i) {
                this.localPathPrefixes[i] = ScriptsHandler.stripSeparator(localPaths.get(i));
            }
            this.localPathSeparator = ScriptsHandler.findSeparator(localPaths.get(0));
            for (i = 0; i < n; ++i) {
                this.serverPathPrefixes[i] = ScriptsHandler.stripSeparator(serverPaths.get(i));
            }
            this.serverPathSeparator = ScriptsHandler.findSeparator(serverPaths.get(0));
        } else {
            this.doPathTranslation = false;
            this.serverPathPrefixes = null;
            this.localPathPrefixes = null;
            this.serverPathSeparator = '\u0000';
            this.localPathSeparator = '\u0000';
            this.numPrefixes = 0;
        }
        if (!localPaths.isEmpty()) {
            FileObject[] lroots = new FileObject[localPaths.size()];
            i = 0;
            for (String localPath : localPaths) {
                localRoot = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(localPath)));
                if (localRoot == null) continue;
                lroots[i++] = localRoot;
            }
            if (i < localPaths.size()) {
                lroots = Arrays.copyOf(lroots, i);
            }
            this.localRoots = lroots;
            this.smt = USE_SOURCE_MAPS ? SourceMapsScanner.getInstance().scan(this.localRoots) : null;
        } else {
            this.localRoots = null;
            this.smt = USE_SOURCE_MAPS ? SourceMapsTranslator.create() : null;
        }
        if (!localPathExclusionFilters.isEmpty()) {
            FileObject[] lpefs = new FileObject[localPathExclusionFilters.size()];
            i = 0;
            for (String lpef : localPathExclusionFilters) {
                localRoot = FileUtil.toFileObject((File)new File(lpef));
                if (localRoot != null) {
                    lpefs[i++] = localRoot;
                    continue;
                }
                lpefs = Arrays.copyOf(lpefs, lpefs.length - 1);
            }
            this.localPathExclusionFilters = lpefs.length > 0 ? lpefs : null;
        } else {
            this.localPathExclusionFilters = null;
        }
        LOG.log(Level.FINE, "ScriptsHandler: doPathTranslation = {0}, localPathPrefixes = {1}, separator = {2}, serverPathPrefixes = {3}, separator = {4}, localRoots = {5}, localPathExclusionFilters = {6}.", new Object[]{this.doPathTranslation, Arrays.toString(this.localPathPrefixes), Character.valueOf(this.localPathSeparator), Arrays.toString(this.serverPathPrefixes), Character.valueOf(this.serverPathSeparator), Arrays.toString(this.localRoots), Arrays.toString(this.localPathExclusionFilters)});
        this.dbg = dbg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(V8Script script) {
        Map<Long, V8Script> map = this.scriptsById;
        synchronized (map) {
            this.scriptsById.put(script.getId(), script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(V8Script[] scripts) {
        Map<Long, V8Script> map = this.scriptsById;
        synchronized (map) {
            for (V8Script script : scripts) {
                this.scriptsById.put(script.getId(), script);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(long scriptId) {
        V8Script removed;
        Map<Long, V8Script> map = this.scriptsById;
        synchronized (map) {
            removed = this.scriptsById.remove(scriptId);
        }
        if (removed != null) {
            URL removedURL = null;
            Map<URL, Object> map2 = this.scriptsByURL;
            synchronized (map2) {
                for (Map.Entry<URL, V8Script> entry : this.scriptsByURL.entrySet()) {
                    if (removed != entry.getValue()) continue;
                    removedURL = entry.getKey();
                    this.scriptsByURL.remove(removedURL);
                    break;
                }
            }
            if (removedURL != null) {
                map2 = this.scriptsFirstLineShifts;
                synchronized (map2) {
                    this.scriptsFirstLineShifts.remove(removedURL);
                }
            }
        }
    }

    @CheckForNull
    public SourceMapsTranslator getSourceMapsTranslator() {
        return this.smt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public V8Script getScript(long id) {
        Map<Long, V8Script> map = this.scriptsById;
        synchronized (map) {
            return this.scriptsById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<V8Script> getScripts() {
        Map<Long, V8Script> map = this.scriptsById;
        synchronized (map) {
            return new ArrayList<V8Script>(this.scriptsById.values());
        }
    }

    public boolean containsLocalFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        if ("js-scripts".equals(fo.toURL().getProtocol())) {
            return true;
        }
        if (this.localPathExclusionFilters != null) {
            for (FileObject lpef : this.localPathExclusionFilters) {
                if (!FileUtil.isParentOf((FileObject)lpef, (FileObject)fo)) continue;
                return false;
            }
        }
        if (this.localRoots == null) {
            return true;
        }
        for (FileObject localRoot : this.localRoots) {
            if (!FileUtil.isParentOf((FileObject)localRoot, (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRemoteFile(URL url) {
        int index;
        String path;
        if (!"js-scripts".equals(url.getProtocol())) {
            return false;
        }
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException usex) {
            return false;
        }
        int l = path.length();
        for (index = 0; index < l && path.charAt(index) == '/'; ++index) {
        }
        int begin = path.indexOf(47, index);
        if (begin > 0) {
            return path.regionMatches(begin + 1, this.remotePathPrefix, 0, this.remotePathPrefix.length());
        }
        return false;
    }

    @CheckForNull
    public FileObject getFile(long scriptId) {
        V8Script script = this.getScript(scriptId);
        if (script == null) {
            return null;
        }
        return this.getFile(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FileObject getFile(@NonNull V8Script script) {
        String name = script.getName();
        if (name != null && script.getScriptType() == V8Script.Type.NORMAL) {
            FileObject fo;
            File localFile = null;
            if (this.doPathTranslation) {
                try {
                    String lp = this.getLocalPath(name);
                    localFile = new File(lp);
                }
                catch (OutOfScope lp) {}
            } else {
                File f = new File(name);
                if (f.isAbsolute()) {
                    localFile = f;
                }
            }
            if (localFile != null && (fo = FileUtil.toFileObject(localFile)) != null) {
                Map<URL, V8Script> map = this.scriptsByURL;
                synchronized (map) {
                    this.scriptsByURL.put(fo.toURL(), script);
                }
                return fo;
            }
        }
        if (name == null) {
            name = "unknown.js";
        }
        name = this.remotePathPrefix + name;
        String content = script.getSource();
        URL sourceURL = content != null ? SourceFilesCache.getDefault().getSourceFile(name, content.hashCode(), content) : SourceFilesCache.getDefault().getSourceFile(name, 1234, (SourceContent)new ScriptContentLoader(script, this.dbg));
        Map<URL, V8Script> map = this.scriptsByURL;
        synchronized (map) {
            this.scriptsByURL.put(sourceURL, script);
        }
        return URLMapper.findFileObject((URL)sourceURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public V8Script findScript(@NonNull URL scriptURL) {
        Map<URL, V8Script> map = this.scriptsByURL;
        synchronized (map) {
            return this.scriptsByURL.get(scriptURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScriptFirstLineColumnShift(FileObject fo) {
        URL url = fo.toURL();
        if ("js-scripts".equals(url.getProtocol())) {
            return 62;
        }
        Integer shift = null;
        Map<URL, Integer> map = this.scriptsFirstLineShifts;
        synchronized (map) {
            shift = this.scriptsFirstLineShifts.get(url);
        }
        if (shift == null) {
            V8Script script = this.findScript(url);
            if (script == null) {
                return 62;
            }
            String ss = script.getSourceStart();
            String firstLine = null;
            try {
                List lines = fo.asLines();
                Iterator linesIterator = lines.iterator();
                if (linesIterator.hasNext()) {
                    firstLine = (String)linesIterator.next();
                }
            }
            catch (IOException lines) {
                // empty catch block
            }
            if (firstLine == null) {
                shift = 0;
            } else {
                shift = ScriptsHandler.findOffsetIn(ss, firstLine);
                if (shift < 0) {
                    String content = script.getSource();
                    if (content == null) {
                        try {
                            content = new ScriptContentLoader(script, this.dbg).getContent();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    shift = content != null ? Integer.valueOf(ScriptsHandler.findOffsetIn(content, firstLine)) : Integer.valueOf(62);
                }
            }
            Map<URL, Integer> map2 = this.scriptsFirstLineShifts;
            synchronized (map2) {
                this.scriptsFirstLineShifts.put(url, shift);
            }
        }
        return shift;
    }

    private static int findOffsetIn(String container, String text) {
        int rIndex;
        int nc = container.length();
        int nIndex = container.indexOf(10);
        if (nIndex < 0) {
            nIndex = nc;
        }
        if ((rIndex = container.indexOf(13)) < 0) {
            rIndex = nc;
        }
        if ((nc = Math.min(nIndex, rIndex)) < container.length()) {
            container = container.substring(0, nc);
        }
        if (text.startsWith(container)) {
            return 0;
        }
        int nt = text.length();
        for (int ic = 0; ic < nc; ++ic) {
            char t;
            char c;
            int ict;
            int it = 0;
            for (ict = ic; it < nt && ict < nc && (c = container.charAt(ict)) == (t = text.charAt(it)); ++it, ++ict) {
            }
            if (ict != nc) continue;
            return ic;
        }
        return -1;
    }

    @CheckForNull
    public String getServerPath(@NonNull FileObject fo) {
        String serverPath;
        File file = FileUtil.toFile((FileObject)fo);
        if (file != null) {
            String localPath = file.getAbsolutePath();
            try {
                serverPath = this.getServerPath(localPath);
            }
            catch (OutOfScope oos) {
                serverPath = null;
            }
        } else {
            String path;
            int begin;
            URL url = fo.toURL();
            V8Script script = this.findScript(url);
            serverPath = script != null ? script.getName() : ("js-scripts".equals(url.getProtocol()) ? ((begin = (path = fo.getPath()).indexOf(47)) > 0 ? ((path = path.substring(begin + 1)).startsWith(this.remotePathPrefix) ? path.substring(this.remotePathPrefix.length()) : null) : null) : null);
        }
        return serverPath;
    }

    @CheckForNull
    public String getServerPath(@NonNull URL url) {
        int index;
        String path;
        if (!"js-scripts".equals(url.getProtocol())) {
            return null;
        }
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException usex) {
            return null;
        }
        int l = path.length();
        for (index = 0; index < l && path.charAt(index) == '/'; ++index) {
        }
        int begin = path.indexOf(47, index);
        if (begin > 0) {
            if (path.regionMatches(begin + 1, this.remotePathPrefix, 0, this.remotePathPrefix.length())) {
                path = path.substring(begin + 1 + this.remotePathPrefix.length());
                return path;
            }
            return null;
        }
        return null;
    }

    public String getLocalPath(@NonNull String serverPath) throws OutOfScope {
        if (!this.doPathTranslation) {
            return serverPath;
        }
        for (int i = 0; i < this.numPrefixes; ++i) {
            if (!ScriptsHandler.isChildOf(this.serverPathPrefixes[i], serverPath)) continue;
            return ScriptsHandler.translate(serverPath, this.serverPathPrefixes[i], this.serverPathSeparator, this.localPathPrefixes[i], this.localPathSeparator);
        }
        throw new OutOfScope(serverPath, Arrays.toString(this.serverPathPrefixes));
    }

    public String getServerPath(@NonNull String localPath) throws OutOfScope {
        if (!this.doPathTranslation) {
            return localPath;
        }
        for (int i = 0; i < this.numPrefixes; ++i) {
            if (!ScriptsHandler.isChildOf(this.localPathPrefixes[i], localPath)) continue;
            return ScriptsHandler.translate(localPath, this.localPathPrefixes[i], this.localPathSeparator, this.serverPathPrefixes[i], this.serverPathSeparator);
        }
        throw new OutOfScope(localPath, Arrays.toString(this.localPathPrefixes));
    }

    public File[] getLocalRoots() {
        if (this.localRoots == null) {
            return new File[0];
        }
        int l = this.localRoots.length;
        File[] roots = new File[l];
        for (int i = 0; i < l; ++i) {
            roots[i] = FileUtil.toFile((FileObject)this.localRoots[i]);
        }
        return roots;
    }

    private static boolean isChildOf(String parent, String child) {
        if (!child.startsWith(parent)) {
            return false;
        }
        int l = parent.length();
        return ScriptsHandler.isRootPath(parent) || child.length() <= l || ScriptsHandler.isSeparator(child.charAt(l));
    }

    private static String translate(String path, String pathPrefix, char pathSeparator, String otherPathPrefix, char otherPathSeparator) throws OutOfScope {
        int l;
        if (!path.startsWith(pathPrefix)) {
            throw new OutOfScope(path, pathPrefix);
        }
        if (!ScriptsHandler.isRootPath(pathPrefix) && path.length() > l && !ScriptsHandler.isSeparator(path.charAt(l))) {
            throw new OutOfScope(path, pathPrefix);
        }
        for (l = pathPrefix.length(); path.length() > l && ScriptsHandler.isSeparator(path.charAt(l)); ++l) {
        }
        String otherPath = path.substring(l);
        if (pathSeparator != otherPathSeparator) {
            otherPath = otherPath.replace(pathSeparator, otherPathSeparator);
        }
        if (otherPath.isEmpty()) {
            return otherPathPrefix;
        }
        if (ScriptsHandler.isRootPath(otherPathPrefix)) {
            return otherPathPrefix + otherPath;
        }
        return otherPathPrefix + otherPathSeparator + otherPath;
    }

    private static char findSeparator(String path) {
        if (path.indexOf(47) >= 0) {
            return '/';
        }
        if (path.indexOf(92) >= 0) {
            return '\\';
        }
        return '/';
    }

    private static boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    private static String stripSeparator(String path) {
        if (ScriptsHandler.isRootPath(path)) {
            return path;
        }
        while (path.length() > 1 && (path.endsWith("/") || path.endsWith("\\"))) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static boolean isRootPath(String path) {
        if ("/".equals(path)) {
            return true;
        }
        return path.length() == 4 && path.endsWith(":\\\\");
    }

    private static final class ScriptContentLoader
    implements SourceContent,
    V8Debugger.CommandResponseCallback {
        private final V8Script script;
        private final V8Debugger dbg;
        private String content;
        private final Object contentLock = new Object();
        private String contentLoadError;

        public ScriptContentLoader(V8Script script, V8Debugger dbg) {
            this.script = script;
            this.dbg = dbg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContent() throws IOException {
            if (this.content != null) {
                return this.content;
            }
            V8Script.Type st = this.script.getScriptType();
            V8Script.Types types = new V8Script.Types(V8Script.Type.NATIVE == st, V8Script.Type.EXTENSION == st, V8Script.Type.NORMAL == st);
            Scripts.Arguments sa = new Scripts.Arguments(types, new long[]{this.script.getId()}, Boolean.valueOf(true), null);
            V8Request request = this.dbg.sendCommandRequest(V8Command.Scripts, (V8Arguments)sa, this);
            if (request == null) {
                throw new IOException(Bundle.ERR_NoSourceRequest());
            }
            Object object = this.contentLock;
            synchronized (object) {
                if (this.content == null && this.contentLoadError == null) {
                    try {
                        this.contentLock.wait();
                    }
                    catch (InterruptedException iex) {
                        throw new IOException(Bundle.ERR_Interrupted(), iex);
                    }
                }
                if (this.contentLoadError != null) {
                    throw new IOException(this.contentLoadError);
                }
                return this.content;
            }
        }

        public long getLength() {
            return this.script.getSourceLength().getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyResponse(V8Request request, V8Response response) {
            V8Script[] scripts;
            if (response != null) {
                Scripts.ResponseBody srb = (Scripts.ResponseBody)response.getBody();
                scripts = srb.getScripts();
            } else {
                scripts = null;
            }
            Object object = this.contentLock;
            synchronized (object) {
                if (scripts == null || scripts.length == 0) {
                    this.contentLoadError = Bundle.ERR_ScriptFailedToLoad();
                } else {
                    String source = scripts[0].getSource();
                    if (source == null) {
                        this.contentLoadError = Bundle.ERR_ScriptHasNoSource();
                    } else {
                        this.content = source;
                    }
                }
                this.contentLock.notifyAll();
            }
        }
    }

    public static final class OutOfScope
    extends Exception {
        private OutOfScope(String path, String scope) {
            super(path);
        }
    }
}

