/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.libraries;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NpmExecutable;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Bundle;
import org.netbeans.modules.javascript.nodejs.ui.libraries.DependenciesPanel;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Dependency;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Library;
import org.netbeans.modules.javascript.nodejs.ui.libraries.LibraryProvider;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class LibrariesPanel
extends JPanel
implements HelpCtx.Provider {
    private static final RequestProcessor RP = new RequestProcessor(LibrariesPanel.class);
    private final Project project;
    private Map<String, String> installedLibraries;
    private DependenciesPanel[] dependencyPanels;
    private ProgressHandle progressHandle;
    private boolean logLibraryUsage;
    private static final UsageLogger USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.javascript.nodejs").message(LibrariesPanel.class, "USG_NPM_LIBRARY_EDIT").create();
    private JPanel buttonPanel;
    private JButton configureButton;
    private DependenciesPanel developmentPanel;
    private JLabel loadingLabel;
    private JLabel npmProblemLabel;
    private JPanel npmProblemPanel;
    private DependenciesPanel optionalPanel;
    private JLabel packageJsonProblemLabel;
    private DependenciesPanel regularPanel;
    private JButton retryButton;
    private JTabbedPane tabbedPane;

    public LibrariesPanel(Project project) {
        this.project = project;
        this.initComponents();
        PackageJson packageJson = this.getPackageJson();
        if (packageJson.exists()) {
            this.dependencyPanels = new DependenciesPanel[]{this.regularPanel, this.developmentPanel, this.optionalPanel};
            this.regularPanel.setDependencyType(Dependency.Type.REGULAR);
            this.developmentPanel.setDependencyType(Dependency.Type.DEVELOPMENT);
            this.optionalPanel.setDependencyType(Dependency.Type.OPTIONAL);
            PackageJson.NpmDependencies npmDependencies = packageJson.getDependencies();
            DependenciesPanel.Dependencies dependencies = new DependenciesPanel.Dependencies(npmDependencies);
            for (DependenciesPanel dependencyPanel : this.dependencyPanels) {
                dependencyPanel.setProject(project);
                dependencyPanel.setDependencies(dependencies);
            }
            this.loadInstalledLibraries();
        } else {
            this.show(this.packageJsonProblemLabel);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.nodejs.ui.libraries.LibrariesPanel");
    }

    private void show(Component component) {
        assert (EventQueue.isDispatchThread());
        GroupLayout layout = (GroupLayout)this.getLayout();
        Component currentComponent = this.getComponent(0);
        layout.replace(currentComponent, component);
    }

    ActionListener createStoreListener() {
        return new StoreListener();
    }

    private PackageJson getPackageJson() {
        NodeJsSupport nodeJsSupport = (NodeJsSupport)this.project.getLookup().lookup(NodeJsSupport.class);
        if (nodeJsSupport != null) {
            return nodeJsSupport.getPackageJson();
        }
        return new PackageJson(this.project.getProjectDirectory());
    }

    static List<Library.Version> toLibraries(Map<String, String> map) {
        ArrayList<Library.Version> libraries = new ArrayList<Library.Version>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Library library = new Library(entry.getKey());
            Library.Version version = new Library.Version(library, entry.getValue());
            libraries.add(version);
        }
        return libraries;
    }

    private void loadInstalledLibraries() {
        this.show(this.loadingLabel);
        RP.post(new Runnable(){

            @Override
            public void run() {
                LibraryProvider provider = LibraryProvider.forProject(LibrariesPanel.this.project);
                LibrariesPanel.this.installedLibraries = provider.installedLibraries();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LibrariesPanel.this.installedLibraries == null) {
                            LibrariesPanel.this.show(LibrariesPanel.this.npmProblemPanel);
                        } else {
                            LibrariesPanel.this.regularPanel.setInstalledLibraries(LibrariesPanel.this.installedLibraries);
                            LibrariesPanel.this.developmentPanel.setInstalledLibraries(LibrariesPanel.this.installedLibraries);
                            LibrariesPanel.this.optionalPanel.setInstalledLibraries(LibrariesPanel.this.installedLibraries);
                            LibrariesPanel.this.show(LibrariesPanel.this.tabbedPane);
                        }
                    }
                });
            }
        });
    }

    void storeChanges() {
        if (this.installedLibraries == null) {
            return;
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LibrariesPanel.this.progressHandle = ProgressHandle.createHandle((String)Bundle.LibrariesPanel_updatingPackages());
                LibrariesPanel.this.progressHandle.start();
                LibrariesPanel.this.logLibraryUsage = false;
                try {
                    PackageJson packageJson = LibrariesPanel.this.getPackageJson();
                    if (packageJson.exists()) {
                        Dependency.Type dependencyType;
                        PackageJson.NpmDependencies dependencies = packageJson.getDependencies();
                        ArrayList errors = new ArrayList();
                        for (DependenciesPanel dependencyPanel : LibrariesPanel.this.dependencyPanels) {
                            dependencyType = dependencyPanel.getDependencyType();
                            LibrariesPanel.this.uninstallDependencies(LibrariesPanel.this.getPackageJsonDependencies(dependencies, dependencyType), dependencyPanel.getSelectedDependencies(), dependencyType, errors);
                        }
                        for (DependenciesPanel dependencyPanel : LibrariesPanel.this.dependencyPanels) {
                            dependencyType = dependencyPanel.getDependencyType();
                            LibrariesPanel.this.installDependencies(dependencyPanel.getSelectedDependencies(), dependencyType, errors);
                        }
                        LibrariesPanel.this.progressHandle.progress(Bundle.LibrariesPanel_updatingPackageJson());
                        packageJson.refresh();
                        for (DependenciesPanel dependencyPanel : LibrariesPanel.this.dependencyPanels) {
                            dependencyType = dependencyPanel.getDependencyType();
                            LibrariesPanel.this.updatePackageJson(dependencyPanel.getSelectedDependencies(), dependencyType, errors);
                        }
                        LibrariesPanel.this.reportErrors(errors);
                        if (LibrariesPanel.this.logLibraryUsage) {
                            LibrariesPanel.this.logLibraryUsage();
                        }
                    }
                }
                finally {
                    LibrariesPanel.this.progressHandle.finish();
                    LibrariesPanel.this.progressHandle = null;
                }
            }
        });
    }

    private Map<String, String> getPackageJsonDependencies(PackageJson.NpmDependencies dependencies, Dependency.Type dependencyType) {
        Map<String, String> map;
        switch (dependencyType) {
            case REGULAR: {
                map = dependencies.dependencies;
                break;
            }
            case DEVELOPMENT: {
                map = dependencies.devDependencies;
                break;
            }
            case OPTIONAL: {
                map = dependencies.optionalDependencies;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return map;
    }

    private String getSaveParameter(Dependency.Type dependencyType) {
        String saveParameter;
        switch (dependencyType) {
            case REGULAR: {
                saveParameter = "--save";
                break;
            }
            case DEVELOPMENT: {
                saveParameter = "--save-dev";
                break;
            }
            case OPTIONAL: {
                saveParameter = "--save-optional";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return saveParameter;
    }

    private String getPackageJsonSection(Dependency.Type dependencyType) {
        String section;
        switch (dependencyType) {
            case REGULAR: {
                section = "dependencies";
                break;
            }
            case DEVELOPMENT: {
                section = "devDependencies";
                break;
            }
            case OPTIONAL: {
                section = "optionalDependencies";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return section;
    }

    private void reportErrors(List<String> errors) {
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (String error : errors) {
                if (message.length() != 0) {
                    message.append('\n');
                }
                message.append(error);
            }
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message.toString(), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
        }
    }

    private void uninstallDependencies(Map<String, String> originalDependencies, List<Dependency> selectedDependencies, Dependency.Type dependencyType, List<String> errors) {
        NpmExecutable executable = NpmExecutable.getDefault(this.project, false);
        if (executable != null) {
            HashSet<String> selectedSet = new HashSet<String>();
            for (Dependency dependency : selectedDependencies) {
                selectedSet.add(dependency.getName());
            }
            String saveParameter = this.getSaveParameter(dependencyType);
            for (String name : originalDependencies.keySet()) {
                if (selectedSet.contains(name)) continue;
                this.progressHandle.progress(Bundle.LibrariesPanel_uninstallingPackage(name));
                this.installedLibraries.remove(name);
                Integer result = null;
                try {
                    Future<Integer> future = executable.uninstall(saveParameter, name);
                    if (future != null) {
                        result = future.get();
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    Logger.getLogger(LibrariesPanel.class.getName()).log(Level.INFO, null, ex);
                }
                if (result == null || result != 0) {
                    errors.add(Bundle.LibrariesPanel_uninstallationFailed(name));
                }
                this.logLibraryUsage = true;
            }
        }
    }

    private void installDependencies(List<Dependency> selectedDependencies, Dependency.Type dependencyType, List<String> errors) {
        NpmExecutable executable = NpmExecutable.getDefault(this.project, false);
        if (executable != null) {
            for (Dependency dependency : selectedDependencies) {
                String name = dependency.getName();
                String versionToInstall = dependency.getInstalledVersion();
                String installedVersion = this.installedLibraries.get(name);
                if (versionToInstall == null || versionToInstall.equals(installedVersion)) continue;
                this.progressHandle.progress(Bundle.LibrariesPanel_installingPackage(name, versionToInstall));
                Integer result = null;
                try {
                    String saveParameter = this.getSaveParameter(dependencyType);
                    Future<Integer> future = executable.install(saveParameter, name + "@" + versionToInstall);
                    if (future != null) {
                        result = future.get();
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    Logger.getLogger(LibrariesPanel.class.getName()).log(Level.INFO, null, ex);
                }
                if (result == null || result != 0) {
                    errors.add(Bundle.LibrariesPanel_installationFailed(name, versionToInstall));
                }
                this.logLibraryUsage = true;
            }
        }
    }

    private void updatePackageJson(List<Dependency> selectedDependencies, Dependency.Type dependencyType, List<String> errors) {
        PackageJson packageJson = this.getPackageJson();
        if (packageJson.exists()) {
            String section = this.getPackageJsonSection(dependencyType);
            Map<String, String> currentDependencies = this.getPackageJsonDependencies(packageJson.getDependencies(), dependencyType);
            for (Dependency dependency : selectedDependencies) {
                String name = dependency.getName();
                String currentRequiredVersion = currentDependencies.get(name);
                String newRequiredVersion = dependency.getRequiredVersion();
                if (newRequiredVersion.equals(currentRequiredVersion)) continue;
                try {
                    packageJson.setContent(Arrays.asList(section, name), newRequiredVersion);
                }
                catch (IOException ioex) {
                    Logger.getLogger(LibrariesPanel.class.getName()).log(Level.INFO, null, ioex);
                    errors.add(Bundle.LibrariesPanel_dependencyNotSet(name, newRequiredVersion));
                }
                this.logLibraryUsage = true;
            }
        }
    }

    private void logLibraryUsage() {
        USAGE_LOGGER.log(new Object[0]);
    }

    private void initComponents() {
        this.packageJsonProblemLabel = new JLabel();
        this.npmProblemPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.configureButton = new JButton();
        this.retryButton = new JButton();
        this.npmProblemLabel = new JLabel();
        this.loadingLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.regularPanel = new DependenciesPanel();
        this.developmentPanel = new DependenciesPanel();
        this.optionalPanel = new DependenciesPanel();
        this.packageJsonProblemLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.packageJsonProblemLabel, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.packageJsonProblemLabel.text"));
        this.packageJsonProblemLabel.setEnabled(false);
        this.packageJsonProblemLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.configureButton, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.configureButton.text"));
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesPanel.this.configureButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.retryButton, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.retryButton.text"));
        this.retryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesPanel.this.retryButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addComponent(this.configureButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.retryButton)));
        buttonPanelLayout.linkSize(0, this.configureButton, this.retryButton);
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configureButton).addComponent(this.retryButton)));
        Mnemonics.setLocalizedText((JLabel)this.npmProblemLabel, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.npmProblemLabel.text"));
        GroupLayout npmProblemPanelLayout = new GroupLayout(this.npmProblemPanel);
        this.npmProblemPanel.setLayout(npmProblemPanelLayout);
        npmProblemPanelLayout.setHorizontalGroup(npmProblemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(npmProblemPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(npmProblemPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.npmProblemLabel).addComponent(this.buttonPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        npmProblemPanelLayout.setVerticalGroup(npmProblemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(npmProblemPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.npmProblemLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.loadingLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.loadingLabel, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.loadingLabel.text"));
        this.loadingLabel.setEnabled(false);
        this.loadingLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.tabbedPane.addTab(NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.regularPanel.TabConstraints.tabTitle"), this.regularPanel);
        this.tabbedPane.addTab(NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.developmentPanel.TabConstraints.tabTitle"), this.developmentPanel);
        this.tabbedPane.addTab(NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.optionalPanel.TabConstraints.tabTitle"), this.optionalPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, GroupLayout.Alignment.TRAILING));
    }

    private void configureButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Html5/NodeJs");
    }

    private void retryButtonActionPerformed(ActionEvent evt) {
        this.loadInstalledLibraries();
    }

    private class StoreListener
    implements ActionListener {
        private StoreListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibrariesPanel.this.storeChanges();
        }
    }
}

