/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.preferences;

import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.preferences.Bundle;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.javascript.nodejs.util.ValidationUtils;
import org.netbeans.modules.web.common.api.ValidationResult;

public final class NodeJsPreferencesValidator {
    private static final String START_FILE = "start.file";
    private static final String DEBUG_PORT = "debug.port";
    private final ValidationResult result = new ValidationResult();

    public static String getCustomizerCategory(ValidationResult result) {
        assert (!result.isFaultless()) : result.getFirstErrorMessage() + " + " + result.getFirstWarningMessage();
        ArrayList messages = new ArrayList();
        messages.addAll(result.getErrors());
        messages.addAll(result.getWarnings());
        for (ValidationResult.Message message : messages) {
            switch (message.getSource().toString()) {
                case "node.path": 
                case "node.sources.path": 
                case "debug.port": {
                    return "NodeJs";
                }
                case "start.file": {
                    return "RUN";
                }
            }
            assert (false) : "Unknown validation source: " + message.getSource().toString();
        }
        assert (false);
        return "NodeJs";
    }

    public ValidationResult getResult() {
        return this.result;
    }

    public NodeJsPreferencesValidator validate(Project project, boolean validateNodeSources) {
        NodeJsPreferences preferences = NodeJsSupport.forProject(project).getPreferences();
        if (!preferences.isEnabled()) {
            return this;
        }
        this.validateNode(preferences.isDefaultNode(), preferences.getNode(), validateNodeSources ? preferences.getNodeSources() : null);
        return this;
    }

    public NodeJsPreferencesValidator validateNode(String node) {
        ValidationUtils.validateNode(this.result, node);
        return this;
    }

    public NodeJsPreferencesValidator validateCustomizer(boolean enabled, boolean defaultNode, String node, String nodeSources, int debugPort) {
        if (!enabled) {
            return this;
        }
        this.validateNode(defaultNode, node, nodeSources);
        this.validateDebugPort(debugPort);
        return this;
    }

    public NodeJsPreferencesValidator validateRun(String startFile, String args) {
        String warning = FileUtils.validateFile(Bundle.NodeJsPreferencesValidator_startFile_name(), startFile, false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)START_FILE, warning));
        }
        return this;
    }

    public NodeJsPreferencesValidator validateDebugPort(int debugPort) {
        if (debugPort < 0 || debugPort > 65535) {
            this.result.addWarning(new ValidationResult.Message((Object)DEBUG_PORT, Bundle.NodeJsPreferencesValidator_debugPort_invalid()));
        }
        return this;
    }

    private void validateNode(boolean defaultNode, String node, String nodeSources) {
        if (defaultNode) {
            return;
        }
        ValidationUtils.validateNode(this.result, node);
        ValidationUtils.validateNodeSources(this.result, nodeSources);
    }
}

