/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.javascript.karma.exec.KarmaExecutable;
import org.netbeans.modules.javascript.karma.util.FileUtils;
import org.openide.util.NbPreferences;

public final class KarmaOptions {
    private static final String KARMA_PATH = "karma.path";
    private static final String PREFERENCES_PATH = "karma";
    private static final KarmaOptions INSTANCE = new KarmaOptions();
    private final Preferences preferences = NbPreferences.forModule(KarmaOptions.class).node("karma");
    private volatile boolean karmaSearched = false;

    private KarmaOptions() {
    }

    public static KarmaOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getKarma() {
        String path = this.preferences.get(KARMA_PATH, null);
        if (path == null && !this.karmaSearched) {
            this.karmaSearched = true;
            List<String> files = FileUtils.findFileOnUsersPath(KarmaExecutable.KARMA_NAME);
            if (!files.isEmpty()) {
                path = files.get(0);
                this.setKarma(path);
            }
        }
        return path;
    }

    public void setKarma(String karma) {
        this.preferences.put(KARMA_PATH, karma);
    }
}

