/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.libs.jstestdriver.api.JsTestDriver;
import org.netbeans.libs.jstestdriver.api.ServerListener;
import org.netbeans.libs.jstestdriver.api.TestListener;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.gsf.testrunner.ui.api.TestRunnerNodeFactory;
import org.netbeans.modules.javascript.jstestdriver.Bundle;
import org.netbeans.modules.javascript.jstestdriver.JSTestDriverCustomizerPanel;
import org.netbeans.modules.javascript.jstestdriver.TestDriverServiceNode;
import org.netbeans.modules.javascript.jstestdriver.ui.nodes.JSTestDriverTestRunnerNodeFactory;
import org.netbeans.modules.javascript.jstestdriver.ui.nodes.JumpToCallStackAction;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.browser.api.WebBrowserPane;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.LifecycleManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class JSTestDriverSupport {
    private static JSTestDriverSupport def;
    private static final Logger LOGGER;
    private static final Logger USG_LOGGER;
    private RequestProcessor RP = new RequestProcessor("js-test-driver server", 5);
    private AbstractLookup projectContext;
    private InstanceContent lookupContent = new InstanceContent();
    private List<WebBrowserPane> integratedBrowserPanes;
    private JsTestDriver testDriver;
    private volatile boolean starting = false;

    public static synchronized JSTestDriverSupport getDefault() {
        if (def == null) {
            def = new JSTestDriverSupport();
        }
        return def;
    }

    private JSTestDriverSupport() {
        this.projectContext = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
    }

    private synchronized JsTestDriver getJsTestDriver() {
        if (this.testDriver == null) {
            if (!this.isConfiguredProperly()) {
                return null;
            }
            String jsTestDriverJar = JSTestDriverCustomizerPanel.getJSTestDriverJar();
            File f = new File(jsTestDriverJar);
            try {
                this.testDriver = new JsTestDriver(f);
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.INFO, "cannot access js-test-driver wrapper", ex);
                return null;
            }
        }
        return this.testDriver;
    }

    public String getUserDescription() {
        if (JSTestDriverCustomizerPanel.getPort() == -1) {
            return NbBundle.getMessage(JSTestDriverSupport.class, (String)"SERVER_EXTERNAL", (Object)JSTestDriverCustomizerPanel.getServerURL());
        }
        if (this.wasStartedExternally()) {
            return NbBundle.getMessage(JSTestDriverSupport.class, (String)"SERVER_EXTERNAL2", (Object)JSTestDriverCustomizerPanel.getPort());
        }
        if (this.isRunning()) {
            return NbBundle.getMessage(JSTestDriverSupport.class, (String)"SERVER_RUNNING", (Object)JSTestDriverCustomizerPanel.getServerURL());
        }
        return NbBundle.getMessage(JSTestDriverSupport.class, (String)"SERVER_NOT_RUNNING");
    }

    boolean isRunning() {
        return this.testDriver != null && this.testDriver.isRunning();
    }

    void forgetCurrentServer() {
        this.testDriver = null;
    }

    public boolean wasStartedExternally() {
        return this.testDriver != null && this.testDriver.wasStartedExternally();
    }

    public boolean isStarting() {
        return this.starting;
    }

    public void stop() {
        assert (this.isRunning());
        assert (this.testDriver != null);
        this.testDriver.stopServer();
        TestDriverServiceNode.getInstance().refresh();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
            Thread.currentThread().interrupt();
        }
        if (this.integratedBrowserPanes != null) {
            for (WebBrowserPane wbp : this.integratedBrowserPanes) {
                wbp.close(true);
            }
        }
    }

    public void start(final ServerListener l) {
        assert (!this.isRunning());
        JsTestDriver td = this.getJsTestDriver();
        if (td == null && this.configure()) {
            td = this.getJsTestDriver();
        }
        if (td == null) {
            return;
        }
        final JsTestDriver td2 = td;
        this.starting = true;
        TestDriverServiceNode.getInstance().refresh();
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    td2.startServer(JSTestDriverCustomizerPanel.getPort(), JSTestDriverCustomizerPanel.isStricModel(), new ServerListener(){

                        public void serverStarted() {
                            JSTestDriverSupport.this.RP.post(new Runnable(){

                                @Override
                                public void run() {
                                    JSTestDriverSupport.this.captureBrowsers();
                                    if (l != null) {
                                        l.serverStarted();
                                    }
                                    JSTestDriverSupport.this.starting = false;
                                    TestDriverServiceNode.getInstance().refresh();
                                    JSTestDriverSupport.logUsage(JSTestDriverSupport.class, "USG_JSTESTDRIVER_STARTED", null);
                                }
                            });
                        }
                    });
                    if (td2.wasStartedExternally()) {
                        JSTestDriverSupport.this.starting = false;
                        TestDriverServiceNode.getInstance().refresh();
                        if (l != null) {
                            l.serverStarted();
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "cannot start server", t);
                }
            }
        });
    }

    public boolean configure() {
        final boolean[] res = new boolean[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean b = JSTestDriverCustomizerPanel.showCustomizer();
                TestDriverServiceNode.getInstance().refresh();
                res[0] = b;
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return res[0];
    }

    public boolean isConfiguredProperly() {
        return JSTestDriverCustomizerPanel.isConfiguredProperly();
    }

    public void runAllTests(Project project, File baseFolder, File configFile, String testsToRun) {
        JsTestDriver td = this.getJsTestDriver();
        if (td == null && this.configure()) {
            td = this.getJsTestDriver();
        }
        if (td == null) {
            return;
        }
        String serverURL = JSTestDriverCustomizerPanel.getServerURL();
        int port = JSTestDriverCustomizerPanel.getPort();
        boolean strictMode = JSTestDriverCustomizerPanel.isStricModel();
        if (!this.isRunning() && port != -1) {
            final Semaphore s = new Semaphore(0);
            this.start(new ServerListener(){

                public void serverStarted() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    s.release();
                }
            });
            try {
                s.acquire();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!this.isRunning()) {
                return;
            }
        }
        this.updateJsDebuggerProjectContext(project);
        Listener listener = new Listener(project, new Rerun(project, baseFolder, configFile));
        LineConvertorImpl convertor = new LineConvertorImpl(project);
        td.runTests(serverURL, strictMode, baseFolder, configFile, testsToRun, (TestListener)listener, (LineConvertor)convertor);
    }

    private void updateJsDebuggerProjectContext(Project p) {
        this.lookupContent.set(Collections.singletonList(p), null);
    }

    private void captureBrowsers() {
        this.integratedBrowserPanes = new ArrayList<WebBrowserPane>();
        for (WebBrowser bd : JSTestDriverCustomizerPanel.getBrowsers()) {
            String s = JSTestDriverCustomizerPanel.getServerURL();
            if (bd.getBrowserFamily().isMobile() && s.startsWith("http://localhost:")) {
                s = s.replace("localhost", WebUtils.getLocalhostInetAddress().getHostAddress());
            }
            s = s + "/capture";
            if (bd.hasNetBeansIntegration()) {
                s = s + "/timeout/-1/";
            }
            if (JSTestDriverCustomizerPanel.isStricModel()) {
                s = s + "?strict";
            }
            try {
                URL u = new URL(s);
                WebBrowserFeatures features = new WebBrowserFeatures(true, true, false, false, true, false);
                WebBrowserPane pane = bd.createNewBrowserPane(features, true);
                pane.setProjectContext((Lookup)this.projectContext);
                pane.showURL(u);
                if (!bd.hasNetBeansIntegration()) continue;
                this.integratedBrowserPanes.add(pane);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void logUsage(Class srcClass, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }

    static {
        LOGGER = Logger.getLogger(JSTestDriverSupport.class.getName());
        USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.jstestdriver");
    }

    private static final class CallStackCallback
    implements JumpToCallStackAction.Callback {
        private static final Pattern FILE_LINE_PATTERN = Pattern.compile(" [(](?<FILE>[^:]+):(?<LINE>\\d+):(?<COLUMN>\\d+)[)]");
        private final File projectDir;

        public CallStackCallback(Project project) {
            assert (project != null);
            this.projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        }

        @Override
        public Pair<File, int[]> parseLocation(String callStack) {
            Matcher matcher = FILE_LINE_PATTERN.matcher(callStack);
            if (matcher.find()) {
                File file;
                File path = new File(matcher.group("FILE").replace('/', File.separatorChar));
                if (path.isAbsolute()) {
                    file = path;
                } else {
                    file = new File(this.projectDir, path.getPath());
                    if (!file.isFile()) {
                        return null;
                    }
                }
                int[] lineColumn = new int[]{Integer.parseInt(matcher.group("LINE")), Integer.parseInt(matcher.group("COLUMN"))};
                return Pair.of((Object)file, (Object)lineColumn);
            }
            return null;
        }
    }

    private static class Rerun
    implements RerunHandler {
        private Project project;
        private File baseFolder;
        private File configFile;
        private RequestProcessor RP = new RequestProcessor("js-test-driver rerun", 5);

        public Rerun(Project project, File baseFolder, File configFile) {
            this.project = project;
            this.baseFolder = baseFolder;
            this.configFile = configFile;
        }

        public void rerun() {
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    LifecycleManager.getDefault().saveAll();
                    JSTestDriverSupport.getDefault().runAllTests(project, baseFolder, configFile, "all");
                }
            });
        }

        public void rerun(Set<Testcase> tests) {
        }

        public boolean enabled(RerunType type) {
            return RerunType.ALL.equals((Object)type);
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }

    private static class Listener
    implements TestListener {
        private TestSession testSession;
        private Manager manager = Manager.getInstance();
        private Report report;

        public Listener(Project project, Rerun rerun) {
            this.manager.setNodeFactory((TestRunnerNodeFactory)new JSTestDriverTestRunnerNodeFactory(new CallStackCallback(project)));
            this.testSession = new TestSession(Bundle.JsTestDriverSupport_runner_title(ProjectUtils.getInformation((Project)project).getDisplayName()), project, TestSession.SessionType.TEST);
            this.testSession.setRerunHandler((RerunHandler)rerun);
            this.manager.testStarted(this.testSession);
        }

        public void onTestComplete(TestListener.TestResult testResult) {
            TestSuite currentSuite = this.testSession.getCurrentSuite();
            if (currentSuite == null || !currentSuite.getName().equals(testResult.getBrowserInfo().getDisplayName())) {
                if (this.report != null) {
                    this.manager.displayReport(this.testSession, this.report, true);
                }
                TestSuite ts = new TestSuite(testResult.getBrowserInfo().getDisplayName());
                this.testSession.addSuite(ts);
                this.report = this.testSession.getReport(0L);
                this.manager.displaySuiteRunning(this.testSession, ts.getName());
            }
            Testcase testCase = new Testcase(testResult.getTestCaseName() + "." + testResult.getTestName(), null, this.testSession);
            testCase.setStatus(this.convert(testResult.getResult()));
            testCase.setTimeMillis(testResult.getDuration());
            if (testResult.getResult() == TestListener.TestResult.Result.failed || testResult.getResult() == TestListener.TestResult.Result.error) {
                Trouble t = new Trouble(true);
                if (testResult.getStack().length() > 0) {
                    t.setStackTrace(this.trimArray(testResult.getStack().split("\\u000d")));
                    testCase.addOutputLines(Arrays.asList(testResult.getStack().split("\\u000d")));
                }
                if (testResult.getMessage().length() > 0) {
                    // empty if block
                }
                if (testResult.getLog().length() > 0) {
                    // empty if block
                }
                testCase.setTrouble(t);
            }
            this.testSession.addTestCase(testCase);
            this.report.update(this.testSession.getReport(0L));
            this.manager.displayReport(this.testSession, this.report, false);
        }

        private Status convert(TestListener.TestResult.Result res) {
            switch (res) {
                case passed: {
                    return Status.PASSED;
                }
                case failed: {
                    return Status.FAILED;
                }
                case error: {
                    return Status.ERROR;
                }
                case started: {
                    return Status.PENDING;
                }
            }
            throw new AssertionError((Object)res.name());
        }

        public void onTestingFinished() {
            this.manager.sessionFinished(this.testSession);
            if (this.report == null) {
                this.testSession.addSuite(TestSuite.ANONYMOUS_TEST_SUITE);
                this.report = this.testSession.getReport(0L);
            }
            this.manager.displayReport(this.testSession, this.report, true);
        }

        private String[] trimArray(String[] split) {
            if (split == null) {
                return null;
            }
            ArrayList<String> r = new ArrayList<String>();
            for (int i = 0; i < split.length; ++i) {
                String s = split[i].trim();
                if (s.length() <= 0) continue;
                r.add(s);
            }
            return r.toArray(new String[r.size()]);
        }
    }

    private static class ListenerImpl
    implements OutputListener {
        private FileObject fo;
        private int line;
        private int column;

        public ListenerImpl(FileObject fo, int line, int column) {
            this.fo = fo;
            this.line = line;
            this.column = column;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            Line l = this.getLine();
            if (l != null) {
                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column != -1 ? this.column - 1 : -1);
            }
        }

        private Line getLine() {
            LineCookie result = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)this.fo);
                if (dataObject != null) {
                    result = (LineCookie)dataObject.getCookie(LineCookie.class);
                }
            }
            catch (DataObjectNotFoundException e) {
                e.printStackTrace();
            }
            if (result != null) {
                return result.getLineSet().getCurrent(this.line - 1);
            }
            return null;
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public boolean isValidHyperlink() {
            return this.getLine() != null;
        }
    }

    private static class LineConvertorImpl
    implements LineConvertor {
        private Project p;

        public LineConvertorImpl(Project p) {
            this.p = p;
        }

        public List<ConvertedLine> convert(String line) {
            if (!line.endsWith(")")) {
                return this.convertLineURL(line);
            }
            int start = line.lastIndexOf(40);
            if (start == -1) {
                return null;
            }
            int lineNumberEnd = line.lastIndexOf(58);
            if (lineNumberEnd == -1) {
                return null;
            }
            int fileEnd = line.lastIndexOf(58, lineNumberEnd - 1);
            if (fileEnd == -1) {
                return null;
            }
            if (start >= fileEnd) {
                return null;
            }
            int lineNumber = -1;
            int columnNumber = -1;
            try {
                lineNumber = Integer.parseInt(line.substring(fileEnd + 1, lineNumberEnd));
                columnNumber = Integer.parseInt(line.substring(lineNumberEnd + 1, line.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (columnNumber != -1 && lineNumber == -1) {
                lineNumber = columnNumber;
            }
            if (lineNumber == -1) {
                return null;
            }
            String file = line.substring(start + 1, fileEnd);
            if (file.length() == 0) {
                return null;
            }
            FileObject fo = this.p.getProjectDirectory().getFileObject(file);
            if (fo == null) {
                return null;
            }
            ArrayList<ConvertedLine> res = new ArrayList<ConvertedLine>();
            ListenerImpl l = new ListenerImpl(fo, lineNumber, columnNumber);
            res.add(ConvertedLine.forText((String)line, (OutputListener)(l.isValidHyperlink() ? l : null)));
            return res;
        }

        private List<ConvertedLine> convertLineURL(String line) {
            int col2;
            int u1 = line.indexOf("http://");
            if (u1 < 0) {
                u1 = line.indexOf("https://");
            }
            if (u1 < 0) {
                return null;
            }
            int ue = line.indexOf(32, u1);
            int uee = line.indexOf(10, u1);
            if (uee != -1 && uee < ue) {
                ue = uee;
            }
            if (ue < 0) {
                ue = line.length();
            }
            if ((col2 = line.lastIndexOf(58, ue)) < 0) {
                return null;
            }
            int col1 = line.lastIndexOf(58, col2 - 1);
            if (col1 < 0) {
                return null;
            }
            int lineNumber = -1;
            int columnNumber = -1;
            try {
                lineNumber = Integer.parseInt(line.substring(col1 + 1, col2));
                columnNumber = Integer.parseInt(line.substring(col2 + 1, ue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (columnNumber != -1 && lineNumber == -1) {
                lineNumber = columnNumber;
            }
            if (lineNumber == -1) {
                return null;
            }
            String file = line.substring(u1, col1);
            if (file.length() == 0) {
                return null;
            }
            FileObject fo = null;
            try {
                URL url = URI.create(file).toURL();
                fo = ServerURLMapping.fromServer((Project)this.p, (URL)url);
                if (fo == null) {
                    fo = RemoteFileCache.getRemoteFile((URL)url);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (fo == null) {
                return null;
            }
            ArrayList<ConvertedLine> res = new ArrayList<ConvertedLine>();
            ListenerImpl l = new ListenerImpl(fo, lineNumber, columnNumber);
            res.add(ConvertedLine.forText((String)line, (OutputListener)(l.isValidHyperlink() ? l : null)));
            return res;
        }
    }
}

