/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.samples;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.api.JavaFXProjectUtils;
import org.netbeans.modules.javafx2.samples.PanelConfigureProject;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PanelOptionsVisual
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger("javafx");
    private PanelConfigureProject panel;
    private ComboBoxModel platformsModel;
    private ListCellRenderer platformsCellRenderer;
    private JavaPlatformChangeListener jpcl;
    private JButton btnManagePlatforms;
    private Box.Filler filler1;
    private JLabel lblPlatform;
    private JComboBox platformComboBox;
    private JLabel progressLabel;
    private JPanel progressPanel;

    PanelOptionsVisual(PanelConfigureProject panel) {
        this.panel = panel;
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    private void preInitComponents() {
        this.platformsModel = JavaFXProjectUtils.createPlatformComboBoxModel();
        this.platformsCellRenderer = JavaFXProjectUtils.createPlatformListCellRenderer();
    }

    private void postInitComponents() {
        if (!UIManager.getLookAndFeel().getClass().getName().toUpperCase().contains("AQUA")) {
            this.platformComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        this.jpcl = new JavaPlatformChangeListener();
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.jpcl, (Object)JavaPlatformManager.getDefault()));
        this.selectJavaFXEnabledPlatform();
        this.progressLabel.setVisible(false);
        this.progressPanel.setVisible(false);
    }

    private void initComponents() {
        this.lblPlatform = new JLabel();
        this.platformComboBox = new JComboBox();
        this.btnManagePlatforms = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 100), new Dimension(0, 0));
        this.progressLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblPlatform.setLabelFor(this.platformComboBox);
        this.lblPlatform.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_Platform_ComboBox"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 0, 5, 12);
        this.add((Component)this.lblPlatform, gridBagConstraints);
        this.lblPlatform.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_labelPlatform"));
        this.lblPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_labelPlatform"));
        this.platformComboBox.setModel(this.platformsModel);
        this.platformComboBox.setRenderer(this.platformsCellRenderer);
        this.platformComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.platformComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.platformComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnManagePlatforms, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Manage_Button"));
        this.btnManagePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnManagePlatformsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.add((Component)this.btnManagePlatforms, gridBagConstraints);
        this.btnManagePlatforms.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_buttonManagePlatforms"));
        this.btnManagePlatforms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_buttonManagePlatforms"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler1, gridBagConstraints);
        this.progressLabel.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_Platform_Progress"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.progressLabel, gridBagConstraints);
        this.progressLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_platformProgress"));
        this.progressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_platformProgress"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.progressPanel, gridBagConstraints);
    }

    private void btnManagePlatformsActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelectedPlatform());
    }

    private void platformComboBoxItemStateChanged(ItemEvent evt) {
        this.panel.fireChangeEvent();
    }

    private JavaPlatform getSelectedPlatform() {
        Object selectedItem = this.platformComboBox.getSelectedItem();
        JavaPlatform platform = selectedItem == null ? null : JavaFXProjectUtils.getPlatform((Object)selectedItem);
        return platform;
    }

    private void selectJavaFXEnabledPlatform() {
        for (int i = 0; i < this.platformsModel.getSize(); ++i) {
            JavaPlatform platform = JavaFXProjectUtils.getPlatform(this.platformsModel.getElementAt(i));
            if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)platform)) continue;
            this.platformComboBox.setSelectedIndex(i);
            break;
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)this.getSelectedPlatform())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.notFXPlatform"));
            return false;
        }
        return true;
    }

    void store(WizardDescriptor d) {
        String platformName = (String)this.getSelectedPlatform().getProperties().get("platform.ant.name");
        d.putProperty("java.platform.name", (Object)platformName);
    }

    void read(WizardDescriptor d) {
    }

    private class JavaPlatformChangeListener
    implements PropertyChangeListener {
        private JavaPlatformChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PanelOptionsVisual.this.panel.fireChangeEvent();
        }
    }
}

