/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.fxml;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SourceGroupSupport {
    private List<SourceGroupProxy> groups = null;
    private final String type;
    private SourceGroupProxy currentSourceGroup = null;
    private String currentPackageName = null;
    private SourceGroupSupport parent = null;
    private String currentFileName = null;

    public SourceGroupSupport(@NonNull String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setParent(SourceGroupSupport support) {
        this.parent = support;
    }

    public SourceGroupSupport getParent() {
        return this.parent;
    }

    public void addSourceGroups(@NonNull SourceGroup[] sourceGroups) {
        if (sourceGroups == null || sourceGroups.length == 0) {
            return;
        }
        if (this.groups == null) {
            this.groups = new ArrayList<SourceGroupProxy>();
        }
        for (int i = 0; i < sourceGroups.length; ++i) {
            this.groups.add(new SourceGroupProxy(sourceGroups[i]));
        }
        if (this.currentSourceGroup == null) {
            this.currentSourceGroup = this.groups.get(0);
        }
    }

    public void addSourceGroupProxy(@NonNull Project project, @NonNull String displayName, String[] packageProxy) {
        if (packageProxy == null || packageProxy.length == 0) {
            return;
        }
        if (this.groups == null) {
            this.groups = new ArrayList<SourceGroupProxy>();
        }
        this.groups.add(new SourceGroupProxy(project, displayName, packageProxy));
        if (this.currentSourceGroup == null) {
            this.currentSourceGroup = this.groups.get(0);
        }
    }

    public int noOfSourceGroups() {
        if (this.groups != null) {
            return this.groups.size();
        }
        return 0;
    }

    public List<SourceGroupProxy> getSourceGroups() {
        if (this.groups != null) {
            return Collections.unmodifiableList(this.groups);
        }
        return null;
    }

    public File[] getSourceGroupsAsFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (SourceGroupProxy p : this.groups) {
            list.add(FileUtil.toFile((FileObject)p.getRootFolder()));
        }
        return list.toArray(new File[0]);
    }

    public void setCurrentSourceGroup(SourceGroupProxy current) {
        this.currentSourceGroup = current;
    }

    public SourceGroupProxy getCurrentSourceGroup() {
        return this.currentSourceGroup;
    }

    public void setCurrentPackageName(String current) {
        this.currentPackageName = current;
    }

    public String getCurrentPackageName() {
        return this.currentPackageName;
    }

    public void setCurrentFileName(String fileName) {
        this.currentFileName = fileName;
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public String getCurrentPackagePath() {
        if (this.currentPackageName != null && this.currentSourceGroup != null) {
            String packageNameDecorated = (this.currentPackageName.startsWith("/") || this.currentPackageName.startsWith(File.separator) ? "" : "/") + this.currentPackageName + (this.currentPackageName.endsWith("/") || this.currentPackageName.endsWith(File.separator) || this.currentPackageName.length() == 0 ? "" : "/");
            if (this.currentSourceGroup.isReal()) {
                return FileUtil.getFileDisplayName((FileObject)this.currentSourceGroup.getRootFolder()) + packageNameDecorated;
            }
            return FileUtil.getFileDisplayName((FileObject)this.currentSourceGroup.getRootFolder()) + "/<" + this.currentSourceGroup.getDisplayName() + ">" + packageNameDecorated;
        }
        return null;
    }

    public FileObject getCurrentSourceGroupFolder() {
        if (this.currentSourceGroup != null) {
            return this.currentSourceGroup.getRootFolder();
        }
        return null;
    }

    public FileObject getCurrentChooserFolder() {
        FileObject folder = this.getCurrentPackageFolder(false);
        if (folder == null) {
            folder = this.getCurrentSourceGroupFolder();
        }
        return folder;
    }

    public FileObject getCurrentPackageFolder(boolean create) {
        if (this.currentPackageName != null && this.currentSourceGroup != null) {
            SourceGroup created;
            if (create && !this.currentSourceGroup.isReal() && (created = SourceGroupModifier.createSourceGroup((Project)this.currentSourceGroup.getProject(), (String)this.getType(), (String)"main")) != null) {
                for (SourceGroupProxy p : this.groups) {
                    if (p.isReal()) continue;
                    p.setSourceGroup(created);
                }
                return this.getCurrentPackageFolder(create);
            }
            if (this.currentSourceGroup.isReal()) {
                FileObject rootFolder = this.currentSourceGroup.getRootFolder();
                FileObject folder = rootFolder.getFileObject(this.currentPackageName, "");
                if (folder == null && create) {
                    try {
                        folder = rootFolder;
                        StringTokenizer tk = new StringTokenizer(this.currentPackageName, "/.");
                        String name = null;
                        while (tk.hasMoreTokens()) {
                            name = tk.nextToken();
                            FileObject fo = folder.getFileObject(name, "");
                            if (fo == null) {
                                folder = folder.createFolder(name);
                                break;
                            }
                            folder = fo;
                        }
                        while (tk.hasMoreTokens()) {
                            name = tk.nextToken();
                            folder = folder.createFolder(name);
                        }
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                return folder;
            }
        }
        return null;
    }

    public static SourceGroupProxy getContainingSourceGroup(SourceGroupSupport support, FileObject folder) {
        List<SourceGroupProxy> list = null;
        if (folder != null) {
            list = support.getSourceGroups();
            for (SourceGroupProxy p : list) {
                FileObject root = p.getRootFolder();
                if (root == null || !root.equals(folder) && !FileUtil.isParentOf((FileObject)root, (FileObject)folder)) continue;
                return p;
            }
        }
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static ComboBoxModel getWaitModel() {
        return new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(SourceGroupSupport.class, (String)"LBL_ConfigureFXMLPanel_PackageName_PleaseWait")});
    }

    public static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            String name;
            if (value == null) {
                name = "";
                icon = null;
            } else {
                assert (value instanceof SourceGroupProxy);
                SourceGroupProxy g = (SourceGroupProxy)value;
                name = g.getDisplayName();
                icon = g.getIcon(false);
            }
            super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            this.setIcon(icon);
            return this;
        }
    }

    public static class SourceGroupProxy
    implements SourceGroup {
        private Project project = null;
        private SourceGroup sourceGroup = null;
        private FileObject root = null;
        private String name = "n/a";
        private String displayName = "n/a";
        private Icon iconTrue = null;
        private Icon iconFalse = null;
        private List<String> packageProxy = null;

        public SourceGroupProxy(@NonNull SourceGroup sourceGroup) {
            this.sourceGroup = sourceGroup;
        }

        public SourceGroupProxy(@NonNull Project project, @NonNull String displayName, String[] packageProxy) {
            this.project = project;
            this.root = project.getProjectDirectory();
            this.displayName = displayName;
            this.packageProxy = new ArrayList<String>();
            this.packageProxy.addAll(Arrays.asList(packageProxy));
        }

        public boolean isReal() {
            return this.sourceGroup != null;
        }

        public Project getProject() {
            return this.project;
        }

        public void setSourceGroup(@NonNull SourceGroup sourceGroup) {
            this.sourceGroup = sourceGroup;
        }

        public ComboBoxModel getPackagesComboBoxModel() {
            if (this.sourceGroup != null) {
                return PackageView.createListView((SourceGroup)this.sourceGroup);
            }
            if (this.packageProxy != null) {
                return new DefaultComboBoxModel<String>(this.packageProxy.toArray(new String[0]));
            }
            return null;
        }

        public String toString() {
            if (this.sourceGroup != null) {
                return this.sourceGroup.toString();
            }
            return this.name + '/' + this.displayName;
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (this.sourceGroup != null ? this.sourceGroup.hashCode() : 0);
            FileObject root = this.getRootFolder();
            hash = 53 * hash + (root != null ? root.hashCode() : 0);
            hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 53 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceGroupProxy other = (SourceGroupProxy)obj;
            if (this.sourceGroup != null && other.sourceGroup != null) {
                return this.sourceGroup.getRootFolder().getPath().equals(other.sourceGroup.getRootFolder().getPath());
            }
            if (this.sourceGroup == null && other.sourceGroup == null) {
                return this.displayName.equals(other.displayName);
            }
            return false;
        }

        public FileObject getRootFolder() {
            if (this.sourceGroup != null) {
                return this.sourceGroup.getRootFolder();
            }
            return this.root;
        }

        public String getName() {
            if (this.sourceGroup != null) {
                return this.sourceGroup.getName();
            }
            return this.name;
        }

        public String getDisplayName() {
            if (this.sourceGroup != null) {
                return this.sourceGroup.getDisplayName();
            }
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            if (this.sourceGroup != null) {
                return this.sourceGroup.getIcon(opened);
            }
            return opened ? this.iconTrue : this.iconFalse;
        }

        public boolean contains(FileObject file) {
            if (this.sourceGroup != null) {
                return this.sourceGroup.contains(file);
            }
            return false;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.sourceGroup != null) {
                this.sourceGroup.addPropertyChangeListener(listener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.sourceGroup != null) {
                this.sourceGroup.removePropertyChangeListener(listener);
            }
        }
    }
}

