/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.openjdk.project.ModuleDescription;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class GlobalSourceForBinaryQuery
implements SourceForBinaryQueryImplementation2 {
    private static final Reference<Project> NO_PROJECT_CACHE = new WeakReference<Object>(null);
    private final Map<URL, Reference<Project>> projectCache = new HashMap<URL, Reference<Project>>();

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        Project prj;
        Reference<Project> cachedProject = this.projectCache.get(binaryRoot);
        if (cachedProject == NO_PROJECT_CACHE) {
            return null;
        }
        Project project = prj = cachedProject != null ? cachedProject.get() : null;
        if (prj == null) {
            try {
                String moduleName;
                FileObject root;
                String path;
                int lastSlash;
                ModuleDescription.ModuleRepository repository;
                URI jdkRootCandidate = binaryRoot.toURI().resolve("../../../../../").normalize();
                if (jdkRootCandidate != null && (repository = ModuleDescription.getModuleRepository(jdkRootCandidate)) != null && (lastSlash = (path = binaryRoot.getPath()).lastIndexOf(47, path.length() - 2)) >= 0 && (root = repository.findModuleRoot(moduleName = path.substring(lastSlash + 1, path.length() - 1))) != null) {
                    prj = FileOwnerQuery.getOwner((FileObject)root);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (prj == null) {
            this.projectCache.put(binaryRoot, NO_PROJECT_CACHE);
            return null;
        }
        this.projectCache.put(binaryRoot, new WeakReference<Project>(prj));
        return new ResultImpl(prj);
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    private static final class ResultImpl
    implements SourceForBinaryQueryImplementation2.Result,
    ChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final Sources sources;

        public ResultImpl(Project prj) {
            this.sources = ProjectUtils.getSources((Project)prj);
            this.sources.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.sources));
        }

        public boolean preferSources() {
            return false;
        }

        public FileObject[] getRoots() {
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            for (SourceGroup sg : this.sources.getSourceGroups("java")) {
                roots.add(sg.getRootFolder());
            }
            return roots.toArray(new FileObject[0]);
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }
    }
}

