/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.openjdk.project.AccessibilityQueryImpl;
import org.netbeans.modules.java.openjdk.project.ActionProviderImpl;
import org.netbeans.modules.java.openjdk.project.BinaryForSourceQueryImpl;
import org.netbeans.modules.java.openjdk.project.Bundle;
import org.netbeans.modules.java.openjdk.project.ClassPathProviderImpl;
import org.netbeans.modules.java.openjdk.project.ConfigurationImpl;
import org.netbeans.modules.java.openjdk.project.LogicalViewProviderImpl;
import org.netbeans.modules.java.openjdk.project.ModuleDescription;
import org.netbeans.modules.java.openjdk.project.OpenProjectHookImpl;
import org.netbeans.modules.java.openjdk.project.Settings;
import org.netbeans.modules.java.openjdk.project.SourceForBinaryQueryImpl;
import org.netbeans.modules.java.openjdk.project.SourceLevelQueryImpl;
import org.netbeans.modules.java.openjdk.project.SourcesImpl;
import org.netbeans.modules.java.openjdk.project.SubProjectProviderImpl;
import org.netbeans.modules.java.openjdk.project.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;

public class JDKProject
implements Project {
    public static final String PROJECT_KEY = "org-netbeans-modules-java-openjdk-project-JDKProject";
    private final FileObject projectDir;
    private final Lookup lookup;
    private final List<Root> roots;
    private final URI fakeOutput;
    final ModuleDescription.ModuleRepository moduleRepository;
    final ModuleDescription currentModule;
    private final PropertyEvaluator evaluator;
    final MapPropertyProvider properties;
    final ConfigurationImpl.ProviderImpl configurations;
    private static final Configuration LEGACY_OPEN_CONFIGURATION = new Configuration(Arrays.asList(Pair.of((Object)"${basedir}/src/share/classes/", (Object)"com/sun/jmx/snmp/.*|com/sun/jmx/snmp|sun/management/snmp/.*|sun/management/snmp|sun/dc/.*|sun/dc"), Pair.of((Object)"${basedir}/src/${legacy-os}/classes/", null), Pair.of((Object)"${outputRoot}/jdk/gensrc/", null), Pair.of((Object)"${outputRoot}/jdk/impsrc/", null)), Arrays.asList(new Pair[0]), Arrays.asList(Pair.of((Object)"${basedir}/test", null)));
    private static final Configuration LEGACY_CLOSED_CONFIGURATION = new Configuration(Arrays.asList(Pair.of((Object)"${basedir}/src/share/classes/", null), Pair.of((Object)"${basedir}/src/${legacy-os}/classes/", null), Pair.of((Object)"${basedir}/src/closed/share/classes/", null), Pair.of((Object)"${basedir}/src/closed/${legacy-os}/classes/", null), Pair.of((Object)"${outputRoot}/jdk/gensrc/", null), Pair.of((Object)"${outputRoot}/jdk/impsrc/", null)), Arrays.asList(new Pair[0]), Arrays.asList(Pair.of((Object)"${basedir}/test", null)));
    private static final Configuration MODULAR_CONFIGURATION = new Configuration(Arrays.asList(Pair.of((Object)"${basedir}/share/classes/", null), Pair.of((Object)"${basedir}/${os}/classes/", null), Pair.of((Object)"${basedir}/${generalized-os}/classes/", null), Pair.of((Object)"${basedir}/../closed/${module}/share/classes/", null), Pair.of((Object)"${basedir}/../closed/${module}/${os}/classes/", null), Pair.of((Object)"${basedir}/../closed/${module}/${generalized-os}/classes/", null), Pair.of((Object)"${basedir}/../../../closed/src/${module}/share/classes/", null), Pair.of((Object)"${basedir}/../../../closed/src/${module}/${os}/classes/", null), Pair.of((Object)"${basedir}/../../../closed/src/${module}/${generalized-os}/classes/", null), Pair.of((Object)"${outputRoot}/jdk/gensrc/${module}/", null), Pair.of((Object)"${outputRoot}/support/gensrc/${module}/", null)), Arrays.asList(Pair.of((Object)"${basedir}/share/native/", null), Pair.of((Object)"${basedir}/${os}/native/", null), Pair.of((Object)"${basedir}/${generalized-os}/native/", null), Pair.of((Object)"${outputRoot}/support/headers/${module}/", null)), Arrays.asList(new Pair[0]));

    public JDKProject(FileObject projectDir, @NullAllowed ModuleDescription.ModuleRepository moduleRepository, @NullAllowed ModuleDescription currentModule) {
        try {
            URL fakeOutputURL;
            boolean modular;
            String legacyOsKey;
            String generalizedOsKey;
            this.projectDir = projectDir;
            this.moduleRepository = moduleRepository;
            this.currentModule = currentModule;
            URI jdkDirURI = projectDir.toURI();
            this.properties = new MapPropertyProvider();
            this.properties.setProperty("basedir", JDKProject.stripTrailingSlash(jdkDirURI.toString()));
            this.properties.setProperty("module", projectDir.getNameExt());
            String osName = System.getProperty("os.name").toLowerCase();
            String osKey = osName.contains("mac") ? "macosx" : (osName.contains("windows") ? "windows" : (osName.contains("solaris") ? "solaris" : "linux"));
            switch (osKey) {
                case "macosx": {
                    generalizedOsKey = "unix";
                    legacyOsKey = "macosx";
                    break;
                }
                case "solaris": {
                    generalizedOsKey = "unix";
                    legacyOsKey = "solaris";
                    break;
                }
                case "linux": {
                    generalizedOsKey = "unix";
                    legacyOsKey = "solaris";
                    break;
                }
                case "windows": {
                    generalizedOsKey = "no-such-key";
                    legacyOsKey = "windows";
                    break;
                }
                default: {
                    throw new IllegalStateException(osKey);
                }
            }
            this.properties.setProperty("os", osKey);
            this.properties.setProperty("generalized-os", generalizedOsKey);
            this.properties.setProperty("legacy-os", legacyOsKey);
            FileObject jdkRoot = moduleRepository != null ? moduleRepository.getJDKRoot() : projectDir.getFileObject("..");
            this.properties.setProperty("jdkRoot", JDKProject.stripTrailingSlash(jdkRoot.toURI().toString()));
            this.configurations = ConfigurationImpl.getProvider(jdkRoot);
            this.configurations.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == null || evt.getPropertyName().equals("activeConfiguration")) {
                        JDKProject.this.updateConfiguration();
                    }
                }
            });
            this.updateConfiguration();
            this.evaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.properties, (PropertyProvider[])new PropertyProvider[0]);
            boolean closed = projectDir.getFileObject("src/closed/share/classes/javax/swing/plaf/basic/icons/JavaCup16.png") != null;
            boolean bl = modular = currentModule != null;
            Configuration configuration = modular ? MODULAR_CONFIGURATION : (closed ? LEGACY_CLOSED_CONFIGURATION : LEGACY_OPEN_CONFIGURATION);
            this.roots = new ArrayList<Root>(configuration.mainSourceRoots.size());
            this.addRoots(RootKind.MAIN_SOURCES, configuration.mainSourceRoots);
            this.addRoots(RootKind.NATIVE_SOURCES, configuration.nativeSourceRoots);
            this.addRoots(RootKind.TEST_SOURCES, configuration.testSourceRoots);
            try {
                URI fakeOutputJar = new URI(this.evaluator.evaluate("${basedir}/fake-target.jar"));
                this.fakeOutput = FileUtil.getArchiveRoot((URL)fakeOutputJar.toURL()).toURI();
                fakeOutputURL = this.fakeOutput.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
            if (currentModule != null) {
                String testRoots;
                switch (currentModule.name) {
                    case "java.base": {
                        this.addRoots(RootKind.MAIN_SOURCES, Arrays.asList(Pair.of((Object)"${jdkRoot}/langtools/src/java.base/share/classes/", null)));
                        break;
                    }
                    case "jdk.compiler": {
                        this.addRoots(RootKind.MAIN_SOURCES, Arrays.asList(Pair.of((Object)"${jdkRoot}/jdk/src/jdk.compiler/share/classes/", null)));
                        break;
                    }
                    case "jdk.dev": {
                        this.addRoots(RootKind.MAIN_SOURCES, Arrays.asList(Pair.of((Object)"${jdkRoot}/jdk/src/jdk.dev/share/classes/", null)));
                    }
                }
                FileObject shareClasses = projectDir.getFileObject("share/classes");
                if (shareClasses != null && Arrays.stream(shareClasses.getChildren()).anyMatch(c -> c.isFolder() && c.getNameExt().contains("."))) {
                    List submodules = Arrays.stream(shareClasses.getChildren()).filter(c -> c.isFolder()).map(c -> c.getNameExt()).collect(Collectors.toList());
                    ArrayList<Root> newRoots = new ArrayList<Root>();
                    for (Root r : this.roots) {
                        if (r.kind != RootKind.MAIN_SOURCES) {
                            newRoots.add(r);
                            continue;
                        }
                        newRoots.add(new Root(r.relPath, r.displayName, RootKind.MAIN_SOURCES, this.evaluator, Pattern.compile("module-info.java"), null));
                        for (String submodule : submodules) {
                            newRoots.add(new Root(r.relPath + submodule + "/src/", r.displayName + submodule + "/src/", RootKind.MAIN_SOURCES, this.evaluator, null));
                        }
                    }
                    this.roots.clear();
                    this.roots.addAll(newRoots);
                }
                if ((testRoots = moduleRepository.moduleTests(currentModule.name)) != null) {
                    this.addRoots(RootKind.TEST_SOURCES, Arrays.asList(Pair.of((Object)testRoots, null)));
                }
            }
            ClassPathProviderImpl cpp = new ClassPathProviderImpl(this, moduleRepository);
            Lookup base = Lookups.fixed((Object[])new Object[]{cpp, new OpenProjectHookImpl(this, cpp, moduleRepository), new SourcesImpl(this), new LogicalViewProviderImpl(this), new SourceLevelQueryImpl(jdkRoot), new SourceForBinaryQueryImpl(fakeOutputURL, cpp.getSourceCP()), new ProjectInformationImpl(), this.configurations, new SubProjectProviderImpl(this), new ActionProviderImpl(this), new AccessibilityQueryImpl(currentModule), new CustomizerProviderImpl(this), new Settings(this), new BinaryForSourceQueryImpl(this, cpp.getSourceCP()), this});
            this.lookup = LookupProviderSupport.createCompositeLookup((Lookup)base, (String)"Projects/org-netbeans-modules-java-openjdk-project-JDKProject/Lookup");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private void addRoots(RootKind kind, Iterable<Pair<String, String>> rootSpecifications) {
        for (Pair<String, String> sr : rootSpecifications) {
            this.roots.add(new Root((String)sr.first(), (String)sr.first(), kind, this.evaluator, sr.second() != null ? Pattern.compile((String)sr.second()) : null));
        }
    }

    private static String stripTrailingSlash(String from) {
        if (from.endsWith("/")) {
            return from.substring(0, from.length() - 1);
        }
        return from;
    }

    private void updateConfiguration() {
        ProjectManager.mutex().readAccess(new Runnable(){

            @Override
            public void run() {
                ConfigurationImpl activeConfig = JDKProject.this.configurations.getActiveConfiguration();
                File configurationDir = activeConfig != null ? activeConfig.getLocation() : null;
                JDKProject.this.properties.setProperty("outputRoot", configurationDir != null ? JDKProject.stripTrailingSlash(configurationDir.toURI().toString()) : FileUtil.normalizeFile((File)new File(URI.create("file:///non-existing"))).toURI().toString());
            }
        });
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public List<Root> getRoots() {
        return this.roots;
    }

    public URI getFakeOutput() {
        return this.fakeOutput;
    }

    public PropertyEvaluator evaluator() {
        return this.evaluator;
    }

    static boolean isJDKProject(FileObject projectDirectory) {
        try {
            ModuleDescription.ModuleRepository repository = ModuleDescription.getModules(projectDirectory);
            if (repository != null) {
                return repository.findModule(projectDirectory.getNameExt()) != null;
            }
            return projectDirectory.getFileObject("src/share/classes/java/lang/Object.java") != null;
        }
        catch (Exception ex) {
            Logger.getLogger(JDKProject.class.getName()).log(Level.FINE, null, ex);
            return false;
        }
    }

    static final class MapPropertyProvider
    implements PropertyProvider {
        private final Map<String, String> properties = new HashMap<String, String>();
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        MapPropertyProvider() {
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public void setProperty(String key, String value) {
            this.properties.put(key, value);
            this.cs.fireChange();
        }
    }

    private final class ProjectInformationImpl
    implements ProjectInformation {
        private ProjectInformationImpl() {
        }

        public String getName() {
            return JDKProject.this.currentModule != null ? JDKProject.this.getProjectDirectory().getNameExt() : "j2se";
        }

        public String getDisplayName() {
            return JDKProject.this.currentModule != null ? Bundle.DN_Module(JDKProject.this.getProjectDirectory().getNameExt(), JDKProject.this.moduleRepository.getJDKRoot().getNameExt()) : Bundle.DN_Project(JDKProject.this.getProjectDirectory().getParent().getNameExt());
        }

        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/openjdk/project/resources/jdk-project.png", (boolean)false);
        }

        public Project getProject() {
            return JDKProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    public static final class JDKProjectFactory
    implements ProjectFactory {
        public boolean isProject(FileObject projectDirectory) {
            return JDKProject.isJDKProject(projectDirectory);
        }

        public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
            if (this.isProject(projectDirectory)) {
                Project prj = this.loadModularProject(projectDirectory);
                if (prj != null) {
                    return prj;
                }
                if (projectDirectory.getFileObject("src/share/classes/java/lang/Object.java") != null) {
                    return new JDKProject(projectDirectory, null, null);
                }
            }
            return null;
        }

        private Project loadModularProject(FileObject projectDirectory) {
            try {
                ModuleDescription.ModuleRepository repository = ModuleDescription.getModules(projectDirectory);
                if (repository == null) {
                    return null;
                }
                ModuleDescription thisModule = repository.findModule(projectDirectory.getNameExt());
                if (thisModule == null) {
                    return null;
                }
                if (!projectDirectory.equals(repository.findModuleRoot(thisModule.name))) {
                    return null;
                }
                return new JDKProject(projectDirectory, repository, thisModule);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.getLogger(JDKProject.class.getName()).log(Level.FINE, null, ex);
                return null;
            }
        }

        public void saveProject(Project project) throws IOException, ClassCastException {
        }
    }

    private static final class Configuration {
        public final List<Pair<String, String>> mainSourceRoots;
        private final List<Pair<String, String>> nativeSourceRoots;
        public final List<Pair<String, String>> testSourceRoots;

        public Configuration(List<Pair<String, String>> mainSourceRoots, List<Pair<String, String>> nativeSourceRoots, List<Pair<String, String>> testSourceRoots) {
            this.mainSourceRoots = mainSourceRoots;
            this.nativeSourceRoots = nativeSourceRoots;
            this.testSourceRoots = testSourceRoots;
        }
    }

    public static enum RootKind {
        MAIN_SOURCES,
        NATIVE_SOURCES,
        TEST_SOURCES;

    }

    public static final class Root
    implements PropertyChangeListener {
        public final String relPath;
        public final String displayName;
        public final RootKind kind;
        public final Pattern includes;
        public final Pattern excludes;
        private final PropertyEvaluator evaluator;
        private URL location;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        private Root(String relPath, String displayName, RootKind kind, PropertyEvaluator evaluator, Pattern excludes) {
            this(relPath, displayName, kind, evaluator, null, excludes);
        }

        private Root(String relPath, String displayName, RootKind kind, PropertyEvaluator evaluator, Pattern includes, Pattern excludes) {
            this.relPath = relPath;
            this.displayName = displayName;
            this.kind = kind;
            this.evaluator = evaluator;
            this.includes = includes;
            this.excludes = excludes;
            this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public URL getLocation() {
            if (this.location == null) {
                try {
                    this.location = new URL(this.evaluator.evaluate(this.relPath)).toURI().normalize().toURL();
                }
                catch (MalformedURLException | URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.location;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.location = null;
            this.cs.fireChange();
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }
    }
}

